#! /usr/bin/env python

import os
import DistUtilsExtra.auto
from DistUtilsExtra.command import *
import glob

def gen_data_files(*dirs):
    results = []
    for src_dir in dirs:
        for root,dirs,files in os.walk(src_dir):
            results.append((root, map(lambda f:root + "/" + f, files)))
    return results

DistUtilsExtra.auto.setup(
      name="zeitgeist-explorer",
      version="0.2",
      license = "GNU LGPL 2.1",
      description="A tool which can be used to monitor and explore the events logged by zeitgeist",
      url="https://launchpad.net/zeitgeist-explorer",
      author="Manish Sinha",
      author_email="manishsinha@ubuntu.com",
      packages=["zgexplorer"],
      scripts=["zeitgeist-explorer"],
      data_files = gen_data_files("data/icons"),
      platforms = "posix",
      cmdclass = { "build" : build_extra.build_extra,
                   "build_i18n" :  build_i18n.build_i18n,
                   "build_icons" :  build_icons.build_icons }
                        )
