/* *****************************************************************************
/
/ This file is part of Solirte, a solenoid ion ray-tracing engine.
/ (c) 2008 Michael Brown.
/ michael.brown@anu.edu.au
/
/ This file contains the raw Ziggurat table data.
/ *************************************************************************** */

#include "ziggurat.h"

// Gaussian ziggurat:
//  128 bins:
//    DIGITS = 32 gives r = 3.442619852328124412387060404999
//    DIGITS = 48 gives r = 3.442619855896652123156699485478
//    DIGITS = 64 gives r = 3.442619855896652121424320491467
//    DIGITS = 80 gives r = 3.442619855896652121424320491467
//    DIGITS = 96 gives r = 3.442619855896652121424320491467
//    3.44261985589665212142432049146733971
//  256 bins:
//    DIGITS = 32 gives r = 3.654152877891919476822964862999
//    DIGITS = 48 gives r = 3.654152885361008775196442582742
//    DIGITS = 64 gives r = 3.654152885361008771645429720399
//    DIGITS = 80 gives r = 3.654152885361008771645429720399
//    DIGITS = 96 gives r = 3.654152885361008771645429720399
//    3.6541528853610087716454297203996
const CZigguratGaussian_FP32::TBinData CZigguratGaussian_FP32::Bins[CZigguratGaussian_FP32::NumBins] = {
  {0x7799ec, 3.91075802e+000f, 0, 0},
  {0x78d2d2, 3.65415287e+000f, 1.26028596e-003f, 1.34878687e-003f},
  {0x7b3630, 3.44927835e+000f, 2.60907272e-003f, 1.42889982e-003f},
  {0x7c4fd2, 3.32024479e+000f, 4.03797254e-003f, 1.48443074e-003f},
  {0x7cf4b9, 3.22457504e+000f, 5.52240340e-003f, 1.52847217e-003f},
  {0x7d6203, 3.14788938e+000f, 7.05087557e-003f, 1.56570727e-003f},
  {0x7db036, 3.08352613e+000f, 8.61658249e-003f, 1.59838866e-003f},
  {0x7deb2c, 3.02783775e+000f, 1.02149714e-002f, 1.62778643e-003f},
  {0x7e1959, 2.97860336e+000f, 1.18427575e-002f, 1.65469269e-003f},
  {0x7e3e93, 2.93436694e+000f, 1.34974504e-002f, 1.67963770e-003f},
  {0x7e5d47, 2.89412117e+000f, 1.51770879e-002f, 1.70299481e-003f},
  {0x7e7710, 2.85713863e+000f, 1.68800838e-002f, 1.72503816e-003f},
  {0x7e8d0d, 2.82287741e+000f, 1.86051205e-002f, 1.74597499e-003f},
  {0x7ea00a, 2.79092121e+000f, 2.03510970e-002f, 1.76596653e-003f},
  {0x7eb09d, 2.76094389e+000f, 2.21170634e-002f, 1.78514060e-003f},
  {0x7ebf37, 2.73268533e+000f, 2.39022039e-002f, 1.80360069e-003f},
  {0x7ecc2f, 2.70593357e+000f, 2.57058032e-002f, 1.82143168e-003f},
  {0x7ed7c8, 2.68051457e+000f, 2.75272354e-002f, 1.83870411e-003f},
  {0x7ee237, 2.65628314e+000f, 2.93659400e-002f, 1.85547746e-003f},
  {0x7eeba8, 2.63311648e+000f, 3.12214177e-002f, 1.87180226e-003f},
  {0x7ef43e, 2.61091042e+000f, 3.30932178e-002f, 1.88772206e-003f},
  {0x7efc16, 2.58957601e+000f, 3.49809416e-002f, 1.90327421e-003f},
  {0x7f0346, 2.56903553e+000f, 3.68842147e-002f, 1.91849167e-003f},
  {0x7f09e4, 2.54922152e+000f, 3.88027057e-002f, 1.93340320e-003f},
  {0x7f1000, 2.53007531e+000f, 4.07361090e-002f, 1.94803427e-003f},
  {0x7f15a9, 2.51154447e+000f, 4.26841453e-002f, 1.96240726e-003f},
  {0x7f1aea, 2.49358296e+000f, 4.46465537e-002f, 1.97654264e-003f},
  {0x7f1fce, 2.47615004e+000f, 4.66230959e-002f, 1.99045823e-003f},
  {0x7f245f, 2.45920849e+000f, 4.86135520e-002f, 2.00417056e-003f},
  {0x7f28a4, 2.44272542e+000f, 5.06177247e-002f, 2.01769453e-003f},
  {0x7f2ca4, 2.42667103e+000f, 5.26354201e-002f, 2.03104294e-003f},
  {0x7f3065, 2.41101837e+000f, 5.46664596e-002f, 2.04422884e-003f},
  {0x7f33ed, 2.39574313e+000f, 5.67106903e-002f, 2.05726293e-003f},
  {0x7f3741, 2.38082290e+000f, 5.87679520e-002f, 2.07015546e-003f},
  {0x7f3a64, 2.36623716e+000f, 6.08381070e-002f, 2.08291598e-003f},
  {0x7f3d5a, 2.35196733e+000f, 6.29210249e-002f, 2.09555356e-003f},
  {0x7f4028, 2.33799624e+000f, 6.50165752e-002f, 2.10807589e-003f},
  {0x7f42cf, 2.32430792e+000f, 6.71246573e-002f, 2.12049065e-003f},
  {0x7f4553, 2.31088829e+000f, 6.92451447e-002f, 2.13280460e-003f},
  {0x7f47b6, 2.29772329e+000f, 7.13779479e-002f, 2.14502471e-003f},
  {0x7f49fa, 2.28480077e+000f, 7.35229701e-002f, 2.15715659e-003f},
  {0x7f4c22, 2.27210903e+000f, 7.56801292e-002f, 2.16920627e-003f},
  {0x7f4e2f, 2.25963712e+000f, 7.78493360e-002f, 2.18117912e-003f},
  {0x7f5022, 2.24737501e+000f, 8.00305158e-002f, 2.19308003e-003f},
  {0x7f51fe, 2.23531342e+000f, 8.22235942e-002f, 2.20491365e-003f},
  {0x7f53c4, 2.22344327e+000f, 8.44285116e-002f, 2.21668486e-003f},
  {0x7f5575, 2.21175671e+000f, 8.66451934e-002f, 2.22839764e-003f},
  {0x7f5713, 2.20024562e+000f, 8.88735950e-002f, 2.24005594e-003f},
  {0x7f589e, 2.18890285e+000f, 9.11136493e-002f, 2.25166394e-003f},
  {0x7f5a17, 2.17772150e+000f, 9.33653116e-002f, 2.26322492e-003f},
  {0x7f5b7f, 2.16669512e+000f, 9.56285372e-002f, 2.27474235e-003f},
  {0x7f5cd8, 2.15581775e+000f, 9.79032815e-002f, 2.28621974e-003f},
  {0x7f5e21, 2.14508367e+000f, 1.00189500e-001f, 2.29766010e-003f},
  {0x7f5f5d, 2.13448715e+000f, 1.02487162e-001f, 2.30906671e-003f},
  {0x7f608a, 2.12402320e+000f, 1.04796223e-001f, 2.32044212e-003f},
  {0x7f61ab, 2.11368704e+000f, 1.07116669e-001f, 2.33178935e-003f},
  {0x7f62c0, 2.10347414e+000f, 1.09448455e-001f, 2.34311097e-003f},
  {0x7f63c8, 2.09337974e+000f, 1.11791566e-001f, 2.35440978e-003f},
  {0x7f64c6, 2.08339977e+000f, 1.14145979e-001f, 2.36568786e-003f},
  {0x7f65b8, 2.07353020e+000f, 1.16511665e-001f, 2.37694778e-003f},
  {0x7f66a1, 2.06376743e+000f, 1.18888617e-001f, 2.38819211e-003f},
  {0x7f677f, 2.05410790e+000f, 1.21276803e-001f, 2.39942269e-003f},
  {0x7f6854, 2.04454803e+000f, 1.23676226e-001f, 2.41064210e-003f},
  {0x7f691f, 2.03508425e+000f, 1.26086876e-001f, 2.42185197e-003f},
  {0x7f69e2, 2.02571392e+000f, 1.28508717e-001f, 2.43305485e-003f},
  {0x7f6a9c, 2.01643372e+000f, 1.30941778e-001f, 2.44425260e-003f},
  {0x7f6b4f, 2.00724077e+000f, 1.33386031e-001f, 2.45544687e-003f},
  {0x7f6bf9, 1.99813247e+000f, 1.35841474e-001f, 2.46663997e-003f},
  {0x7f6c9c, 1.98910606e+000f, 1.38308123e-001f, 2.47783330e-003f},
  {0x7f6d37, 1.98015893e+000f, 1.40785947e-001f, 2.48902920e-003f},
  {0x7f6dcb, 1.97128868e+000f, 1.43274978e-001f, 2.50022905e-003f},
  {0x7f6e58, 1.96249306e+000f, 1.45775214e-001f, 2.51143472e-003f},
  {0x7f6edf, 1.95376968e+000f, 1.48286641e-001f, 2.52264785e-003f},
  {0x7f6f5f, 1.94511652e+000f, 1.50809288e-001f, 2.53387028e-003f},
  {0x7f6fd9, 1.93653142e+000f, 1.53343156e-001f, 2.54510366e-003f},
  {0x7f704d, 1.92801237e+000f, 1.55888259e-001f, 2.55634938e-003f},
  {0x7f70bb, 1.91955733e+000f, 1.58444613e-001f, 2.56760931e-003f},
  {0x7f7123, 1.91116452e+000f, 1.61012217e-001f, 2.57888483e-003f},
  {0x7f7186, 1.90283215e+000f, 1.63591102e-001f, 2.59017758e-003f},
  {0x7f71e3, 1.89455855e+000f, 1.66181281e-001f, 2.60148896e-003f},
  {0x7f723a, 1.88634181e+000f, 1.68782771e-001f, 2.61282083e-003f},
  {0x7f728d, 1.87818050e+000f, 1.71395600e-001f, 2.62417435e-003f},
  {0x7f72da, 1.87007296e+000f, 1.74019769e-001f, 2.63555138e-003f},
  {0x7f7323, 1.86201763e+000f, 1.76655322e-001f, 2.64695310e-003f},
  {0x7f7366, 1.85401309e+000f, 1.79302275e-001f, 2.65838113e-003f},
  {0x7f73a5, 1.84605789e+000f, 1.81960657e-001f, 2.66983686e-003f},
  {0x7f73df, 1.83815062e+000f, 1.84630498e-001f, 2.68132170e-003f},
  {0x7f7414, 1.83028996e+000f, 1.87311813e-001f, 2.69283750e-003f},
  {0x7f7445, 1.82247460e+000f, 1.90004647e-001f, 2.70438520e-003f},
  {0x7f7472, 1.81470323e+000f, 1.92709044e-001f, 2.71596666e-003f},
  {0x7f749a, 1.80697465e+000f, 1.95425004e-001f, 2.72758305e-003f},
  {0x7f74be, 1.79928756e+000f, 1.98152587e-001f, 2.73923599e-003f},
  {0x7f74de, 1.79164100e+000f, 2.00891823e-001f, 2.75092688e-003f},
  {0x7f74f9, 1.78403366e+000f, 2.03642756e-001f, 2.76265712e-003f},
  {0x7f7511, 1.77646446e+000f, 2.06405401e-001f, 2.77442811e-003f},
  {0x7f7524, 1.76893246e+000f, 2.09179834e-001f, 2.78624170e-003f},
  {0x7f7534, 1.76143634e+000f, 2.11966082e-001f, 2.79809884e-003f},
  {0x7f753f, 1.75397527e+000f, 2.14764178e-001f, 2.81000137e-003f},
  {0x7f7547, 1.74654830e+000f, 2.17574179e-001f, 2.82195071e-003f},
  {0x7f754b, 1.73915422e+000f, 2.20396131e-001f, 2.83394824e-003f},
  {0x7f754a, 1.73179233e+000f, 2.23230079e-001f, 2.84599559e-003f},
  {0x7f7546, 1.72446156e+000f, 2.26076066e-001f, 2.85809417e-003f},
  {0x7f753f, 1.71716094e+000f, 2.28934169e-001f, 2.87024537e-003f},
  {0x7f7533, 1.70988965e+000f, 2.31804416e-001f, 2.88245105e-003f},
  {0x7f7524, 1.70264685e+000f, 2.34686866e-001f, 2.89471261e-003f},
  {0x7f7511, 1.69543171e+000f, 2.37581581e-001f, 2.90703145e-003f},
  {0x7f74fb, 1.68824315e+000f, 2.40488604e-001f, 2.91940942e-003f},
  {0x7f74e0, 1.68108070e+000f, 2.43408009e-001f, 2.93184817e-003f},
  {0x7f74c3, 1.67394328e+000f, 2.46339858e-001f, 2.94434885e-003f},
  {0x7f74a1, 1.66683030e+000f, 2.49284208e-001f, 2.95691355e-003f},
  {0x7f747c, 1.65974081e+000f, 2.52241135e-001f, 2.96954392e-003f},
  {0x7f7453, 1.65267420e+000f, 2.55210668e-001f, 2.98224133e-003f},
  {0x7f7427, 1.64562953e+000f, 2.58192897e-001f, 2.99500790e-003f},
  {0x7f73f6, 1.63860619e+000f, 2.61187911e-001f, 3.00784479e-003f},
  {0x7f73c3, 1.63160348e+000f, 2.64195770e-001f, 3.02075432e-003f},
  {0x7f738b, 1.62462056e+000f, 2.67216504e-001f, 3.03373812e-003f},
  {0x7f7350, 1.61765683e+000f, 2.70250261e-001f, 3.04679759e-003f},
  {0x7f7312, 1.61071157e+000f, 2.73297042e-001f, 3.05993529e-003f},
  {0x7f72cf, 1.60378420e+000f, 2.76356995e-001f, 3.07315239e-003f},
  {0x7f7289, 1.59687376e+000f, 2.79430151e-001f, 3.08645121e-003f},
  {0x7f723f, 1.58997989e+000f, 2.82516599e-001f, 3.09983385e-003f},
  {0x7f71f2, 1.58310175e+000f, 2.85616428e-001f, 3.11330170e-003f},
  {0x7f71a1, 1.57623875e+000f, 2.88729727e-001f, 3.12685710e-003f},
  {0x7f714c, 1.56939018e+000f, 2.91856587e-001f, 3.14050214e-003f},
  {0x7f70f3, 1.56255543e+000f, 2.94997096e-001f, 3.15423892e-003f},
  {0x7f7096, 1.55573404e+000f, 2.98151314e-001f, 3.16806929e-003f},
  {0x7f7035, 1.54892504e+000f, 3.01319391e-001f, 3.18199582e-003f},
  {0x7f6fd1, 1.54212821e+000f, 3.04501384e-001f, 3.19602061e-003f},
  {0x7f6f68, 1.53534257e+000f, 3.07697415e-001f, 3.21014551e-003f},
  {0x7f6efc, 1.52856767e+000f, 3.10907573e-001f, 3.22437356e-003f},
  {0x7f6e8c, 1.52180302e+000f, 3.14131945e-001f, 3.23870638e-003f},
  {0x7f6e17, 1.51504779e+000f, 3.17370623e-001f, 3.25314701e-003f},
  {0x7f6d9e, 1.50830162e+000f, 3.20623785e-001f, 3.26769752e-003f},
  {0x7f6d21, 1.50156367e+000f, 3.23891491e-001f, 3.28236050e-003f},
  {0x7f6ca0, 1.49483347e+000f, 3.27173829e-001f, 3.29713849e-003f},
  {0x7f6c1b, 1.48811054e+000f, 3.30470979e-001f, 3.31203453e-003f},
  {0x7f6b91, 1.48139405e+000f, 3.33783031e-001f, 3.32705071e-003f},
  {0x7f6b03, 1.47468352e+000f, 3.37110072e-001f, 3.34219029e-003f},
  {0x7f6a70, 1.46797848e+000f, 3.40452254e-001f, 3.35745607e-003f},
  {0x7f69d9, 1.46127820e+000f, 3.43809724e-001f, 3.37285083e-003f},
  {0x7f693c, 1.45458210e+000f, 3.47182572e-001f, 3.38837761e-003f},
  {0x7f689c, 1.44788969e+000f, 3.50570947e-001f, 3.40403942e-003f},
  {0x7f67f6, 1.44120026e+000f, 3.53974968e-001f, 3.41983931e-003f},
  {0x7f674c, 1.43451333e+000f, 3.57394814e-001f, 3.43578076e-003f},
  {0x7f669c, 1.42782819e+000f, 3.60830605e-001f, 3.45186703e-003f},
  {0x7f65e8, 1.42114437e+000f, 3.64282459e-001f, 3.46810161e-003f},
  {0x7f652e, 1.41446126e+000f, 3.67750555e-001f, 3.48448800e-003f},
  {0x7f646f, 1.40777826e+000f, 3.71235043e-001f, 3.50102945e-003f},
  {0x7f63aa, 1.40109479e+000f, 3.74736100e-001f, 3.51773016e-003f},
  {0x7f62e0, 1.39441013e+000f, 3.78253818e-001f, 3.53459362e-003f},
  {0x7f6210, 1.38772380e+000f, 3.81788403e-001f, 3.55162402e-003f},
  {0x7f613b, 1.38103521e+000f, 3.85340035e-001f, 3.56882508e-003f},
  {0x7f605f, 1.37434363e+000f, 3.88908863e-001f, 3.58620146e-003f},
  {0x7f5f7e, 1.36764860e+000f, 3.92495066e-001f, 3.60375713e-003f},
  {0x7f5e96, 1.36094940e+000f, 3.96098822e-001f, 3.62149649e-003f},
  {0x7f5da8, 1.35424531e+000f, 3.99720311e-001f, 3.63942422e-003f},
  {0x7f5cb3, 1.34753585e+000f, 4.03359741e-001f, 3.65754520e-003f},
  {0x7f5bb8, 1.34082031e+000f, 4.07017291e-001f, 3.67586385e-003f},
  {0x7f5ab5, 1.33409810e+000f, 4.10693139e-001f, 3.69438576e-003f},
  {0x7f59ac, 1.32736862e+000f, 4.14387524e-001f, 3.71311582e-003f},
  {0x7f589c, 1.32063103e+000f, 4.18100655e-001f, 3.73205938e-003f},
  {0x7f5784, 1.31388462e+000f, 4.21832711e-001f, 3.75122204e-003f},
  {0x7f5664, 1.30712903e+000f, 4.25583929e-001f, 3.77060962e-003f},
  {0x7f553d, 1.30036318e+000f, 4.29354548e-001f, 3.79022816e-003f},
  {0x7f540d, 1.29358673e+000f, 4.33144778e-001f, 3.81008349e-003f},
  {0x7f52d5, 1.28679872e+000f, 4.36954856e-001f, 3.83018213e-003f},
  {0x7f5195, 1.27999842e+000f, 4.40785021e-001f, 3.85053083e-003f},
  {0x7f504c, 1.27318525e+000f, 4.44635570e-001f, 3.87113611e-003f},
  {0x7f4ef9, 1.26635826e+000f, 4.48506713e-001f, 3.89200542e-003f},
  {0x7f4d9d, 1.25951684e+000f, 4.52398717e-001f, 3.91314598e-003f},
  {0x7f4c38, 1.25266027e+000f, 4.56311852e-001f, 3.93456500e-003f},
  {0x7f4ac8, 1.24578750e+000f, 4.60246414e-001f, 3.95627134e-003f},
  {0x7f494e, 1.23889792e+000f, 4.64202702e-001f, 3.97827243e-003f},
  {0x7f47ca, 1.23199058e+000f, 4.68180954e-001f, 4.00057714e-003f},
  {0x7f463a, 1.22506464e+000f, 4.72181529e-001f, 4.02319431e-003f},
  {0x7f449f, 1.21811938e+000f, 4.76204723e-001f, 4.04613325e-003f},
  {0x7f42f8, 1.21115375e+000f, 4.80250865e-001f, 4.06940375e-003f},
  {0x7f4145, 1.20416689e+000f, 4.84320283e-001f, 4.09301510e-003f},
  {0x7f3f84, 1.19715774e+000f, 4.88413274e-001f, 4.11697896e-003f},
  {0x7f3db7, 1.19012547e+000f, 4.92530257e-001f, 4.14130557e-003f},
  {0x7f3bdc, 1.18306911e+000f, 4.96671557e-001f, 4.16600611e-003f},
  {0x7f39f3, 1.17598760e+000f, 5.00837564e-001f, 4.19109268e-003f},
  {0x7f37fb, 1.16887987e+000f, 5.05028665e-001f, 4.21657786e-003f},
  {0x7f35f3, 1.16174483e+000f, 5.09245217e-001f, 4.24247468e-003f},
  {0x7f33dc, 1.15458143e+000f, 5.13487697e-001f, 4.26879665e-003f},
  {0x7f31b3, 1.14738846e+000f, 5.17756522e-001f, 4.29555727e-003f},
  {0x7f2f7a, 1.14016485e+000f, 5.22052050e-001f, 4.32277238e-003f},
  {0x7f2d2e, 1.13290930e+000f, 5.26374876e-001f, 4.35045734e-003f},
  {0x7f2ad0, 1.12562048e+000f, 5.30725300e-001f, 4.37862799e-003f},
  {0x7f285d, 1.11829722e+000f, 5.35103917e-001f, 4.40730201e-003f},
  {0x7f25d7, 1.11093807e+000f, 5.39511263e-001f, 4.43649711e-003f},
  {0x7f233a, 1.10354173e+000f, 5.43947756e-001f, 4.46623191e-003f},
  {0x7f2087, 1.09610665e+000f, 5.48413992e-001f, 4.49652737e-003f},
  {0x7f1dbd, 1.08863139e+000f, 5.52910507e-001f, 4.52740304e-003f},
  {0x7f1ada, 1.08111441e+000f, 5.57437897e-001f, 4.55888221e-003f},
  {0x7f17dc, 1.07355404e+000f, 5.61996758e-001f, 4.59098723e-003f},
  {0x7f14c4, 1.06594872e+000f, 5.66587746e-001f, 4.62374371e-003f},
  {0x7f118f, 1.05829644e+000f, 5.71211517e-001f, 4.65717632e-003f},
  {0x7f0e3c, 1.05059564e+000f, 5.75868666e-001f, 4.69131302e-003f},
  {0x7f0aca, 1.04284430e+000f, 5.80559969e-001f, 4.72618314e-003f},
  {0x7f0736, 1.03504050e+000f, 5.85286200e-001f, 4.76181693e-003f},
  {0x7f037f, 1.02718198e+000f, 5.90048015e-001f, 4.79824748e-003f},
  {0x7effa3, 1.01926672e+000f, 5.94846249e-001f, 4.83550876e-003f},
  {0x7efba0, 1.01129246e+000f, 5.99681735e-001f, 4.87363804e-003f},
  {0x7ef774, 1.00325668e+000f, 6.04555368e-001f, 4.91267443e-003f},
  {0x7ef31b, 9.95157003e-001f, 6.09468043e-001f, 4.95265890e-003f},
  {0x7eee94, 9.86990750e-001f, 6.14420712e-001f, 4.99363663e-003f},
  {0x7ee9dc, 9.78755176e-001f, 6.19414389e-001f, 5.03565511e-003f},
  {0x7ee4ef, 9.70447302e-001f, 6.24450028e-001f, 5.07876417e-003f},
  {0x7edfcb, 9.62064147e-001f, 6.29528761e-001f, 5.12301922e-003f},
  {0x7eda6b, 9.53602433e-001f, 6.34651780e-001f, 5.16847800e-003f},
  {0x7ed4cc, 9.45058703e-001f, 6.39820278e-001f, 5.21520339e-003f},
  {0x7ecee8, 9.36429322e-001f, 6.45035505e-001f, 5.26326243e-003f},
  {0x7ec8bc, 9.27710533e-001f, 6.50298715e-001f, 5.31272730e-003f},
  {0x7ec243, 9.18898165e-001f, 6.55611455e-001f, 5.36367716e-003f},
  {0x7ebb75, 9.09987926e-001f, 6.60975158e-001f, 5.41619631e-003f},
  {0x7eb44e, 9.00975227e-001f, 6.66391373e-001f, 5.47037600e-003f},
  {0x7eacc6, 8.91855061e-001f, 6.71861708e-001f, 5.52631635e-003f},
  {0x7ea4d5, 8.82622242e-001f, 6.77388012e-001f, 5.58412541e-003f},
  {0x7e9c72, 8.73271048e-001f, 6.82972133e-001f, 5.64392144e-003f},
  {0x7e9395, 8.63795519e-001f, 6.88616097e-001f, 5.70583297e-003f},
  {0x7e8a32, 8.54189157e-001f, 6.94321930e-001f, 5.77000203e-003f},
  {0x7e803e, 8.44444931e-001f, 7.00091898e-001f, 5.83658321e-003f},
  {0x7e75aa, 8.34555328e-001f, 7.05928504e-001f, 5.90574741e-003f},
  {0x7e6a69, 8.24512184e-001f, 7.11834252e-001f, 5.97768370e-003f},
  {0x7e5e67, 8.14306676e-001f, 7.17811942e-001f, 6.05260069e-003f},
  {0x7e5193, 8.03929090e-001f, 7.23864555e-001f, 6.13073120e-003f},
  {0x7e43d5, 7.93369055e-001f, 7.29995251e-001f, 6.21233368e-003f},
  {0x7e3515, 7.82615006e-001f, 7.36207604e-001f, 6.29769824e-003f},
  {0x7e2534, 7.71654427e-001f, 7.42505312e-001f, 6.38715085e-003f},
  {0x7e1411, 7.60473430e-001f, 7.48892426e-001f, 6.48105936e-003f},
  {0x7e0183, 7.49056637e-001f, 7.55373478e-001f, 6.57984056e-003f},
  {0x7ded5d, 7.37387240e-001f, 7.61953354e-001f, 6.68396894e-003f},
  {0x7dd767, 7.25446165e-001f, 7.68637300e-001f, 6.79398933e-003f},
  {0x7dbf61, 7.13212311e-001f, 7.75431275e-001f, 6.91052759e-003f},
  {0x7da4fc, 7.00661838e-001f, 7.82341838e-001f, 7.03431107e-003f},
  {0x7d87db, 6.87767863e-001f, 7.89376140e-001f, 7.16618681e-003f},
  {0x7d678b, 6.74499810e-001f, 7.96542346e-001f, 7.30715273e-003f},
  {0x7d437f, 6.60822570e-001f, 8.03849459e-001f, 7.45839113e-003f},
  {0x7d1b08, 6.46695733e-001f, 8.11307847e-001f, 7.62131717e-003f},
  {0x7ced48, 6.32072210e-001f, 8.18929195e-001f, 7.79764215e-003f},
  {0x7cb926, 6.16896987e-001f, 8.26726854e-001f, 7.98945874e-003f},
  {0x7c7d33, 6.01104617e-001f, 8.34716320e-001f, 8.19936022e-003f},
  {0x7c3788, 5.84616780e-001f, 8.42915654e-001f, 8.43060575e-003f},
  {0x7be597, 5.67338228e-001f, 8.51346254e-001f, 8.68736301e-003f},
  {0x7b83d4, 5.49151719e-001f, 8.60033631e-001f, 8.97506718e-003f},
  {0x7b0d2f, 5.29909730e-001f, 8.69008660e-001f, 9.30096768e-003f},
  {0x7a7a35, 5.09423316e-001f, 8.78309667e-001f, 9.67500452e-003f},
  {0x79bf6b, 4.87443954e-001f, 8.87984633e-001f, 1.01112612e-002f},
  {0x78ca38, 4.63634342e-001f, 8.98095906e-001f, 1.06305182e-002f},
  {0x777a5c, 4.37518388e-001f, 9.08726454e-001f, 1.12650646e-002f},
  {0x7592af, 4.08389121e-001f, 9.19991493e-001f, 1.20685706e-002f},
  {0x728fb4, 3.75121325e-001f, 9.32060063e-001f, 1.31388772e-002f},
  {0x6d1aa8, 3.35737526e-001f, 9.45198953e-001f, 1.46801388e-002f},
  {0x6045f5, 2.86174595e-001f, 9.59879100e-001f, 1.72226094e-002f},
  {0x0, 2.15241894e-001f, 9.77101684e-001f, 2.28982996e-002f}};

const CZigguratGaussian_FP64::TBinData CZigguratGaussian_FP64::Bins[CZigguratGaussian_FP64::NumBins] = {{UINT64_C(0xed5a442469c86), 3.71308624674036340e+000, 0, 0},
  {UINT64_C(0xefacc9cb3e7aa), 3.44261985589665190e+000, 2.66962908390250320e-003, 2.87936613691396670e-003},
  {UINT64_C(0xf4e442ecd31e3), 3.22308498457861870e+000, 5.54899522081647030e-003, 3.07548919211400030e-003},
  {UINT64_C(0xf75217b867632), 3.08322885821421360e+000, 8.62448441293047100e-003, 3.21499424505184260e-003},
  {UINT64_C(0xf8c01e3503b07), 2.97869625264501710e+000, 1.18394786579823130e-002, 3.32781935268972860e-003},
  {UINT64_C(0xf9b36957d7631), 2.89434400701867080e+000, 1.51672980106720420e-002, 3.42480472649377010e-003},
  {UINT64_C(0xfa61c12ef4eb6), 2.82312535054596660e+000, 1.85921027371658140e-002, 3.51120187894578010e-003},
  {UINT64_C(0xfae541f793634), 2.76116937238415390e+000, 2.21033046161115930e-002, 3.58998732003802410e-003},
  {UINT64_C(0xfb4c343c9e1c4), 2.70611357311872250e+000, 2.56932919361496160e-002, 3.66302550410421270e-003},
  {UINT64_C(0xfb9f18e44c3e0), 2.65640641125819240e+000, 2.93563174402538300e-002, 3.73156870625132590e-003},
  {UINT64_C(0xfbe354bbf1765), 2.61097224842861310e+000, 3.30878861465051520e-002, 3.79650264046361850e-003},
  {UINT64_C(0xfc1c7fea75fb0), 2.56903362592163910e+000, 3.68843887869687720e-002, 3.85847928782183080e-003},
  {UINT64_C(0xfc4d185e5531a), 2.53000967238546660e+000, 4.07428680747906060e-002, 3.91799412608182480e-003},
  {UINT64_C(0xfc76e6f466e49), 2.49345452209195080e+000, 4.46608622008724250e-002, 3.97543365941162210e-003},
  {UINT64_C(0xfc9b3bdb13e7c), 2.45901817740835020e+000, 4.86362958602840550e-002, 4.03110604321911800e-003},
  {UINT64_C(0xfcbb14343dfc6), 2.42642064553021180e+000, 5.26674019035031710e-002, 4.08526157803541440e-003},
  {UINT64_C(0xfcd7326658ef5), 2.39543427800746760e+000, 5.67526634815385890e-002, 4.13810686702779150e-003},
  {UINT64_C(0xfcf02e5177e25), 2.36587137011398770e+000, 6.08907703485663740e-002, 4.18981486506549760e-003},
  {UINT64_C(0xfd068067ddaaa), 2.33757524133553090e+000, 6.50805852136318720e-002, 4.24053218054837920e-003},
  {UINT64_C(0xfd1a8974e5beb), 2.31041368369500200e+000, 6.93211173941802590e-002, 4.29038449057464120e-003},
  {UINT64_C(0xfd2c982d9aad3), 2.28427405967365700e+000, 7.36115018847548900e-002, 4.33948062989982130e-003},
  {UINT64_C(0xfd3ced3f00194), 2.25905957386532960e+000, 7.79509825146547100e-002, 4.38791572830269420e-003},
  {UINT64_C(0xfd4bbe4f6092c), 2.23468639558705680e+000, 8.23388982429574120e-002, 4.43577365258556070e-003},
  {UINT64_C(0xfd593840d12ae), 2.21108140887472790e+000, 8.67746718955429710e-002, 4.48312893209174090e-003},
  {UINT64_C(0xfd6580ea1b2bb), 2.18818043207202080e+000, 9.12578008276347110e-002, 4.53004829494344130e-003},
  {UINT64_C(0xfd70b86ae561f), 2.16592679374484080e+000, 9.57878491225781640e-002, 4.57659190696738710e-003},
  {UINT64_C(0xfd7afa35123bb), 2.14427018235626130e+000, 1.00364441029545550e-001, 4.62281438080900000e-003},
  {UINT64_C(0xfd845ddde3917), 2.12316570866979020e+000, 1.04987255410354540e-001, 4.66876560546322130e-003},
  {UINT64_C(0xfd8cf7c45b13c), 2.10257313518499880e+000, 1.09656021015817760e-001, 4.71449143407051340e-003},
  {UINT64_C(0xfd94d996bb7b6), 2.08245623798772470e+000, 1.14370512449888270e-001, 4.76003425883031370e-003},
  {UINT64_C(0xfd9c12be84a31), 2.06278227450396350e+000, 1.19130546708718590e-001, 4.80543349526315470e-003},
  {UINT64_C(0xfda2b0b870f3c), 2.04352153665066940e+000, 1.23935980203981740e-001, 4.85072599312221830e-003},
  {UINT64_C(0xfda8bf5ca5dda), 2.02464697337293400e+000, 1.28786706197103970e-001, 4.89594638754368030e-003},
  {UINT64_C(0xfdae491a4e357), 2.00613386995896680e+000, 1.33682652584647650e-001, 4.94112740120339600e-003},
  {UINT64_C(0xfdb357291a996), 1.98795957412306090e+000, 1.38623779985851040e-001, 4.98630010608195830e-003},
  {UINT64_C(0xfdb7f1b297b7f), 1.97010326084971350e+000, 1.43610080091932990e-001, 5.03149415176397130e-003},
  {UINT64_C(0xfdbc1ff4dff8a), 1.95254572954888930e+000, 1.48641574243696950e-001, 5.07673796588960480e-003},
  {UINT64_C(0xfdbfe85fdcab9), 1.93526922829190040e+000, 1.53718312209586570e-001, 5.12205893134850750e-003},
  {UINT64_C(0xfdc350ae0c352), 1.91825730085973170e+000, 1.58840371140935080e-001, 5.16748354399266910e-003},
  {UINT64_C(0xfdc65df991f31), 1.90149465310031760e+000, 1.64007854684927760e-001, 5.21303755399700390e-003},
  {UINT64_C(0xfdc914ce2e802), 1.88496703570286920e+000, 1.69220892238924750e-001, 5.25874609347757110e-003},
  {UINT64_C(0xfdcb7938a0f83), 1.86866114098954220e+000, 1.74479638332402320e-001, 5.30463379255979170e-003},
  {UINT64_C(0xfdcd8ed3da108), 1.85256451172308710e+000, 1.79784272124962120e-001, 5.35072488575131810e-003},
  {UINT64_C(0xfdcf58d456e0c), 1.83666546025338380e+000, 1.85134997010713430e-001, 5.39704331020028890e-003},
  {UINT64_C(0xfdd0da11e9f84), 1.82095299659100500e+000, 1.90532040320913730e-001, 5.44361279719669280e-003},
  {UINT64_C(0xfdd215102d142), 1.80541676421404860e+000, 1.95975653118110410e-001, 5.49045695809282760e-003},
  {UINT64_C(0xfdd30c05cbca7), 1.79004698259461900e+000, 2.01466110076203210e-001, 5.53759936567055880e-003},
  {UINT64_C(0xfdd3c0e2cf5d4), 1.77483439558076930e+000, 2.07003709441873800e-001, 5.58506363186229980e-003},
  {UINT64_C(0xfdd435560d34c), 1.75977022489423200e+000, 2.12588773073736110e-001, 5.63287348263449490e-003},
  {UINT64_C(0xfdd46ad1d3fca), 1.74484612810837650e+000, 2.18221646556370580e-001, 5.68105283076329130e-003},
  {UINT64_C(0xfdd4628feecae), 1.73005416055824360e+000, 2.23902699387133890e-001, 5.72962584716881630e-003},
  {UINT64_C(0xfdd41d9511e20), 1.71538674070811670e+000, 2.29632325234302690e-001, 5.77861703142495270e-003},
  {UINT64_C(0xfdd39cb3c16b7), 1.70083661856430090e+000, 2.35410942265727670e-001, 5.82805128202365950e-003},
  {UINT64_C(0xfdd2e08ebfc9e), 1.68639684677348620e+000, 2.41238993547751300e-001, 5.87795396694542040e-003},
  {UINT64_C(0xfdd1e99b0ed52), 1.67206075409185220e+000, 2.47116947514696760e-001, 5.92835099506912410e-003},
  {UINT64_C(0xfdd0b8218d4e8), 1.65782192094820750e+000, 2.53045298509765870e-001, 5.97926888894488320e-003},
  {UINT64_C(0xfdcf4c4038209), 1.64367415685698260e+000, 2.59024567398710770e-001, 6.03073485945119800e-003},
  {UINT64_C(0xfdcda5eb15778), 1.62961147946467830e+000, 2.65055302258161930e-001, 6.08277688286333350e-003},
  {UINT64_C(0xfdcbc4ecce607), 1.61562809503713290e+000, 2.71138079141025220e-001, 6.13542378087243800e-003},
  {UINT64_C(0xfdc9a8e6fa665), 1.60171838021527700e+000, 2.77273502921897730e-001, 6.18870530411480630e-003},
  {UINT64_C(0xfdc751521f7ce), 1.58787686488440060e+000, 2.83462208226012540e-001, 6.24265221979797970e-003},
  {UINT64_C(0xfdc4bd7d677d5), 1.57409821601674960e+000, 2.89704860445810510e-001, 6.29729640404533880e-003},
  {UINT64_C(0xfdc1ec8e0b749), 1.56037722235984070e+000, 2.96002156849855810e-001, 6.35267093962392590e-003},
  {UINT64_C(0xfdbedd7e7400c), 1.54670877985350330e+000, 3.02354827789479810e-001, 6.40881021977215970e-003},
  {UINT64_C(0xfdbb8f1d0d018), 1.53308787766755610e+000, 3.08763638009251940e-001, 6.46575005890559930e-003},
  {UINT64_C(0xfdb8000ac9d97), 1.51950958475937090e+000, 3.15229388068157480e-001, 6.52352781105109810e-003},
  {UINT64_C(0xfdb42eb9566fe), 1.50596903685655010e+000, 3.21752915879208620e-001, 6.58218249694377580e-003},
  {UINT64_C(0xfdb01968f0057), 1.49246142377461540e+000, 3.28335098376152380e-001, 6.64175494081876550e-003},
  {UINT64_C(0xfdabbe25dfb4c), 1.47898197698309790e+000, 3.34976853316971190e-001, 6.70228791804252260e-003},
  {UINT64_C(0xfda71ac58f289), 1.46552595733579460e+000, 3.41679141235013640e-001, 6.76382631485878460e-003},
  {UINT64_C(0xfda22ce32e93d), 1.45208864288221660e+000, 3.48442967549872470e-001, 6.82641730167467520e-003},
  {UINT64_C(0xfd9cf1dbe152c), 1.43866531667746140e+000, 3.55269384851547130e-001, 6.89011052148606750e-003},
  {UINT64_C(0xfd9766ca64bc2), 1.42525125450686160e+000, 3.62159495373033210e-001, 6.95495829524192790e-003},
  {UINT64_C(0xfd91888222809), 1.41184171243976020e+000, 3.69114453668275110e-001, 7.02101584617929010e-003},
  {UINT64_C(0xfd8b53899d846), 1.39843191412360630e+000, 3.76135469514454420e-001, 7.08834154542921630e-003},
  {UINT64_C(0xfd84c414253d5), 1.38501703772514870e+000, 3.83223811059883680e-001, 7.15699718150584340e-003},
  {UINT64_C(0xfd7dd5fab84c2), 1.37159220241973220e+000, 3.90380808241389490e-001, 7.22704825665306320e-003},
  {UINT64_C(0xfd7684b3fb21d), 1.35815245432242280e+000, 3.97607856498042530e-001, 7.29856431344579930e-003},
  {UINT64_C(0xfd6ecb4b22e88), 1.34469275174571300e+000, 4.04906420811488310e-001, 7.37161929553626930e-003},
  {UINT64_C(0xfd66a455af7c7), 1.33120794965767650e+000, 4.12278040107024620e-001, 7.44629194701361410e-003},
  {UINT64_C(0xfd5e09e7c8d03), 1.31769278320134300e+000, 4.19724332054038250e-001, 7.52266625552416420e-003},
  {UINT64_C(0xfd54f5870c6c6), 1.30414185012042160e+000, 4.27246998309562360e-001, 7.60083194509949750e-003},
  {UINT64_C(0xfd4b601b8e90b), 1.29054959191787310e+000, 4.34847830254661890e-001, 7.68088502558471850e-003},
  {UINT64_C(0xfd4141dec7702), 1.27691027355169970e+000, 4.42528715280246620e-001, 7.76292840668034620e-003},
  {UINT64_C(0xfd36924817bd2), 1.26321796144602820e+000, 4.50291643686926980e-001, 7.84707258594500440e-003},
  {UINT64_C(0xfd2b47f67f96e), 1.24946649956433360e+000, 4.58138716272871950e-001, 7.93343642169901460e-003},
  {UINT64_C(0xfd1f58970f524), 1.23564948325448110e+000, 4.66072152694570970e-001, 8.02214800367862490e-003},
  {UINT64_C(0xfd12b8c7819d6), 1.22176023053096250e+000, 4.74094300698249590e-001, 8.11334563658908620e-003},
  {UINT64_C(0xfd055bf4510cd), 1.20779175040675770e+000, 4.82207646334838700e-001, 8.20717895448294650e-003},
  {UINT64_C(0xfcf7343176cb3), 1.19373670782377220e+000, 4.90414825289321680e-001, 8.30381018726268630e-003},
  {UINT64_C(0xfce8320cd30d2), 1.17958738465446070e+000, 4.98718635476584290e-001, 8.40341560472026430e-003},
  {UINT64_C(0xfcd8445907b15), 1.16533563615504690e+000, 5.07122051081304590e-001, 8.50618716856746220e-003},
  {UINT64_C(0xfcc757ef46ebf), 1.15097284213897600e+000, 5.15628238249872030e-001, 8.61233442912074510e-003},
  {UINT64_C(0xfcb557663edcd), 1.13648985200307550e+000, 5.24240572678992820e-001, 8.72208671099478950e-003},
  {UINT64_C(0xfca22abbd9f85), 1.12187692257225400e+000, 5.32962659389987550e-001, 8.83569564173653480e-003},
  {UINT64_C(0xfc8db6eefbc49), 1.10712364752353530e+000, 5.41798355031724130e-001, 8.95343808933115290e-003},
  {UINT64_C(0xfc77dd85a7a76), 1.09221887689655370e+000, 5.50751793121055270e-001, 9.07561958963954040e-003},
  {UINT64_C(0xfc607bfb0eb26), 1.07715062488193760e+000, 5.59827412710694810e-001, 9.20257836402679430e-003},
  {UINT64_C(0xfc476b0fc6cb9), 1.06190596368361940e+000, 5.69029991074721520e-001, 9.33469005198070060e-003},
  {UINT64_C(0xfc2c7df4cf4d5), 1.04647090075258030e+000, 5.78364681126702360e-001, 9.47237331511821200e-003},
  {UINT64_C(0xfc0f8147e0d63), 1.03083023605645560e+000, 5.87837054441820550e-001, 9.61609650999175650e-003},
  {UINT64_C(0xfbf039d4a3f47), 1.01496739523929950e+000, 5.97453150951812280e-001, 9.76638568079260350e-003},
  {UINT64_C(0xfbce630a82c38), 9.98864233480643460e-001, 6.07219536632604860e-001, 9.92383419395760290e-003},
  {UINT64_C(0xfba9ad117147f), 9.82500803502760370e-001, 6.17143370826562570e-001, 1.00891144312520770e-002},
  {UINT64_C(0xfb81ba60a1dd6), 9.65855079388130530e-001, 6.27232485257814500e-001, 1.02629920853303090e-002},
  {UINT64_C(0xfb561cafbb9ed), 9.48902625497911930e-001, 6.37495477343144930e-001, 1.04463437754059340e-002},
  {UINT64_C(0xfb26510c6d071), 9.31616196601353750e-001, 6.47941821118550810e-001, 1.06401789401028710e-002},
  {UINT64_C(0xfaf1bac8fa7f9), 9.13965251008801770e-001, 6.58582000058653750e-001, 1.08456672990524870e-002},
  {UINT64_C(0xfab79cd957292), 8.95915352566238550e-001, 6.69427667357706200e-001, 1.10641736487081650e-002},
  {UINT64_C(0xfa77110617069), 8.77427429097715760e-001, 6.80491841006414240e-001, 1.12973024396215200e-002},
  {UINT64_C(0xfa2efc1667f11), 8.58456843178050820e-001, 6.91789143446035810e-001, 1.15469555797815640e-002},
  {UINT64_C(0xf9ddfda5b286b), 8.38952214281207480e-001, 7.03336099025817400e-001, 1.18154083946596270e-002},
  {UINT64_C(0xf98259adad18c), 8.18853906683317810e-001, 7.15151507420477060e-001, 1.21054109340288340e-002},
  {UINT64_C(0xf919d8b6b9593), 7.98092060626274800e-001, 7.27256918354505900e-001, 1.24203253288322700e-002},
  {UINT64_C(0xf8a199cebca78), 7.76583987876148350e-001, 7.39677243683338200e-001, 1.27643155023656530e-002},
  {UINT64_C(0xf815ce44612cb), 7.54230664434510150e-001, 7.52441559185703770e-001, 1.31426147235321950e-002},
  {UINT64_C(0xf771518c32c92), 7.30911910621881210e-001, 7.65584173909235940e-001, 1.35619120324671720e-002},
  {UINT64_C(0xf6ad054c5acb0), 7.06479611313608040e-001, 7.79146085941703200e-001, 1.40309258421560460e-002},
  {UINT64_C(0xf5bec53e6296a), 6.80747918645904230e-001, 7.93177011783859240e-001, 1.45612829122619030e-002},
  {UINT64_C(0xf4979cba30c87), 6.53478638715042300e-001, 8.07738294696121130e-001, 1.51689166991408870e-002},
  {UINT64_C(0xf3208b87a197a), 6.24358597309088270e-001, 8.22907211395262020e-001, 1.58763939153852250e-002},
  {UINT64_C(0xf1344b7af4e41), 5.92962942441978000e-001, 8.38783605310647220e-001, 1.67170025744170610e-002},
  {UINT64_C(0xee9243d6d8ea3), 5.58692178375517990e-001, 8.55500607885064210e-001, 1.77424410417893060e-002},
  {UINT64_C(0xeac00a3a040d4), 5.20656038725144880e-001, 8.73243048926853560e-001, 1.90386018754491360e-002},
  {UINT64_C(0xe4b68d43fed6a), 4.77437837253787860e-001, 8.92281650802302710e-001, 2.07619971897353390e-002},
  {UINT64_C(0xd9c88f4d8196a), 4.26547986303305150e-001, 9.13043647992037970e-001, 2.32390337163330160e-002},
  {UINT64_C(0xc01e36a71ab09), 3.62871431028418290e-001, 9.36282681708371030e-001, 2.73170114473965250e-002},
  {UINT64_C(0x0000000000000), 2.72320864704663880e-001, 9.63599693155767540e-001, 3.64003068442324000e-002}};

//  128 bins:
//    DIGITS = 32 gives r = 6.898315115152075929700371759999
//    DIGITS = 48 gives r = 6.898315116615642605754685885904
//    DIGITS = 64 gives r = 6.898315116615642605754685885904
//    DIGITS = 80 gives r = 6.898315116615642605754685885904
//    DIGITS = 96 gives r = 6.898315116615642605754685885904
//    Using 6.898315116615642605754685885905
//  256 bins:
//    DIGITS = 32 gives r = 7.697117467070213692186499485999
//    DIGITS = 48 gives r = 7.697117470131049714044628048015
//    DIGITS = 64 gives r = 7.697117470131049714044628048015
//    DIGITS = 80 gives r = 7.697117470131049714044628048015
//    DIGITS = 96 gives r = 7.697117470131049714044628048015
//    Using 7.697117470131049714044628048016
const CZigguratExponential_FP32::TBinData CZigguratExponential_FP32::Bins[CZigguratExponential_FP32::NumBins] = {
  {0x714851, 8.69711781e+000f, 0, 0},
  {0x736d37, 7.69711733e+000f, 4.54134366e-004f, 5.13134932e-004f},
  {0x7777d9, 6.94103384e+000f, 9.67269298e-004f, 5.69030526e-004f},
  {0x796587, 6.47837830e+000f, 1.53629982e-003f, 6.09667972e-004f},
  {0x7a8a98, 6.14416456e+000f, 2.14596768e-003f, 6.42831030e-004f},
  {0x7b4e33, 5.88214445e+000f, 2.78879888e-003f, 6.71465998e-004f},
  {0x7bdabc, 5.66640997e+000f, 3.46026476e-003f, 6.97030337e-004f},
  {0x7c44f8, 5.48289061e+000f, 4.15729498e-003f, 7.20360840e-004f},
  {0x7c9851, 5.32309055e+000f, 4.87765577e-003f, 7.41986209e-004f},
  {0x7cdb97, 5.18148708e+000f, 5.61964232e-003f, 7.62263720e-004f},
  {0x7d131e, 5.05428839e+000f, 6.38190610e-003f, 7.81447219e-004f},
  {0x7d41c9, 4.93877697e+000f, 7.16335326e-003f, 7.99724250e-004f},
  {0x7d699a, 4.83293962e+000f, 7.96307717e-003f, 8.17237538e-004f},
  {0x7d8c00, 4.73524284e+000f, 8.78031459e-003f, 8.34098668e-004f},
  {0x7daa09, 4.64449167e+000f, 9.61441360e-003f, 8.50396522e-004f},
  {0x7dc480, 4.55973721e+000f, 1.04648098e-002f, 8.66203394e-004f},
  {0x7ddc03, 4.48021173e+000f, 1.13310134e-002f, 8.81578831e-004f},
  {0x7df10a, 4.40528774e+000f, 1.22125922e-002f, 8.96572485e-004f},
  {0x7e03f7, 4.33444357e+000f, 1.31091652e-002f, 9.11226496e-004f},
  {0x7e1518, 4.26724243e+000f, 1.40203917e-002f, 9.25576605e-004f},
  {0x7e24ac, 4.20331383e+000f, 1.49459681e-002f, 9.39653837e-004f},
  {0x7e32e6, 4.14234066e+000f, 1.58856213e-002f, 9.53484967e-004f},
  {0x7e3ff3, 4.08405113e+000f, 1.68391075e-002f, 9.67093569e-004f},
  {0x7e4bf7, 4.02820873e+000f, 1.78062003e-002f, 9.80500365e-004f},
  {0x7e570f, 3.97460604e+000f, 1.87867004e-002f, 9.93723632e-004f},
  {0x7e6155, 3.92306256e+000f, 1.97804235e-002f, 1.00677973e-003f},
  {0x7e6ae1, 3.87341762e+000f, 2.07872037e-002f, 1.01968343e-003f},
  {0x7e73c5, 3.82552934e+000f, 2.18068883e-002f, 1.03244791e-003f},
  {0x7e7c11, 3.77927089e+000f, 2.28393357e-002f, 1.04508514e-003f},
  {0x7e83d4, 3.73452878e+000f, 2.38844212e-002f, 1.05760596e-003f},
  {0x7e8b1a, 3.69120097e+000f, 2.49420255e-002f, 1.07002025e-003f},
  {0x7e91ef, 3.64919543e+000f, 2.60120463e-002f, 1.08233711e-003f},
  {0x7e985d, 3.60842872e+000f, 2.70943847e-002f, 1.09456503e-003f},
  {0x7e9e6b, 3.56882524e+000f, 2.81889495e-002f, 1.10671145e-003f},
  {0x7ea422, 3.53031588e+000f, 2.92956606e-002f, 1.11878372e-003f},
  {0x7ea988, 3.49283767e+000f, 3.04144435e-002f, 1.13078824e-003f},
  {0x7eaea4, 3.45633292e+000f, 3.15452330e-002f, 1.14273129e-003f},
  {0x7eb37a, 3.42074847e+000f, 3.26879621e-002f, 1.15461869e-003f},
  {0x7eb811, 3.38603544e+000f, 3.38425823e-002f, 1.16645556e-003f},
  {0x7ebc6d, 3.35214901e+000f, 3.50090377e-002f, 1.17824704e-003f},
  {0x7ec091, 3.31904745e+000f, 3.61872837e-002f, 1.18999800e-003f},
  {0x7ec481, 3.28669214e+000f, 3.73772830e-002f, 1.20171276e-003f},
  {0x7ec841, 3.25504732e+000f, 3.85789946e-002f, 1.21339550e-003f},
  {0x7ecbd3, 3.22407961e+000f, 3.97923924e-002f, 1.22505031e-003f},
  {0x7ecf3b, 3.19375801e+000f, 4.10174429e-002f, 1.23668101e-003f},
  {0x7ed27b, 3.16405344e+000f, 4.22541238e-002f, 1.24829111e-003f},
  {0x7ed595, 3.13493896e+000f, 4.35024127e-002f, 1.25988421e-003f},
  {0x7ed88c, 3.10638905e+000f, 4.47622985e-002f, 1.27146335e-003f},
  {0x7edb61, 3.07838011e+000f, 4.60337624e-002f, 1.28303189e-003f},
  {0x7ede16, 3.05088997e+000f, 4.73167934e-002f, 1.29459263e-003f},
  {0x7ee0ae, 3.02389741e+000f, 4.86113839e-002f, 1.30614871e-003f},
  {0x7ee329, 2.99738288e+000f, 4.99175340e-002f, 1.31770282e-003f},
  {0x7ee589, 2.97132778e+000f, 5.12352362e-002f, 1.32925750e-003f},
  {0x7ee7cf, 2.94571447e+000f, 5.25644943e-002f, 1.34081556e-003f},
  {0x7ee9fd, 2.92052627e+000f, 5.39053120e-002f, 1.35237945e-003f},
  {0x7eec13, 2.89574766e+000f, 5.52576892e-002f, 1.36395160e-003f},
  {0x7eee14, 2.87136412e+000f, 5.66216409e-002f, 1.37553434e-003f},
  {0x7eefff, 2.84736085e+000f, 5.79971746e-002f, 1.38713000e-003f},
  {0x7ef1d6, 2.82372522e+000f, 5.93843050e-002f, 1.39874080e-003f},
  {0x7ef39a, 2.80044436e+000f, 6.07830472e-002f, 1.41036895e-003f},
  {0x7ef54b, 2.77750611e+000f, 6.21934161e-002f, 1.42201665e-003f},
  {0x7ef6ea, 2.75489926e+000f, 6.36154339e-002f, 1.43368577e-003f},
  {0x7ef878, 2.73261261e+000f, 6.50491193e-002f, 1.44537864e-003f},
  {0x7ef9f6, 2.71063614e+000f, 6.64944947e-002f, 1.45709701e-003f},
  {0x7efb64, 2.68895960e+000f, 6.79515898e-002f, 1.46884308e-003f},
  {0x7efcc3, 2.66757393e+000f, 6.94204345e-002f, 1.48061861e-003f},
  {0x7efe13, 2.64647007e+000f, 7.09010586e-002f, 1.49242568e-003f},
  {0x7eff56, 2.62563896e+000f, 7.23934844e-002f, 1.50426617e-003f},
  {0x7f008b, 2.60507298e+000f, 7.38977492e-002f, 1.51614170e-003f},
  {0x7f01b2, 2.58476377e+000f, 7.54138902e-002f, 1.52805448e-003f},
  {0x7f02cd, 2.56470418e+000f, 7.69419447e-002f, 1.54000602e-003f},
  {0x7f03dc, 2.54488659e+000f, 7.84819499e-002f, 1.55199831e-003f},
  {0x7f04df, 2.52530432e+000f, 8.00339505e-002f, 1.56403321e-003f},
  {0x7f05d6, 2.50595069e+000f, 8.15979838e-002f, 1.57611235e-003f},
  {0x7f06c2, 2.48681927e+000f, 8.31740946e-002f, 1.58823747e-003f},
  {0x7f07a4, 2.46790409e+000f, 8.47623274e-002f, 1.60041056e-003f},
  {0x7f087b, 2.44919896e+000f, 8.63627419e-002f, 1.61263335e-003f},
  {0x7f0947, 2.43069839e+000f, 8.79753754e-002f, 1.62490748e-003f},
  {0x7f0a0a, 2.41239691e+000f, 8.96002799e-002f, 1.63723470e-003f},
  {0x7f0ac3, 2.39428902e+000f, 9.12375152e-002f, 1.64961687e-003f},
  {0x7f0b73, 2.37637019e+000f, 9.28871334e-002f, 1.66205585e-003f},
  {0x7f0c19, 2.35863495e+000f, 9.45491865e-002f, 1.67455315e-003f},
  {0x7f0cb7, 2.34107924e+000f, 9.62237418e-002f, 1.68711075e-003f},
  {0x7f0d4c, 2.32369781e+000f, 9.79108512e-002f, 1.69973040e-003f},
  {0x7f0dd8, 2.30648685e+000f, 9.96105820e-002f, 1.71241374e-003f},
  {0x7f0e5c, 2.28944182e+000f, 1.01323001e-001f, 1.72516273e-003f},
  {0x7f0ed7, 2.27255893e+000f, 1.03048161e-001f, 1.73797912e-003f},
  {0x7f0f4b, 2.25583386e+000f, 1.04786143e-001f, 1.75086479e-003f},
  {0x7f0fb7, 2.23926282e+000f, 1.06537007e-001f, 1.76382135e-003f},
  {0x7f101b, 2.22284245e+000f, 1.08300827e-001f, 1.77685090e-003f},
  {0x7f1077, 2.20656896e+000f, 1.10077679e-001f, 1.78995531e-003f},
  {0x7f10cc, 2.19043899e+000f, 1.11867629e-001f, 1.80313620e-003f},
  {0x7f111a, 2.17444897e+000f, 1.13670766e-001f, 1.81639567e-003f},
  {0x7f1160, 2.15859580e+000f, 1.15487166e-001f, 1.82973559e-003f},
  {0x7f119f, 2.14287639e+000f, 1.17316902e-001f, 1.84315792e-003f},
  {0x7f11d8, 2.12728763e+000f, 1.19160056e-001f, 1.85666466e-003f},
  {0x7f1209, 2.11182666e+000f, 1.21016718e-001f, 1.87025766e-003f},
  {0x7f1233, 2.09649014e+000f, 1.22886978e-001f, 1.88393902e-003f},
  {0x7f1257, 2.08127594e+000f, 1.24770917e-001f, 1.89771084e-003f},
  {0x7f1274, 2.06618071e+000f, 1.26668632e-001f, 1.91157509e-003f},
  {0x7f128b, 2.05120230e+000f, 1.28580198e-001f, 1.92553387e-003f},
  {0x7f129b, 2.03633809e+000f, 1.30505741e-001f, 1.93958939e-003f},
  {0x7f12a4, 2.02158523e+000f, 1.32445320e-001f, 1.95374386e-003f},
  {0x7f12a7, 2.00694180e+000f, 1.34399071e-001f, 1.96799915e-003f},
  {0x7f12a4, 1.99240494e+000f, 1.36367068e-001f, 1.98235805e-003f},
  {0x7f129a, 1.97797275e+000f, 1.38349429e-001f, 1.99682219e-003f},
  {0x7f128a, 1.96364272e+000f, 1.40346244e-001f, 2.01139436e-003f},
  {0x7f1274, 1.94941270e+000f, 1.42357647e-001f, 2.02607666e-003f},
  {0x7f1258, 1.93528080e+000f, 1.44383729e-001f, 2.04087165e-003f},
  {0x7f1235, 1.92124474e+000f, 1.46424592e-001f, 2.05578166e-003f},
  {0x7f120c, 1.90730250e+000f, 1.48480371e-001f, 2.07080925e-003f},
  {0x7f11dd, 1.89345217e+000f, 1.50551185e-001f, 2.08595698e-003f},
  {0x7f11a8, 1.87969184e+000f, 1.52637139e-001f, 2.10122741e-003f},
  {0x7f116d, 1.86601949e+000f, 1.54738367e-001f, 2.11662287e-003f},
  {0x7f112b, 1.85243356e+000f, 1.56854987e-001f, 2.13214662e-003f},
  {0x7f10e4, 1.83893192e+000f, 1.58987135e-001f, 2.14780099e-003f},
  {0x7f1096, 1.82551312e+000f, 1.61134943e-001f, 2.16358877e-003f},
  {0x7f1042, 1.81217527e+000f, 1.63298532e-001f, 2.17951322e-003f},
  {0x7f0fe8, 1.79891682e+000f, 1.65478036e-001f, 2.19557667e-003f},
  {0x7f0f88, 1.78573596e+000f, 1.67673618e-001f, 2.21178262e-003f},
  {0x7f0f21, 1.77263117e+000f, 1.69885397e-001f, 2.22813408e-003f},
  {0x7f0eb4, 1.75960088e+000f, 1.72113538e-001f, 2.24463386e-003f},
  {0x7f0e41, 1.74664366e+000f, 1.74358174e-001f, 2.26128544e-003f},
  {0x7f0dc8, 1.73375785e+000f, 1.76619455e-001f, 2.27809208e-003f},
  {0x7f0d48, 1.72094202e+000f, 1.78897545e-001f, 2.29505682e-003f},
  {0x7f0cc2, 1.70819473e+000f, 1.81192607e-001f, 2.31218361e-003f},
  {0x7f0c36, 1.69551456e+000f, 1.83504790e-001f, 2.32947571e-003f},
  {0x7f0ba3, 1.68290007e+000f, 1.85834259e-001f, 2.34693661e-003f},
  {0x7f0b09, 1.67034996e+000f, 1.88181207e-001f, 2.36457027e-003f},
  {0x7f0a69, 1.65786290e+000f, 1.90545768e-001f, 2.38238042e-003f},
  {0x7f09c2, 1.64543748e+000f, 1.92928150e-001f, 2.40037078e-003f},
  {0x7f0914, 1.63307238e+000f, 1.95328519e-001f, 2.41854554e-003f},
  {0x7f0860, 1.62076652e+000f, 1.97747067e-001f, 2.43690866e-003f},
  {0x7f07a4, 1.60851848e+000f, 2.00183973e-001f, 2.45546433e-003f},
  {0x7f06e2, 1.59632707e+000f, 2.02639446e-001f, 2.47421721e-003f},
  {0x7f0618, 1.58419108e+000f, 2.05113649e-001f, 2.49317149e-003f},
  {0x7f0548, 1.57210922e+000f, 2.07606822e-001f, 2.51233159e-003f},
  {0x7f0470, 1.56008053e+000f, 2.10119158e-001f, 2.53170263e-003f},
  {0x7f0391, 1.54810357e+000f, 2.12650865e-001f, 2.55128904e-003f},
  {0x7f02aa, 1.53617740e+000f, 2.15202153e-001f, 2.57109618e-003f},
  {0x7f01bb, 1.52430093e+000f, 2.17773244e-001f, 2.59112869e-003f},
  {0x7f00c5, 1.51247287e+000f, 2.20364377e-001f, 2.61139218e-003f},
  {0x7effc7, 1.50069213e+000f, 2.22975761e-001f, 2.63189198e-003f},
  {0x7efec1, 1.48895776e+000f, 2.25607663e-001f, 2.65263370e-003f},
  {0x7efdb2, 1.47726870e+000f, 2.28260294e-001f, 2.67362315e-003f},
  {0x7efc9c, 1.46562374e+000f, 2.30933920e-001f, 2.69486615e-003f},
  {0x7efb7d, 1.45402181e+000f, 2.33628780e-001f, 2.71636900e-003f},
  {0x7efa55, 1.44246209e+000f, 2.36345157e-001f, 2.73813773e-003f},
  {0x7ef924, 1.43094325e+000f, 2.39083290e-001f, 2.76017911e-003f},
  {0x7ef7eb, 1.41946459e+000f, 2.41843462e-001f, 2.78249965e-003f},
  {0x7ef6a8, 1.40802491e+000f, 2.44625971e-001f, 2.80510657e-003f},
  {0x7ef55c, 1.39662325e+000f, 2.47431070e-001f, 2.82800663e-003f},
  {0x7ef406, 1.38525856e+000f, 2.50259072e-001f, 2.85120774e-003f},
  {0x7ef2a7, 1.37392998e+000f, 2.53110290e-001f, 2.87471712e-003f},
  {0x7ef13d, 1.36263645e+000f, 2.55985022e-001f, 2.89854268e-003f},
  {0x7eefc9, 1.35137689e+000f, 2.58883536e-001f, 2.92269303e-003f},
  {0x7eee4a, 1.34015059e+000f, 2.61806250e-001f, 2.94717611e-003f},
  {0x7eecc1, 1.32895637e+000f, 2.64753431e-001f, 2.97200121e-003f},
  {0x7eeb2d, 1.31779337e+000f, 2.67725408e-001f, 2.99717695e-003f},
  {0x7ee98d, 1.30666065e+000f, 2.70722598e-001f, 3.02271289e-003f},
  {0x7ee7e2, 1.29555714e+000f, 2.73745298e-001f, 3.04861879e-003f},
  {0x7ee62a, 1.28448200e+000f, 2.76793927e-001f, 3.07490490e-003f},
  {0x7ee466, 1.27343428e+000f, 2.79868841e-001f, 3.10158124e-003f},
  {0x7ee296, 1.26241291e+000f, 2.82970428e-001f, 3.12865921e-003f},
  {0x7ee0b8, 1.25141716e+000f, 2.86099076e-001f, 3.15614976e-003f},
  {0x7edece, 1.24044585e+000f, 2.89255232e-001f, 3.18406476e-003f},
  {0x7edcd5, 1.22949815e+000f, 2.92439282e-001f, 3.21241608e-003f},
  {0x7edace, 1.21857321e+000f, 2.95651704e-001f, 3.24121676e-003f},
  {0x7ed8b9, 1.20766985e+000f, 2.98892915e-001f, 3.27047962e-003f},
  {0x7ed694, 1.19678736e+000f, 3.02163392e-001f, 3.30021861e-003f},
  {0x7ed460, 1.18592465e+000f, 3.05463612e-001f, 3.33044771e-003f},
  {0x7ed21c, 1.17508066e+000f, 3.08794081e-001f, 3.36118182e-003f},
  {0x7ecfc7, 1.16425467e+000f, 3.12155247e-001f, 3.39243654e-003f},
  {0x7ecd61, 1.15344548e+000f, 3.15547675e-001f, 3.42422770e-003f},
  {0x7ecae9, 1.14265227e+000f, 3.18971902e-001f, 3.45657207e-003f},
  {0x7ec85e, 1.13187397e+000f, 3.22428495e-001f, 3.48948734e-003f},
  {0x7ec5c1, 1.12110960e+000f, 3.25917959e-001f, 3.52299190e-003f},
  {0x7ec310, 1.11035812e+000f, 3.29440951e-001f, 3.55710438e-003f},
  {0x7ec04b, 1.09961855e+000f, 3.32998067e-001f, 3.59184528e-003f},
  {0x7ebd71, 1.08888996e+000f, 3.36589903e-001f, 3.62723507e-003f},
  {0x7eba80, 1.07817113e+000f, 3.40217143e-001f, 3.66329565e-003f},
  {0x7eb779, 1.06746125e+000f, 3.43880445e-001f, 3.70004983e-003f},
  {0x7eb45a, 1.05675900e+000f, 3.47580492e-001f, 3.73752182e-003f},
  {0x7eb123, 1.04606342e+000f, 3.51318002e-001f, 3.77573632e-003f},
  {0x7eadd1, 1.03537345e+000f, 3.55093747e-001f, 3.81472008e-003f},
  {0x7eaa66, 1.02468789e+000f, 3.58908474e-001f, 3.85450036e-003f},
  {0x7ea6de, 1.01400566e+000f, 3.62762988e-001f, 3.89510649e-003f},
  {0x7ea33a, 1.00332558e+000f, 3.66658092e-001f, 3.93656874e-003f},
  {0x7e9f77, 9.92646396e-001f, 3.70594651e-001f, 3.97891924e-003f},
  {0x7e9b95, 9.81967032e-001f, 3.74573559e-001f, 4.02219174e-003f},
  {0x7e9793, 9.71286237e-001f, 3.78595769e-001f, 4.06642212e-003f},
  {0x7e936d, 9.60602701e-001f, 3.82662177e-001f, 4.11164761e-003f},
  {0x7e8f24, 9.49915171e-001f, 3.86773825e-001f, 4.15790780e-003f},
  {0x7e8ab6, 9.39222336e-001f, 3.90931726e-001f, 4.20524506e-003f},
  {0x7e8620, 9.28522766e-001f, 3.95136982e-001f, 4.25370270e-003f},
  {0x7e8160, 9.17815208e-001f, 3.99390697e-001f, 4.30332823e-003f},
  {0x7e7c76, 9.07098055e-001f, 4.03694004e-001f, 4.35417052e-003f},
  {0x7e775d, 8.96369994e-001f, 4.08048183e-001f, 4.40628268e-003f},
  {0x7e7215, 8.85629475e-001f, 4.12454456e-001f, 4.45972057e-003f},
  {0x7e6c9b, 8.74874890e-001f, 4.16914195e-001f, 4.51454241e-003f},
  {0x7e66ec, 8.64104629e-001f, 4.21428740e-001f, 4.57081199e-003f},
  {0x7e6104, 8.53317022e-001f, 4.25999552e-001f, 4.62859636e-003f},
  {0x7e5ae2, 8.42510343e-001f, 4.30628151e-001f, 4.68796585e-003f},
  {0x7e5481, 8.31682861e-001f, 4.35316116e-001f, 4.74899774e-003f},
  {0x7e4ddf, 8.20832610e-001f, 4.40065116e-001f, 4.81177261e-003f},
  {0x7e46f6, 8.09957743e-001f, 4.44876879e-001f, 4.87637753e-003f},
  {0x7e3fc4, 7.99056172e-001f, 4.49753255e-001f, 4.94290609e-003f},
  {0x7e3843, 7.88125873e-001f, 4.54696149e-001f, 5.01145795e-003f},
  {0x7e306f, 7.77164638e-001f, 4.59707618e-001f, 5.08214068e-003f},
  {0x7e2842, 7.66170084e-001f, 4.64789748e-001f, 5.15506882e-003f},
  {0x7e1fb6, 7.55140007e-001f, 4.69944835e-001f, 5.23036765e-003f},
  {0x7e16c6, 7.44071722e-001f, 4.75175202e-001f, 5.30817080e-003f},
  {0x7e0d69, 7.32962668e-001f, 4.80483353e-001f, 5.38862357e-003f},
  {0x7e0399, 7.21810102e-001f, 4.85872000e-001f, 5.47188241e-003f},
  {0x7df94d, 7.10611045e-001f, 4.91343856e-001f, 5.55811776e-003f},
  {0x7dee7c, 6.99362457e-001f, 4.96901989e-001f, 5.64751448e-003f},
  {0x7de31c, 6.88061118e-001f, 5.02549529e-001f, 5.74027468e-003f},
  {0x7dd722, 6.76703572e-001f, 5.08289754e-001f, 5.83661720e-003f},
  {0x7dca82, 6.65286124e-001f, 5.14126420e-001f, 5.93678374e-003f},
  {0x7dbd2d, 6.53804958e-001f, 5.20063162e-001f, 6.04103645e-003f},
  {0x7daf15, 6.42255962e-001f, 5.26104212e-001f, 6.14966638e-003f},
  {0x7da028, 6.30634665e-001f, 5.32253861e-001f, 6.26299158e-003f},
  {0x7d9053, 6.18936479e-001f, 5.38516879e-001f, 6.38136547e-003f},
  {0x7d7f82, 6.07156217e-001f, 5.44898212e-001f, 6.50517875e-003f},
  {0x7d6d9b, 5.95288575e-001f, 5.51403403e-001f, 6.63486589e-003f},
  {0x7d5a84, 5.83327711e-001f, 5.58038294e-001f, 6.77091070e-003f},
  {0x7d461d, 5.71267307e-001f, 5.64809203e-001f, 6.91385567e-003f},
  {0x7d3043, 5.59100568e-001f, 5.71723044e-001f, 7.06430990e-003f},
  {0x7d18cd, 5.46820104e-001f, 5.78787386e-001f, 7.22295977e-003f},
  {0x7cff8c, 5.34417868e-001f, 5.86010337e-001f, 7.39058340e-003f},
  {0x7ce449, 5.21885037e-001f, 5.93400896e-001f, 7.56806461e-003f},
  {0x7cc6c6, 5.09211957e-001f, 6.00968957e-001f, 7.75641575e-003f},
  {0x7ca6b8, 4.96388048e-001f, 6.08725369e-001f, 7.95679912e-003f},
  {0x7c83c8, 4.83401477e-001f, 6.16682172e-001f, 8.17055814e-003f},
  {0x7c5d8e, 4.70239282e-001f, 6.24852717e-001f, 8.39925557e-003f},
  {0x7c338c, 4.56886828e-001f, 6.33251965e-001f, 8.64472240e-003f},
  {0x7c052e, 4.43327874e-001f, 6.41896725e-001f, 8.90911743e-003f},
  {0x7bd1bb, 4.29543942e-001f, 6.50805831e-001f, 9.19500738e-003f},
  {0x7b9853, 4.15514171e-001f, 6.60000861e-001f, 9.50547587e-003f},
  {0x7b57dc, 4.01214689e-001f, 6.69506311e-001f, 9.84425563e-003f},
  {0x7b0ef4, 3.86617988e-001f, 6.79350555e-001f, 1.02159241e-002f},
  {0x7abbd7, 3.71692151e-001f, 6.89566493e-001f, 1.06261587e-002f},
  {0x7a5c37, 3.56399775e-001f, 7.00192630e-001f, 1.10821053e-002f},
  {0x79ed08, 3.40696484e-001f, 7.11274743e-001f, 1.15928985e-002f},
  {0x796a2c, 3.24529111e-001f, 7.22867668e-001f, 1.21704331e-002f},
  {0x78cdee, 3.07832956e-001f, 7.35038102e-001f, 1.28305294e-002f},
  {0x781027, 2.90527970e-001f, 7.47868598e-001f, 1.35947671e-002f},
  {0x7724d3, 2.72513181e-001f, 7.61463404e-001f, 1.44934636e-002f},
  {0x75f96f, 2.53658354e-001f, 7.75956869e-001f, 1.55707849e-002f},
  {0x746ff9, 2.33790487e-001f, 7.91527629e-001f, 1.68940146e-002f},
  {0x725474, 2.12671503e-001f, 8.08421671e-001f, 1.85716450e-002f},
  {0x6f44a0, 1.89958692e-001f, 8.26993287e-001f, 2.07922049e-002f},
  {0x6a6edd, 1.65127620e-001f, 8.47785473e-001f, 2.39188317e-002f},
  {0x61bbd6, 1.37304977e-001f, 8.71704340e-001f, 2.87655983e-002f},
  {0x4df56f, 1.04838505e-001f, 9.00469959e-001f, 3.76737528e-002f},
  {0x0, 6.38521612e-002f, 9.38143671e-001f, 6.18563183e-002f}};

const CZigguratExponential_FP64::TBinData CZigguratExponential_FP64::Bins[CZigguratExponential_FP64::NumBins] = {
  {UINT64_C(0xdf9688bda95ce), 7.89831511661564360e+000, 0, 0},
  {UINT64_C(0xe3ae1dd040148), 6.89831511661564270e+000, 1.00948486124341270e-003, 1.15582274870986290e-003},
  {UINT64_C(0xec622f1fa45a8), 6.13519284450123870e+000, 2.16530760995327540e-003, 1.29958906616922730e-003},
  {UINT64_C(0xf0986fbcf7b9d), 5.66507246608574010e+000, 3.46489667612250290e-003, 1.40743646039581260e-003},
  {UINT64_C(0xf31d0df9c0ba1), 5.32418237313749910e+000, 4.87233313651831530e-003, 1.49755004257206310e-003},
  {UINT64_C(0xf4cd07fce550a), 5.05617414879851080e+000, 6.36988317909037770e-003, 1.57692937484128270e-003},
  {UINT64_C(0xf6041c9638b3e), 4.83498436732483940e+000, 7.94681255393166020e-003, 1.64907038654294920e-003},
  {UINT64_C(0xf6ef857588626), 4.64642113286248290e+000, 9.59588294047461140e-003, 1.71599373185561590e-003},
  {UINT64_C(0xf7a83deabe527), 4.48190207226268540e+000, 1.13118766723302260e-002, 1.77898343404192480e-003},
  {UINT64_C(0xf83d3ed29599f), 4.33584099408585730e+000, 1.30908601063721520e-002, 1.83891188593610260e-003},
  {UINT64_C(0xf8b8130bfc254), 4.20439793932874740e+000, 1.49297719923082530e-002, 1.89640220897512230e-003},
  {UINT64_C(0xf91f1c567ee1c), 4.08481961680575440e+000, 1.68261742012833780e-002, 1.95191716832489970e-003},
  {UINT64_C(0xf976ca7a48218), 3.97506444137807560e+000, 1.87780913696082750e-002, 2.00581139177440130e-003},
  {UINT64_C(0xf9c24ca169e08), 3.87357649759723400e+000, 2.07839027613826760e-002, 2.05836377427921120e-003},
  {UINT64_C(0xfa03fbabd9d1b), 3.77914266375610140e+000, 2.28422665356618860e-002, 2.10979850430649630e-003},
  {UINT64_C(0xfa3d9cac6f264), 3.69079869307661830e+000, 2.49520650399683820e-002, 2.16029922046685060e-003},
  {UINT64_C(0xfa708bfdf3bd7), 3.60776540937242010e+000, 2.71123642604352360e-002, 2.21001884403023130e-003},
  {UINT64_C(0xfa9dda0b0986d), 3.52940412612390550e+000, 2.93223831044654650e-002, 2.25908659213529170e-003},
  {UINT64_C(0xfac65f0c34b84), 3.45518473239647680e+000, 3.15814696966007570e-002, 2.30761309657193020e-003},
  {UINT64_C(0xfaeac8e3f5d2f), 3.38466235796156270e+000, 3.38890827931726880e-002, 2.35569421593810740e-003},
  {UINT64_C(0xfb0ba50d2a39b), 3.31745999056962320e+000, 3.62447770091107940e-002, 2.40341392578014190e-003},
  {UINT64_C(0xfb2967da3f4c6), 3.25325531138591820e+000, 3.86481909348909340e-002, 2.45084654488946860e-003},
  {UINT64_C(0xfb4471d5357b1), 3.19177057673762210e+000, 4.10990374797804080e-002, 2.49805847502457440e-003},
  {UINT64_C(0xfb5d13cb52430), 3.13276473738663300e+000, 4.35970959548049810e-002, 2.54510957825859450e-003},
  {UINT64_C(0xfb7391e31b451), 3.07602722648897760e+000, 4.61422055330635780e-002, 2.59205428056443090e-003},
  {UINT64_C(0xfb8825fe3adea), 3.02137300929172260e+000, 4.87342598136280000e-002, 2.63894246590314030e-003},
  {UINT64_C(0xfb9b019596d34), 2.96863859890389170e+000, 5.13732022795311410e-002, 2.68582020812416870e-003},
  {UINT64_C(0xfbac4f30bc228), 2.91767882028667460e+000, 5.40590224876553100e-002, 2.73273037598089230e-003},
  {UINT64_C(0xfbbc3390ae103), 2.86836415985974290e+000, 5.67917528636362050e-002, 2.77971313793830280e-003},
  {UINT64_C(0xfbcace9fc7b92), 2.82057857791505380e+000, 5.95714660015745080e-002, 2.82680638716586650e-003},
  {UINT64_C(0xfbd83c33d7f71), 2.77421769006790030e+000, 6.23982723887403780e-002, 2.87404610247379020e-003},
  {UINT64_C(0xfbe494ac5c145), 2.72918724542131490e+000, 6.52723184912141620e-002, 2.92146665749298300e-003},
  {UINT64_C(0xfbefed745d03c), 2.68540184513682600e+000, 6.81937851487071510e-002, 2.96910108779166370e-003},
  {UINT64_C(0xfbfa596db2206), 2.64278385719113860e+000, 7.11628862364988150e-002, 3.01698132363642210e-003},
  {UINT64_C(0xfc03e94a1e604), 2.60126249230736000e+000, 7.41798675601352260e-002, 3.06513839458051520e-003},
  {UINT64_C(0xfc0cabd5c1b9f), 2.56077301312943820e+000, 7.72450059547157420e-002, 3.11360261088102550e-003},
  {UINT64_C(0xfc14ae3599ebe), 2.52125605419779400e+000, 8.03586085655967760e-002, 3.16240372582482060e-003},
  {UINT64_C(0xfc1bfc1c3c0c0), 2.48265703457377860e+000, 8.35210122914215870e-002, 3.21157108231920210e-003},
  {UINT64_C(0xfc229ff67fd7c), 2.44492564833780920e+000, 8.67325833737407900e-002, 3.26113374653094930e-003},
  {UINT64_C(0xfc28a3117e5b9), 2.40801542086344610e+000, 8.99937171202717380e-002, 3.31112063090298470e-003},
  {UINT64_C(0xfc2e0dbb012bf), 2.37188332090636770e+000, 9.33048377511747350e-002, 3.36156060851538040e-003},
  {UINT64_C(0xfc32e75d49877), 2.33648942026299180e+000, 9.66663983596901120e-002, 3.41248262046743400e-003},
  {UINT64_C(0xfc373696ec00a), 2.30179659413941360e+000, 1.00078880980157530e-001, 3.46391577772513310e-003},
  {UINT64_C(0xfc3b014f5b379), 2.26777025649706990e+000, 1.03542796757882680e-001, 3.51588945869208290e-003},
  {UINT64_C(0xfc3e4cc8a0cc8), 2.23437812556076800e+000, 1.07058686216574760e-001, 3.56843340361310880e-003},
  {UINT64_C(0xfc411daead9e7), 2.20159001542912370e+000, 1.10627119620187880e-001, 3.62157780680131970e-003},
  {UINT64_C(0xfc4378249879d), 2.16937765034949680e+000, 1.14248697426989200e-001, 3.67535340758625650e-003},
  {UINT64_C(0xfc455fd013b6b), 2.13771449873480890e+000, 1.17924050834575440e-001, 3.72979158080856410e-003},
  {UINT64_C(0xfc46d7e35643b), 2.10657562442829520e+000, 1.21653842415384000e-001, 3.78492442763233390e-003},
  {UINT64_C(0xfc47e325aab2d), 2.07593755308033500e+000, 1.25438766843016330e-001, 3.84078486740730040e-003},
  {UINT64_C(0xfc4883face9e4), 2.04577815180181450e+000, 1.29279551710423660e-001, 3.89740673128759640e-003},
  {UINT64_C(0xfc48bc6945e5d), 2.01607652051125990e+000, 1.33176958441711240e-001, 3.95482485830029280e-003},
  {UINT64_C(0xfc488e1fbf79e), 1.98681289360651370e+000, 1.37131783300011550e-001, 4.01307519455457090e-003},
  {UINT64_C(0xfc47fa79a48e9), 1.95796855077274130e+000, 1.41144858494566120e-001, 4.07219489629020730e-003},
  {UINT64_C(0xfc470282e6ea1), 1.92952573589244110e+000, 1.45217053390856330e-001, 4.13222243748188460e-003},
  {UINT64_C(0xfc45a6fb1f6eb), 1.90146758315441720e+000, 1.49349275828338210e-001, 4.19319772274339560e-003},
  {UINT64_C(0xfc43e8580aefa), 1.87377804957094020e+000, 1.53542473551081610e-001, 4.25516220631318080e-003},
  {UINT64_C(0xfc41c6c770a2f), 1.84644185320861750e+000, 1.57797635757394750e-001, 4.31815901795021010e-003},
  {UINT64_C(0xfc3f42307b264), 1.81944441652128620e+000, 1.62115794775344990e-001, 4.38223309662738940e-003},
  {UINT64_C(0xfc3c5a348ad9d), 1.79277181424456500e+000, 1.66498027871972380e-001, 4.44743133297933680e-003},
  {UINT64_C(0xfc390e2f8661f), 1.76641072537331660e+000, 1.70945459204951720e-001, 4.51380272154337790e-003},
  {UINT64_C(0xfc355d37ac44a), 1.74034838879653100e+000, 1.75459261926495080e-001, 4.58139852392833950e-003},
  {UINT64_C(0xfc31461ce6dba), 1.71457256221030410e+000, 1.80040660450423410e-001, 4.65027244415656180e-003},
  {UINT64_C(0xfc2cc767a2205), 1.68907148396960040e+000, 1.84690932894579970e-001, 4.72048081755253260e-003},
  {UINT64_C(0xfc27df5721292), 1.66383383757420830e+000, 1.89411413712132520e-001, 4.79208281469866230e-003},
  {UINT64_C(0xfc228bdf4f7c8), 1.63884871851443630e+000, 1.94203496526831190e-001, 4.86514066214785610e-003},
  {UINT64_C(0xfc1ccaa6089b0), 1.61410560322821440e+000, 1.99068637188979020e-001, 4.93971988177664080e-003},
  {UINT64_C(0xfc1698ffce480), 1.58959431994388960e+000, 2.04008357070755680e-001, 5.01588955088549510e-003},
  {UINT64_C(0xfc0ff3ebe4175), 1.56530502120252320e+000, 2.09024246621641180e-001, 5.09372258540905390e-003},
  {UINT64_C(0xfc08d80fc49ee), 1.54122815787027710e+000, 2.14117969207050230e-001, 5.17329604889335550e-003},
  {UINT64_C(0xfc0141b1e23f7), 1.51735445446579090e+000, 2.19291265255943580e-001, 5.25469149023627060e-003},
  {UINT64_C(0xfbf92cb3a2c8e), 1.49367488563953700e+000, 2.24545956746179860e-001, 5.33799531357832550e-003},
  {UINT64_C(0xfbf0948a8235a), 1.47018065365220570e+000, 2.29883952059758170e-001, 5.42329918418290020e-003},
  {UINT64_C(0xfbe77438453c7), 1.44686316670733060e+000, 2.35307251243941060e-001, 5.51070047466783230e-003},
  {UINT64_C(0xfbddc642207f1), 1.42371401799975960e+000, 2.40817951718608920e-001, 5.60030275655741710e-003},
  {UINT64_C(0xfbd384a6b47ac), 1.40072496534626720e+000, 2.46418254475166330e-001, 5.69221634282963090e-003},
  {UINT64_C(0xfbc8a8d2b9055), 1.37788791126762610e+000, 2.52110470817995980e-001, 5.78655888795649290e-003},
  {UINT64_C(0xfbbd2b942cd1d), 1.35519488339283130e+000, 2.57897029705952460e-001, 5.88345605289765890e-003},
  {UINT64_C(0xfbb1050bd61b2), 1.33263801505584100e+000, 2.63780485758850100e-001, 5.98304224363537410e-003},
  {UINT64_C(0xfba42c9cd8d17), 1.31020952595313790e+000, 2.69763528002485490e-001, 6.08546143316520720e-003},
  {UINT64_C(0xfb9698da1c50e), 1.28790170272645010e+000, 2.75848989435650730e-001, 6.19086807842119960e-003},
  {UINT64_C(0xfb883f712e4df), 1.26570687932901430e+000, 2.82039857514071900e-001, 6.29942814546470470e-003},
  {UINT64_C(0xfb79151241e2e), 1.24361741702554250e+000, 2.88339285659536590e-001, 6.41132025846316050e-003},
  {UINT64_C(0xfb690d54d7ebc), 1.22162568386532850e+000, 2.94750605917999730e-001, 6.52673699060215150e-003},
  {UINT64_C(0xfb581a9888793), 1.19972403345431930e+000, 3.01277342908601920e-001, 6.64588631820309250e-003},
  {UINT64_C(0xfb462de14b349), 1.17790478283506840e+000, 3.07923229226805040e-001, 6.76899326307422830e-003},
  {UINT64_C(0xfb3336ae7cff8), 1.15616018926267890e+000, 3.14692222489879270e-001, 6.89630175264750990e-003},
  {UINT64_C(0xfb1f22cbba83f), 1.13448242563946720e+000, 3.21588524242526760e-001, 7.02807673292890710e-003},
  {UINT64_C(0xfb09de1a78032), 1.11286355434023990e+000, 3.28616600975455640e-001, 7.16460657594309660e-003},
  {UINT64_C(0xfaf352530427d), 1.09129549912268640e+000, 3.35781207551398730e-001, 7.30620583147582190e-003},
  {UINT64_C(0xfadb66bb5b083), 1.06977001477206410e+000, 3.43087413382874570e-001, 7.45321838288049740e-003},
  {UINT64_C(0xfac1ffd1d3e21), 1.04827865407435320e+000, 3.50540631765755060e-001, 7.60602107899829240e-003},
  {UINT64_C(0xfaa6fee942756), 1.02681273164522140e+000, 3.58146652844753390e-001, 7.76502792946314610e-003},
  {UINT64_C(0xfa8a41b395670), 1.00536328406062330e+000, 3.65911680774216540e-001, 7.93069496963319170e-003},
  {UINT64_C(0xfa6ba1b744e76), 9.83921025635170590e-001, 3.73842375743849710e-001, 8.10352592516901290e-003},
  {UINT64_C(0xfa4af3aafbf46), 9.62476299071922560e-001, 3.81945901669018710e-001, 8.28407883627031370e-003},
  {UINT64_C(0xfa2806b1bac80), 9.41019020056089730e-001, 3.90229980505289010e-001, 8.47297383965548750e-003},
  {UINT64_C(0xfa02a3702c5db), 9.19538614677599670e-001, 3.98702954344944520e-001, 8.67090235503485860e-003},
  {UINT64_C(0xf9da8af1ed14a), 8.98023948333463220e-001, 4.07373856699979390e-001, 8.87863798549032820e-003},
  {UINT64_C(0xf9af7552e35eb), 8.76463244467077240e-001, 4.16252494685469710e-001, 9.09704952248341530e-003},
  {UINT64_C(0xf981101d522e1), 8.54843991130224020e-001, 4.25349544207953120e-001, 9.32711655259079420e-003},
  {UINT64_C(0xf94efc48a3eb6), 8.33152832880709400e-001, 4.34676660760543900e-001, 9.56994830346462320e-003},
  {UINT64_C(0xf918cbbe9c8e6), 8.11375444921901830e-001, 4.44246609064008540e-001, 9.82680655355665230e-003},
  {UINT64_C(0xf8ddfe43fc48e), 7.89496385605450550e-001, 4.54073415617565150e-001, 1.00991336818330880e-002},
  {UINT64_C(0xf89dfd95a2c92), 7.67498922393608280e-001, 4.64172549299398220e-001, 1.03885872760410940e-002},
  {UINT64_C(0xf858187a78cc3), 7.45364825026504470e-001, 4.74561136575439410e-001, 1.06970831891214730e-002},
  {UINT64_C(0xf80b7c728a3fd), 7.23074117839883180e-001, 4.85258219764560790e-001, 1.10268495896005400e-002},
  {UINT64_C(0xf7b72d8957ded), 7.00604780753902530e-001, 4.96285069354161390e-001, 1.13804954784546360e-002},
  {UINT64_C(0xf759fb9f0ef30), 6.77932385146246540e-001, 5.07665564832616050e-001, 1.17610984727237520e-002},
  {UINT64_C(0xf6f274315eb5e), 6.55029646251399590e-001, 5.19426663305339710e-001, 1.21723185892159950e-002},
  {UINT64_C(0xf67ecf3aeb50f), 6.31865867316897760e-001, 5.31598981894555790e-001, 1.26185476253217220e-002},
  {UINT64_C(0xf5fcd51051c5e), 6.08406241612121760e-001, 5.44217529519877450e-001, 1.31051080581068030e-002},
  {UINT64_C(0xf569ba0af05ef), 5.84610965138341210e-001, 5.57322637577984280e-001, 1.36385220514410300e-002},
  {UINT64_C(0xf4c1eb0d23f12), 5.60434093304459480e-001, 5.70961159629425290e-001, 1.42268816883379390e-002},
  {UINT64_C(0xf400c2f84ef38), 5.35822045250432090e-001, 5.85188041317763250e-001, 1.48803686041453710e-002},
  {UINT64_C(0xf3201c17ff745), 5.10711613728867640e-001, 6.00068409921908570e-001, 1.56119996593349630e-002},
  {UINT64_C(0xf217a773ccddd), 4.85027265694870590e-001, 6.15680409581243590e-001, 1.64387243841450930e-002},
  {UINT64_C(0xf0dbe31ebf97d), 4.58677399489966220e-001, 6.32119133965388660e-001, 1.73830878705152070e-002},
  {UINT64_C(0xef5c67c8061dd), 4.31549022036835210e-001, 6.49502221835903890e-001, 1.84758373496509250e-002},
  {UINT64_C(0xed81024b4fe39), 4.03499951515524150e-001, 6.67978059185554860e-001, 1.97601747152793130e-002},
  {UINT64_C(0xeb2479ca95862), 3.74346987428728790e-001, 6.87738233900834110e-001, 2.12990348722159740e-002},
  {UINT64_C(0xe80a830ae6bb6), 3.43847188566281770e-001, 7.09037268773050070e-001, 2.31882935346918730e-002},
  {UINT64_C(0xe3cac9d1f6974), 3.11666667258660050e-001, 7.32225562307742050e-001, 2.55825546237715110e-002},
  {UINT64_C(0xdda058265f4b6), 2.77325069275912110e-001, 7.57808116931513510e-001, 2.87504824586228940e-002},
  {UINT64_C(0xd3e7a257e0685), 2.40088052723822300e-001, 7.86558599390136390e-001, 3.32096055971816480e-002},
  {UINT64_C(0xc2735d80dc305), 1.98733655529202440e-001, 8.19768204987318060e-001, 4.01201775226334640e-002},
  {UINT64_C(0x9ae6fc6f3abd3), 1.50952685936872420e-001, 8.59888382509951480e-001, 5.28193949651737240e-002},
  {UINT64_C(0x0), 9.13395181029036110e-002, 9.12707777475125210e-001, 8.72922225248747710e-002}};
