/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.NotAnInterfaceException;
import jde.wizards.Signature;
import jde.wizards.SignatureContainer;
import jde.wizards.SignatureVisitor;

public class InterfaceFactory
extends MethodFactory {
    private SignatureContainer signatures = new SignatureContainer();
    private static InterfaceFactory interfaceFactory;

    protected InterfaceFactory() {
    }

    public InterfaceFactory(NameFactory factory) {
        super(factory);
    }

    public SignatureContainer getSignatures() {
        return this.signatures;
    }

    public void setSignatures(SignatureContainer argSignatures) {
        this.signatures = argSignatures;
    }

    public static InterfaceFactory getTheFactory() {
        return interfaceFactory;
    }

    public static void setTheFactory(InterfaceFactory argInterfaceFactory) {
        interfaceFactory = argInterfaceFactory;
    }

    protected final void sortByDeclaringClass(Signature sig) {
        this.signatures.add(sig);
    }

    public void flush() {
        super.flush();
        this.signatures.clear();
    }

    public void process(String interfaceName) throws ClassNotFoundException, NotAnInterfaceException {
        this.process(interfaceName, true);
    }

    public void process(String name, boolean truncate) throws ClassNotFoundException, NotAnInterfaceException {
        Class<?> aclass;
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        if (!(aclass = Class.forName(name)).isInterface()) {
            throw new NotAnInterfaceException(name);
        }
        Method[] methods = aclass.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.sortByDeclaringClass(new Signature(methods[i], this, truncate));
            ++i;
        }
    }

    protected void implementInterface(String name, boolean truncate) {
        try {
            this.process(name, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find interface named: " + name + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (NotAnInterfaceException e) {
            MethodFactory.println("(error \"Error: " + name + " is not an interface.\")");
            return;
        }
        catch (Exception e) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dumpExpression(new PrintWriter(System.out, true), truncate);
    }

    public static void makeInterfaceExpression(String name, boolean truncate) {
        InterfaceFactory theFactory = InterfaceFactory.getTheFactory();
        if (theFactory == null) {
            theFactory = new InterfaceFactory();
            InterfaceFactory.setTheFactory(theFactory);
        }
        theFactory.flush();
        theFactory.implementInterface(name, truncate);
    }

    public static void getImportedClasses() {
        MethodFactory.println(interfaceFactory.getImportsAsList());
    }

    public void dumpExpression(PrintWriter out, boolean truncate) {
        final StringBuffer buf = new StringBuffer("(jde-wiz-gen-implementation-methods (list ");
        this.signatures.visit(new SignatureVisitor(){

            public void visit(Signature sig, boolean firstOfClass) {
                if (firstOfClass) {
                    buf.append("(quote ");
                    buf.append("\"Implementation of ");
                    buf.append(sig.getDeclaringClass().getName());
                    buf.append("\")");
                }
                buf.append("(quote ");
                buf.append(InterfaceFactory.this.getMethodSkeletonExpression(sig));
                buf.append(")");
            }
        });
        buf.append("))");
        MethodFactory.println(buf.toString());
    }
}

