target=carreleur1 carreleur2 carreleur3

\author{Bernadette Perrin-Riou}

\precision{10}



\integer{n=2}
\text{choix=randint(1..2)}
#if #TARGET(carreleur1)
\title{Carrelages}
 \text{horiz=item(\choix,horizontaux d'en bas, verticaux de gauche)}
#endif

#if #TARGET(carreleur2)
\title{Carrelages et matrices d'Hermite}
 \text{super=suprieure,infrieure}
 \text{STEP=\choix,3-\choix}
 \text{super=\super[\STEP]}
#endif

#if #TARGET(carreleur3)
\title{Carrelages : taille}
#endif
#include "style.inc"
#include "help.inc"

\text{color=shuffle(green,purple)}
\text{color=\choix=2 ? \color[2],\color[1]}
\text{A=slib(matrix/invertible \n, 3)}
\text{A=randint(2..5),randint(1..3)}
\matrix{A=\A[1],randint(1..\A[1]-1)
0,\A[2]}
\text{U=slib(matrix/unimodular \n, 5)}
\text{A=pari([\A]*[\U])} 

\text{V=pari(A = Mat([\A]) ; H = mathnf(A) ; W=[0,1;1,0] ; 
  V = W * mathnf(W*A)*W  ; V )}  
\text{H=pari(H)}
\text{diagH=pari(vector(\n,i,H[i,i]))}
\text{diagV=pari(vector(\n,i,V[i,i]))}
\text{max=pari(floor(2.2*vecmax(concat([\diagH],[\diagV]))))}
\matrix{HV=\H
\V}

#if #TARGET(carreleur1)
\text{Herm = \choix=1 ? \H : \V}
\text{diag = \choix=1 ? \diagH : \diagV}
\text{P1=0,0}
\text{P2=\Herm[1;1],\Herm[2;2]}
\text{P3=pari(Herm=Mat([\Herm]) ; Herm[,3-\choix]~)}
\text{P4=pari(Herm[,3-\choix]~+[\diag])}
\text{P5=\choix=1 ? pari(Herm[,2]~+Herm[,1]~) :pari(Herm[,\choix]~) }
\text{P6=\choix=1 ? pari(Herm[,2]~+Herm[,1]~+[\diag]) : pari(Herm[,\choix]~+[\diag])}

\text{PointH=}

\for{i=0 to 6}{
  \for{j=0 to 6}{
   \text{PointH=\PointH
   rectangle pari(S=\i*H[,1]~ + \j*H[,2]~ ; concat(S,S + [\diagH])),\color[1]
   }
  }
}
  
\text{PointV=}
\for{i=-2 to 12}{
  \for{j=-2 to 6}{
   \text{PointV=\PointV
   rectangle pari(S=\i*V[,1]~ + \j*V[,2]~ ; concat(S,S + [\diagV])),\color[2]
   }
  }
}

#endif
\text{xrange=-\max/10,\max}
\text{yrange=-\max/10,\max}
\text{SIZE=300,300}

#if #TARGET(carreleur2)
\text{dessinprel=xrange \xrange
yrange \yrange
parallel 0,\yrange[1],0,\yrange[2],1,0,40,grey
parallel \xrange[1],0,\xrange[2],0,0,1,40,grey
linewidth 7
lattice 0,0, \A[1;1],  \A[2;1],  \A[1;2],  \A[2;2], 40,40,black
lattice 0,0, \A[1;1],  \A[2;1], -\A[1;2], -\A[2;2], 40,40,black
lattice 0,0,-\A[1;1], -\A[2;1], -\A[1;2], -\A[2;2], 40,40,black
lattice 0,0,-\A[1;1], -\A[2;1],  \A[1;2],  \A[2;2], 40,40,black
}
\text{reseau=draw(\SIZE
\dessinprel)}
\text{dessin=\dessinprel
linewidth 2
rectangle  0,0,\H[1;1],\H[2;2],green
rectangle  0,0,\V[1;1],\V[2;2],blue
}
\text{dessin=draw(\SIZE
\dessin)}
#endif

#if #TARGET(carreleur1)
\text{dessinprel=xrange \xrange
yrange \yrange
parallel 0,\yrange[1],0,\yrange[2],1,0,40,grey
parallel \xrange[1],0,\xrange[2],0,0,1,40,grey
hline black,0,0
vline black,0,0
linewidth 7
lattice 0,0, \A[1;1],  \A[2;1],  \A[1;2],  \A[2;2], 40,40,black
lattice 0,0, \A[1;1],  \A[2;1], -\A[1;2], -\A[2;2], 40,40,black
lattice 0,0,-\A[1;1], -\A[2;1], -\A[1;2], -\A[2;2], 40,40,black
lattice 0,0,-\A[1;1], -\A[2;1],  \A[1;2],  \A[2;2], 40,40,black

}
\text{dessin1=\dessinprel
linewidth 6
point \P1,red
}

\text{dessinH=\dessinprel
linewidth 4
\PointH
}
\text{dessinV=\dessinprel
linewidth 4
\PointV
}

\text{dessin2=\dessinprel
linewidth 6
point \P3,red
linewidth 2
rectangle \P1,\P2,\color[\choix]
}

\text{dessin3=\dessinprel
linewidth 6
point \P5,red
linewidth 2
rectangle \P1,\P2,\color[\choix]
rectangle \P3,\P4,\color[\choix]
}

\text{dessin=draw(\SIZE
\dessin1),
draw(\SIZE
\dessin2),
draw(\SIZE
\dessin3)
}

\text{DESSIN=draw(\SIZE
\dessinH),
draw(\SIZE
\dessinV)
}
#endif
#if #TARGET(carreleur3)

\statement{
Donner la taille des carreaux rectangulaires permettant de 
\special{help paver,paver} le plan
paralllement aux axes de manire  ce que le groupe de translations du pavage soit
engendr par les deux vecteurs \([\A[1;1];\A[2;1]]) et 
\([\A[1;2];\A[2;2]]) : 
<p align="center">\embed{reply1,4} \times \embed{reply2,4}</p>
<p align="center">\embed{reply3,4} \times \embed{reply4,4}</p>
}
\answer{}{\a}
\answer{}{\b}
\answer{}{\c}
\answer{}{\d}
\condition{}{(\a=\diagH[1] and \b=\diagH[2] and \c=\diagV[1] and \d=\diagV[2])
or (\a=\diagV[1] and \b=\diagV[2] and \c=\diagH[1] and \d=\diagH[2])}
#endif

#if #TARGET(carreleur2)
\steps{r1
r2}
\statement{
Voici un rseau dessin : 
<p align="center"><img src=\reseau> </p>

\if{\step=2}{La matrice d'Hermite (chelonne en colonnes, triangulaire \super[1]) 
qui lui est associe est
<p align="center">\([\HV[2*\choix-1,2*\choix;]])</p>}

Donner la matrice d'Hermite 
(chelonne en colonnes, triangulaire \super[\step]) qui lui est associe :


<p align="center">
\embed{reply \step, 4 x 4}
</p>
}
\answer{}{\HV[2*\choix-1,2*\choix;]}{type=matrix}
\answer{}{\HV[2*(3-\choix)-1,2*(3-\choix);]}{type=matrix}
\feedback{1=1}{Voici les deux  carrelages correspondant  ces
deux matrices d'Hermite : <p align="center"><img src="\dessin"></p>}
#endif
#if #TARGET(carreleur1)
\text{sommet1=slib(draw/convpixel \P1, \SIZE,\xrange,\yrange,0,pixels)}
\text{sommet2=slib(draw/convpixel \P2, \SIZE,\xrange,\yrange,0,pixels)}
\text{sommet3=slib(draw/convpixel \P3, \SIZE,\xrange,\yrange,0,pixels)}
\text{sommet4=slib(draw/convpixel \P4, \SIZE,\xrange,\yrange,0,pixels)}
\text{sommet5=slib(draw/convpixel \P5, \SIZE,\xrange,\yrange,0,pixels)}
\text{sommet6=slib(draw/convpixel \P6, \SIZE,\xrange,\yrange,0,pixels)}
\steps{r1
r2
r3
r4,r5}
\statement{\style On dsire paver le plan avec des carreaux rectangulaires 
de manire  ce que chaque coin en bas  gauche soit sur  un 
point du rseau dessin [\special{help paver,aide}]

\if{\step <= 3}{
<div class="question">On dsire de plus que les deux extrmits des bords \horiz  
soient sur le rseau. Placer avec la souris le premier pav 
dont le coin en bas  gauche est le point rouge : 
<p align="center">
\embed{reply \step,\SIZE[1] x \SIZE[2]}
</p>
</div>
}

\if{\step=4}{
<p align="center"><img src="\DESSIN[\choix]"></p>
<div class="question">Donner la dimension des carreaux (horizontale, verticale)

<p align="center">\embed{r4,5} \times \embed{r5,5}
</p>
</div>}

}

\answer{}{\dessin[1];rectangle,\sommet1,\sommet2}{type=javacurve}
\answer{}{\dessin[2];rectangle,\sommet3,\sommet4}{type=javacurve}
\answer{}{\dessin[3];rectangle,\sommet5,\sommet6}{type=javacurve}
\answer{}{\diag[1]}
\answer{}{\diag[2]}
\feedback{1=1}{Voici les deux types de pavage qu'on peut obtenir, l'un deux
est celui que vous avez comenc  dessiner : 
<p align="center">
<img src=\DESSIN[1]> <img src=\DESSIN[2]>
</p>}

#endif

\help{\style
\if{\help_subject issametext  or \help_subject issametext paver}{
\help_m }
}
