/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
const int BASE = (short) 100;
const int LAST = (short) 143;
static char* unknown_error = "Unknown error code";
static char* no_error =  "No Error";
static char* vdkxdb_errors[] = 
{
  "End Of File", // 100
  "Beginning Of File",
  "No Memory",
  "File Already Exists",
  "Database or Index Open Error",
  "Error writing to disk drive",
  "Unknown Field Type",
  "Database already open",
  "Not an Xbase type database",
  "Invalid Record Number",
  "Invalid Option", // 110
  "Database not open",
  "Disk Drive Seek Error",
  "Disk Drive Read Error",
  "Search Key Not Found",
  "Search Key Found",
  "Invalid Key",
  "Invalid Node Link",
  "Key Not Unique",
  "Invalid Key Expression",
  "DBF File Not Open", // 120
  "Invalid Key Type",
  "Invalid Node No",
  "Node Full",
  "Invalid Field Number",
  "Invalid Data",
  "Not a leaf node",
  "Lock Failed",
  "Close Error",
  "Invalid Schema",
  "Invalid Name", // 130
  "Invalid Block Size",
  "Invalid Block Number",
  "Not a Memo field",
  "No Memo Data",
  "Expression syntax error",
  "Parse Error",
  "No Data",
  "Unknown Token Type",
  "Unknown error code",
  "Invalid Field", // 140
  "Insufficient Parms",
  "Invalid Function",
  "Invalid Field Length",
  0
};

char* 
VDKXError(short rc)
{
  rc *= -1;
  if(rc == 0)
    return no_error;
  else if( rc >= BASE && rc <= LAST)
    return vdkxdb_errors[rc - BASE];
  else
    return unknown_error;
}










