/* uucicolog.c -- Eat uucico/... a line at a time.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include    "tua_4_hdb.h"

#if HDB_UUCP

int
DEFUN (GetUucicoLog, (fp, lentry),
       FILE * fp AND struct uucico_log * lentry)

{
  char line[LINE_BUFFER_SIZE];
  extern int EXFUN(atoi, (CONST char *));

  debug_newline();
  
  if (fgets (line, LINE_BUFFER_SIZE, fp) == NULL)
    return (EOF);

  xfree (lentry->Command);
  lentry->Command = 0;

  strtok (line, "(");		/* skip user and system */
  lentry->TimeStamp = parse_date (strtok (NULL, ","));
  lentry->ProcessId = atoi (strtok (NULL, ","));
  strtok (NULL, ")");
  lentry->Command = savestring (strtok (NULL, "\n")+1);
  return OK;
}

#endif /* TAYLOR_UUCP */

  
  
