/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.nodes;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.piccolo2d.PCamera;
import org.piccolo2d.PRoot;
import org.piccolo2d.activities.PActivity;
import org.piccolo2d.activities.PTransformActivity;
import org.piccolo2d.util.PAffineTransform;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PDimension;
import org.piccolo2d.util.PPaintContext;

public class PCacheCamera
extends PCamera {
    private static final long serialVersionUID = 1L;
    private transient BufferedImage paintBuffer;
    private boolean imageAnimate;
    private PBounds imageAnimateBounds;

    protected BufferedImage getPaintBuffer() {
        PBounds fRef = this.getFullBoundsReference();
        if (this.paintBuffer == null || this.isBufferSmallerThanBounds(fRef)) {
            this.paintBuffer = this.buildPaintBuffer(fRef);
        }
        return this.paintBuffer;
    }

    private boolean isBufferSmallerThanBounds(PBounds bounds) {
        return (double)this.paintBuffer.getWidth() < bounds.getWidth() || (double)this.paintBuffer.getHeight() < bounds.getHeight();
    }

    private BufferedImage buildPaintBuffer(PBounds fRef) {
        int newBufferWidth = (int)Math.ceil(fRef.getWidth());
        int newBufferHeight = (int)Math.ceil(fRef.getHeight());
        if (GraphicsEnvironment.isHeadless()) {
            return new BufferedImage(newBufferWidth, newBufferHeight, 6);
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(newBufferWidth, newBufferHeight);
    }

    private AffineTransform cacheViewBounds(Rectangle2D centerBounds, boolean scaleToFit) {
        PBounds viewBounds = this.getViewBounds();
        PBounds imageBounds = new PBounds(viewBounds);
        imageBounds.add(centerBounds);
        this.animateViewToCenterBounds((Rectangle2D)imageBounds, scaleToFit, 0L);
        this.imageAnimateBounds = this.getViewBounds();
        BufferedImage buffer = this.getPaintBuffer();
        Paint fPaint = Color.white;
        if (this.getPaint() != null) {
            fPaint = this.getPaint();
        }
        this.toImage(buffer, fPaint);
        this.imageAnimate = true;
        this.animateViewToCenterBounds((Rectangle2D)viewBounds, scaleToFit, 0L);
        PDimension delta = viewBounds.deltaRequiredToCenter(centerBounds);
        PAffineTransform newTransform = this.getViewTransform();
        newTransform.translate(delta.width, delta.height);
        if (scaleToFit) {
            double s = Math.min(viewBounds.getWidth() / centerBounds.getWidth(), viewBounds.getHeight() / centerBounds.getHeight());
            newTransform.scaleAboutPoint(s, centerBounds.getCenterX(), centerBounds.getCenterY());
        }
        return newTransform;
    }

    private void clearViewCache() {
        this.imageAnimate = false;
        this.imageAnimateBounds = null;
    }

    public PTransformActivity animateStaticViewToCenterBoundsFast(Rectangle2D centerBounds, boolean shouldScaleToFit, long duration) {
        if (duration == 0L) {
            return this.animateViewToCenterBounds(centerBounds, shouldScaleToFit, duration);
        }
        AffineTransform newViewTransform = this.cacheViewBounds(centerBounds, shouldScaleToFit);
        return this.animateStaticViewToTransformFast(newViewTransform, duration);
    }

    protected PTransformActivity animateStaticViewToTransformFast(AffineTransform dest, long duration) {
        if (duration == 0L) {
            this.setViewTransform(dest);
            return null;
        }
        PTransformActivity.Target t = new PTransformActivity.Target(){

            public void setTransform(AffineTransform aTransform) {
                PCacheCamera.this.setViewTransform(aTransform);
            }

            public void getSourceMatrix(double[] aSource) {
                PCacheCamera.this.getViewTransformReference().getMatrix(aSource);
            }
        };
        PTransformActivity ta = new PTransformActivity(duration, 20L, t, dest){

            protected void activityFinished() {
                PCacheCamera.this.clearViewCache();
                PCacheCamera.this.repaint();
                super.activityFinished();
            }
        };
        PRoot r = this.getRoot();
        if (r != null) {
            r.getActivityScheduler().addActivity((PActivity)ta);
        }
        return ta;
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.imageAnimate) {
            PBounds fRef = this.getFullBoundsReference();
            PBounds viewBounds = this.getViewBounds();
            double scale = this.getFullBoundsReference().getWidth() / this.imageAnimateBounds.getWidth();
            double xOffset = (viewBounds.getX() - this.imageAnimateBounds.getX()) * scale;
            double yOffset = (viewBounds.getY() - this.imageAnimateBounds.getY()) * scale;
            double scaleW = viewBounds.getWidth() * scale;
            double scaleH = viewBounds.getHeight() * scale;
            paintContext.getGraphics().drawImage(this.paintBuffer, 0, 0, (int)Math.ceil(fRef.getWidth()), (int)Math.ceil(fRef.getHeight()), (int)Math.floor(xOffset), (int)Math.floor(yOffset), (int)Math.ceil(xOffset + scaleW), (int)Math.ceil(yOffset + scaleH), null);
        } else {
            super.fullPaint(paintContext);
        }
    }
}

