C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECSY2
C                       *****************
C
C     ----------------------------------------------------------------
     *(NDIM,NDIELE,NPOINS,NELEMS,NBFACE,NN,IREF,INOEUD,IFACE,IELT)
C     ----------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUE DE SYRTHES                 *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "mobil.h"
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C 
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NPOINS,NELEMS,NBFACE,NN
      INTEGER IREF(NPOINS),INOEUD(NELEMS*NN),IFACE(NELEMS*NBFACE)
      INTEGER IELT(NELEMS)
C
C.. Variables internes
      INTEGER I,J,N1,NBNO,N,IERR
      CHARACTER CH*80,CH1*10
      LOGICAL LF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      IF (NDIELE.EQ.2) THEN
        NBNO = 6
      ELSE
        NBNO = 10
      ENDIF
C
C     2- NOMBRE DE NOEUDS ET D'ELEMENTS
C     =================================
C 
      REWIND(NFSGCT)
      READ(NFSGCT,1000) CH,CH,CH,CH
C
      READ(NFSGCT,1001) CH
      READ(NFSGCT,1001) CH
C
C     3- TABLE DES NOEUDS
C     ===================
C
      IERR = 0
      CALL SECGRF(NFSGCT,'C$ RUBRIQUE = NOEUDS',20,IERR)
      IF (IERR.NE.0) THEN
        WRITE(NFECRA,3100)
        STOP
      ENDIF
C
      DO N=1,NPOINS
       READ(NFSGCT,3200) CH1,IREF(N)
      ENDDO
C
C
C     4- TABLE DES ELEMENTS
C     =====================
C
      IERR = 0
      CALL SECGRF(NFSGCT,'C$ RUBRIQUE = ELEMENTS',22,IERR)
      IF (IERR.NE.0) THEN
        WRITE(NFECRA,4100)
        STOP
      ENDIF
C
C
      IF (NBNO.EQ.6) THEN
         DO I=1,NELEMS
            READ(NFSGCT,4200) N1,IELT(I),
     &                  (INOEUD((J-1)*NELEMS+I),J=1,NBNO)
         ENDDO
C
      ELSEIF (NBNO.EQ.10) THEN
         DO I=1,NELEMS
            READ(NFSGCT,4201) N1,IELT(I),
     &       (INOEUD((J-1)*NELEMS+I),J=1,NBNO)
         ENDDO
      ENDIF
C
C
C     5- REFERENCES SUR LES FACES
C     ===========================
C
      IF (LCFACE) THEN
C
        IERR = 0
        CALL SECGRF(NFSGCT,'C$ RUBRIQUE = REFERENCES DES FACES',34,IERR)
C
        LF = .FALSE.
C  
        IF (IERR.EQ.0) THEN
          LF = .TRUE.
          DO N=1,NELEMS
             READ(NFSGCT,5200) J,(IFACE((I-1)*NELEMS+N),I=1,NBFACE)
          ENDDO
        ENDIF
C
        CALL INREFA (NDIM,NDIELE,NELEMS,NBNO,NBFACE,INOEUD,IFACE,
     *               NPOINS,IREF)
C
       ENDIF
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT(A80,/,A80,/,A80,/,A80)
 1001 FORMAT(A80)
C
C
 3100 FORMAT(//,' *** LECGR1 : LE FICHIER GEOMETRIQUE NE CONTIENT ',
     &          'PAS LA TABLE DES NOEUDS')
 3200 FORMAT(A10,I3,1X,3E14.7)
 4100 FORMAT(//,' *** LECGR1 : LE FICHIER GEOMETRIQUE NE CONTIENT ',
     &          'PAS LA TABLE DES ELEMENTS')
 4200 FORMAT(I10,I3,6I10)
 4201 FORMAT(I10,I3,10I10)
 5200 FORMAT(I10,1X,4I5)
C
C 
C
      END
