C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CORFS2
C                       *****************
C
C      --------------------------------------------------------------
     * (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *  NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,BARYF,NCBORF,
     *  BARYS,NCBORS,NCOUPS,NBICOR)
C      --------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA TABLE DE CORRESPONDANCE ENTRE LES     *
C            NOEUDS COUPLES DES MAILLAGES FLUIDE ET SOLIDE             *
C            (CAS DES MAILLAGES NON COINCIDENTS)                       * 
C            ALGORITHME PENIGUEL/RUPP                                  *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL SOLIDE      !
C !  NELESS   !  E ! D  ! NOMBRE D'ELEMENTS DU MAILLGE SURF SOLIDE     !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELT SURF SOLIDE         !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NELESF   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL SOLIDE      !
C !  NDMATF   !  E ! D  ! NOMBRE D'ELEMENTS DU MAILLGE SURF FLUIDE     !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NODESS   ! TE ! D  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF SOLIDE !
C !  COORDF   ! TR ! D  ! COORDONNEES DES NOEUDS FLUIDES COUPLES       !
C !  NODESF   ! TE ! D  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF FLUIDE !
C !  BARYF    ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! FLUIDES DANS LES ELEMENTS SOLIDES            !
C !  NCBORF   ! TE ! R  ! NUMERO DE L'ELEMENT SOLIDE CORRESPONDANT     !
C !  BARYS    ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! SOLIDES DANS LES ELEMENTS FLUIDES            !
C !  NCBORS   ! TE ! R  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT     !
C !  NCOUPS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : DPTSEG, CBARY2
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON 
C***********************************************************************
C
#include "nlofes.h"
#include "optct.h"
#include "mobil.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NELESS,NDMASS
      INTEGER NELESF,NDMASF,NBCOUS,NBCOUF,NBICOR
      INTEGER NODESS(NELESS,NDMASS),NODESF(NELESF,NDMASF)
      INTEGER NCBORF(NBCOUF,NBICOR),NCBORS(NBCOUS,NBICOR)
      INTEGER NCOUPS(NBCOUS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),COORDF(NBCOUF,NDIM)
      DOUBLE PRECISION BARYF(NBCOUF,NDIM),BARYS(NBCOUS,NDIM)
C
C.. Variables internes
      INTEGER ICODE,NUMSEG
      INTEGER N,NPF,NES,NA,NB,NELMIN,N1MIN,N2MIN,N3MIN
      INTEGER NPS,NEF,NG,NGA,NGB,NONC
C
      DOUBLE PRECISION XA,YA,XB,YB,XP1,YP1
      DOUBLE PRECISION XX,YY,DIST,XMIN,YMIN,DMIN
      DOUBLE PRECISION X1,Y1,X2,Y2,X3,Y3
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      NONC=0
C
      DO 1 N=1,NBCOUF*NDIM
        BARYF(N,1) = 0.D0
    1 CONTINUE
C
      DO 2 N=1,NBCOUS*NDIM
        BARYS(N,1) = 0.D0
    2 CONTINUE
C
C
      IF (NBLBLA.GE.2) WRITE(NFECRA,1000)
C
      DO 100 NPF=1,NBCOUF
C
        ICODE = 0
        DMIN = 1.D6
C
        XP1 = COORDF(NPF,1)
        YP1 = COORDF(NPF,2)
C       
        DO 110 NES=1,NELESS
C
            NA = NODESS(NES,1)
            NB = NODESS(NES,2)
C
            IF (NCBORS(NA,1).EQ.-1 .OR. NCBORS(NB,1).EQ.-1) THEN
               GOTO 110
            ENDIF
C
            NGA = NCOUPS(NA)
            NGB = NCOUPS(NB)
C
            XA = COORDS(NGA,1)
            YA = COORDS(NGA,2)
            XB = COORDS(NGB,1)
            YB = COORDS(NGB,2)
C
            CALL DPTSEG (XP1,YP1,XA,YA,XB,YB,DIST,XX,YY,ICODE)
C
            IF (ICODE.NE.0) THEN
               WRITE(NFECRA,1200) NPF,XP1,YP1,NES,NGA,NGB
               STOP
            ENDIF
C
            IF (DIST.LT.DMIN) THEN
               DMIN   = DIST
               XMIN   = XX
               YMIN   = YY
               NELMIN = NES               
            ENDIF
C
  110    CONTINUE
C
         N1MIN  = NODESS(NELMIN,1)
         N2MIN  = NODESS(NELMIN,2)
         N3MIN  = NODESS(NELMIN,3)
C
         X1 = COORDS(NCOUPS(N1MIN),1)
         Y1 = COORDS(NCOUPS(N1MIN),2)
C
         X2 = COORDS(NCOUPS(N2MIN),1)
         Y2 = COORDS(NCOUPS(N2MIN),2)
C
         X3 = COORDS(NCOUPS(N3MIN),1)
         Y3 = COORDS(NCOUPS(N3MIN),2)
C
         CALL SOUSEG (XMIN,YMIN,X1,Y1, X2,Y2, NUMSEG)
C         
         IF (NUMSEG .EQ. 1) THEN
           CALL CBARY2 (XMIN,YMIN,
     &                  X1,Y1,X3,Y3,
     &                  BARYF(NPF,1),BARYF(NPF,2))
         ELSE
           CALL CBARY2 (XMIN,YMIN,
     &                  X2,Y2,X3,Y3,
     &                  BARYF(NPF,1),BARYF(NPF,2))
         ENDIF
C
         NCBORF(NPF,1) = NELMIN
         NCBORF(NPF,2) = NUMSEG
C
         IF (NBLBLA.GE.11) THEN
         WRITE(NFECRA,1700) NPF,XP1,YP1,
     &                      NELMIN,N1MIN,N2MIN,
     &                      NUMSEG,
     &                      XMIN,YMIN,DMIN,
     &                      BARYF(NPF,1),BARYF(NPF,2)
         ENDIF
C
  100 CONTINUE     
C
      IF (NBLBLA.GE.2) WRITE(NFECRA,2000)
C
      DO 200 NPS=1,NBCOUS
C
        IF (NCBORS(NPS,1).EQ.-1) THEN
           NONC=NONC+1
           GOTO 200
        ENDIF
C
        NG = NCOUPS(NPS)
C    
        XP1 = COORDS(NG,1)
        YP1 = COORDS(NG,2)
C
        ICODE = 0
        DMIN = 1.D6
C
        DO 210 NEF=1,NELESF
C
            NA = NODESF(NEF,1)
            NB = NODESF(NEF,2)
C
            XA = COORDF(NA,1)
            YA = COORDF(NA,2)
            XB = COORDF(NB,1)
            YB = COORDF(NB,2)
C
            CALL DPTSEG (XP1,YP1,XA,YA,XB,YB,DIST,XX,YY,ICODE)
C
            IF (ICODE.NE.0) THEN
               WRITE(NFECRA,2200) NG,XP1,YP1,NEF,NA,NB
               STOP
            ENDIF
C
            IF (DIST.LT.DMIN) THEN
               DMIN   = DIST
               XMIN   = XX
               YMIN   = YY
               NELMIN = NEF               
            ENDIF
C
  210    CONTINUE
C
         IF (DMIN .GT. D2MAXF) THEN
            NONC=NONC+1
            NCBORS(NPS,1) = -1
            IF (NBLBLA.GE.11) THEN
               WRITE(NFECRA,2701) NG,XP1,YP1,
     &                            NELMIN,N1MIN,N2MIN,
     &                            XMIN,YMIN,DMIN
         ENDIF
            GOTO 200
         ENDIF
C
         N1MIN  = NODESF(NELMIN,1)
         N2MIN  = NODESF(NELMIN,2)
         X1 = COORDF(N1MIN,1)
         Y1 = COORDF(N1MIN,2)
         X2 = COORDF(N2MIN,1)
         Y2 = COORDF(N2MIN,2)
C
         IF (NDMASF.EQ.3 .AND. NODESF(NELMIN,3).NE.0) THEN
           N3MIN  = NODESF(NELMIN,3)
           X3 = COORDF(N3MIN,1)
           Y3 = COORDF(N3MIN,2)
C
           CALL SOUSEG (XMIN,YMIN,X1,Y1, X2,Y2, NUMSEG)
C
           IF (NUMSEG .EQ. 1) THEN
C  
              CALL CBARY2 (XMIN,YMIN,
     &                     X1,Y1,X3,Y3,
     &                     BARYS(NPS,1),BARYS(NPS,2))
C
           ELSE
C
              CALL CBARY2 (XMIN,YMIN,
     &                     X2,Y2,X3,Y3,
     &                     BARYS(NPS,1),BARYS(NPS,2))
C 
           ENDIF
         ELSE
            CALL CBARY2 (XMIN,YMIN,
     &                   X1,Y1,X2,Y2,
     &                   BARYS(NPS,1),BARYS(NPS,2))
            NUMSEG = 0
         ENDIF
C
         NCBORS(NPS,1) = NELMIN
         NCBORS(NPS,2) = NUMSEG
C
C
         IF (NBLBLA.GE.11) THEN
         WRITE(NFECRA,2700) NG,XP1,YP1,
     &                      NELMIN,N1MIN,N2MIN,
     &                      XMIN,YMIN,DMIN,
     &                      BARYS(NPS,1),BARYS(NPS,2)
         ENDIF
C
C
  200 CONTINUE     
C
      IF (NBLBLA.GE.3) WRITE(NFECRA,3000) NBCOUS,NONC
C
C--------
C FORMATS
C--------
C
 1000 FORMAT(/,' *** CORFS2 : ',/,
     &   '       Recherche du correspondant de chaque noeud du',
     &         ' maillage surfacique fluide',/)
 1200 FORMAT(' %% ERREUR CORFS2 : LA RECHERCHE DU CORRESPONDANT A ',
     &        'ECHOUEE : ',/,
     &        '                  POINT FLUIDE :',I6,/,
     &        '                                ',2G10.3,/,
     &        '        DANS LE SEGMENT SOLIDE :',I6,/,
     &        '                                ',2I6)
 1700 FORMAT(/,'  NOEUD FLUIDE :',I6,', coordonnees : ',2G10.3,/,
     &       '  CORRESPONDANT SOLIDE : ',/,
     &       '            numero du segment solide :',I6,/,
     &       '                              noeuds :',I6,' ',I6,/,
     &       '              numero du sous-segment :',I6,/,
     &       '              coord du correspondant :',2G10.3,/,
     &       '                   distance minimale :',G10.3,/,
     &       '                coord barycentriques :',2G10.3)
C
 2000 FORMAT(/,' *** CORFS2 :',/, 
     &    '       Recherche du correspondant de chaque noeud du',
     &         ' maillage surfacique solide',/)
 2200 FORMAT(' %% ERREUR CORFS2 : LA RECHERCHE DU CORRESPONDANT A ',
     &        'ECHOUEE : ',/,
     &        '                  POINT SOLIDE :',I6,/,
     &        '                                ',2G10.3,/,
     &        '        DANS LE SEGMENT FLUIDE :',I6,/,
     &        '                                ',2I6)
 2700 FORMAT(/,'  NOEUD SOLIDE :',I6,', coordonnees : ',2G10.3,/,
     &       '  CORRESPONDANT FLUIDE : ',/,
     &       '            numero du segment fluide :',I6,/,
     &       '                              noeuds :',I6,' ',I6,/,
     &       '              coord du correspondant :',2G10.3,/,
     &       '                   distance minimale :',G10.3,/,
     &       '                coord barycentriques :',2G10.3)
 2701 FORMAT(/,'  +++ NOEUD SOLIDE ELIMINE :',I6,', coordonnees : ',
     &                                                  2G10.3,/,
     &       '  CORRESPONDANT FLUIDE : ',/,
     &       '            numero du segment fluide :',I6,/,
     &       '                              noeuds :',I6,' ',I6,/,
     &       '              coord du correspondant :',2G10.3,/,
     &       '                   distance minimale :',G10.3)
CC
 3000 FORMAT(/,' *** CORFS2 : ',/,
     *  '       Nombre de noeuds solides candidats au couplage ',I7,/,
     *  '       Nombre de noeuds elimines du couplage          ',I7)

C----
C FIN
C----
      END
               
