/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "TabTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "sublib/Tab.h"
//#include "util/String.h"


void TabTest::setUp()
{
}

void TabTest::tearDown()
{
}

void TabTest::testCalcColumns()
{
  Tab t1(2);

  unsigned int res;
  
  res = t1.calcColumns( "" );
  CPPUNIT_ASSERT( 0 == res );

  res = t1.calcColumns( "aa" );
  CPPUNIT_ASSERT( 2 == res );

  // "__"
  res = t1.calcColumns( "\t" );
  CPPUNIT_ASSERT( 2 == res );

  // "____"
  res = t1.calcColumns( "\t\t" );
  CPPUNIT_ASSERT( 4 == res );

  // "a_a_a"
  res = t1.calcColumns( "a\ta\ta" );
  CPPUNIT_ASSERT( 5 == res );

  // "a_a_a_a_a_a_a_a_a_a_a"
  res = t1.calcColumns( "a\ta\ta\ta\ta\ta\ta\ta\ta\ta\ta" );
  CPPUNIT_ASSERT( 21 == res );
}

void TabTest::testCalcColumnsLineEnd()
{
  unsigned int res;

  Tab tlf( 2 );

  res = tlf.calcColumns( "\n" );
  CPPUNIT_ASSERT( 0 == res );


  Tab tcrlf( 2 );

  res = tlf.calcColumns( "\r\n" );
  CPPUNIT_ASSERT( 0 == res );
}
