/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "UnlockCmd.h"
#include "UnlockParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "util/Error.h"


UnlockCmd::UnlockCmd( UnlockParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

UnlockCmd::~UnlockCmd()
{
  delete _cb;
}

void UnlockCmd::run()
{
  sc::Error* err;

  _prgscb->started( _param, getCancel() );

  err = _client->unlock( _param->getPathsOrUrls(), _param->getBreakLocks() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
