/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "RpViewTreeProxyModel.h"
#include "RpViewTreeItemModel.h"
#include "RpViewEntry.h"
#include "svn/DirEntry.h"
#include "svn/Path.h"
#include "util/Compare.h"


RpViewTreeProxyModel::RpViewTreeProxyModel()
{
}

RpViewTreeProxyModel::~RpViewTreeProxyModel()
{
}

QVariant RpViewTreeProxyModel::data( const QModelIndex& index, int role ) const
{
  QVariant value = sourceModel()->data( mapToSource(index), role );

  if( index.column() == 0 && role == Qt::DisplayRole || role == Qt::EditRole )
  {
    QString temp = value.toString();

    if( temp == (const char*)_current )
    {
      //temp = ".";
    }
    else
    {
      temp = temp.section('/', -1);
    }

    value = temp;
  }

  return value;
}

Qt::ItemFlags RpViewTreeProxyModel::flags( const QModelIndex &index ) const
{
  Qt::ItemFlags flags = sourceModel()->flags( mapToSource(index) );
  sc::String target = index.data(RpViewTreeItemModel::NameRole).value<sc::String>();

  if( target == _current )
    flags &= ~(Qt::ItemIsDragEnabled | Qt::ItemIsEditable);

  return flags;
}

bool RpViewTreeProxyModel::filterAcceptsRow( int sourceRow, const QModelIndex& sourceParent ) const
{
  QModelIndex index = sourceModel()->index( sourceRow, 0, sourceParent );
  sc::String target = index.data(RpViewTreeItemModel::NameRole).value<sc::String>();

  if( target == _current )
    return true;

  sc::String targetDir  = svn::Path::getDirName(target);
  sc::String currentDir = svn::Path::getDirName(_current);
  if( targetDir == currentDir )
    return false;

  //printf("+ %s\n", (const char*)target );
  return true;
}

bool RpViewTreeProxyModel::lessThan(const QModelIndex &left, const QModelIndex &right) const
{
  if( left.column() == 0 && left.isValid() && right.isValid() )
  {
    const RpViewItem* litem = left.data(RpViewTreeItemModel::RpViewItemRole).value<const RpViewItem*>();
    svn::DirEntryPtr leftItem = static_cast<const RpViewEntry*>(litem)->entry();

    const RpViewItem* ritem = right.data(RpViewTreeItemModel::RpViewItemRole).value<const RpViewItem*>();
    svn::DirEntryPtr rightItem = static_cast<const RpViewEntry*>(ritem)->entry();

    int result = compare3( 
      leftItem->getName(), leftItem->isDir(),
      rightItem->getName(), rightItem->isDir() );

    return result < 0;
  }
  else
  {
    return super::lessThan(left,right);
  }

  return false;
}

void RpViewTreeProxyModel::setCurrentPath( const sc::String& current )
{
  _current = current;
}

bool RpViewTreeProxyModel::canFetchMore( const QModelIndex& parent ) const
{
  return sourceModel()->canFetchMore( mapToSource(parent) );
}

void RpViewTreeProxyModel::fetchMore( const QModelIndex& parent )
{
  return sourceModel()->fetchMore( mapToSource(parent) );
}

bool RpViewTreeProxyModel::hasChildren( const QModelIndex& parent ) const
{
  return sourceModel()->hasChildren( mapToSource(parent) );
}

