/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;

public class NumericConstant
implements ADQLOperand {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "NUMERIC_VALUE", false, "A numeric value.");
    protected String value;
    protected TextPosition position = null;

    public NumericConstant(String value) throws NumberFormatException {
        this(value, true);
    }

    public NumericConstant(long val) {
        this("" + val, false);
    }

    public NumericConstant(double val) {
        this("" + val, false);
    }

    public NumericConstant(String value, boolean checkNumeric) throws NumberFormatException {
        this.setValue(value, checkNumeric);
    }

    public NumericConstant(NumericConstant toCopy) {
        this.value = toCopy.value;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean isHexadecimal() {
        return this.isHexadecimal(this.value);
    }

    protected boolean isHexadecimal(String val) {
        return val.matches("0[Xx][0-9a-fA-F]+");
    }

    public double getNumericValue() {
        try {
            if (this.isHexadecimal()) {
                return Long.parseLong(this.value.substring(2), 16);
            }
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public void setValue(long value) {
        this.value = "" + value;
    }

    public void setValue(double value) {
        this.value = "" + value;
    }

    public void setValue(String value) throws NumberFormatException {
        this.setValue(value, true);
    }

    public void setValue(String value, boolean checkNumeric) throws NumberFormatException {
        if (checkNumeric) {
            if (this.isHexadecimal(value)) {
                Long.parseLong(value.substring(2), 16);
            } else {
                Double.parseDouble(value);
            }
        }
        this.value = value;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() {
        return new NumericConstant(this);
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return this.value;
    }
}

