/*
	SRG - Squid Report Generator
	Report template
	Copyright 2005 University of Waikato

	This file is part of SRG.

	SRG is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	SRG is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with SRG; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
	USA

*/

#include "Report.h"
#include "srg.h"
#include "prototypes.h"

/* Default constructor */
Report::Report(char* name) {

	mName = strdup(name);
	zeroStats();

	if (srg.debug)
		fprintf(stderr, "Creating Report: %s\n", mName);

}
Report::~Report() {
	free(mName);
}

/* Adds a new log line to the report */
void Report::process_line(const log_line *line) {

	if (srg.debug)
		fprintf(stderr, "In process_line for report '%s'\n", mName);

	//stats.connects++;
	stats.bytesTransferred += line->size;
	stats.timeSpent += line->elapsedTime;
	if (is_cache_hit(line->resultCode)) {
		stats.hits++;
		stats.bytesHit+=line->size;
	} else {
		stats.misses++;
		stats.bytesMissed+=line->size;
	}
	if (is_cache_denied(line->resultCode)) {
		stats.deniedHits++;
	}
      
}

/* Get statistics about this report */
summary_info Report::getStats() {
  
	summary_info returnInfo;

	updateStats();

	returnInfo = stats;

	return returnInfo;

}

/* Update the statistics */
void Report::updateStats() {
	/* Do nothing here */
}

/* Reset the statistics */
void Report::zeroStats() {
	stats.connects = 0;
	stats.bytesTransferred = 0;
	stats.timeSpent = 0;
	stats.hits = 0;
	stats.bytesHit = 0;
	stats.misses = 0;
	stats.bytesMissed = 0;
	stats.deniedHits = 0;
}

/* Get the name of this report */
char * Report::getName() {
	return mName;
}
