/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_30 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 24819, "epsg", 24819,
        "PSAD56 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24819\"]]");
    p = add_epsg_def (filter, first, last, 24820, "epsg", 24820,
        "PSAD56 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24820\"]]");
    p = add_epsg_def (filter, first, last, 24821, "epsg", 24821,
        "PSAD56 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24821\"]]");
    p = add_epsg_def (filter, first, last, 24877, "epsg", 24877,
        "PSAD56 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24877\"]]");
    p = add_epsg_def (filter, first, last, 24878, "epsg", 24878,
        "PSAD56 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24878\"]]");
    p = add_epsg_def (filter, first, last, 24879, "epsg", 24879,
        "PSAD56 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24879\"]]");
    p = add_epsg_def (filter, first, last, 24880, "epsg", 24880,
        "PSAD56 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24880\"]]");
    p = add_epsg_def (filter, first, last, 24881, "epsg", 24881,
        "PSAD56 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24881\"]]");
    p = add_epsg_def (filter, first, last, 24882, "epsg", 24882,
        "PSAD56 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 22S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24882\"]]");
    p = add_epsg_def (filter, first, last, 24891, "epsg", 24891,
        "PSAD56 / Peru west zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-6 +lon_0=-80.5 +k=0.99983008 +x_0=22");
    add_proj4text (p, 1,
        "2000 +y_0=1426834.743 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru west zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",-6],PARAMETER[\"central_meridian\",-80.5],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.99983008],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",222000],PARAMETER[\"false_northing\",1426834.743],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24891\"]]");
    p = add_epsg_def (filter, first, last, 24892, "epsg", 24892,
        "PSAD56 / Peru central zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-76 +k=0.99932994 +x_0=72");
    add_proj4text (p, 1,
        "0000 +y_0=1039979.159 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru central zone\",GEOGCS[\"PSAD56\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Provisional_South_American_Datum_1956\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",-9.5],PARAMETER[\"central_meridian\",-76],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99932994],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",720000],PARAMETER[\"false_northing\",1039979.159],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24892\"]]");
    p = add_epsg_def (filter, first, last, 24893, "epsg", 24893,
        "PSAD56 / Peru east zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-70.5 +k=0.99952992 +x_0=");
    add_proj4text (p, 1,
        "1324000 +y_0=1040084.558 +ellps=intl +towgs84=-288,175,-");
    add_proj4text (p, 2,
        "376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru east zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",-9.5],PARAMETER[\"central_meridian\",-70.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99952992],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",1324000],PARAMETER[\"false_northing\",1040084.558],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24893\"]]");
    p = add_epsg_def (filter, first, last, 25000, "epsg", 25000,
        "Leigon / Ghana Metre Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.9997");
    add_proj4text (p, 1,
        "5 +x_0=274319.51 +y_0=0 +ellps=clrk80 +towgs84=-130,29,3");
    add_proj4text (p, 2,
        "64,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Leigon / Ghana Metre Grid\",GEOGCS[\"Leigon\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Leigon\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.1");
    add_srs_wkt (p, 2,
        "45,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-130,29");
    add_srs_wkt (p, 3,
        ",364,0,0,0,0],AUTHORITY[\"EPSG\",\"6250\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4250\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",4.666666666666667],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-1],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.99975],PARAMETER[\"false_easting\",274319.51],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"25000\"]]");
    p = add_epsg_def (filter, first, last, 25231, "epsg", 25231,
        "Lome / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lome / UTM zone 31N\",GEOGCS[\"Lome\",DATUM[\"L");
    add_srs_wkt (p, 1,
        "ome\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602");
    add_srs_wkt (p, 2,
        "12936269,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6252\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4252\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"25231\"]]");
    p = add_epsg_def (filter, first, last, 25391, "epsg", 25391,
        "Luzon 1911 / Philippines zone I");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone I\",GEOGCS[\"Luzo");
    add_srs_wkt (p, 1,
        "n 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"6253");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",117],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99995],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"25391\"]]");
    p = add_epsg_def (filter, first, last, 25392, "epsg", 25392,
        "Luzon 1911 / Philippines zone II");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone II\",GEOGCS[\"Luz");
    add_srs_wkt (p, 1,
        "on 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",119],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99995],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"25392\"]]");
    p = add_epsg_def (filter, first, last, 25393, "epsg", 25393,
        "Luzon 1911 / Philippines zone III");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone III\",GEOGCS[\"Lu");
    add_srs_wkt (p, 1,
        "zon 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "53\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",121],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99995],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"25393\"]]");
    p = add_epsg_def (filter, first, last, 25394, "epsg", 25394,
        "Luzon 1911 / Philippines zone IV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone IV\",GEOGCS[\"Luz");
    add_srs_wkt (p, 1,
        "on 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",123],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99995],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"25394\"]]");
    p = add_epsg_def (filter, first, last, 25395, "epsg", 25395,
        "Luzon 1911 / Philippines zone V");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone V\",GEOGCS[\"Luzo");
    add_srs_wkt (p, 1,
        "n 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"6253");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",125],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99995],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"25395\"]]");
    p = add_epsg_def (filter, first, last, 25700, "epsg", 25700,
        "Makassar (Jakarta) / NEIEZ (deprecated)");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=");
    add_proj4text (p, 2,
        "jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Makassar (Jakarta) / NEIEZ (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Makassar (Jakarta)\",DATUM[\"Makassar_Jakarta\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[-587.8,519.75,145.76,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6804\"]],PRIMEM[\"Jakarta\",106.807");
    add_srs_wkt (p, 5,
        "7194444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4804\"]],PROJECTION[\"Mercator_1SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",110],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.997],PARAMETER[\"false_easting\",3900000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",900000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"25700\"]]");
    p = add_epsg_def (filter, first, last, 25828, "epsg", 25828,
        "ETRS89 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 28N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-15],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"25828\"]]");
    p = add_epsg_def (filter, first, last, 25829, "epsg", 25829,
        "ETRS89 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 29N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25829\"]]");
    p = add_epsg_def (filter, first, last, 25830, "epsg", 25830,
        "ETRS89 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 30N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-3],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25830\"]]");
    p = add_epsg_def (filter, first, last, 25831, "epsg", 25831,
        "ETRS89 / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",3],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25831\"]]");
    p = add_epsg_def (filter, first, last, 25832, "epsg", 25832,
        "ETRS89 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25832\"]]");
    p = add_epsg_def (filter, first, last, 25833, "epsg", 25833,
        "ETRS89 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25833\"]]");
    p = add_epsg_def (filter, first, last, 25834, "epsg", 25834,
        "ETRS89 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25834\"]]");
    p = add_epsg_def (filter, first, last, 25835, "epsg", 25835,
        "ETRS89 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25835\"]]");
    p = add_epsg_def (filter, first, last, 25836, "epsg", 25836,
        "ETRS89 / UTM zone 36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",33],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25836\"]]");
    p = add_epsg_def (filter, first, last, 25837, "epsg", 25837,
        "ETRS89 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 37N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25837\"]]");
    p = add_epsg_def (filter, first, last, 25838, "epsg", 25838,
        "ETRS89 / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 38N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25838\"]]");
    p = add_epsg_def (filter, first, last, 25884, "epsg", 25884,
        "ETRS89 / TM Baltic93");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM Baltic93\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",24],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"25884\"]]");
    p = add_epsg_def (filter, first, last, 25932, "epsg", 25932,
        "Malongo 1987 / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +towgs84=-254.1,-5");
    add_proj4text (p, 1,
        ".36,-100.29,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Malongo 1987 / UTM zone 32S\",GEOGCS[\"Malongo ");
    add_srs_wkt (p, 1,
        "1987\",DATUM[\"Malongo_1987\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-254.1,-5.36,-100.29,0,0,0,0],AUTHORITY[\"EPSG\",\"6259\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4259\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"25932\"]]");
    p = add_epsg_def (filter, first, last, 26191, "epsg", 26191,
        "Merchich / Nord Maroc");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +");
    add_proj4text (p, 2,
        "towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Nord Maroc\",GEOGCS[\"Merchich\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999625769],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26191\"]]");
    p = add_epsg_def (filter, first, last, 26192, "epsg", 26192,
        "Merchich / Sud Maroc");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.7 +lat_0=29.7 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "6155960000001 +x_0=500000 +y_0=300000 +a=6378249.2 +b=63");
    add_proj4text (p, 2,
        "56515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sud Maroc\",GEOGCS[\"Merchich\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,");
    add_srs_wkt (p, 2,
        "293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",29.7],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999615596],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26192\"]]");
    p = add_epsg_def (filter, first, last, 26193, "epsg", 26193,
        "Merchich / Sahara (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "6 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara (deprecated)\",GEOGCS[\"Merch");
    add_srs_wkt (p, 1,
        "ich\",DATUM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",");
    add_srs_wkt (p, 2,
        "6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26.1],PARAMETER[\"central_meridian\",-5.4],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",12");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",400000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26193\"]]");
    p = add_epsg_def (filter, first, last, 26194, "epsg", 26194,
        "Merchich / Sahara Nord");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "616304 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Nord\",GEOGCS[\"Merchich\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26.1");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999616304],PARAMETER[\"false_easting\",12000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",400000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26194\"]]");
    p = add_epsg_def (filter, first, last, 26195, "epsg", 26195,
        "Merchich / Sahara Sud");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22.5 +lat_0=22.5 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "616437 +x_0=1500000 +y_0=400000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Sud\",GEOGCS[\"Merchich\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",22.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999616437],PARAMETER[\"false_easting\",150000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",400000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26195\"]]");
    p = add_epsg_def (filter, first, last, 26237, "epsg", 26237,
        "Massawa / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=bessel +towgs84=639,405,60,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Massawa / UTM zone 37N\",GEOGCS[\"Massawa\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Massawa\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[639,405,60");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6262\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4262\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"26237\"]]");
    p = add_epsg_def (filter, first, last, 26331, "epsg", 26331,
        "Minna / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=clrk80 +towgs84=-92,-93,122,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / UTM zone 31N\",GEOGCS[\"Minna\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,122,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26331\"]]");
    p = add_epsg_def (filter, first, last, 26332, "epsg", 26332,
        "Minna / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=clrk80 +towgs84=-92,-93,122,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / UTM zone 32N\",GEOGCS[\"Minna\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,122,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26332\"]]");
    p = add_epsg_def (filter, first, last, 26391, "epsg", 26391,
        "Minna / Nigeria West Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=4.5 +k=0.99975 +x_0=230738.2");
    add_proj4text (p, 1,
        "6 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria West Belt\",GEOGCS[\"Minna\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,1");
    add_srs_wkt (p, 3,
        "22,0,0,0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",4],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",4.5],PARAMETER[\"scale_factor\",0.99975],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",230738.26],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26391\"]]");
    p = add_epsg_def (filter, first, last, 26392, "epsg", 26392,
        "Minna / Nigeria Mid Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=8.5 +k=0.99975 +x_0=670553.9");
    add_proj4text (p, 1,
        "8 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria Mid Belt\",GEOGCS[\"Minna\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,12");
    add_srs_wkt (p, 3,
        "2,0,0,0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",4],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",8.5],PARAMETER[\"scale_factor\",0.99975],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",670553.98],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26392\"]]");
    p = add_epsg_def (filter, first, last, 26393, "epsg", 26393,
        "Minna / Nigeria East Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=12.5 +k=0.99975 +x_0=1110369");
    add_proj4text (p, 1,
        ".7 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria East Belt\",GEOGCS[\"Minna\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,1");
    add_srs_wkt (p, 3,
        "22,0,0,0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",4],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",12.5],PARAMETER[\"scale_factor\",0.99975],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1110369.7],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"26393\"]]");
    p = add_epsg_def (filter, first, last, 26432, "epsg", 26432,
        "Mhast / UTM zone 32S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +towgs84=-252.95,-");
    add_proj4text (p, 1,
        "4.11,-96.38,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast / UTM zone 32S (deprecated)\",GEOGCS[\"Mh");
    add_srs_wkt (p, 1,
        "ast\",DATUM[\"Mhast\",SPHEROID[\"International 1924\",63");
    add_srs_wkt (p, 2,
        "78388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-252.95,");
    add_srs_wkt (p, 3,
        "-4.11,-96.38,0,0,0,0],AUTHORITY[\"EPSG\",\"6264\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4264\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26432\"]]");
    p = add_epsg_def (filter, first, last, 26591, "epsg", 26591,
        "Monte Mario (Rome) / Italy zone 1 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-3.45233333333333 +k=0.9996 ");
    add_proj4text (p, 1,
        "+x_0=1500000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9");
    add_proj4text (p, 2,
        ".9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario (Rome) / Italy zone 1 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917");
    add_srs_wkt (p, 4,
        ",0.714,-11.68],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"Ro");
    add_srs_wkt (p, 5,
        "me\",12.45233333333333,AUTHORITY[\"EPSG\",\"8906\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4806\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-3.45233333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",150");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26591\"]]");
    p = add_epsg_def (filter, first, last, 26592, "epsg", 26592,
        "Monte Mario (Rome) / Italy zone 2 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=2.54766666666666 +k=0.9996 +");
    add_proj4text (p, 1,
        "x_0=2520000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.");
    add_proj4text (p, 2,
        "9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario (Rome) / Italy zone 2 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917");
    add_srs_wkt (p, 4,
        ",0.714,-11.68],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"Ro");
    add_srs_wkt (p, 5,
        "me\",12.45233333333333,AUTHORITY[\"EPSG\",\"8906\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4806\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",2.54766666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",25200");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"26592\"]]");
    p = add_epsg_def (filter, first, last, 26632, "epsg", 26632,
        "M'poraloko / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-74,");
    add_proj4text (p, 1,
        "-130,42,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"M'poraloko / UTM zone 32N\",GEOGCS[\"M'poraloko");
    add_srs_wkt (p, 1,
        "\",DATUM[\"M_poraloko\",SPHEROID[\"Clarke 1880 (IGN)\",6");
    add_srs_wkt (p, 2,
        "378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-74,-130,42,0,0,0,0],AUTHORITY[\"EPSG\",\"6266\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4266\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26632\"]]");
    p = add_epsg_def (filter, first, last, 26692, "epsg", 26692,
        "M'poraloko / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-74,-130,42,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"M'poraloko / UTM zone 32S\",GEOGCS[\"M'poraloko");
    add_srs_wkt (p, 1,
        "\",DATUM[\"M_poraloko\",SPHEROID[\"Clarke 1880 (IGN)\",6");
    add_srs_wkt (p, 2,
        "378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-74,-130,42,0,0,0,0],AUTHORITY[\"EPSG\",\"6266\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4266\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"26692\"]]");
    p = add_epsg_def (filter, first, last, 26701, "epsg", 26701,
        "NAD27 / UTM zone 1N");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 1N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26701\"]]");
    p = add_epsg_def (filter, first, last, 26702, "epsg", 26702,
        "NAD27 / UTM zone 2N");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 2N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26702\"]]");
    p = add_epsg_def (filter, first, last, 26703, "epsg", 26703,
        "NAD27 / UTM zone 3N");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 3N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26703\"]]");
    p = add_epsg_def (filter, first, last, 26704, "epsg", 26704,
        "NAD27 / UTM zone 4N");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 4N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26704\"]]");
    p = add_epsg_def (filter, first, last, 26705, "epsg", 26705,
        "NAD27 / UTM zone 5N");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 5N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26705\"]]");
    p = add_epsg_def (filter, first, last, 26706, "epsg", 26706,
        "NAD27 / UTM zone 6N");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 6N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26706\"]]");
    p = add_epsg_def (filter, first, last, 26707, "epsg", 26707,
        "NAD27 / UTM zone 7N");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 7N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26707\"]]");
    p = add_epsg_def (filter, first, last, 26708, "epsg", 26708,
        "NAD27 / UTM zone 8N");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 8N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26708\"]]");
    p = add_epsg_def (filter, first, last, 26709, "epsg", 26709,
        "NAD27 / UTM zone 9N");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 9N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26709\"]]");
    p = add_epsg_def (filter, first, last, 26710, "epsg", 26710,
        "NAD27 / UTM zone 10N");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 10N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26710\"]]");
    p = add_epsg_def (filter, first, last, 26711, "epsg", 26711,
        "NAD27 / UTM zone 11N");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 11N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26711\"]]");
    p = add_epsg_def (filter, first, last, 26712, "epsg", 26712,
        "NAD27 / UTM zone 12N");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 12N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26712\"]]");
    p = add_epsg_def (filter, first, last, 26713, "epsg", 26713,
        "NAD27 / UTM zone 13N");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 13N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26713\"]]");
    p = add_epsg_def (filter, first, last, 26714, "epsg", 26714,
        "NAD27 / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 14N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6714\"]]");
    p = add_epsg_def (filter, first, last, 26715, "epsg", 26715,
        "NAD27 / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 15N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6715\"]]");
    p = add_epsg_def (filter, first, last, 26716, "epsg", 26716,
        "NAD27 / UTM zone 16N");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 16N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6716\"]]");
    p = add_epsg_def (filter, first, last, 26717, "epsg", 26717,
        "NAD27 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 17N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6717\"]]");
    p = add_epsg_def (filter, first, last, 26718, "epsg", 26718,
        "NAD27 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 18N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6718\"]]");
    p = add_epsg_def (filter, first, last, 26719, "epsg", 26719,
        "NAD27 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 19N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6719\"]]");
    p = add_epsg_def (filter, first, last, 26720, "epsg", 26720,
        "NAD27 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 20N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6720\"]]");
    p = add_epsg_def (filter, first, last, 26721, "epsg", 26721,
        "NAD27 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 21N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6721\"]]");
    p = add_epsg_def (filter, first, last, 26722, "epsg", 26722,
        "NAD27 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 22N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6722\"]]");
    p = add_epsg_def (filter, first, last, 26729, "epsg", 26729,
        "NAD27 / Alabama East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alabama East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-85.83333333333333],PARAMETER[\"scale_factor\",0.99996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26729\"]]");
    p = add_epsg_def (filter, first, last, 26730, "epsg", 26730,
        "NAD27 / Alabama West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=1");
    add_proj4text (p, 1,
        "52400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alabama West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-87.5],PARAMETER[\"scale_factor\",0.999933333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"26730\"]]");
    p = add_epsg_def (filter, first, last, 26731, "epsg", 26731,
        "NAD27 / Alaska zone 1");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=32");
    add_proj4text (p, 1,
        "3.1301023611111 +k=0.9999 +x_0=5000000.001016002 +y_0=-5");
    add_proj4text (p, 2,
        "000000.001016002 +gamma=323.1301023611111 +datum=NAD27 +");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 1\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_center\",57],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 8,
        "_center\",-133.6666666666667],PARAMETER[\"azimuth\",323.");
    add_srs_wkt (p, 9,
        "1301023611111],PARAMETER[\"rectified_grid_angle\",323.13");
    add_srs_wkt (p, 10,
        "01023611111],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",16404166.67],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",-16404166.67],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26731\"]]");
    p = add_epsg_def (filter, first, last, 26732, "epsg", 26732,
        "NAD27 / Alaska zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 2\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-142],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26732\"]]");
    p = add_epsg_def (filter, first, last, 26733, "epsg", 26733,
        "NAD27 / Alaska zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 3\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-146],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26733\"]]");
    p = add_epsg_def (filter, first, last, 26734, "epsg", 26734,
        "NAD27 / Alaska zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 4\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-150],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26734\"]]");
    p = add_epsg_def (filter, first, last, 26735, "epsg", 26735,
        "NAD27 / Alaska zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 5\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-154],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26735\"]]");
    p = add_epsg_def (filter, first, last, 26736, "epsg", 26736,
        "NAD27 / Alaska zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 6\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-158],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26736\"]]");
    p = add_epsg_def (filter, first, last, 26737, "epsg", 26737,
        "NAD27 / Alaska zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=213360.");
    add_proj4text (p, 1,
        "4267208534 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 7\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-162],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",700000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26737\"]]");
    p = add_epsg_def (filter, first, last, 26738, "epsg", 26738,
        "NAD27 / Alaska zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 8\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-166],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26738\"]]");
    p = add_epsg_def (filter, first, last, 26739, "epsg", 26739,
        "NAD27 / Alaska zone 9");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=182880.");
    add_proj4text (p, 1,
        "3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 9\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-170],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",600000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26739\"]]");
    p = add_epsg_def (filter, first, last, 26740, "epsg", 26740,
        "NAD27 / Alaska zone 10");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=914401.8288036576 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 10\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",53.83333333333334],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",51.83333333333334],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",51],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-176],PARAMETER[\"false_easting\",3000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26740\"]]");
    p = add_epsg_def (filter, first, last, 26741, "epsg", 26741,
        "NAD27 / California zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone I\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",41.66666666666666],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_2\",40],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",39.33333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-122],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26741\"]]");
    p = add_epsg_def (filter, first, last, 26742, "epsg", 26742,
        "NAD27 / California zone II");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone II\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",39.83333333333334]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",38.33333333333334],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",37.66666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-122],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"26742\"]]");
    p = add_epsg_def (filter, first, last, 26743, "epsg", 26743,
        "NAD27 / California zone III");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone III\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",38.43333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",37.06666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",36.5],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-120.5],PARAMETER[\"false_easting\",2000000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26743\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 26744, "epsg", 26744,
        "NAD27 / California zone IV");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=609601.2192024384 +y_0=0 +datum=NAD27");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone IV\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",37.25],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_2\",36],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 9,
        "\",35.33333333333334],PARAMETER[\"central_meridian\",-11");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26744\"]]");
    p = add_epsg_def (filter, first, last, 26745, "epsg", 26745,
        "NAD27 / California zone V");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone V\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",35.46666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_2\",34.03333333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",33.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-118],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26745\"]]");
    p = add_epsg_def (filter, first, last, 26746, "epsg", 26746,
        "NAD27 / California zone VI");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=609601.");
    add_proj4text (p, 2,
        "2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VI\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",33.88333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",32.78333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",32.16666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-116.25],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 12,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"26746\"]]");
    p = add_epsg_def (filter, first, last, 26747, "epsg", 26747,
        "NAD27 / California zone VII (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=127079.524511049 +datum=NAD27");
    add_proj4text (p, 3,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34.4");
    add_srs_wkt (p, 8,
        "1666666666666],PARAMETER[\"standard_parallel_2\",33.8666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"latitude_of_origin\",34.13333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"central_meridian\",-118.333333333333");
    add_srs_wkt (p, 11,
        "3],PARAMETER[\"false_easting\",4186692.58],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",416926.74],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26747\"]]");
    p = add_epsg_def (filter, first, last, 26748, "epsg", 26748,
        "NAD27 / Arizona East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-110.1666666666667],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26748\"]]");
    p = add_epsg_def (filter, first, last, 26749, "epsg", 26749,
        "NAD27 / Arizona Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-111.9166666666667],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26749\"]]");
    p = add_epsg_def (filter, first, last, 26750, "epsg", 26750,
        "NAD27 / Arizona West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-113.75],PARAMETER[\"scale_factor\",0.999933333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"26750\"]]");
    p = add_epsg_def (filter, first, last, 26751, "epsg", 26751,
        "NAD27 / Arkansas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",36.23333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",34.93333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",34.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-92],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26751\"]]");
    p = add_epsg_def (filter, first, last, 26752, "epsg", 26752,
        "NAD27 / Arkansas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",34.76666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",33.3],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",32.66666666666666],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-92],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26752\"]]");
    p = add_epsg_def (filter, first, last, 26753, "epsg", 26753,
        "NAD27 / Colorado North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.71666666666667 +lat_2=40.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",39.71666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",40.78333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",39.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-105.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26753\"]]");
    p = add_epsg_def (filter, first, last, 26754, "epsg", 26754,
        "NAD27 / Colorado Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=");
    add_proj4text (p, 2,
        "NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",39.75],PARAMETER[\"sta");
    add_srs_wkt (p, 8,
        "ndard_parallel_2\",38.45],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 9,
        "\",37.83333333333334],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 10,
        "5.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26754\"]]");
    p = add_epsg_def (filter, first, last, 26755, "epsg", 26755,
        "NAD27 / Colorado South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",38.43333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",37.23333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",36.66666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-105.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26755\"]]");
    p = add_epsg_def (filter, first, last, 26756, "epsg", 26756,
        "NAD27 / Connecticut");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=182880.3657607315 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Connecticut\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",41.86666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",41.2],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",40.83333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-72.75],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26756\"]]");
    p = add_epsg_def (filter, first, last, 26757, "epsg", 26757,
        "NAD27 / Delaware");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Delaware\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",38],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
        "5.41666666666667],PARAMETER[\"scale_factor\",0.999995],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26757\"]]");
    p = add_epsg_def (filter, first, last, 26758, "epsg", 26758,
        "NAD27 / Florida East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.33333333333333],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-81],PARAMETER[\"scale_factor\",0.9999411");
    add_srs_wkt (p, 9,
        "77],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26758\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

