#include "gui_flowtext_image.h"

#include "../../descriptor/image.h"
#include "../../dataobj/environment.h"
#include "../../simworld.h"
#include "../../dataobj/scenario.h"
#include "../../utils/imgloader.h"
//#include "../../utils/dr_rdpng.h"
#include "../../simdebug.h"

gui_flowtext_image_t::gui_flowtext_image_t() {
	_image_name="";
	_image_id=0;
}

image_id gui_flowtext_image_t::get_image_id() {
	return _image_id;
}

std::string gui_flowtext_image_t::get_image_name() {
	return _image_name;
}

hashtable_tpl<const char *,image_id,stringhash_t> *gui_flowtext_image_t::_images=NULL;

gui_flowtext_image_t::gui_flowtext_image_t(std::string filePath) {
	// Initialize Image list if it has not already been done.
	if (_images==NULL) {
		_images=new hashtable_tpl<const char *,image_id,stringhash_t>();
	}
	_image_name=filePath;

	// Check if image is already loaded
	_image_id=_images->get(filePath.c_str());
	if (_image_id>0) {
		return;
	}

	// First Search for image in Scenario Path, then PAK path, the base path
	scenario_t *scenario=world()->get_scenario();
	std::string spath=scenario->get_scenario_path().c_str();

	std::string path= env_t::program_dir+spath+filePath;
	FILE *fp=fopen(path.c_str(),"rb");

	if (fp==NULL) {
		path= env_t::program_dir+env_t::objfilename + filePath;
		fp=fopen(path.c_str(),"rb");
		if (fp==NULL) {
			path= env_t::program_dir+filePath;
			fp=fopen(path.c_str(),"rb");
			if (fp==NULL) {
				// file not found
				_image_id=0;
				return;
			}
		}
	}

	fclose(fp);
	dbg->message("gui_flow_text_image_t()","Loading File %s",path.c_str());
	img_loader c=img_loader();
	c.load_image(path.c_str());
	dbg->message("gui_flow_text_image_t()","Loaded File %s",path.c_str());
	/*if ((filePath.substr(filePath.length()-3,3)=="png")||(filePath.substr(filePath.length()-3,3)=="PNG")) {
		// Load PNG Instead
		unsigned char **block=new unsigned char * [1];
		block[0]=(unsigned char *)malloc(1);
		uint32 width=0;
		uint32 height=0;
		uint32 base_img_size=1;
		load_block(block,&width,&height,path.c_str(),base_img_size);
		c.set_bits(block[0],width,0-height,0x000000FF,0x0000FF00,0x00FF0000);
	} else {
		// Load BMP
		c.load(path.c_str());
	}*/
	uint a = 0x00000000;
	uint r = 0x00007C00;
	uint g = 0x000003E0;
	uint bl = 0x0000001F;
	uint size=c.get_width()*c.get_height()+2;
	uint16 *buffer=new uint16 [size];
	size=size*2;
	c.get_bits((void*)buffer,size,r,g,bl,a,false);
	//PIXVAL pixel=0;
	//PIXVAL prevPixel=0;
	//PIXVAL count=0;
	size_t len=0;
	// Create a buffer to store all required PIXVAL data
	PIXVAL *pixBuffer=new PIXVAL [(c.get_width()+2)*c.get_height()*3];
	bool first=true;
	for (uint32 i=0;i<(c.get_width()*c.get_height());i++) {
		if (i%c.get_width()==0) {
			if (first) {
				first=false;
			} else {
				// Add end of line 0 terminator
				pixBuffer[len]=0;
				len++;
			}
			// Add 0 Transparent pixels
			pixBuffer[len]=0;
			len++;
			// Add image width pixels
			pixBuffer[len]=c.get_width();
			len++;
		}
		// Add the pixel data
		pixBuffer[len]=buffer[i];
		len++;
	}
	// Add a 0 at the end of the data
	pixBuffer[len]=0;
	len++;

	// Not sure how to correctly allocate data for bild_t, other than that in has a set of data + buffer of PIXVAL items
	image_t *b=(image_t *)malloc(sizeof(PIXVAL)*len+128);
	// Set image data
	b->x=0;
	b->y=0;
	b->w=c.get_width();
	b->h=c.get_height();
	b->zoomable=0;
	b->len=len;
	for (uint32 i=0;i<len;i++) {
		b->data[i]=pixBuffer[i];
	}
	// delete the temporary pixBuffer
	delete pixBuffer;
	// register the image
	register_image(b);
	// Store the image number for later retrieval
	_image_id=b->imageid;
	char * name=new char [_image_name.length()+1];
	strcpy(name,_image_name.c_str());
	// Store the image details in case it is accessed later
	_images->put(name,_image_id);
}
