#version 330


layout(points) in;
layout(triangle_strip, max_vertices = 115) out;
//layout(line_strip, max_vertices = 80) out;

const float PI = 3.14159265359f;
const int segments = 8;

uniform mat4 pmv;
uniform mat3 normalMatrix;
uniform int dontshowSymElement[200];
uniform int dontshowSymOperation[200];
uniform int dssesize=0;
uniform int dssosize=0;
uniform float glideVectorThickness = 0.04;
uniform float planeFrameThinkness  = 0.04;

in float coli[];
in float oprn[];
in vec3 norv[];
in vec3 midv[];
in vec3 verts0v[];
in vec3 verts1v[];
in vec3 glidev[];

out vec3 Normal;
out float col;
out float transparent;

out gl_PerVertex{
  vec4 gl_Position;
};




void main() {
  for (int i=0; i<dssesize; i++) if ((dontshowSymElement[i]==coli[0])) return;
  for (int i=0; i<dssosize; i++) if ((dontshowSymOperation[i]==oprn[0])) return;
  // plane frame lines
  vec4 start = vec4(verts0v[0],1);
  vec4 end = vec4(verts1v[0],1);
  vec3 direction   = normalize(end.xyz - start.xyz);
  float l = length(end.xyz - start.xyz);
  vec3 lot = (abs(dot(direction, vec3(1, 0, 0))) > 0.8)?
              (abs(dot(direction, vec3(0, 1, 0))) > 0.8)?
              normalize(cross(direction, vec3(0, 0, 1))):
              normalize(cross(direction, vec3(0, 1, 0))):
              normalize(cross(direction, vec3(1, 0, 0)));
  vec3 lot2 = normalize(cross(direction,lot));
  vec3 r = vec3(0,0,0);
  float rad = planeFrameThinkness;
  vec3 vert=vec3(0,0,0);
  for (int i = 0; i <= 2*segments; i++){
      r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;

      vert = start.xyz  + rad * r;
      gl_Position = pmv* vec4(vert, 1);
      Normal = normalize(normalMatrix * r);
      col = coli[0];
      transparent=0.0;
      EmitVertex();

      vert = end.xyz  + rad * r;
      gl_Position = pmv* vec4(vert , 1);
      Normal = normalize(normalMatrix * r);
      col = coli[0];
      transparent=0.0;
      EmitVertex();
  }
  EndPrimitive();

  //glide axis line
  if (length(glidev[0])>0.1){
    start = vec4(midv[0],1);
    end = vec4(midv[0]+glidev[0],1);
    direction   = normalize(end.xyz - start.xyz);
    l = length(end.xyz - start.xyz);
    lot = (dot(direction, vec3(1, 0, 0)) > 0.8)?
                (dot(direction, vec3(0, 1, 0)) > 0.8)?
                normalize(cross(direction, vec3(0, 0, 1))):
                normalize(cross(direction, vec3(0, 1, 0))):
                normalize(cross(direction, vec3(1, 0, 0)));
    lot2 = normalize(cross(direction,lot));
    r = vec3(0,0,0);
    rad = glideVectorThickness;
    vert=vec3(0,0,0);
    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;

        vert = start.xyz + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalize(normalMatrix * r);
        col = coli[0];
        transparent=0.0;
        EmitVertex();

        vert = end.xyz + rad * r;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalize(normalMatrix * r);
        col = coli[0];
        transparent=0.0;
        EmitVertex();
    }
    EndPrimitive();
    rad*=2;//arrow tip
    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;

        vert = end.xyz + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalize(normalMatrix * r);
        col = coli[0];
        transparent=0.0;
        EmitVertex();

        vert = end.xyz + direction;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalize(normalMatrix * r);
        col = coli[0];
        transparent=0.0;
        EmitVertex();
    }
    EndPrimitive();
  }

   {
  gl_Position = pmv* vec4(midv[0] , 1);
  Normal = normalize(normalMatrix * norv[0]);
  col = coli[0];
  transparent=2.0;
  EmitVertex();

  gl_Position = pmv* vec4(verts0v[0] , 1);
  Normal = normalize(normalMatrix * norv[0]);
  col = coli[0];
  transparent=2.0;
  EmitVertex();

  gl_Position = pmv* vec4(verts1v[0] , 1);
  Normal = normalize(normalMatrix * norv[0]);
  col = coli[0];
  transparent=2.0;
  EmitVertex();
 }
EndPrimitive();
}
