/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Select.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#define _LIST_SELECT_
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "etc.h"



/* ---------------------------------------------------------
 * Select Data をリストの最後に追加
 *	
 */
int select_list_add_last(SELECT *add_select)
{
	SELECT_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_select_list = (SELECT_LIST *)xmalloc(sizeof(SELECT_LIST));

	/* データ (select) を書き込むための領域を確保する */
	p_select_list->select = (SELECT *)xmalloc(sizeof(SELECT));

	/* 確保した領域にデータ (select) を書き込む */
	*p_select_list->select = *add_select;
	p_select_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (select_list_info.head == NULL && select_list_info.tail == NULL) {
		select_list_info.head = p_select_list;
		select_list_info.tail = p_select_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (select_list_info.head != NULL 
				&& select_list_info.tail != NULL 
					&& select_list_info.head == select_list_info.tail) 
	{
		select_list_info.head->next = p_select_list;
		select_list_info.tail = p_select_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = select_list_info.tail;
		select_list_info.tail = p_select_list;
		p->next = select_list_info.tail;
	}

	return 0;
}



/* ---------------------------------------------------------
 * Select Data をリストの最初に追加
 *	
 */
int select_list_add_first(SELECT *add_select)
{
	SELECT_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_select_list = (SELECT_LIST *)xmalloc(sizeof(SELECT_LIST));

	/* データ (select) を書き込むための領域を確保する */
	p_select_list->select = (SELECT *)xmalloc(sizeof(SELECT));

	/* 確保した領域にデータ (select) を書き込む */
	*p_select_list->select = *add_select;
	p_select_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (select_list_info.head == NULL && select_list_info.tail == NULL) {
		select_list_info.head = p_select_list;
		select_list_info.tail = p_select_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = select_list_info.head;
		select_list_info.head = p_select_list;
		p_select_list->next = p;
	}

	return 0;
}



/* ---------------------------------------------------------
 *	Select Data をリストから削除
 */
int select_list_free(SELECT_LIST *del_List)
{
	SELECT_LIST *p = NULL;
	SELECT_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == select_list_info.head && del_List->next == NULL) {
		select_list_info.head = NULL;
		select_list_info.tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == select_list_info.head && del_List->next != NULL) {
		select_list_info.head = select_list_info.head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = select_list_info.head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
		/* 最後のデータ */
			if (del_List == select_list_info.tail) {
				pb->next = NULL;
				select_list_info.tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != select_list_info.head && del_List != select_list_info.tail) {
				pb->next = p->next;
			}
		}
		/* リストのセレクトデータのではない */
		else {
			// 
			return 0;
		}
	}
	xfree(del_List->select);
	xfree(del_List);
	return 1;
}



/* ---------------------------------------------------------
 * SELECT_LIST のデータの検索
 *	
 * 戻値  long
 */
long select_search_select_to_num(SELECT_LIST *p_select)
{
	SELECT_LIST *p;
	long i;

	i = 1;
	p = select_list_info.head;
	/*	*/
	while( p != NULL && p != p_select) {
		p = p->next;
		i++;
	}

	/* p_select のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}



/* ---------------------------------------------------------
 *	全リストを削除
 */
void select_list_all_free(void)
{
	while (select_list_info.head != NULL) {
		select_list_free(select_list_info.head);
	}
}



/* ---------------------------------------------------------
 *	リストの総数を調べる
 */
long select_list_num(void)
{
	SELECT_LIST *p;
	long i;

	p = select_list_info.head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}



/* ---------------------------------------------------------
 * n 番目のデータの検索
 *	
 */
SELECT_LIST *select_search_num(long search_number)
{
	SELECT_LIST *p;
	long i;

	p = select_list_info.head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* ---------------------------------------------------------
 * セレクトされているＣＡＤデータを検索
 *	
 */
SELECT_LIST *select_search_cad(CAD *cad)
{
	SELECT_LIST *p;

	p = select_list_info.head;
	/*	*/
	while( p != NULL ) {
		if (p->select->index == 2 || p->select->index == 4) {
			if (p->select->diagram_point.cad_point == cad) break;
		}
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}




/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Select.c
 * ====================================================================
 */
