/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "userinfo.h"
#include "globals.h"

#include <assert.h>

#include <QHostAddress>
#include <QCryptographicHash>
#include <QFile>
#include <QDir>
#include <QIcon>

UserInfo* UserInfo::m_myInfo = 0;

UserInfo::UserInfo(const QHostAddress& addr, const QString & nick, int uid) :
  m_enabled          (0),
  m_programVerID     (0),
  m_programVerName   (""),
  m_status           (Globals::FREE),
  m_ip               (addr.toIPv4Address()),
  m_compName         (""),
  m_statusDescription(""),
  m_gender           (0),
  m_nickname         (nick),
  m_avatar           (NULL),
  m_uid              (uid)
{
}

UserInfo::UserInfo(QC_DatagramHeader* hdr) :
  m_enabled          (0),
  m_programVerID     (0),
  m_programVerName   (""),
  m_status           (Globals::FREE),
  m_ip               (hdr->src_ip),
  m_compName         (""),
  m_statusDescription(""),
  m_gender           (0),
  m_nickname         (hdr->name),
  m_avatar           (NULL),
  m_uid              (hdr->src_ip)
{
}


//\*****************************************************************************
UserInfo::~UserInfo()
{
  qDebug("[~UserInfo]\n");
}
//\*****************************************************************************
void UserInfo::setPhoto(const QByteArray & ba)
{
  QCryptographicHash md5_hash(QCryptographicHash::Md5);
  QFile              file;
  QByteArray         hash;

  md5_hash.addData(ba);

  hash = md5_hash.result();

  m_photoFilename = QDir::tempPath() + "/photo_" + m_nickname;

  int len = hash.size();
  for(int i = 0; i < len; i++)
    m_photoFilename.append(QString::number((uchar)hash.at(i), 16));

  file.setFileName(m_photoFilename);

  if(file.open(QIODevice::WriteOnly | QIODevice::Unbuffered))
  {
    file.write(ba);
    file.close();
  }
  else
    qWarning("[UserInfo::setPhoto]: couldn't open '%s'", m_photoFilename.toLocal8Bit().data());
}
//\*****************************************************************************
void UserInfo::setPicture(const QByteArray & ba)
{
  QCryptographicHash md5_hash(QCryptographicHash::Md5);
  QFile              file;
  QByteArray         hash;

  md5_hash.addData(ba);

  hash = md5_hash.result();

  m_pictureFilename = QDir::tempPath() + "/picture_" + m_nickname;

  int len = hash.size();
  for(int i = 0; i < len; i++)
    m_pictureFilename.append(QString::number((uchar)hash.at(i), 16));

  file.setFileName(m_pictureFilename);
  if(file.open(QIODevice::WriteOnly | QIODevice::Unbuffered))
  {
    file.write(ba);
    file.close();
  }
  else
    qWarning("[UserInfo::setPicture]: couldn't open '%s'", m_pictureFilename.toLocal8Bit().data());
}
//\*****************************************************************************
QPixmap* UserInfo::newIcon(uint wd, uint he, bool disabled) const
{
  QPixmap* pix  = NULL;
  QPixmap* icon = new QPixmap(wd, he);

  if(!m_pictureFilename.isEmpty())
    pix = new QPixmap(m_pictureFilename);
  else if(!m_photoFilename.isEmpty())
    pix = new QPixmap(m_photoFilename);

  if(pix)
  {
    if(disabled)
      *icon = QIcon(*pix).pixmap(32, 32, QIcon::Disabled);
    else
      *icon = pix->scaled(wd, he, Qt::KeepAspectRatio, Qt::SmoothTransformation);

    delete pix;

    return icon;
  }

  delete icon;

  return NULL;
}
//\*****************************************************************************
QImage* UserInfo::newIconImg(uint wd, uint he) const
{
  QImage* pix  = NULL;
  QImage* icon = new QImage;

  m_avatarHash.resize(0);

  if(!m_pictureFilename.isEmpty())
  {
    pix = new QImage(m_pictureFilename);
    m_avatarHash = m_pictureHash;
  }
  else if(!m_photoFilename.isEmpty())
  {
    pix = new QImage(m_photoFilename);
    m_avatarHash = m_photoHash;
  }

  if(pix)
  {
    *icon = pix->scaled(wd, he, Qt::KeepAspectRatio, Qt::SmoothTransformation);
    delete pix;

    return icon;
  }

  delete icon;

  return NULL;
}
//\*****************************************************************************
void UserInfo::setPictureOrPhoto(const QString & fname, QString & mmbr_fname, QByteArray & hash)
{
  QFile file;
  QByteArray ba;
  QCryptographicHash md5_hash(QCryptographicHash::Md5);

  if(!fname.isNull())
  {
    mmbr_fname = fname;

    if(fname.isEmpty())
      hash = QByteArray();
    else
    {
      file.setFileName(mmbr_fname);
      if(file.open(QIODevice::ReadOnly))
      {
        ba = file.readAll();
        md5_hash.addData(ba);
        hash = md5_hash.result();
      }
      else
      {
        qWarning("[UserInfo::setPictureOrPhoto]: couldn't open '%s'", mmbr_fname.toLocal8Bit().data());
        hash = QByteArray();
      }
    }
  }

  if(!m_pictureFilename.isEmpty())
    m_avatarHash = m_pictureHash;
  else if(!m_photoFilename.isEmpty())
    m_avatarHash = m_photoHash;
  else
    m_avatarHash.clear();
}
