/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef QCHAT_H
#define QCHAT_H

#include <QObject>
#include <QApplication>

class ChatWgt;
class ChatCore;
struct CmdArgs;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class QChat : public QObject
{
  Q_OBJECT
  private:
    ChatWgt*  m_chat;
    ChatCore* m_core;
    QApplication* m_app;
    QString   m_styleSheet;

  private:
    void unknownOptionMessage(const QString&);
    void helpMessage();
    void welcomeMessage();
    void authorMessage();

    CmdArgs* processCmdArgs(int argc, char* argv[]);

  public:
    QChat(QObject *parent = 0);
    ~QChat();

    void start(int argc, char *argv[], QApplication* app);

  public slots:
    void reloadStyleSheet();
    void setStyleSheet(const QString &);
    void hide2tray();
};

#endif
