#------------------------------------------------------------------------------
# Copyright (c) 2021, 2022, Oracle and/or its affiliates.
#
# This software is dual-licensed to you under the Universal Permissive License
# (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl and Apache License
# 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose
# either license.
#
# If you elect to accept the software under the Apache License, Version 2.0,
# the following applies:
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# data_types.pyx
#
# Cython file defining the data type array sent to the database server during
# connect (embedded in thin_impl.pyx).
#------------------------------------------------------------------------------

ctypedef struct DataType:
    uint16_t data_type
    uint16_t conv_data_type
    uint16_t representation

cdef DataType[312] DATA_TYPES = [
    [TNS_DATA_TYPE_VARCHAR, TNS_DATA_TYPE_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NUMBER, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_LONG, TNS_DATA_TYPE_LONG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DATE, TNS_DATA_TYPE_DATE, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_RAW, TNS_DATA_TYPE_RAW, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LONG_RAW, TNS_DATA_TYPE_LONG_RAW, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB2, TNS_DATA_TYPE_UB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB4, TNS_DATA_TYPE_UB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SB1, TNS_DATA_TYPE_SB1, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SB2, TNS_DATA_TYPE_SB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SB4, TNS_DATA_TYPE_SB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SWORD, TNS_DATA_TYPE_SWORD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UWORD, TNS_DATA_TYPE_UWORD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PTRB, TNS_DATA_TYPE_PTRB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PTRW, TNS_DATA_TYPE_PTRW, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIDDEF, TNS_DATA_TYPE_TIDDEF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ROWID, TNS_DATA_TYPE_ROWID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AMS, TNS_DATA_TYPE_AMS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BRN, TNS_DATA_TYPE_BRN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CWD, TNS_DATA_TYPE_CWD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NEW_OAC, TNS_DATA_TYPE_NEW_OAC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER8, TNS_DATA_TYPE_OER8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FUN, TNS_DATA_TYPE_FUN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AUA, TNS_DATA_TYPE_AUA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH7, TNS_DATA_TYPE_RXH7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NA6, TNS_DATA_TYPE_NA6, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BRP, TNS_DATA_TYPE_BRP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BRV, TNS_DATA_TYPE_BRV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVA, TNS_DATA_TYPE_KVA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CLS, TNS_DATA_TYPE_CLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CUI, TNS_DATA_TYPE_CUI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DFN, TNS_DATA_TYPE_DFN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DQR, TNS_DATA_TYPE_DQR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSC, TNS_DATA_TYPE_DSC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EXE, TNS_DATA_TYPE_EXE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FCH, TNS_DATA_TYPE_FCH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GBV, TNS_DATA_TYPE_GBV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GEM, TNS_DATA_TYPE_GEM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GIV, TNS_DATA_TYPE_GIV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKG, TNS_DATA_TYPE_OKG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_HMI, TNS_DATA_TYPE_HMI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INO, TNS_DATA_TYPE_INO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LNF, TNS_DATA_TYPE_LNF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ONT, TNS_DATA_TYPE_ONT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OPE, TNS_DATA_TYPE_OPE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OSQ, TNS_DATA_TYPE_OSQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SFE, TNS_DATA_TYPE_SFE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SPF, TNS_DATA_TYPE_SPF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VSN, TNS_DATA_TYPE_VSN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UD7, TNS_DATA_TYPE_UD7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSA, TNS_DATA_TYPE_DSA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PIN, TNS_DATA_TYPE_PIN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PFN, TNS_DATA_TYPE_PFN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PPT, TNS_DATA_TYPE_PPT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_STO, TNS_DATA_TYPE_STO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ARC, TNS_DATA_TYPE_ARC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRS, TNS_DATA_TYPE_MRS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRT, TNS_DATA_TYPE_MRT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRG, TNS_DATA_TYPE_MRG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRR, TNS_DATA_TYPE_MRR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRC, TNS_DATA_TYPE_MRC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VER, TNS_DATA_TYPE_VER, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LON2, TNS_DATA_TYPE_LON2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INO2, TNS_DATA_TYPE_INO2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ALL, TNS_DATA_TYPE_ALL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UDB, TNS_DATA_TYPE_UDB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQI, TNS_DATA_TYPE_AQI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ULB, TNS_DATA_TYPE_ULB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ULD, TNS_DATA_TYPE_ULD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SID, TNS_DATA_TYPE_SID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NA7, TNS_DATA_TYPE_NA7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AL7, TNS_DATA_TYPE_AL7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_K2RPC, TNS_DATA_TYPE_K2RPC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XDP, TNS_DATA_TYPE_XDP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKO8, TNS_DATA_TYPE_OKO8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UD12, TNS_DATA_TYPE_UD12, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AL8, TNS_DATA_TYPE_AL8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LFOP, TNS_DATA_TYPE_LFOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FCRT, TNS_DATA_TYPE_FCRT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DNY, TNS_DATA_TYPE_DNY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OPR, TNS_DATA_TYPE_OPR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PLS, TNS_DATA_TYPE_PLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XID, TNS_DATA_TYPE_XID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TXN, TNS_DATA_TYPE_TXN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DCB, TNS_DATA_TYPE_DCB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CCA, TNS_DATA_TYPE_CCA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_WRN, TNS_DATA_TYPE_WRN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TLH, TNS_DATA_TYPE_TLH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TOH, TNS_DATA_TYPE_TOH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FOI, TNS_DATA_TYPE_FOI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SID2, TNS_DATA_TYPE_SID2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TCH, TNS_DATA_TYPE_TCH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PII, TNS_DATA_TYPE_PII, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PFI, TNS_DATA_TYPE_PFI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PPU, TNS_DATA_TYPE_PPU, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PTE, TNS_DATA_TYPE_PTE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH8, TNS_DATA_TYPE_RXH8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_N12, TNS_DATA_TYPE_N12, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AUTH, TNS_DATA_TYPE_AUTH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVAL, TNS_DATA_TYPE_KVAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FGI, TNS_DATA_TYPE_FGI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSY, TNS_DATA_TYPE_DSY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYR8, TNS_DATA_TYPE_DSYR8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYH8, TNS_DATA_TYPE_DSYH8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYL, TNS_DATA_TYPE_DSYL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYT8, TNS_DATA_TYPE_DSYT8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYV8, TNS_DATA_TYPE_DSYV8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYP, TNS_DATA_TYPE_DSYP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYF, TNS_DATA_TYPE_DSYF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYK, TNS_DATA_TYPE_DSYK, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYY, TNS_DATA_TYPE_DSYY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYQ, TNS_DATA_TYPE_DSYQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYC, TNS_DATA_TYPE_DSYC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYA, TNS_DATA_TYPE_DSYA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OT8, TNS_DATA_TYPE_OT8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYTY, TNS_DATA_TYPE_DSYTY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQE, TNS_DATA_TYPE_AQE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KV, TNS_DATA_TYPE_KV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQD, TNS_DATA_TYPE_AQD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQ8, TNS_DATA_TYPE_AQ8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RFS, TNS_DATA_TYPE_RFS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH10, TNS_DATA_TYPE_RXH10, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPN, TNS_DATA_TYPE_KPN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNR, TNS_DATA_TYPE_KPDNR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYD, TNS_DATA_TYPE_DSYD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYS, TNS_DATA_TYPE_DSYS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYR, TNS_DATA_TYPE_DSYR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYH, TNS_DATA_TYPE_DSYH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYT, TNS_DATA_TYPE_DSYT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYV, TNS_DATA_TYPE_DSYV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQM, TNS_DATA_TYPE_AQM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER11, TNS_DATA_TYPE_OER11, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQL, TNS_DATA_TYPE_AQL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OTC, TNS_DATA_TYPE_OTC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KFNO, TNS_DATA_TYPE_KFNO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KFNP, TNS_DATA_TYPE_KFNP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KGT8, TNS_DATA_TYPE_KGT8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RASB4, TNS_DATA_TYPE_RASB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RAUB2, TNS_DATA_TYPE_RAUB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RAUB1, TNS_DATA_TYPE_RAUB1, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RATXT, TNS_DATA_TYPE_RATXT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSSB4, TNS_DATA_TYPE_RSSB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSUB2, TNS_DATA_TYPE_RSUB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSUB1, TNS_DATA_TYPE_RSUB1, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSTXT, TNS_DATA_TYPE_RSTXT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RIDL, TNS_DATA_TYPE_RIDL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GLRDD, TNS_DATA_TYPE_GLRDD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GLRDG, TNS_DATA_TYPE_GLRDG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GLRDC, TNS_DATA_TYPE_GLRDC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKO, TNS_DATA_TYPE_OKO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPP, TNS_DATA_TYPE_DPP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPLS, TNS_DATA_TYPE_DPLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPMOP, TNS_DATA_TYPE_DPMOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_STAT, TNS_DATA_TYPE_STAT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RFX, TNS_DATA_TYPE_RFX, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FAL, TNS_DATA_TYPE_FAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CKV, TNS_DATA_TYPE_CKV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DRCX, TNS_DATA_TYPE_DRCX, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KGH, TNS_DATA_TYPE_KGH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQO, TNS_DATA_TYPE_AQO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKGT, TNS_DATA_TYPE_OKGT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPFC, TNS_DATA_TYPE_KPFC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FE2, TNS_DATA_TYPE_FE2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SPFP, TNS_DATA_TYPE_SPFP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPULS, TNS_DATA_TYPE_DPULS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQA, TNS_DATA_TYPE_AQA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPBF, TNS_DATA_TYPE_KPBF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TSM, TNS_DATA_TYPE_TSM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MSS, TNS_DATA_TYPE_MSS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPC, TNS_DATA_TYPE_KPC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CRS, TNS_DATA_TYPE_CRS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KKS, TNS_DATA_TYPE_KKS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSP, TNS_DATA_TYPE_KSP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSPTOP, TNS_DATA_TYPE_KSPTOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSPVAL, TNS_DATA_TYPE_KSPVAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PSS, TNS_DATA_TYPE_PSS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NLS, TNS_DATA_TYPE_NLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ALS, TNS_DATA_TYPE_ALS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSDEVTVAL, TNS_DATA_TYPE_KSDEVTVAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSDEVTTOP, TNS_DATA_TYPE_KSDEVTTOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPSPP, TNS_DATA_TYPE_KPSPP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KOL, TNS_DATA_TYPE_KOL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LST, TNS_DATA_TYPE_LST, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ACX, TNS_DATA_TYPE_ACX, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCS, TNS_DATA_TYPE_SCS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH, TNS_DATA_TYPE_RXH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNS, TNS_DATA_TYPE_KPDNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDCN, TNS_DATA_TYPE_KPDCN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNNS, TNS_DATA_TYPE_KPNNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNCN, TNS_DATA_TYPE_KPNCN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPS, TNS_DATA_TYPE_KPS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_APINF, TNS_DATA_TYPE_APINF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TEN, TNS_DATA_TYPE_TEN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSCS, TNS_DATA_TYPE_XSSCS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSSO, TNS_DATA_TYPE_XSSSO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSAO, TNS_DATA_TYPE_XSSAO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSRPC, TNS_DATA_TYPE_KSRPC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVL, TNS_DATA_TYPE_KVL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSDEF, TNS_DATA_TYPE_XSSDEF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PDQCINV, TNS_DATA_TYPE_PDQCINV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PDQIDC, TNS_DATA_TYPE_PDQIDC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDQCSTA, TNS_DATA_TYPE_KPDQCSTA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPRS, TNS_DATA_TYPE_KPRS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDQIDC, TNS_DATA_TYPE_KPDQIDC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RTSTRM, TNS_DATA_TYPE_RTSTRM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSGET, TNS_DATA_TYPE_SESSGET, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSREL, TNS_DATA_TYPE_SESSREL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSRET, TNS_DATA_TYPE_SESSRET, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCN6, TNS_DATA_TYPE_SCN6, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KECPA, TNS_DATA_TYPE_KECPA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KECPP, TNS_DATA_TYPE_KECPP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SXA, TNS_DATA_TYPE_SXA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVARR, TNS_DATA_TYPE_KVARR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNGN, TNS_DATA_TYPE_KPNGN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BINARY_INTEGER, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_FLOAT, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_STR, TNS_DATA_TYPE_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VNU, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_PDN, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_VCS, TNS_DATA_TYPE_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VBI, TNS_DATA_TYPE_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OAC, TNS_DATA_TYPE_NEW_OAC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UIN, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_SLS, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_LVC, TNS_DATA_TYPE_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LVB, TNS_DATA_TYPE_RAW, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CHAR, TNS_DATA_TYPE_CHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AVC, TNS_DATA_TYPE_CHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BINARY_FLOAT, TNS_DATA_TYPE_BINARY_FLOAT,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BINARY_DOUBLE, TNS_DATA_TYPE_BINARY_DOUBLE,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CURSOR, TNS_DATA_TYPE_CURSOR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RDD, TNS_DATA_TYPE_ROWID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OSL, TNS_DATA_TYPE_OSL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EXT_NAMED, TNS_DATA_TYPE_INT_NAMED, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INT_NAMED, TNS_DATA_TYPE_INT_NAMED, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EXT_REF, TNS_DATA_TYPE_INT_REF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INT_REF, TNS_DATA_TYPE_INT_REF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CLOB, TNS_DATA_TYPE_CLOB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BLOB, TNS_DATA_TYPE_BLOB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BFILE, TNS_DATA_TYPE_BFILE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CFILE, TNS_DATA_TYPE_CFILE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSET, TNS_DATA_TYPE_CURSOR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_JSON, TNS_DATA_TYPE_JSON, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DJSON, TNS_DATA_TYPE_DJSON, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CLV, TNS_DATA_TYPE_CLV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DTR, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_DUN, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_DOP, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_VST, TNS_DATA_TYPE_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ODT, TNS_DATA_TYPE_DATE, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_DOL, TNS_DATA_TYPE_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_TIME, TNS_DATA_TYPE_TIME, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIME_TZ, TNS_DATA_TYPE_TIME_TZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIMESTAMP, TNS_DATA_TYPE_TIMESTAMP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIMESTAMP_TZ, TNS_DATA_TYPE_TIMESTAMP_TZ,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INTERVAL_YM, TNS_DATA_TYPE_INTERVAL_YM,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INTERVAL_DS, TNS_DATA_TYPE_INTERVAL_DS,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EDATE, TNS_DATA_TYPE_DATE, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_ETIME, TNS_DATA_TYPE_ETIME, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ETTZ, TNS_DATA_TYPE_ETTZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ESTAMP, TNS_DATA_TYPE_ESTAMP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ESTZ, TNS_DATA_TYPE_ESTZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EIYM, TNS_DATA_TYPE_EIYM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EIDS, TNS_DATA_TYPE_EIDS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DCLOB, TNS_DATA_TYPE_CLOB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DBLOB, TNS_DATA_TYPE_BLOB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DBFILE, TNS_DATA_TYPE_BFILE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UROWID, TNS_DATA_TYPE_UROWID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIMESTAMP_LTZ, TNS_DATA_TYPE_TIMESTAMP_LTZ,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ESITZ, TNS_DATA_TYPE_TIMESTAMP_LTZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB8, TNS_DATA_TYPE_UB8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PNTY, TNS_DATA_TYPE_INT_NAMED, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BOOLEAN, TNS_DATA_TYPE_BOOLEAN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNSOP, TNS_DATA_TYPE_XSNSOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSATTR, TNS_DATA_TYPE_XSATTR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNS, TNS_DATA_TYPE_XSNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB1ARRAY, TNS_DATA_TYPE_UB1ARRAY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSSTATE, TNS_DATA_TYPE_SESSSTATE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AC_REPLAY, TNS_DATA_TYPE_AC_REPLAY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AC_CONT, TNS_DATA_TYPE_AC_CONT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_IMPLRES, TNS_DATA_TYPE_IMPLRES, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER, TNS_DATA_TYPE_OER, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TXT, TNS_DATA_TYPE_TXT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSESSNS, TNS_DATA_TYPE_XSSESSNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSATTOP, TNS_DATA_TYPE_XSATTOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSCREOP, TNS_DATA_TYPE_XSCREOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSDETOP, TNS_DATA_TYPE_XSDETOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSDESOP, TNS_DATA_TYPE_XSDESOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSETSP, TNS_DATA_TYPE_XSSETSP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSIDP, TNS_DATA_TYPE_XSSIDP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSPRIN, TNS_DATA_TYPE_XSPRIN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSKVL, TNS_DATA_TYPE_XSKVL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSSDEF2, TNS_DATA_TYPE_XSSSDEF2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNSOP2, TNS_DATA_TYPE_XSNSOP2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNS2, TNS_DATA_TYPE_XSNS2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNREQ, TNS_DATA_TYPE_KPDNREQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRNF, TNS_DATA_TYPE_KPDNRNF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNGNC, TNS_DATA_TYPE_KPNGNC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNRI, TNS_DATA_TYPE_KPNRI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQENQ, TNS_DATA_TYPE_AQENQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQDEQ, TNS_DATA_TYPE_AQDEQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQJMS, TNS_DATA_TYPE_AQJMS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRPAY, TNS_DATA_TYPE_KPDNRPAY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRACK, TNS_DATA_TYPE_KPDNRACK, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRMP, TNS_DATA_TYPE_KPDNRMP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRDQ, TNS_DATA_TYPE_KPDNRDQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCN, TNS_DATA_TYPE_SCN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCN8, TNS_DATA_TYPE_SCN8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CHUNKINFO, TNS_DATA_TYPE_CHUNKINFO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UDS, TNS_DATA_TYPE_UDS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TNP, TNS_DATA_TYPE_TNP, TNS_TYPE_REP_UNIVERSAL],
    [0, 0, 0]
]
