# Generated by Django 3.1.3 on 2021-09-26 11:13

from django.db import migrations, models

import quantityfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="BigIntFieldSaveModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.BigIntegerQuantityField(
                        base_units="gram", unit_choices=["gram"]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChoicesDefinedInModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "weight",
                    quantityfield.fields.QuantityField(
                        base_units="kilogram", unit_choices=["milligram", "pounds"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ChoicesDefinedInModelInt",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "weight",
                    quantityfield.fields.IntegerQuantityField(
                        base_units="kilogram", unit_choices=["milligram", "pounds"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CustomUregDecimalHayBale",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "custom_decimal",
                    quantityfield.fields.DecimalQuantityField(
                        base_units="custom",
                        decimal_places=2,
                        max_digits=10,
                        unit_choices=["custom"],
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CustomUregHayBale",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "custom",
                    quantityfield.fields.QuantityField(
                        base_units="custom", unit_choices=["custom"]
                    ),
                ),
                (
                    "custom_int",
                    quantityfield.fields.IntegerQuantityField(
                        base_units="custom", unit_choices=["custom"]
                    ),
                ),
                (
                    "custom_bigint",
                    quantityfield.fields.BigIntegerQuantityField(
                        base_units="custom", unit_choices=["custom"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="DecimalFieldSaveModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.DecimalQuantityField(
                        base_units="gram",
                        decimal_places=2,
                        max_digits=10,
                        unit_choices=["gram"],
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="EmptyHayBaleBigInt",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.BigIntegerQuantityField(
                        base_units="gram", null=True, unit_choices=["gram"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EmptyHayBaleDecimal",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.DecimalQuantityField(
                        base_units="gram",
                        decimal_places=2,
                        max_digits=10,
                        null=True,
                        unit_choices=["gram"],
                    ),
                ),
                (
                    "compare",
                    models.DecimalField(decimal_places=2, max_digits=10, null=True),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EmptyHayBaleFloat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.QuantityField(
                        base_units="gram", null=True, unit_choices=["gram"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EmptyHayBaleInt",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.IntegerQuantityField(
                        base_units="gram", null=True, unit_choices=["gram"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FloatFieldSaveModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.QuantityField(
                        base_units="gram", unit_choices=["gram"]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="HayBale",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.QuantityField(
                        base_units="gram", unit_choices=["gram"]
                    ),
                ),
                (
                    "weight_int",
                    quantityfield.fields.IntegerQuantityField(
                        base_units="gram", blank=True, null=True, unit_choices=["gram"]
                    ),
                ),
                (
                    "weight_bigint",
                    quantityfield.fields.BigIntegerQuantityField(
                        base_units="gram", blank=True, null=True, unit_choices=["gram"]
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="IntFieldSaveModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                (
                    "weight",
                    quantityfield.fields.IntegerQuantityField(
                        base_units="gram", unit_choices=["gram"]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
