# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class QueryAggregation(Model):
    """The aggregation expression to be used in the query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column to aggregate.
    :type name: str
    :ivar function: Required. The name of the aggregation function to use.
     Default value: "Sum" .
    :vartype function: str
    """

    _validation = {
        'name': {'required': True},
        'function': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'function': {'key': 'function', 'type': 'str'},
    }

    function = "Sum"

    def __init__(self, *, name: str, **kwargs) -> None:
        super(QueryAggregation, self).__init__(**kwargs)
        self.name = name
