import logging
log = logging.getLogger('root')

def toStr(s):
	return str(s, 'utf8') if isinstance(s, bytes) else str(s)

html_entity2str = {
	"ldash": "–",
	"acirc": "â",
	"ecirc": "ê",
	"icirc": "î",
	"ocirc": "ô",
	"ucirc": "û",
	"ycirc": "ŷ",
	"uring": "ů",
	"wring": "ẘ",
	"yring": "ẙ",
	"agrave": "à",
	"egrave": "è",
	"igrave": "ì",
	"ograve": "ò",
	"ugrave": "ù",
	"ygrave": "ỳ",
	"atilde": "ã",
	"etilde": "ẽ",
	"itilde": "ĩ",
	"otilde": "õ",
	"utilde": "ũ",
	"ytilde": "ỹ",
	"auml": "ӓ",
	"euml": "ë",
	"iuml": "ï",
	"ouml": "ö",
	"uuml": "ü",
	"yuml": "ÿ",
	"ccedil": "ç",
	"aelig": "æ",
	"eth": "ð",
	"pound": "£",
	"deg": "°",
	"divide": "÷",
	"frac12": "½",
	"frac13": "⅓",
	"frac14": "¼",
	"frac23": "⅔",
	"frac34": "¾",
	"xfrac13": "⅓",
	"hearts": "♥",
	"diams": "♦",
	"spades": "♠",
	"clubs": "♣"
}

# Use build_name2codepoint_dict function to update this dictionary
name2codepoint = {
	"aring": 0x00c5,  # Å
	"gt": 0x003e,  # >
	"sup": 0x2283,  # ⊃
	"ge": 0x2265,  # ≥
	"upsih": 0x03d2,  # ϒ
	"asymp": 0x2248,  # ≈
	"radic": 0x221a,  # √
	"otimes": 0x2297,  # ⊗
	"aelig": 0x00c6,  # Æ
	"sigmaf": 0x03c2,  # ς
	"lrm": 0x200e,  # ‎
	"cedil": 0x00b8,  # ¸
	"kappa": 0x03ba,  # κ
	"wring": 0x1e98,  # ẘ
	"prime": 0x2032,  # ′
	"lceil": 0x2308,  # ⌈
	"iquest": 0x00bf,  # ¿
	"shy": 0x00ad,  # ­
	"sdot": 0x22c5,  # ⋅
	"lfloor": 0x230a,  # ⌊
	"brvbar": 0x00a6,  # ¦
	"egrave": 0x00c8,  # È
	"sub": 0x2282,  # ⊂
	"iexcl": 0x00a1,  # ¡
	"ordf": 0x00aa,  # ª
	"sum": 0x2211,  # ∑
	"ntilde": 0x00f1,  # ñ
	"atilde": 0x00e3,  # ã
	"theta": 0x03b8,  # θ
	"equiv": 0x2261,  # ≡
	"nsub": 0x2284,  # ⊄
	"omicron": 0x039f,  # Ο
	"yuml": 0x0178,  # Ÿ
	"thinsp": 0x2009,  #  
	"ecirc": 0x00ca,  # Ê
	"bdquo": 0x201e,  # „
	"frac23": 0x2154,  # ⅔
	"emsp": 0x2003,  #  
	"permil": 0x2030,  # ‰
	"eta": 0x0397,  # Η
	"forall": 0x2200,  # ∀
	"eth": 0x00d0,  # Ð
	"rceil": 0x2309,  # ⌉
	"ldash": 0x2013,  # –
	"divide": 0x00f7,  # ÷
	"igrave": 0x00cc,  # Ì
	"pound": 0x00a3,  # £
	"frasl": 0x2044,  # ⁄
	"zeta": 0x03b6,  # ζ
	"lowast": 0x2217,  # ∗
	"chi": 0x03a7,  # Χ
	"cent": 0x00a2,  # ¢
	"perp": 0x22a5,  # ⊥
	"there4": 0x2234,  # ∴
	"pi": 0x03c0,  # π
	"empty": 0x2205,  # ∅
	"euml": 0x00cb,  # Ë
	"notin": 0x2209,  # ∉
	"uuml": 0x00fc,  # ü
	"icirc": 0x00ee,  # î
	"bull": 0x2022,  # •
	"upsilon": 0x03a5,  # Υ
	"ensp": 0x2002,  #  
	"ccedil": 0x00c7,  # Ç
	"cap": 0x2229,  # ∩
	"mu": 0x03bc,  # μ
	"deg": 0x00b0,  # °
	"tau": 0x03c4,  # τ
	"nabla": 0x2207,  # ∇
	"ucirc": 0x00db,  # Û
	"ugrave": 0x00f9,  # ù
	"cong": 0x2245,  # ≅
	"quot": 0x0022,  # "
	"uacute": 0x00da,  # Ú
	"acirc": 0x00c2,  # Â
	"sim": 0x223c,  # ∼
	"phi": 0x03a6,  # Φ
	"diams": 0x2666,  # ♦
	"minus": 0x2212,  # −
	"euro": 0x20ac,  # €
	"thetasym": 0x03d1,  # ϑ
	"iuml": 0x00cf,  # Ï
	"sect": 0x00a7,  # §
	"ldquo": 0x201c,  # “
	"hearts": 0x2665,  # ♥
	"oacute": 0x00f3,  # ó
	"zwnj": 0x200c,  # ‌
	"yen": 0x00a5,  # ¥
	"ograve": 0x00d2,  # Ò
	"uring": 0x016f,  # ů
	"trade": 0x2122,  # ™
	"nbsp": 0x00a0,  #  
	"tilde": 0x02dc,  # ˜
	"itilde": 0x0129,  # ĩ
	"oelig": 0x0153,  # œ
	"xfrac13": 0x2153,  # ⅓
	"le": 0x2264,  # ≤
	"auml": 0x00e4,  # ä
	"cup": 0x222a,  # ∪
	"otilde": 0x00f5,  # õ
	"lt": 0x003c,  # <
	"ndash": 0x2013,  # –
	"sbquo": 0x201a,  # ‚
	"real": 0x211c,  # ℜ
	"psi": 0x03c8,  # ψ
	"rsaquo": 0x203a,  # ›
	"darr": 0x2193,  # ↓
	"not": 0x00ac,  # ¬
	"amp": 0x0026,  # &
	"oslash": 0x00f8,  # ø
	"acute": 0x00b4,  # ´
	"zwj": 0x200d,  # ‍
	"alefsym": 0x2135,  # ℵ
	"sup3": 0x00b3,  # ³
	"rdquo": 0x201d,  # ”
	"laquo": 0x00ab,  # «
	"micro": 0x00b5,  # µ
	"ygrave": 0x1ef3,  # ỳ
	"szlig": 0x00df,  # ß
	"clubs": 0x2663,  # ♣
	"agrave": 0x00e0,  # à
	"harr": 0x2194,  # ↔
	"frac14": 0x00bc,  # ¼
	"frac13": 0x2153,  # ⅓
	"frac12": 0x00bd,  # ½
	"utilde": 0x0169,  # ũ
	"prop": 0x221d,  # ∝
	"circ": 0x02c6,  # ˆ
	"ocirc": 0x00f4,  # ô
	"uml": 0x00a8,  # ¨
	"prod": 0x220f,  # ∏
	"reg": 0x00ae,  # ®
	"rlm": 0x200f,  # ‏
	"ycirc": 0x0177,  # ŷ
	"infin": 0x221e,  # ∞
	"etilde": 0x1ebd,  # ẽ
	"mdash": 0x2014,  # —
	"uarr": 0x21d1,  # ⇑
	"times": 0x00d7,  # ×
	"rarr": 0x21d2,  # ⇒
	"yring": 0x1e99,  # ẙ
	"or": 0x2228,  # ∨
	"gamma": 0x03b3,  # γ
	"lambda": 0x03bb,  # λ
	"rang": 0x232a,  # 〉
	"xi": 0x039e,  # Ξ
	"dagger": 0x2021,  # ‡
	"image": 0x2111,  # ℑ
	"hellip": 0x2026,  # …
	"sube": 0x2286,  # ⊆
	"alpha": 0x03b1,  # α
	"plusmn": 0x00b1,  # ±
	"sup1": 0x00b9,  # ¹
	"sup2": 0x00b2,  # ²
	"frac34": 0x00be,  # ¾
	"oline": 0x203e,  # ‾
	"loz": 0x25ca,  # ◊
	"iota": 0x03b9,  # ι
	"iacute": 0x00cd,  # Í
	"para": 0x00b6,  # ¶
	"ordm": 0x00ba,  # º
	"epsilon": 0x03b5,  # ε
	"weierp": 0x2118,  # ℘
	"part": 0x2202,  # ∂
	"delta": 0x03b4,  # δ
	"copy": 0x00a9,  # ©
	"scaron": 0x0161,  # š
	"lsquo": 0x2018,  # ‘
	"isin": 0x2208,  # ∈
	"supe": 0x2287,  # ⊇
	"and": 0x2227,  # ∧
	"ang": 0x2220,  # ∠
	"curren": 0x00a4,  # ¤
	"int": 0x222b,  # ∫
	"rfloor": 0x230b,  # ⌋
	"crarr": 0x21b5,  # ↵
	"exist": 0x2203,  # ∃
	"oplus": 0x2295,  # ⊕
	"piv": 0x03d6,  # ϖ
	"ni": 0x220b,  # ∋
	"ne": 0x2260,  # ≠
	"lsaquo": 0x2039,  # ‹
	"yacute": 0x00fd,  # ý
	"nu": 0x03bd,  # ν
	"macr": 0x00af,  # ¯
	"larr": 0x2190,  # ←
	"aacute": 0x00e1,  # á
	"beta": 0x03b2,  # β
	"fnof": 0x0192,  # ƒ
	"rho": 0x03c1,  # ρ
	"eacute": 0x00e9,  # é
	"omega": 0x03c9,  # ω
	"middot": 0x00b7,  # ·
	"lang": 0x2329,  # 〈
	"spades": 0x2660,  # ♠
	"rsquo": 0x2019,  # ’
	"thorn": 0x00fe,  # þ
	"ouml": 0x00f6,  # ö
	"raquo": 0x00bb,  # »
	"sigma": 0x03c3,  # σ
	"ytilde": 0x1ef9,  # ỹ
}


def build_name2codepoint_dict():
	"""
		Builds name to codepoint dictionary
		copy and paste the output to the name2codepoint dictionary
		name2str - name to utf-8 string dictionary
	"""
	import html.entities
	name2str = html_entity2str
	for k, v in html.entities.name2codepoint.items():
		name2str[k.lower()] = chr(v).encode("utf-8")
	for key in sorted(name2str.keys()):
		value = toStr(name2str[key])
		if len(value) > 1:
			raise ValueError("value = %r" % value)
		log.info("    \"{0}\": 0x{1:0>4x},  # {2}".format(
			key,
			ord(value),
			value,
		))


if __name__ == "__main__":
	build_name2codepoint_dict()
