//
// TextEncodingTest.cpp
//
// $Id: //poco/1.3/Foundation/testsuite/src/TextEncodingTest.cpp#1 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "TextEncodingTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/TextEncoding.h"
#include "Poco/Latin1Encoding.h"


using Poco::TextEncoding;
using Poco::Latin1Encoding;


TextEncodingTest::TextEncodingTest(const std::string& name): CppUnit::TestCase(name)
{
}


TextEncodingTest::~TextEncodingTest()
{
}


void TextEncodingTest::testTextEncoding()
{
	TextEncoding& utf8 = TextEncoding::byName("utf8");
	assert (std::string("UTF-8") == utf8.canonicalName());
	
	TextEncoding& latin1 = TextEncoding::byName("latin1");
	assert (std::string("ISO-8859-1") == latin1.canonicalName());
	
	TextEncoding& glob = TextEncoding::global();
	assert (std::string("UTF-8") == glob.canonicalName());
	
	TextEncoding::global(new Latin1Encoding);

	TextEncoding& glob2 = TextEncoding::global();
	assert (std::string("ISO-8859-1") == glob2.canonicalName());
}


void TextEncodingTest::setUp()
{
}


void TextEncodingTest::tearDown()
{
}


CppUnit::Test* TextEncodingTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("TextEncodingTest");

	CppUnit_addTest(pSuite, TextEncodingTest, testTextEncoding);

	return pSuite;
}
