#ifndef ECA_USBCOMM_H
#define ECA_USBCOMM_H

#include "BaseCommunication.h"

#define IOCTL_CCID_INT        0x80722216L
#define IOCTL_CCID_ABORT      0x80722218L

typedef struct _USB_DEVICE_T {
   WORD length;
   WORD USBVersion;
   WORD DeviceClass;
   WORD DeviceSubClass;
   WORD DeviceProtocol;
   WORD MaxPacketSize0;
   WORD VendorId;
   WORD ProductId;
   WORD DeviceVersion;
   WORD NumConfigurations;
   WORD ManufacturerLength;
   WORD ManufacturerOffs;
   WORD ProductLength;
   WORD ProductOffs;
   WORD SerialLength;
   WORD SerialOffs;
}USB_DEVICE_T;


class CUSBCommunication :
	public CBaseCommunication
{
public:
	CUSBCommunication(const char *cDeviceName,CReader *Owner);
	virtual int Write(void *Message,uint32_t len);
	virtual int Read(void *Response,uint32_t *ResponseLen);
	virtual CBaseReader *BuildReaderObject(); 
	virtual void SetCommunicationString(cj_ReaderInfo *ReaderInfo);
	virtual bool IsConnected();


	virtual int Open();
	virtual void Close();


public:
	virtual ~CUSBCommunication(void);
	virtual bool SetupDeviceInfo();

	USB_DEVICE_T *m_pDriverInfo;

private:
	DWORD IntPipeThreadRoutine();

	virtual int StartInterruptPipe();
	virtual int HaltInterruptPipe();
	static DWORD __stdcall _IntPipeThreadRoutine(LPVOID ptr);
	void _Close();
private:
	HANDLE m_hDevice;
	OVERLAPPED m_olTransmit;
	OVERLAPPED m_olReceive;
	uint8_t *m_pSBuffer;
	uint32_t m_nSBufferLen;
	HANDLE m_IntPipeThread;
	bool m_bFirstReceive;
	DWORD m_dwWriteTimeout;


};

#endif
