/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <QueryOverTimeAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for QueryOverTimeAttributes::TimeType
//

static const char *TimeType_strings[] = {
"Cycle", "DTime", "Timestep"
};

std::string
QueryOverTimeAttributes::TimeType_ToString(QueryOverTimeAttributes::TimeType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return TimeType_strings[index];
}

std::string
QueryOverTimeAttributes::TimeType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return TimeType_strings[index];
}

bool
QueryOverTimeAttributes::TimeType_FromString(const std::string &s, QueryOverTimeAttributes::TimeType &val)
{
    val = QueryOverTimeAttributes::Cycle;
    for(int i = 0; i < 3; ++i)
    {
        if(s == TimeType_strings[i])
        {
            val = (TimeType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Init utility for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void QueryOverTimeAttributes::Init()
{
    timeType = Cycle;
    startTimeFlag = false;
    startTime = 0;
    endTimeFlag = false;
    endTime = 1;
    strideFlag = false;
    stride = 1;
    createWindow = true;
    windowId = 2;

    QueryOverTimeAttributes::SelectAll();
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Copy utility for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void QueryOverTimeAttributes::Copy(const QueryOverTimeAttributes &obj)
{
    timeType = obj.timeType;
    startTimeFlag = obj.startTimeFlag;
    startTime = obj.startTime;
    endTimeFlag = obj.endTimeFlag;
    endTime = obj.endTime;
    strideFlag = obj.strideFlag;
    stride = obj.stride;
    createWindow = obj.createWindow;
    windowId = obj.windowId;
    queryAtts = obj.queryAtts;
    pickAtts = obj.pickAtts;

    QueryOverTimeAttributes::SelectAll();
}

// Type map format string
const char *QueryOverTimeAttributes::TypeMapFormatString = QUERYOVERTIMEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t QueryOverTimeAttributes::TmfsStruct = {QUERYOVERTIMEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Default constructor for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::QueryOverTimeAttributes() : 
    AttributeSubject(QueryOverTimeAttributes::TypeMapFormatString)
{
    QueryOverTimeAttributes::Init();
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Constructor for the derived classes of QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::QueryOverTimeAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    QueryOverTimeAttributes::Init();
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Copy constructor for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::QueryOverTimeAttributes(const QueryOverTimeAttributes &obj) : 
    AttributeSubject(QueryOverTimeAttributes::TypeMapFormatString)
{
    QueryOverTimeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::QueryOverTimeAttributes(const QueryOverTimeAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    QueryOverTimeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::~QueryOverTimeAttributes
//
// Purpose: 
//   Destructor for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::~QueryOverTimeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes& 
QueryOverTimeAttributes::operator = (const QueryOverTimeAttributes &obj)
{
    if (this == &obj) return *this;

    QueryOverTimeAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::operator == (const QueryOverTimeAttributes &obj) const
{
    // Create the return value
    return ((timeType == obj.timeType) &&
            (startTimeFlag == obj.startTimeFlag) &&
            (startTime == obj.startTime) &&
            (endTimeFlag == obj.endTimeFlag) &&
            (endTime == obj.endTime) &&
            (strideFlag == obj.strideFlag) &&
            (stride == obj.stride) &&
            (createWindow == obj.createWindow) &&
            (windowId == obj.windowId) &&
            (queryAtts == obj.queryAtts) &&
            (pickAtts == obj.pickAtts));
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::operator != (const QueryOverTimeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::TypeName
//
// Purpose: 
//   Type name method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
QueryOverTimeAttributes::TypeName() const
{
    return "QueryOverTimeAttributes";
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const QueryOverTimeAttributes *tmp = (const QueryOverTimeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryOverTimeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new QueryOverTimeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryOverTimeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new QueryOverTimeAttributes(*this);
    else
        retval = new QueryOverTimeAttributes;

    return retval;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QueryOverTimeAttributes::SelectAll()
{
    Select(ID_timeType,      (void *)&timeType);
    Select(ID_startTimeFlag, (void *)&startTimeFlag);
    Select(ID_startTime,     (void *)&startTime);
    Select(ID_endTimeFlag,   (void *)&endTimeFlag);
    Select(ID_endTime,       (void *)&endTime);
    Select(ID_strideFlag,    (void *)&strideFlag);
    Select(ID_stride,        (void *)&stride);
    Select(ID_createWindow,  (void *)&createWindow);
    Select(ID_windowId,      (void *)&windowId);
    Select(ID_queryAtts,     (void *)&queryAtts);
    Select(ID_pickAtts,      (void *)&pickAtts);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryOverTimeAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be 
//   saved to a config file.
//
// Programmer: Kathleen Bonnell 
// Creation:   May 26, 2004
//
// Modifications:
//   Brad Whitlock, Fri Dec 14 15:59:43 PST 2007
//   Made it use ids.
//
// ****************************************************************************

bool
QueryOverTimeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    QueryOverTimeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for QueryOverTimeAttributes.
    DataNode *node = new DataNode("QueryOverTimeAttributes");

    if(completeSave || !FieldsEqual(ID_timeType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeType", TimeType_ToString(timeType)));
    }

    if(completeSave || !FieldsEqual(ID_startTimeFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startTimeFlag", startTimeFlag));
    }

    if(completeSave || !FieldsEqual(ID_startTime, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startTime", startTime));
    }

    if(completeSave || !FieldsEqual(ID_endTimeFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endTimeFlag", endTimeFlag));
    }

    if(completeSave || !FieldsEqual(ID_endTime, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endTime", endTime));
    }

    if(completeSave || !FieldsEqual(ID_stride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(ID_createWindow, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("createWindow", createWindow));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowId", windowId));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: QueryOverTimeAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode 
//   representation of the object.
//
// Programmer: Kathleen Bonnell 
// Creation:   May 26, 2004
//
// Modifications:
//   
// ****************************************************************************

void
QueryOverTimeAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("QueryOverTimeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("timeType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetTimeType(TimeType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TimeType value;
            if(TimeType_FromString(node->AsString(), value))
                SetTimeType(value);
        }
    }
    if((node = searchNode->GetNode("startTimeFlag")) != 0)
        SetStartTimeFlag(node->AsBool());
    if((node = searchNode->GetNode("startTime")) != 0)
        SetStartTime(node->AsInt());
    if((node = searchNode->GetNode("endTimeFlag")) != 0)
        SetEndTimeFlag(node->AsBool());
    if((node = searchNode->GetNode("endTime")) != 0)
        SetEndTime(node->AsInt());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("createWindow")) != 0)
        SetCreateWindow(node->AsBool());
    if((node = searchNode->GetNode("windowId")) != 0)
        SetWindowId(node->AsInt());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryOverTimeAttributes::SetTimeType(QueryOverTimeAttributes::TimeType timeType_)
{
    timeType = timeType_;
    Select(ID_timeType, (void *)&timeType);
}

void
QueryOverTimeAttributes::SetStartTimeFlag(bool startTimeFlag_)
{
    startTimeFlag = startTimeFlag_;
    Select(ID_startTimeFlag, (void *)&startTimeFlag);
}

void
QueryOverTimeAttributes::SetStartTime(int startTime_)
{
    startTime = startTime_;
    Select(ID_startTime, (void *)&startTime);
}

void
QueryOverTimeAttributes::SetEndTimeFlag(bool endTimeFlag_)
{
    endTimeFlag = endTimeFlag_;
    Select(ID_endTimeFlag, (void *)&endTimeFlag);
}

void
QueryOverTimeAttributes::SetEndTime(int endTime_)
{
    endTime = endTime_;
    Select(ID_endTime, (void *)&endTime);
}

void
QueryOverTimeAttributes::SetStrideFlag(bool strideFlag_)
{
    strideFlag = strideFlag_;
    Select(ID_strideFlag, (void *)&strideFlag);
}

void
QueryOverTimeAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(ID_stride, (void *)&stride);
}

void
QueryOverTimeAttributes::SetCreateWindow(bool createWindow_)
{
    createWindow = createWindow_;
    Select(ID_createWindow, (void *)&createWindow);
}

void
QueryOverTimeAttributes::SetWindowId(int windowId_)
{
    windowId = windowId_;
    Select(ID_windowId, (void *)&windowId);
}

void
QueryOverTimeAttributes::SetQueryAtts(const QueryAttributes &queryAtts_)
{
    queryAtts = queryAtts_;
    Select(ID_queryAtts, (void *)&queryAtts);
}

void
QueryOverTimeAttributes::SetPickAtts(const PickAttributes &pickAtts_)
{
    pickAtts = pickAtts_;
    Select(ID_pickAtts, (void *)&pickAtts);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

QueryOverTimeAttributes::TimeType
QueryOverTimeAttributes::GetTimeType() const
{
    return TimeType(timeType);
}

bool
QueryOverTimeAttributes::GetStartTimeFlag() const
{
    return startTimeFlag;
}

int
QueryOverTimeAttributes::GetStartTime() const
{
    return startTime;
}

bool
QueryOverTimeAttributes::GetEndTimeFlag() const
{
    return endTimeFlag;
}

int
QueryOverTimeAttributes::GetEndTime() const
{
    return endTime;
}

bool
QueryOverTimeAttributes::GetStrideFlag() const
{
    return strideFlag;
}

int
QueryOverTimeAttributes::GetStride() const
{
    return stride;
}

bool
QueryOverTimeAttributes::GetCreateWindow() const
{
    return createWindow;
}

int
QueryOverTimeAttributes::GetWindowId() const
{
    return windowId;
}

const QueryAttributes &
QueryOverTimeAttributes::GetQueryAtts() const
{
    return queryAtts;
}

QueryAttributes &
QueryOverTimeAttributes::GetQueryAtts()
{
    return queryAtts;
}

const PickAttributes &
QueryOverTimeAttributes::GetPickAtts() const
{
    return pickAtts;
}

PickAttributes &
QueryOverTimeAttributes::GetPickAtts()
{
    return pickAtts;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryOverTimeAttributes::SelectQueryAtts()
{
    Select(ID_queryAtts, (void *)&queryAtts);
}

void
QueryOverTimeAttributes::SelectPickAtts()
{
    Select(ID_pickAtts, (void *)&pickAtts);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryOverTimeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryOverTimeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_timeType:      return "timeType";
    case ID_startTimeFlag: return "startTimeFlag";
    case ID_startTime:     return "startTime";
    case ID_endTimeFlag:   return "endTimeFlag";
    case ID_endTime:       return "endTime";
    case ID_strideFlag:    return "strideFlag";
    case ID_stride:        return "stride";
    case ID_createWindow:  return "createWindow";
    case ID_windowId:      return "windowId";
    case ID_queryAtts:     return "queryAtts";
    case ID_pickAtts:      return "pickAtts";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
QueryOverTimeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_timeType:      return FieldType_enum;
    case ID_startTimeFlag: return FieldType_bool;
    case ID_startTime:     return FieldType_int;
    case ID_endTimeFlag:   return FieldType_bool;
    case ID_endTime:       return FieldType_int;
    case ID_strideFlag:    return FieldType_bool;
    case ID_stride:        return FieldType_int;
    case ID_createWindow:  return FieldType_bool;
    case ID_windowId:      return FieldType_int;
    case ID_queryAtts:     return FieldType_att;
    case ID_pickAtts:      return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryOverTimeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_timeType:      return "enum";
    case ID_startTimeFlag: return "bool";
    case ID_startTime:     return "int";
    case ID_endTimeFlag:   return "bool";
    case ID_endTime:       return "int";
    case ID_strideFlag:    return "bool";
    case ID_stride:        return "int";
    case ID_createWindow:  return "bool";
    case ID_windowId:      return "int";
    case ID_queryAtts:     return "att";
    case ID_pickAtts:      return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const QueryOverTimeAttributes &obj = *((const QueryOverTimeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_timeType:
        {  // new scope
        retval = (timeType == obj.timeType);
        }
        break;
    case ID_startTimeFlag:
        {  // new scope
        retval = (startTimeFlag == obj.startTimeFlag);
        }
        break;
    case ID_startTime:
        {  // new scope
        retval = (startTime == obj.startTime);
        }
        break;
    case ID_endTimeFlag:
        {  // new scope
        retval = (endTimeFlag == obj.endTimeFlag);
        }
        break;
    case ID_endTime:
        {  // new scope
        retval = (endTime == obj.endTime);
        }
        break;
    case ID_strideFlag:
        {  // new scope
        retval = (strideFlag == obj.strideFlag);
        }
        break;
    case ID_stride:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case ID_createWindow:
        {  // new scope
        retval = (createWindow == obj.createWindow);
        }
        break;
    case ID_windowId:
        {  // new scope
        retval = (windowId == obj.windowId);
        }
        break;
    case ID_queryAtts:
        {  // new scope
        retval = (queryAtts == obj.queryAtts);
        }
        break;
    case ID_pickAtts:
        {  // new scope
        retval = (pickAtts == obj.pickAtts);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

