/**
 * Copyright (C) 2008-2009 Felipe Contreras.
 * Copyright (C) 1998-2006 Pidgin (see pidgin-copyright)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MSN_COMMAND_PRIVATE_H
#define MSN_COMMAND_PRIVATE_H

#include <glib.h>

#include "command.h"
#include "transaction.h"

struct MsnCommand
{
    MsnTransaction *trans;
    guint tr_id;

    gchar *base;
    gchar **params;
    guint param_count;

    gchar *payload;
    gsize payload_len;

    MsnPayloadCb payload_cb;
};

#endif /* MSN_COMMAND_PRIVATE_H */
