// Copyright (c) 2011, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

/// A Container for a log and a verbosity level.

class Script
implements ILog
{
	public function new()
	{
		verbosity = 0;
		logFile = null;
	}

	public function setLogFile( logFileName : String )
	{
		#if debug
		if( logFile != null ) throw "logFile already set!?";
		#end
		logFile = neko.io.File.write( logFileName, false );		
	}
	
	// Implements ILog.
	public function log( line : String )
	{
		if( logFile != null ) logFile.writeString( line + "\n" );
	}

	// Implements ILog.
	public function error( line : String )
	{
		Util.writeError( line );
	}

	// Implements ILog.
	public var verbosity : Int;

	// Implements ILog.
	public function info( level : Int, line : String )
	{
		if( verbosity >= level ) Util.writeInfo( line );
	}

	// Implements ILog.
	public function infos( level : Int, lines : Iterable<String> )
	{
		if( verbosity >= level ) Lambda.iter( lines, Util.writeInfo );
	}

	var logFile : neko.io.FileOutput;
}
