/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */

// Google Tests
#include <gtest/gtest.h>

// Standard Library
#include <string>

// Media Scanner
#include "mediascanner/locale.h"
#include "mediascanner/logging.h"

// Test Suite
#include "testlib/loggingsink.h"
#include "testlib/testutils.h"

namespace mediascanner {

TEST(LocaleTest, FromUnicodeWithoutSetup) {
    LoggingSink sink;

    std::locale::global(std::locale::classic());
    ASSERT_TRUE(logging::warning()->enabled());
    EXPECT_TRUE(sink.get().empty());

    ASSERT_EQ(std::string("Wide String"), FromUnicode(L"Wide String"));
    EXPECT_FALSE(sink.take().empty());
    EXPECT_TRUE(sink.get().empty());
}

TEST(LocaleTest, ToUnicodeWithoutSetup) {
    LoggingSink sink;

    std::locale::global(std::locale::classic());
    ASSERT_TRUE(logging::warning()->enabled());
    EXPECT_TRUE(sink.get().empty());

    ASSERT_EQ(std::wstring(L"String"), ToUnicode("String"));
    EXPECT_FALSE(sink.take().empty());
    EXPECT_TRUE(sink.get().empty());
}

} // namespace mediascanner

int main(int argc, char *argv[]) {
    mediascanner::InitTests(&argc, argv);
    return RUN_ALL_TESTS();
}
