# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class ExtractHistogram(TableAlgorithm):
    r"""
    ExtractHistogram - Extract histogram data (binned values) from any
    dataset
    
    Superclass: TableAlgorithm
    
    ExtractHistogram accepts any DataSet as input and produces a
    Table containing histogram data as output.  The output Table
    will contains a DoubleArray named "bin_extents" which contains the
    boundaries between each histogram bin, and a UnsignedLongArray
    named "bin_values" which will contain the value for each bin.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractHistogram, obj, update, **traits)
    
    accumulation = tvtk_base.false_bool_trait(desc=\
        r"""
        If this option is set to true then the output table will contain
        an additional column with accumulated bin values. Default is
        false.
        """
    )

    def _accumulation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAccumulation,
                        self.accumulation_)

    calculate_averages = tvtk_base.false_bool_trait(desc=\
        r"""
        This option controls whether the algorithm calculates averages of
        variables other than the primary variable that fall into each
        bin. Default is false.
        """
    )

    def _calculate_averages_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCalculateAverages,
                        self.calculate_averages_)

    center_bins_around_min_and_max = tvtk_base.false_bool_trait(desc=\
        r"""
        Get/Set if first and last bins must be centered around the min
        and max data. This is only used when use_custom_bin_ranges is set to
        false. Default is false.
        """
    )

    def _center_bins_around_min_and_max_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCenterBinsAroundMinAndMax,
                        self.center_bins_around_min_and_max_)

    normalize = tvtk_base.false_bool_trait(desc=\
        r"""
        If this option is set then the bin values will be normalized so
        that the sum of the bin values adds up to 1.0. Default is false.
        """
    )

    def _normalize_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalize,
                        self.normalize_)

    use_custom_bin_ranges = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true, custom_bin_ranges will  be used instead of using
        the full range for the selected array. Default is false.
        """
    )

    def _use_custom_bin_ranges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseCustomBinRanges,
                        self.use_custom_bin_ranges_)

    bin_accumulation_array_name = traits.String('bin_accumulation', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the name of the optional bin accumulation array. Default
        is "bin_accumulation".
        """
    )

    def _bin_accumulation_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBinAccumulationArrayName,
                        self.bin_accumulation_array_name)

    bin_count = traits.Trait(10, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Controls the number of bins N in the output histogram data.
        Default is 10.
        """
    )

    def _bin_count_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBinCount,
                        self.bin_count)

    bin_extents_array_name = traits.String('bin_extents', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the name of the bin extents array. Default is
        "bin_extents".
        """
    )

    def _bin_extents_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBinExtentsArrayName,
                        self.bin_extents_array_name)

    bin_values_array_name = traits.String('bin_values', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the name of the bin values array. Default is
        "bin_values".
        """
    )

    def _bin_values_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBinValuesArrayName,
                        self.bin_values_array_name)

    component = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Controls which input data component should be binned, for input
        arrays with more-than-one component.  Setting this to the number
        of components will compute the histogram of the magnitude (L2
        norm) of the tuple. Default is 0.
        """
    )

    def _component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComponent,
                        self.component)

    custom_bin_ranges = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 100.0), cols=2, desc=\
        r"""
        Get/Set custom bin range to use. These are used only when
        use_custom_bin_ranges is set to true. Default is [0, 100].
        """
    )

    def _custom_bin_ranges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCustomBinRanges,
                        self.custom_bin_ranges)

    def _get_bin_range(self):
        return self._vtk_obj.GetBinRange()
    bin_range = traits.Property(_get_bin_range, desc=\
        r"""
        Get the bin range which was used to create the bin extents.
        """
    )

    _updateable_traits_ = \
    (('accumulation', 'GetAccumulation'), ('calculate_averages',
    'GetCalculateAverages'), ('center_bins_around_min_and_max',
    'GetCenterBinsAroundMinAndMax'), ('normalize', 'GetNormalize'),
    ('use_custom_bin_ranges', 'GetUseCustomBinRanges'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('bin_accumulation_array_name',
    'GetBinAccumulationArrayName'), ('bin_count', 'GetBinCount'),
    ('bin_extents_array_name', 'GetBinExtentsArrayName'),
    ('bin_values_array_name', 'GetBinValuesArrayName'), ('component',
    'GetComponent'), ('custom_bin_ranges', 'GetCustomBinRanges'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'accumulation', 'calculate_averages',
    'center_bins_around_min_and_max', 'debug', 'global_warning_display',
    'normalize', 'release_data_flag', 'use_custom_bin_ranges',
    'bin_accumulation_array_name', 'bin_count', 'bin_extents_array_name',
    'bin_values_array_name', 'component', 'custom_bin_ranges',
    'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractHistogram, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['accumulation', 'calculate_averages',
            'center_bins_around_min_and_max', 'normalize',
            'use_custom_bin_ranges'], [], ['bin_accumulation_array_name',
            'bin_count', 'bin_extents_array_name', 'bin_values_array_name',
            'component', 'custom_bin_ranges', 'object_name']),
            title='Edit ExtractHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

