// Integer type class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "IntType.h"
#include "LeafValue.h"
#include "Constraint.h"
#include "Range.h"

/** @file IntType.C
 * Signed integer data type
 */

/* Copyright  1998-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

class Value&
IntType::getFirstValue () const
{
  const class Value* v = myConstraint ? &myConstraint->getFirstValue () : NULL;
  assert (!v || &v->getType () == this);
  return v
    ? *static_cast<class LeafValue*>(v->copy ())
    : *new class LeafValue (*this, INT_T_MIN);
}

class Value&
IntType::getLastValue () const
{
  const class Value* v = myConstraint ? &myConstraint->getLastValue () : NULL;
  assert (!v || &v->getType () == this);
  return v
    ? *static_cast<class LeafValue*>(v->copy ())
    : *new class LeafValue (*this, INT_T_MAX);
}

card_t
IntType::do_getNumValues () const
{
  assert (!myConstraint);
  return CARD_T_MAX;
}

card_t
IntType::convert (const class Value& value) const
{
  assert (value.getKind () == Value::vLeaf);
  if (myConstraint)
    return Type::convert (value);
  return card_t (int_t (static_cast<const class LeafValue&>(value)) -
		 INT_T_MIN);
}

class Value*
IntType::convert (card_t number) const
{
  assert (number < getNumValues ());
  if (myConstraint)
    return Type::convert (number);
  return new class LeafValue (*this, int_t (card_t (INT_T_MIN) + number));
}

#ifdef EXPR_COMPILE
# include "StringBuffer.h"

void
IntType::compileDefinition (class StringBuffer& out,
			    unsigned indent) const
{
  out.indent (indent);
  out.append ("signed");
}

void
IntType::do_compileConversion (class StringBuffer& out,
			       unsigned indent,
			       const char* value,
			       const char* number,
			       bool add) const
{
  out.indent (indent);
  out.append (number);
  out.append (add ? "+=" : "=");
  out.append ("(card_t) (");
  out.append (value);
  out.append (");\n");
}

#endif // EXPR_COMPILE
