// license:BSD-3-Clause
// copyright-holders:David Haywood
/*
  Unknown Fruit Machine ROMs

  Fruit Machine ROMs can be difficult to identify at the best of times, and just as difficult to
  place in a driver, especially if parts are missing.

  This file is just a collection of random odds and ends which I haven't been able to place yet,
  some of it could well be junk.  They can be deleted / placed over time.  Some could be bad,
  some could be missing parts, some could be unique platforms.

  Please remove any confirmed bad roms, and if hardware is positively identified, move things
  to the correct drivers.

*/


#include "emu.h"

class unkfr_state : public driver_device
{
public:
	unkfr_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
		m_maincpu(*this, "maincpu") { }
	required_device<cpu_device> m_maincpu;

	void unkfr(machine_config &config);
};


#if 0

static INPUT_PORTS_START( unkfr )
	PORT_START("IN0")
	PORT_DIPNAME( 0x01, 0x01, "IN0:01" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x01, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, "IN0:02" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x02, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, "IN0:04" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x04, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, "IN0:08" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x08, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, "IN0:10" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x10, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, "IN0:20" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x20, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, "IN0:40" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x40, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, "IN0:80" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x80, DEF_STR( On ) )
INPUT_PORTS_END

MACHINE_CONFIG_START( unkfr_state::unkfr )
MACHINE_CONFIG_END

ROM_START( unkfr )
	ROM_REGION( 0x800000, "unkroms", 0 )
// 3 Of A Kind (Unk)
	ROM_LOAD( "3ofakind.bin", 0x0000, 0x008000, CRC(46883c38) SHA1(ab1ffbc437a919e991443d1f5c1b6378b0c8fd53) )
	ROM_LOAD( "3ofakindhacked.bin", 0x0000, 0x008000, CRC(94acff35) SHA1(d0e3c7666fb655b1fc20542527e4f55bc25abe0c) )
// Club 21 (Unk) [c] (bad - only a few bits ever used)
//  ROM_LOAD( "club21_1.bin", 0x0000, 0x080000, CRC(826e047c) SHA1(1da8a86688148c184c42ce213239ea2e57cb9e29) )
//  ROM_LOAD( "club21_2.bin", 0x0000, 0x080000, CRC(75297a19) SHA1(1c7e2b3fccfc79b3fbfbc979d06aef3405fa2aad) )
//  ROM_LOAD( "club21snd-0.bin", 0x0000, 0x080000, CRC(673551c6) SHA1(d7540388ccc8df6be2ec7a3fa90765f7e6ac49f7) )
//  ROM_LOAD( "club21snd-1.bin", 0x0000, 0x080000, CRC(a9288cf4) SHA1(a30027497e965fc670ca902ca228c3e434815e34) )
// Cops 'n' Robbers Classic (Bellfruit) - possibly a DMD ROM, given the mtx filename
	ROM_LOAD( "classic-cops-and-robbers_mtx_ass.bin", 0x0000, 0x010000, CRC(3f40a2c9) SHA1(f73731171c56add1329f3a9d2f84303311d87884) )
// Crystal Maze SWP (Barcrest) [c] (just a bad dump?)
	ROM_LOAD( "cr2.p8", 0x0000, 0x080000, CRC(9196fc2f) SHA1(844581f2380045019f65b42051535972e6cf21ca) )
// Each Way Shifter (Barcrest)
	ROM_LOAD( "ews3_3.bin", 0x0000, 0x010000, CRC(fb05345f) SHA1(72183743ec8955b12724471494f19d6af778e4b1) ) // MPU?
	ROM_LOAD( "ews8.a2", 0x0000, 0x000400, CRC(ee4a4809) SHA1(292a12a5ddc5a22c8568016b34dfec7959f49027) )
	//ROM_LOAD( "ews8.az", 0x0000, 0x000400, CRC(ee4a4809) SHA1(292a12a5ddc5a22c8568016b34dfec7959f49027) )
	ROM_LOAD( "ews8.b1", 0x0000, 0x000400, CRC(52e9709a) SHA1(0b437834f48ca7718e0b30303916eed00c7fb4c9) )
// Golden Shot (Empire)
	ROM_LOAD( "game_sec.mot", 0x0000, 0x161880, CRC(81ea2ee4) SHA1(8d5fe57c46054c23afdbb3c5c67fd7a7e9161646) )
// Hells Bells Club (JPM) [c] (looks like it should be sys5 or impact, but code crashes early?)
	ROM_LOAD( "hbl200p1", 0x0000, 0x010000, CRC(1f893dd8) SHA1(c2dd957f65ff6ed7f7ac027e4edb6b6a36871f88) )
	ROM_LOAD( "hbl200p2", 0x0000, 0x010000, CRC(ea470cf6) SHA1(2f64a8aac3bc01245cb4938bb01a5078c360c8d4) )
	ROM_LOAD( "hbl200p3", 0x0000, 0x010000, CRC(05c09717) SHA1(25fe309513daef262099aa1f0266f96eafb22d2c) )
	ROM_LOAD( "hbl200p4", 0x0000, 0x010000, CRC(a1d299db) SHA1(58f35ecbc524c41f4a39d3374f73f44fc54c751b) )
// Jokers (MA Leisure)
	ROM_LOAD( "jokers 1v3 (27256)", 0x0000, 0x008000, CRC(8d4222c1) SHA1(d7edc1338448436044c9fbf4448819c7ba1a9cb3) )
// Knight Fever (Empire) (corrupt? ascii/binary mode?)
	ROM_LOAD( "knight_n_vr105game.bin", 0x0000, 0x04094d, CRC(7a59e3ca) SHA1(fa44dd0fceb53dff38386f81f1e79b605adfbe6a) )
	ROM_LOAD( "knight_p_vr105game.bin", 0x0000, 0x04094d, CRC(ebbde668) SHA1(ba04b18dd398c99923dff40db753f0a43bbe0b08) )
	ROM_LOAD( "knightb3_n_vr101.bin", 0x0000, 0x042153, CRC(bb890b7d) SHA1(a30d71e96d500f4b37974c86ca9490d53c74b8e6) )
	ROM_LOAD( "knightb3_p_vr101.bin", 0x0000, 0x042153, CRC(ca2445f0) SHA1(9e622f84bc1f5349efa99cea470039c608acb7e8) )
	ROM_LOAD( "knightc_n_vr101.bin", 0x0000, 0x0412e9, CRC(66576eaf) SHA1(51d57ca904163bdbf2bf6cf5c90d8bdcee722e04) )
	ROM_LOAD( "knightc_p_vr101.bin", 0x0000, 0x0412e9, CRC(46d57021) SHA1(05a640ca5b7a10e9ae96a02b3ac1f2bc6497f052) )
// LED (Test Rom)  (test rom for what?)
	ROM_LOAD( "ledtest.bin", 0x0000, 0x020000, CRC(c74a0002) SHA1(e475d5c6b3077a2b8e76322c6d0848c622fbd76c) )
// Lucky Spin (DNCL)
	ROM_LOAD( "luckyspin.bin", 0x0000, 0x002000, CRC(765bb41b) SHA1(d3f02494c35cce4dfa79dab14a1416ac7e86683c) )
// Magic Moments (Unk)
	ROM_LOAD( "magicmoments20p-6.bin", 0x0000, 0x008000, CRC(c0986a11) SHA1(0333d37d11f8b03e0507ddcefc4a67ea2cba5bd8) )
// Millionaires Row (Bellfruit) (bad?)
	ROM_LOAD( "millionaires row s16 sound (8meg)", 0x0000, 0x100000, CRC(4086df3f) SHA1(7fd358d901db48d1f8edc4b22789c73b5fb84874) )
	ROM_LOAD( "millionaires row s16 v1-0 hi (4meg)", 0x0000, 0x080000, CRC(6b879665) SHA1(79fa91721375f0f968ecbd07fe9e9695344b7cd6) )
	ROM_LOAD( "millionaires row s16 v1-0 lo (4meg)", 0x0000, 0x080000, CRC(8436aab9) SHA1(815000121e93c9a8e4f6c6d6d12a06c4484eb50c) )
// Money Matrix (Bellfruit)
	ROM_LOAD( "957179.02.bin", 0x0000, 0x008000, CRC(ee215e94) SHA1(249d16a3ed7b9b6c99b1135f350efcb2ed130865) )
// More Money (VFS)
	ROM_LOAD( "mmchancs.bin", 0x0000, 0x002000, CRC(3eaede51) SHA1(6914fcaed6e51736c6dc725ba82b691803571222) )
// Oceans Eleven (Empire) (corrupt? ascii/binary mode?)
	ROM_LOAD( "oceansb3_n_vr102.bin", 0x0000, 0x03f046, CRC(e425c04a) SHA1(9a64c6065670d4523c8f5d1094bdea0598ca2a87) )
	ROM_LOAD( "oceansb3_p_vr102.bin", 0x0000, 0x03f046, CRC(71824b03) SHA1(540c5497217de70fa4e297a9e866b3311a12d6d6) )
	ROM_LOAD( "oceansc_n_vr102.bin", 0x0000, 0x03e88a, CRC(2807cad1) SHA1(4bda5060ce60a3e7ee72f3f50cab2abc00c6ae12) )
	ROM_LOAD( "oceansc_p_vr102.bin", 0x0000, 0x03e88a, CRC(14db1bb5) SHA1(be5986aa1340fd21d22f55627e6049b0011be564) )
// Power Game (JPM)
	ROM_LOAD( "pog5.3p1", 0x0000, 0x020000, CRC(62ea507f) SHA1(ea1e2057f3b51ab3f13c7b91467ed3142c64b76a) ) // unmatched 68k rom?
	ROM_LOAD( "powgam41.bin", 0x0000, 0x004000, CRC(304ccf8c) SHA1(96370bd7d6f7c7218be18e9be2fb87a58a9ac9d4) ) // looks like it should be MPS, but is bad?
	ROM_LOAD( "powgam42.bin", 0x0000, 0x004000, CRC(a71cc455) SHA1(324a0ef33d0e0fc8bd8a5d1309a3b2e6f13926d6) )
	ROM_LOAD( "powgam43.bin", 0x0000, 0x004000, CRC(0661cbcc) SHA1(1d14ec7321e00e837f9cb0da6f660f1a7625b139) )
// Rainbow Gambler (Unk)
	ROM_LOAD( "rambow gambler 2p2 25-7.bin", 0x0000, 0x004000, CRC(4205d5ca) SHA1(ced743a1dee0a6dd1f5a2be8e4bddcd2ec875d23) )
	ROM_LOAD( "rambowgambler320.bin", 0x0000, 0x004000, CRC(72415a35) SHA1(822393f300d5fe3932e546dd1f7ec8feda57ebed) )
// Scoop (Peter Simper)
	ROM_LOAD( "scoopv-2.p1", 0x0000, 0x001000, CRC(e937e298) SHA1(edb4dfb5afd6c2640b6bbd83be591987225bd8fc) )
	ROM_LOAD( "scoopv-2.p2", 0x0000, 0x001000, CRC(2a97a254) SHA1(a249e013d86f7e65e43b07ff916c4d0fd5099f44) )
	ROM_LOAD( "scoopv-2.p3", 0x0000, 0x001000, CRC(34ab1805) SHA1(1e389e9b47c4b3305ec70c94f49a4e3ca0a6f439) )
// Shogun (Bellfruit) // Scorpion encode, but missing 2nd part with vectors?
	ROM_LOAD( "shogun.bin", 0x0000, 0x008000, CRC(38d25549) SHA1(50ac02b6fdaa0b4960f0de4ed28c8c4d8d23cbcf) )
// Stars 'n' Bars (Unk)
	ROM_LOAD( "snbars.bin", 0x0000, 0x008000, CRC(199cb8c9) SHA1(08c123f8eb7a239a397558945b00a61a45cb2154) )
// Talk Of The Town (Unk)
	ROM_LOAD( "ttown1.bin", 0x0000, 0x001000, CRC(996c435b) SHA1(1fcf5a637cddacd6660da752a1fe10e56a7653c7) )
	ROM_LOAD( "ttown2.bin", 0x0000, 0x001000, CRC(93bd6446) SHA1(ef271bb45d27844f0ef1437bbc7f4847f4c0c6ee) )
	ROM_LOAD( "ttown3.bin", 0x0000, 0x001000, CRC(0ca34690) SHA1(1734692d82af89272a2243e2c5f584965bfe197f) )
// Universal Programmer (Unk)
	//ROM_LOAD( "job15r", 0x0000, 0x0092ac, CRC(3c39e49f) SHA1(d45e4c490cf90b707551fd3df21f6e35d326eaf6) ) // text file
// zzz-unk ee2_519a (Unk)
	ROM_LOAD( "ee2_519a", 0x0000, 0x030050, CRC(11af495c) SHA1(b035dd622ed8fa8d2e28f05a559c25049e042f67) )
// zzz_unk 001 (Unk)
	ROM_LOAD( "rom1", 0x0000, 0x000400, CRC(1a1f0d76) SHA1(a47addd727460e379f6106e059d43b3fd4e4a34e) )
	ROM_LOAD( "rom2", 0x0000, 0x000400, CRC(66ac392f) SHA1(b0e841669fe97c6edbd0b0830dd7dd84e354ef29) )
	ROM_LOAD( "rom3", 0x0000, 0x000400, CRC(d02d2983) SHA1(9e9e106083dfea44228ae56e73a3fe7184fdb473) )
	ROM_LOAD( "rom4", 0x0000, 0x000400, CRC(da6421b8) SHA1(d3099d94d722e3e12ade712842261aac8b45f9f4) )
	ROM_LOAD( "rom5", 0x0000, 0x000400, CRC(66ac392f) SHA1(b0e841669fe97c6edbd0b0830dd7dd84e354ef29) )
	ROM_LOAD( "rom6", 0x0000, 0x000400, CRC(66ac392f) SHA1(b0e841669fe97c6edbd0b0830dd7dd84e354ef29) )
	ROM_LOAD( "rom7", 0x0000, 0x000400, CRC(3700a7a3) SHA1(cf24a54e6aa3a3a86ff75f6e8bcb692d0cfd0e80) )
	//rom8 = 7.bn                  galaxbsf   Galaxian (bootleg)
	ROM_LOAD( "rom9", 0x0000, 0x000400, CRC(fdc857b4) SHA1(3b89f0cd5e8ed73c2e3cded1edc64d23d0fefa54) )
	//rom10 = 7.bn                  galaxbsf   Galaxian (bootleg)
	ROM_LOAD( "rom11", 0x0000, 0x000400, CRC(51923338) SHA1(ee29a3e187a5fce82c422c3aafbf6446d3463cc3) )
	ROM_LOAD( "rom12", 0x0000, 0x000400, CRC(656a134b) SHA1(6027480a3bf49da3fac6351f54c286c5de3752ee) )
	ROM_LOAD( "rom13", 0x0000, 0x000400, CRC(8b181929) SHA1(c7e789d1a76e8db0251ac4c75aa85f0a4259fc81) )
	ROM_LOAD( "rom14", 0x0000, 0x000400, CRC(5c65cfc6) SHA1(b04892e932c03d7c500e272eff2252b558b6f37f) )
	ROM_LOAD( "rom15", 0x0000, 0x000400, CRC(4a30ba0e) SHA1(42af9a91760cfd535d3dac2972101af1444750ca) )
	ROM_LOAD( "rom16", 0x0000, 0x000400, CRC(69243c04) SHA1(958791fbd515ab6e2b38391527b611977303ad10) )
	ROM_LOAD( "rom17", 0x0000, 0x000400, CRC(3700a7a3) SHA1(cf24a54e6aa3a3a86ff75f6e8bcb692d0cfd0e80) )
	ROM_LOAD( "rom18", 0x0000, 0x000400, CRC(3700a7a3) SHA1(cf24a54e6aa3a3a86ff75f6e8bcb692d0cfd0e80) )
	ROM_LOAD( "rom19", 0x0000, 0x000400, CRC(52e9709a) SHA1(0b437834f48ca7718e0b30303916eed00c7fb4c9) )
	// rom20 = ewn1.bin              j_ewnda    Each Way Nudger (Barcrest?, set 2)
	ROM_LOAD( "rom21", 0x0000, 0x000400, CRC(6b93d262) SHA1(39fce614845ba1d59e27e678318b1a9331797a9b) )
	ROM_LOAD( "rom22", 0x0000, 0x000400, CRC(73342376) SHA1(8ec9b57076465a64248f1eb02ca9e7a79ea0b993) )
	ROM_LOAD( "rom23", 0x0000, 0x000400, CRC(6b93d262) SHA1(39fce614845ba1d59e27e678318b1a9331797a9b) )
	ROM_LOAD( "rom24", 0x0000, 0x000400, CRC(357d963e) SHA1(8ee43c7cbb3ea52f42e56cb6168c9aff5d279886) )
	ROM_LOAD( "rom25", 0x0000, 0x000400, CRC(8f00ce85) SHA1(9286f88f414db124a8d4b08bfddda032282752e4) )
	ROM_LOAD( "rom26", 0x0000, 0x000400, CRC(7fca2306) SHA1(1b1f1f5fc4fd1834b1c672d239a1c4375366b72a) )
	ROM_LOAD( "rom27", 0x0000, 0x000400, CRC(6669330b) SHA1(e3b83a6a24474fd9469f943a681755458752ab69) )
	ROM_LOAD( "rom28", 0x0000, 0x000400, CRC(7a5ab4b4) SHA1(6234e11c906e183cd12d42195701eb818aaf2b22) )
	ROM_LOAD( "rom29", 0x0000, 0x000400, CRC(9b9438fc) SHA1(65c6283bbfe9bed65f3aaaa051cf9ad277f758cd) )
	ROM_LOAD( "rom30", 0x0000, 0x000400, CRC(3700a7a3) SHA1(cf24a54e6aa3a3a86ff75f6e8bcb692d0cfd0e80) )
	ROM_LOAD( "rom31", 0x0000, 0x000400, CRC(9f12febb) SHA1(52f0243ab18f5fe4c2ddc43727e88cc9edf4c487) )
	ROM_LOAD( "rom32", 0x0000, 0x000400, CRC(660cb6d1) SHA1(15332d295e615298b822c31fcec7278843d8894a) )
	ROM_LOAD( "rom33", 0x0000, 0x000400, CRC(82d974b4) SHA1(2e10b40cf45c0aa7669e8bb046382982de1e77e3) )
	ROM_LOAD( "rom34", 0x0000, 0x000400, CRC(3522d990) SHA1(27544c318acfd5706b6c520b94acde3b9fe763f1) )
	ROM_LOAD( "rom35", 0x0000, 0x000400, CRC(c87e98d9) SHA1(840f0f01aacb3df1cce4d75635de476bd615680b) )
	ROM_LOAD( "rom36", 0x0000, 0x000400, CRC(82d974b4) SHA1(2e10b40cf45c0aa7669e8bb046382982de1e77e3) )
	ROM_LOAD( "rom37", 0x0000, 0x000400, CRC(cd9ac1cd) SHA1(e5983145e52843be701752c7fb52a99d799a489d) )
	ROM_LOAD( "rom38", 0x0000, 0x000400, CRC(ee4a4809) SHA1(292a12a5ddc5a22c8568016b34dfec7959f49027) )
	ROM_LOAD( "rom39", 0x0000, 0x000400, CRC(52e9709a) SHA1(0b437834f48ca7718e0b30303916eed00c7fb4c9) )
	ROM_LOAD( "rom40", 0x0000, 0x000400, CRC(3700a7a3) SHA1(cf24a54e6aa3a3a86ff75f6e8bcb692d0cfd0e80) )
	ROM_LOAD( "rom41", 0x0000, 0x000400, CRC(5eb95f74) SHA1(3bdb8e871cdc597187fb4ae1b9909209ef4ef93d) )
	ROM_LOAD( "rom42", 0x0000, 0x000400, CRC(a0059ddd) SHA1(06bc3bd5eef9fea9e038ec08e5a228ab19f31a56) )
	//rom43 = 3.bn                  galaxbsf   Galaxian (bootleg)
	//rom44 = 3.bn                  galaxbsf   Galaxian (bootleg)
	ROM_LOAD( "rom45", 0x0000, 0x000400, CRC(331762cd) SHA1(3cd9f54c18416b626fb0450fb0609ac126306ff0) )
	//rom46 = 6.bn                  galaxbsf   Galaxian (bootleg)
	//rom47 = 5.bn                  galaxbsf   Galaxian (bootleg)
// zzz_unk 017 (Unk)
	ROM_LOAD( "misc2.bin", 0x0000, 0x010000, CRC(f9b9cd85) SHA1(ca16f4c8b95d3625918756b9c26a0995f9161dab) )
// zzz_unk 94cd910 (Unk)
	ROM_LOAD( "94cd910", 0x0000, 0x004000, CRC(0340ef85) SHA1(f55dbe86a0d6b16aa62ab7ed922ff83d4fbecb04) )
// zzz_unk aa31 (Unk)
	ROM_LOAD( "aa31", 0x0000, 0x010000, CRC(2086f3a2) SHA1(13a75b5e0c1533af3e5d255182a7e6ec88d59826) )
// zzz_unk aladdinprm (Unk)
	ROM_LOAD( "aladdinprm", 0x0000, 0x010000, CRC(1a618500) SHA1(4af077bf8f6a74eae20aedf39c2df447670128f4) )
// zzz_unk all32 (Unk)
	ROM_LOAD( "all32", 0x0000, 0x020000, CRC(1d56097c) SHA1(aab18041b39c904113f5f11dc81149abec871a56) )
// zzz_unk all41meg (Unk)
	ROM_LOAD( "all41meg", 0x0000, 0x020000, CRC(317b61d2) SHA1(52fb22744efda5d236af030bb18f8248a4c19cf8) )
// zzz_unk all4512 (Unk)
	ROM_LOAD( "all4512", 0x0000, 0x010000, CRC(bf34acb0) SHA1(290307f2bed9d11adb7e91a403c973d3266e04c7) )
// zzz_unk alladin2 (Unk)
	ROM_LOAD( "alladin2", 0x0000, 0x020000, CRC(bb8b253b) SHA1(b604a3bcd9db16e84cb5c501cd625ad05a8607dd) )
// zzz_unk astros_1 (Unk)
	ROM_LOAD( "07c1t0.400", 0x0000, 0x0271d4, CRC(1c3236c7) SHA1(c6179fff16f9d8472675c307d9ab0bce5a4e17c1) )
	ROM_LOAD( "07c1t1.400", 0x0000, 0x027357, CRC(b2cac9b3) SHA1(d39266e68bdbca8ac7f19dd617d8c43670cbbe01) )
	ROM_LOAD( "g07n0227.144", 0x0000, 0x0d5676, CRC(b332820b) SHA1(871a6af360c089948082b8859bbd688812425ca6) )
	ROM_LOAD( "g07t0227.145", 0x0000, 0x0d581c, CRC(1385cb9f) SHA1(5ecc2854fb82f3a5c17eca381b6f0c02ae0a0e42) )
	ROM_LOAD( "g26n0227.242", 0x0000, 0x0d5676, CRC(82679c2f) SHA1(5f45e51b3a5f5f2eea93ace6e9c1c120c9e9c8bb) )
	ROM_LOAD( "g26t0227.243", 0x0000, 0x0d5c12, CRC(ab0760b7) SHA1(9dcad1e21d2d7d0e17baca3e20d375dfdcbbbb8a) )
// zzz_unk bgl01 (Unk)
	ROM_LOAD( "bgl01", 0x0000, 0x013ee2, CRC(dcc23e51) SHA1(5883c3d0c1cb7a8e11647218310a3f34c9c7c661) )
// zzz_unk bre (Unk)
	ROM_LOAD( "bre01", 0x0000, 0x013ee2, CRC(c1abf402) SHA1(526c30271227479877075dd259d20b3ede558d05) )
	ROM_LOAD( "bre02", 0x0000, 0x00f6e2, CRC(b7bb7d4c) SHA1(2b9860a6880259d5e96007d09289d30c543cf545) )
	ROM_LOAD( "bre03", 0x0000, 0x010ee2, CRC(2ccd60be) SHA1(056611af30fc39b437aca4e81f0d961834b4a6a3) )
	ROM_LOAD( "bre04", 0x0000, 0x00f6e2, CRC(2cf7f87c) SHA1(546ac9aae295ce389ecddb87253b6c3e9a6c81ce) )
	ROM_LOAD( "bre05", 0x0000, 0x013ee2, CRC(6747a021) SHA1(18f1e671cacdcbbe50289529f3f51446234d794b) )
// zzz_unk ccc (Unk)
	ROM_LOAD( "ccc2", 0x0000, 0x010000, CRC(2df7f687) SHA1(1ee92678944d72577e024ea948c86e89b2035722) )
	ROM_LOAD( "ccc3", 0x0000, 0x020000, CRC(7b02d860) SHA1(e3f879f031135bb6f64de3c44022982e4c321cb2) )
// zzz_unk cdvnv (Unk)
	ROM_LOAD( "cdvnv12", 0x0000, 0x004000, CRC(f49bb59c) SHA1(21184d068a38556ee06ba046ce5181b86c18234b) )
	ROM_LOAD( "cdvr92", 0x0000, 0x004000, CRC(61a8372e) SHA1(74290a034964f921a58a90b497345b4dd271a431) )
// zzz_unk chf (Unk)
	ROM_LOAD( "chf01", 0x0000, 0x013ee2, CRC(13fb2a42) SHA1(6f5434136a420d94f51c721fd03c65f268ee238b) )
	ROM_LOAD( "chf02", 0x0000, 0x00c6e2, CRC(bb9be889) SHA1(a23bfc224f1d9d5c13d3ef16419c46dde28531f2) )
	ROM_LOAD( "chf03", 0x0000, 0x00f6e2, CRC(79fa2dac) SHA1(2ec56feb8d2c38c4c0b59b4bc650daf0d5873f30) )
	ROM_LOAD( "chf04", 0x0000, 0x0036e2, CRC(ad6b71d2) SHA1(eec495b25b38e15f2a2bd35d2db8f0a6ecf98d62) )
// zzz_unk classicsnd (Unk)
	ROM_LOAD( "classicsnd0.bin", 0x0000, 0x020000, CRC(e23bd795) SHA1(8297256b0ee0c15d304c74ab2b7f8eb4891ff1fa) )
	ROM_LOAD( "classicsnd1.bin", 0x0000, 0x020000, CRC(c18ed56f) SHA1(36c2d6df2bf65c6d47500bcd0cfd0e45b5dfeaf4) )
	ROM_LOAD( "classicsnd2.bin", 0x0000, 0x020000, CRC(bee8cc32) SHA1(8d8e0087221710476ec9221ec335545739a926f3) )
// zzz_unk classv (Unk) [Rom] SCORPION
	ROM_LOAD( "classv1.2a.bin", 0x0000, 0x008000, CRC(26930c24) SHA1(2c634171d7e63839b4f8e7f9efcd2924bd38e375) )
	ROM_LOAD( "classv1.2b.bin", 0x0000, 0x008000, CRC(9d98d723) SHA1(afc1ae0bfcf6ecfc6eee2583e6fa31aca6e30550) )
// zzz_unk cro (Unk)
	ROM_LOAD( "cro01", 0x0000, 0x00f6e2, CRC(58b9481d) SHA1(9bdc54b5ef37fb818a02eb5c839667e0b883852e) )
	ROM_LOAD( "cro02", 0x0000, 0x007ee2, CRC(9a6dd9ec) SHA1(a173d65f78d133d319cbc4ac7311f3bbadef0a8d) )
// zzz_unk csk (Unk)
	ROM_LOAD( "csk01", 0x0000, 0x00aee2, CRC(8f5eb65c) SHA1(011ffaf8cb1af461688b992e6d161234cf90af78) )
	ROM_LOAD( "csk04", 0x0000, 0x007ee2, CRC(d461662c) SHA1(50713d62a67d972d6e47371afe436a4c7f7ea9d5) )
	ROM_LOAD( "csk05", 0x0000, 0x0066e2, CRC(dc73a53b) SHA1(85bb964231187fcf38fd0ad83f0cd6f024387331) )
	ROM_LOAD( "csk06", 0x0000, 0x008ae2, CRC(0e507f6b) SHA1(5c11125bb3a14df7d37a14b006283f6da851380b) )
	ROM_LOAD( "csk08", 0x0000, 0x008ae2, CRC(74c19b54) SHA1(12a2b7c29a95fca095c72deb79b88302e811afbb) )
	ROM_LOAD( "csk09", 0x0000, 0x0096e2, CRC(b63908e8) SHA1(f78b4163e8d7a2d3910a00607fb1e219650608e6) )
	ROM_LOAD( "csk10", 0x0000, 0x0072e2, CRC(043846e3) SHA1(b55964b71630f14c127412c4c74d85a5de86b287) )
	ROM_LOAD( "csk11", 0x0000, 0x008ae2, CRC(7d64ab44) SHA1(2d0e9bc59652a76af2ce75f108f78e45d337b16b) )
	ROM_LOAD( "csk12", 0x0000, 0x007ee2, CRC(f77e2605) SHA1(379fa9bdf90f348de453f94a469a505c914cfc30) )
// zzz_unk ddav (Unk)
	ROM_LOAD( "ddav12", 0x0000, 0x002000, CRC(aceba7f4) SHA1(b1e5ae8932fc8fd8ac3eb06b67911fb112fbf808) )
	ROM_LOAD( "ddav12&2", 0x0000, 0x002000, CRC(aceba7f4) SHA1(b1e5ae8932fc8fd8ac3eb06b67911fb112fbf808) )
// zzz_unk dem (Unk)
	ROM_LOAD( "dem01", 0x0000, 0x00dee2, CRC(71829408) SHA1(cba53dc8882ed0fe7ff06dcf6d8f08ef7668952a) )
	ROM_LOAD( "dem02", 0x0000, 0x0066e2, CRC(8887388b) SHA1(72eb781b2ec785db9dcb981643007586bf628c23) )
	ROM_LOAD( "dem03", 0x0000, 0x00aee2, CRC(a32ea48d) SHA1(e607e97766f76dd74476815a5248e21f11e8f92e) )
	ROM_LOAD( "dem04", 0x0000, 0x0036e2, CRC(86387b3c) SHA1(24021823b135e813a24589a1b81be3c811a3d51f) )
// zzz_unk demats01 (Unk)
	ROM_LOAD( "demats01", 0x0000, 0x00b4e2, CRC(0c65c583) SHA1(df97306745f7147016e1b85204f3c858d7dc760f) )
// zzz_unk demgbp01 (Unk)
	ROM_LOAD( "demgbp01", 0x0000, 0x00dee2, CRC(d99f7e8b) SHA1(61abbc50353acedc0e99e76d227d6c4c23af3b53) )
// zzz_unk denlgb01 (Unk)
	ROM_LOAD( "denlgb01", 0x0000, 0x016ee2, CRC(afbef1db) SHA1(3a528b80bbbfcb7894df05bc0a7b0d885660f280) )
// zzz_unk esp (Unk)
	ROM_LOAD( "esp01", 0x0000, 0x0090e2, CRC(e7ca0bca) SHA1(35591d1d04a0c5edc0a41b07b59579304af07632) )
	ROM_LOAD( "esp03", 0x0000, 0x0060e2, CRC(df1322ed) SHA1(a6be1a73dabef045cddd3eef215686d411358cc4) )
	ROM_LOAD( "esp04", 0x0000, 0x0060e2, CRC(ebcb9337) SHA1(bf58afd874e7a710ff2c36f242d24f73a8041686) )
	ROM_LOAD( "esp05", 0x0000, 0x0030e2, CRC(e4ce8ee7) SHA1(19f253fa47406a98bdf115dcf4607023d2eb0202) )
// zzz_unk g26n0233 (Unk)
	ROM_LOAD( "g26n0233.253", 0x0000, 0x0f3cf6, CRC(d3d98cd7) SHA1(2500dc34b39399cad22b2cff0dd83239b4652790) )
// zzz_unk game1 (Unk)
	ROM_LOAD( "game1", 0x0000, 0x009a0d, CRC(89f6fd63) SHA1(7e87740138a6c6e9502e654dc27ad828fe9b793a) )
// zzz_unk game2 (Unk)
	ROM_LOAD( "game2", 0x0000, 0x009a0d, CRC(bf1f1f02) SHA1(be85da267470435d23f9d61c52a4fc446b73d7e7) )
// zzz_unk hazelgrove_superleague (Unk)
	ROM_LOAD( "hazelgrove_superleague.bin", 0x0000, 0x002000, CRC(01c09d5e) SHA1(be4c00391c150ef2d7ce56c5e39836fd2d0b92ec) )
// zzz_unk hgmwb43 (Unk)
	ROM_LOAD( "hgmwb43", 0x0000, 0x008000, CRC(f929fd3a) SHA1(33cc3169eb0bd82d81086aa09679aaaa95fbc6b1) )
// zzz_unk ld3_11i (Unk)
	ROM_LOAD( "ld3_11i", 0x0000, 0x040000, CRC(b9e7e0a9) SHA1(8cfafa8ec24be030179cc1983586bb03cb4ed44e) )
// zzz_unk link 3 (Maygay) (unknown cpu)
	ROM_LOAD( "oxo_mk3-1.bin", 0x0000, 0x000400, CRC(f20a9cf4) SHA1(c97a125904e96e37e3c54a1ffd3617d7d4e0d48c) )
	ROM_LOAD( "oxo_mk3-2.bin", 0x0000, 0x000400, CRC(915c9513) SHA1(7c584fd4c0ae035446cec4515c525a0d0ddb1fd7) )
	ROM_LOAD( "oxo_mk3-3.bin", 0x0000, 0x000400, CRC(9d1479d5) SHA1(128bfc1e49a8ca65aa7bea6fc83f781140bfe18d) )
	ROM_LOAD( "oxo_mk3-4.bin", 0x0000, 0x000400, CRC(2796991f) SHA1(4bba50509719fff9184cf110cf06394eae880f59) )
// zzz_unk mal01 (Unk)
	ROM_LOAD( "mal01", 0x0000, 0x007ee2, CRC(4e984428) SHA1(149fc45c4ca183521edf9c03f3e428d92bf1da95) )
// zzz_unk mc2 (Unk)
	ROM_LOAD( "mc2", 0x0000, 0x008000, CRC(3cf1eba4) SHA1(275d7c8865f80b95f01d7c8eb143aa9f7a918077) )
// zzz_unk mota-51 (Unk)
	ROM_LOAD( "mota-51a.p1", 0x0000, 0x020000, CRC(1057ad83) SHA1(5df0bc3956c22ae14699607cebc7003152011a54) )
// zzz_unk nbn 5p (Unk) [Rom] MPU
	ROM_LOAD( "nbn 5p 1_6_95.bin", 0x0000, 0x010000, CRC(89e960be) SHA1(f97c9062d4d67c11ef4b8b6a97a8d2cc403038b0) )

	// zzz_unk pp (Unk) [Rom] Z80?
	ROM_LOAD( "pp.p1", 0x0000, 0x001000, CRC(2ab92b46) SHA1(1486751885d832ceb7e936447a9332d69011f62c) )
	ROM_LOAD( "pp.p2", 0x0000, 0x001000, CRC(babf8ffa) SHA1(bb148243eac513de83634203393c2e91c9cf98c9) )
	ROM_LOAD( "pp.p3", 0x0000, 0x001000, CRC(72cde502) SHA1(c0401810dbc04a6eff5a7795120471f3016ff3bf) )

// zzz_unk r92rvcd (Unk)
	ROM_LOAD( "r92rvcd", 0x0000, 0x004000, CRC(b723db47) SHA1(bda42bb79b9ff15d68dc9868a40f5de2481f129e) )
// zzz_unk sburgf2 (Unk)
	ROM_LOAD( "sburgf2", 0x0000, 0x008000, CRC(c94bb9b6) SHA1(d0b1e1c6152c1be30cba5790c2e984625822504b) )
// zzz_unk sghost (Unk)
	ROM_LOAD( "sghost", 0x0000, 0x010000, CRC(7c453739) SHA1(05724cb23b711a0e4546435622eb6b6ef1ac6894) )
// zzz_unk shuffle (Unk)
	ROM_LOAD( "shuffle1.1", 0x0000, 0x000400, CRC(2eec7c4d) SHA1(a1740d27e60192659392ba7602b9b62947c4f6db) )
	ROM_LOAD( "shuffle1.3", 0x0000, 0x000400, CRC(4084c605) SHA1(b75320c042d3df79fbd8256dc82267bce09b26cc) )
// zzz_unk sl101a (Unk)
	ROM_LOAD( "sl101a.p1", 0x0000, 0x020000, CRC(7f25fa07) SHA1(9d45993f518bd3a6e54ffd358bef937773ac595e) )
// zzz_unk slcd31 (Unk)
	ROM_LOAD( "slcd31", 0x0000, 0x004000, CRC(e07d8a66) SHA1(9f7ed1566e7e4797a3c34d651c79d0fd8d0a8929) )
// zzz_unk smn (Unk) [Rom] SCP
	ROM_LOAD( "smn3v3ih", 0x0000, 0x010000, CRC(97956ceb) SHA1(c833b1efad6058bd7325a4312174bd182609617f) )
	ROM_LOAD( "smn3v3il", 0x0000, 0x010000, CRC(ddde0b8c) SHA1(093c195bde8710b064be54f7913568fcc8834f6e) )
// zzz_unk sov (Unk)
	ROM_LOAD( "sov0-03.u1", 0x0000, 0x080000, CRC(4e2e7a79) SHA1(77f32b43d2e01cb0223feccb9e29c3fde0a6e9b7) )
	ROM_LOAD( "sov0-03.u2", 0x0000, 0x080000, CRC(1ef8712a) SHA1(1a2ef378679384e720e5b20f1420454102f18258) )
	ROM_LOAD( "sov0-03d.u1", 0x0000, 0x080000, CRC(47d5e5ca) SHA1(d3624a8b8545f67d14bee90bc3967c13b8497e5b) )
// zzz_unk srat (Unk) [Rom] SOUND
	ROM_LOAD( "srat1d", 0x0000, 0x020000, CRC(46683be4) SHA1(2b4c04526f0124c239ec5653aaa49a3f11ba5000) )
	ROM_LOAD( "srat5d", 0x0000, 0x020000, CRC(d0f20a9c) SHA1(b3666e8d1063fed05a7f10c99f33a4dce26bf670) )
	ROM_LOAD( "srat6d", 0x0000, 0x020000, CRC(b023a84e) SHA1(f78a55348d0bbae59e10e47fedb30bdd27205b80) )
// zzz_unk starltv2 (Unk)
	ROM_LOAD( "starltv2", 0x0000, 0x004000, CRC(b0d418b1) SHA1(c1363578130bf9d30afb71a4c9b3e6988feb1128) )
// zzz_unk tempson (Unk) [Rom] SOUND
	ROM_LOAD( "tempson.p1", 0x0000, 0x080000, CRC(6a3beebe) SHA1(66bc8e388003c597587fc5fab7653bb2d4b1c815) )
	ROM_LOAD( "tempson.p2", 0x0000, 0x080000, CRC(3282bbfd) SHA1(2165a8a28cc6d47e99d84d660ba9ec3bb1a69aeb) )
// zzz_unk turbowks (Unk)
	ROM_LOAD( "turbowks", 0x0000, 0x000e92, CRC(0a828093) SHA1(ec755638bf25d4a38378cbbc5cf31a2c15f2cf98) )
// zzz_unk wb (Unk)
	ROM_LOAD( "wb10", 0x0000, 0x002000, CRC(4cdf2dc1) SHA1(06776428afe4f19c578f4167585d8183bfafb915) )
	ROM_LOAD( "wb10&5wz", 0x0000, 0x002000, CRC(4cdf2dc1) SHA1(06776428afe4f19c578f4167585d8183bfafb915) )
	ROM_LOAD( "wb11", 0x0000, 0x002000, CRC(4a16d4d2) SHA1(8e7fa08e769e88eaa429ae14f203f3b707897822) )
	ROM_LOAD( "wb11&4cd", 0x0000, 0x008000, CRC(f8d0d1cc) SHA1(1b392d8f1678ef420d007a64c6bdbeff2e8bd569) )
	ROM_LOAD( "wb20", 0x0000, 0x002000, CRC(af4c0793) SHA1(098cd4b3ea63e9dd4b0a0851b1ba9a2a80525630) )
	ROM_LOAD( "wb20&2da", 0x0000, 0x002000, CRC(ba1bf613) SHA1(42f0e5387a942d20c28bb70bfddaff7ef227147b) )
	ROM_LOAD( "wb21", 0x0000, 0x002000, CRC(a0db450b) SHA1(48572767c6b2ab9ffe74c41cb58e0a7634b7f0bd) )
	// wb22 = wb_v22                ep_unsrt   Unknown / Unsorted 'Epoch' ROMs
	ROM_LOAD( "wb23", 0x0000, 0x002000, CRC(737e4f2b) SHA1(f396a579dcd71050e19db2910a2c0967bacb4e0c) )
	ROM_LOAD( "wb4", 0x0000, 0x008000, CRC(f929fd3a) SHA1(33cc3169eb0bd82d81086aa09679aaaa95fbc6b1) )
	ROM_LOAD( "wb44", 0x0000, 0x002000, CRC(f16acc1e) SHA1(6c51d710d3c850a250bfed3af96e72b0966e782d) )
	ROM_LOAD( "wbl4", 0x0000, 0x002000, CRC(1f44b165) SHA1(097f27306355d1b61c61a6cd34a919b96bed311d) )
	ROM_LOAD( "wbstd44", 0x0000, 0x002000, CRC(f16acc1e) SHA1(6c51d710d3c850a250bfed3af96e72b0966e782d) )
	ROM_LOAD( "wbv11&3", 0x0000, 0x002000, CRC(4a16d4d2) SHA1(8e7fa08e769e88eaa429ae14f203f3b707897822) )
	// wbv22&0 = wb_v22                ep_unsrt   Unknown / Unsorted 'Epoch' ROMs
// zzz_unk wishsound (Unk) [Rom] SOUND
	ROM_LOAD( "wishsound1.bin", 0x0000, 0x080000, CRC(4c8fe9e5) SHA1(9046413c885454e1942c0b92b647598a660f3487) )
	ROM_LOAD( "wishsound2.bin", 0x0000, 0x080000, CRC(c5a91e30) SHA1(b7e4d78ce11bace2ae2bf30db7e5c6b4ebfe6c62) )
	ROM_LOAD( "wishsound3.bin", 0x0000, 0x080000, CRC(b9911a66) SHA1(782513afa16c0efc71cff467a1f055f1590674d5) )
// Accepter GBA (JPM)
	ROM_LOAD( "58c1.190", 0x0000, 0x0269fe, CRC(140592da) SHA1(0362d6b7d0e21a1593f3c89ce5c06072e93ec93c) )
	ROM_LOAD( "58r1.190", 0x0000, 0x0269fe, CRC(73e09e0e) SHA1(be57518033bbc1492953d8552c5a617a9977294f) )
	ROM_LOAD( "58s.190", 0x0000, 0x0269fe, CRC(e965c0a1) SHA1(dd0a377fbcb257d9a1de39ffc52a4c34fe17ba2e) )
	ROM_LOAD( "g58n0245.148", 0x0000, 0x0f8e1e, CRC(c815f689) SHA1(e57c5aa3bb6d9296320882fdc55cff7f5eb0ad99) )
// bfmulator.zip....
	ROM_LOAD( "showtime.bin", 0x0000, 0x010000, CRC(75cb4ebf) SHA1(24e56f00502628332130b56a93847436d7125f46) )
	ROM_LOAD( "bt6-c4_0.bin", 0x0000, 0x010000, CRC(74070e83) SHA1(42ffffb62ea74eaa8d3938dee45b5beaca64a320) )
	ROM_LOAD( "club-wild-west_std_ac_var_ffp_ass1.bin", 0x0000, 0x010000, CRC(2f639748) SHA1(95ddc75bd475789ff4bb48c678f72c081cc85f92) )
// Brain Box (Bellfruit)
	ROM_LOAD( "bbb10.bin", 0x0000, 0x010000, CRC(76d061ba) SHA1(d2d5cb9c24ef04a13c649781fe7c67b13415aa4b) )
// Brain Box 2 (Bellfruit)
	ROM_LOAD( "39360122.p1", 0x0000, 0x008000, CRC(949778b3) SHA1(b40e2ca1bfe91b93165df38ddf84a1d5a6cf6ce2) )
	ROM_LOAD( "39361122.p1", 0x0000, 0x008000, CRC(597bea46) SHA1(23cb9ce90508525c84befefafc171841989f6c38) )
	ROM_LOAD( "bboxint", 0x0000, 0x008000, CRC(ecd2a1d1) SHA1(f9e77fb63f20748f644ab270b56a68e9e53b77f9) )
// Cash Attraction (Bellfruit)
	ROM_LOAD( "95727239.bin", 0x0000, 0x008000, CRC(e3f28981) SHA1(9e56a05fab5aad60d07e18ad1d2ef75cfeb41229) )
// Flash Back (Bellfruit) (bad? both halves identical, no boot vectors)
	ROM_LOAD( "958400.54 20p 6.bin", 0x0000, 0x008000, CRC(13410929) SHA1(e5414ec8fef29de8c5ae3368aa6af22c03cdc592) )
	ROM_LOAD( "958400.55 20p 6.bin", 0x0000, 0x008000, CRC(cc449195) SHA1(4b4b0263748657ca76607653e878938814569a89) )
// Grid Runner (Global)
	ROM_LOAD( "gddl2-4n.p1", 0x0000, 0x020000, CRC(95e4e432) SHA1(ca3ce326da792a19075d89c957e5661513ed0e0d) )
// Hi Noon (JPM)
	ROM_LOAD( "hino-snd.bin", 0x0000, 0x080000, CRC(cf93186d) SHA1(5d190e24d702bbb396d69497b71e9a8ac51e6c6f) )
// James Bond - Licence To Kill (Maygay)
	ROM_LOAD( "james_bond_1.1", 0x0000, 0x01681e, CRC(964d3721) SHA1(6a4e893e0dc0542a3ab81246a40392f927acaffe) )
// Loto (Maygay) [Spain]
	ROM_LOAD( "sj6-586", 0x0000, 0x020641, CRC(853c0c9c) SHA1(42465d15336fe81885f32ea8522a5331fc2d49de) )
// Lucky Strike (Barcrest)
	ROM_LOAD( "lstrikesnd-p1.bin", 0x0000, 0x020000, CRC(0c8f9dcd) SHA1(026be80620bd4afc3e45cb7a374b93fff4c13dd2) )
	ROM_LOAD( "lstrikesnd-p2.bin", 0x0000, 0x020000, CRC(2a746ba5) SHA1(7f9d727a849a7a1ecfd750f214deef150ec3d9eb) )
// Monte Carlo (Ace)
	ROM_LOAD( "monte_carlo_1.1", 0x0000, 0x168095, CRC(96f09fe9) SHA1(1fc2ad662c7e90d580cc9f9753fa6fc48f955636) )
	ROM_LOAD( "monte_carlo_1.2", 0x0000, 0x168095, CRC(ea4a8a60) SHA1(dff6f043c0ee2921367689394b73b221336cdc98) )
	ROM_LOAD( "monte_carlo_1.3", 0x0000, 0x168095, CRC(2628d037) SHA1(8754b9e40a5f815b68b4c341705e587d25db710d) )
	ROM_LOAD( "monte_carlo_1.4", 0x0000, 0x168095, CRC(f9486358) SHA1(868aef1983855e028ed3d4f4996b393774427c13) )
// Note Acceptor Firmware (Misc)
	ROM_LOAD( "ara01", 0x0000, 0x00f6e2, CRC(54ddfb81) SHA1(b1e84ff1afdce40925558d6e454bea7444e59851) )
	ROM_LOAD( "ara02", 0x0000, 0x00c6e2, CRC(043f2326) SHA1(69deef6226c9a55c7ed3a404860de38785157add) )
	ROM_LOAD( "ara05", 0x0000, 0x00c6e2, CRC(64c3051e) SHA1(0fdaa125f78476f67308ecb2ca3f89f709dc1bb7) )
	ROM_LOAD( "ats01", 0x0000, 0x00aee2, CRC(d26d3a31) SHA1(a4ede43d7424e06362933ed270a23f97fd7b07d3) )
	ROM_LOAD( "ats06", 0x0000, 0x007ee2, CRC(d59f9a0b) SHA1(264d984773eb5bc2c498e56584c3eaa51092caea) )
	ROM_LOAD( "ats07", 0x0000, 0x0096e2, CRC(fbdfd213) SHA1(8c734613b8f9af2cf41fcdd2392143593da37c7a) )
	ROM_LOAD( "ats08", 0x0000, 0x0066e2, CRC(1e526dfd) SHA1(2f9aba00695fc917d548049eae41bc341ccdb233) )
	ROM_LOAD( "ats09", 0x0000, 0x0084e2, CRC(f3a891dc) SHA1(7b7ca77bd07e23c3d9eb84e6338871e4e13b86b6) )
	ROM_LOAD( "ats10", 0x0000, 0x007ee2, CRC(18b48d22) SHA1(d433ab40c882c35bb62b489fd8aa51f739b9a93d) )
	ROM_LOAD( "ats11", 0x0000, 0x0066e2, CRC(c431f6b3) SHA1(6e7bd2c10ced131d626bfa175e9a7a67adb47253) )
	ROM_LOAD( "ats12", 0x0000, 0x0036e2, CRC(f3c2f24b) SHA1(422985f418c982e074803ebee4331f22650a61c4) )
	ROM_LOAD( "ats13", 0x0000, 0x004ee2, CRC(9ec00b5a) SHA1(2b4ed3788b0ca52f07b53e7cfc20c176b64bf237) )
	ROM_LOAD( "ats14", 0x0000, 0x0096e2, CRC(10f09ebb) SHA1(5d200be36773dec5b9fe1b784e4ada89b8002f13) )
	ROM_LOAD( "aud01", 0x0000, 0x00f6e2, CRC(e596ca9c) SHA1(e046c305161e3f463874c0eb9c0d267f5054233d) )
	ROM_LOAD( "aud02", 0x0000, 0x00dee2, CRC(fd1692aa) SHA1(7e71301a6cf8155119022de0f28c0898a2c96d5c) )
	ROM_LOAD( "aud03", 0x0000, 0x00c6e2, CRC(97c59544) SHA1(2043beba1400af7500df80bdd80d5ceb86bfcbf3) )
	ROM_LOAD( "bef01", 0x0000, 0x0138e2, CRC(d40b68eb) SHA1(d242d1ca22181a3ffab99b6f6ee697f91a1331ec) )
	ROM_LOAD( "bef02", 0x0000, 0x00eae2, CRC(d134753e) SHA1(67141048b1644baa7d587fa92556065dcb601655) )
	ROM_LOAD( "bef03", 0x0000, 0x00f0e2, CRC(6e7aeac0) SHA1(86d2c66188606345858199d8892d3b9c5bbe5cad) )
	ROM_LOAD( "bef04", 0x0000, 0x00d8e2, CRC(95ed6452) SHA1(771c27448c7210e47ab9a53f9943d216bce6dc53) )
	ROM_LOAD( "bef05", 0x0000, 0x00b4e2, CRC(3deb4219) SHA1(725aac66cc2d2a7bbb0a818034ec643cc855e50c) )
	ROM_LOAD( "bef06", 0x0000, 0x00eae2, CRC(55cc8ed4) SHA1(b96b99e390a1e8d7cfb89ec72fea7781e1eeea0c) )
	ROM_LOAD( "bef07", 0x0000, 0x0120e2, CRC(fe520418) SHA1(3f6ed4613d5f28bbb7bf4679f0a3c0842428216d) )
	ROM_LOAD( "bef08", 0x0000, 0x0102e2, CRC(a8291d68) SHA1(8c2241a24c3d8ca6dd6a4df7da91231448b7481a) )
	ROM_LOAD( "beffrf01", 0x0000, 0x00aee2, CRC(795c2339) SHA1(e51c5232dad7b1745399ca1bae4b68c7a8bb502b) )
	ROM_LOAD( "bnd01", 0x0000, 0x0066e2, CRC(f6be953f) SHA1(d225e6d72fdd025863ce1d76a6674d80ca9e36c5) )
	ROM_LOAD( "ccu0912", 0x0000, 0x010000, CRC(2ca61fdb) SHA1(54bb39f4fdf115b293e7b2f45d170fdecaf80aea) )
	ROM_LOAD( "ccu1012", 0x0000, 0x010000, CRC(860197a5) SHA1(11981df44368a8bd75ead9962972fffbf5e2147e) )
	ROM_LOAD( "cny01", 0x0000, 0x0180e2, CRC(38073629) SHA1(3a4ee9f60466dc9a84f22ff11ced372f8a477247) )
	ROM_LOAD( "cny02", 0x0000, 0x0168e2, CRC(7dd11dda) SHA1(0cb857eca1809b78d9771b5579a4b0f0fbb1021b) )
	ROM_LOAD( "cny03", 0x0000, 0x00c6e2, CRC(d103d871) SHA1(5546d5cb8e79d53ead6be609d815e522d2203699) )
	ROM_LOAD( "cny04", 0x0000, 0x017ae2, CRC(899f2c57) SHA1(7a60188dea28e78f831d708ad5c159fa45d0766a) )
	ROM_LOAD( "cop02", 0x0000, 0x0096e2, CRC(72028f78) SHA1(271342b08efec07576ab73f63c4041de0221cd49) )
	ROM_LOAD( "copo1", 0x0000, 0x0066e2, CRC(3eb6b78c) SHA1(0476c120fd38d9f7a343f323b1fec3224a74125d) )
	ROM_LOAD( "dkk01", 0x0000, 0x00f6e2, CRC(e2cc90f9) SHA1(2d2fffb9ba288590aa877eedee9ecc301627db4d) )
	ROM_LOAD( "dkk02", 0x0000, 0x00dee2, CRC(e0959343) SHA1(65fd485772e2851e8b5d204b2e4f862e4f6669ef) )
	ROM_LOAD( "dkknok02", 0x0000, 0x00dee2, CRC(1f3ac0b6) SHA1(e2098cb69f60c3b742476f49e83d25098ec22057) )
	ROM_LOAD( "dknogb01", 0x0000, 0x0108e2, CRC(fadb6284) SHA1(5b89d67b78ed9960df250facf333c7ffdbb893e0) )
	ROM_LOAD( "dpdfrf01", 0x0000, 0x007ee2, CRC(8fe65917) SHA1(c444c0475d7e1f080101ae588c2dfeb282f6a5d7) )
	ROM_LOAD( "eba-22", 0x0000, 0x040000, CRC(16974672) SHA1(c5cde3a167da1f63093d0a7a786be881c69cfaf0) )
	ROM_LOAD( "ecs01", 0x0000, 0x0066e2, CRC(8de6e3de) SHA1(68026884ce045e74cb20e907bdb11dc45d64a80c) )
	ROM_LOAD( "eek01", 0x0000, 0x0114e2, CRC(429a3ad2) SHA1(5db1f12a713216a262b5c1820cb5e19e51d18aa5) )
	ROM_LOAD( "eek02", 0x0000, 0x0090e2, CRC(9102d2c9) SHA1(e2dc3c53f405a25ca8fed063a642c69881b422ee) )
	ROM_LOAD( "eek04", 0x0000, 0x00a2e2, CRC(9bd6d717) SHA1(10850777c625a3e373b98cb5067cb7e943cb8a46) )
	ROM_LOAD( "fim01", 0x0000, 0x007ee2, CRC(4206f550) SHA1(3bdb54565d0b2cf316e205a9c5a76d25ac624a6e) )
	ROM_LOAD( "gbp01", 0x0000, 0x007ee2, CRC(64bd7bf8) SHA1(7e0c851e3c2de33580e5d0865c742780546f7e32) )
	ROM_LOAD( "gbp02", 0x0000, 0x00f6e2, CRC(67e2673f) SHA1(dc9acb3c3522d2b82f9660871b27f61e921f03a3) )
	ROM_LOAD( "gbp04", 0x0000, 0x00dee2, CRC(1e271034) SHA1(6308498ed3c6b0333f7aad0bd0345655de2a44e9) )
	ROM_LOAD( "gbp06", 0x0000, 0x0180e2, CRC(88815056) SHA1(d7c80e733e908f4c5d765816e2fe0b7718f8e390) )
	ROM_LOAD( "gbp08", 0x0000, 0x0180e2, CRC(649684a8) SHA1(bafdddddd18116cd07af6985ecdae8d614b9e9f1) )
	ROM_LOAD( "gbp09", 0x0000, 0x016ee2, CRC(d168781c) SHA1(39174cf339de3c98c8cc1a8e862f91a1dd08b127) )
	ROM_LOAD( "gbp10", 0x0000, 0x007ee2, CRC(8b430e40) SHA1(61171e1d5d115ebd84fa6422a781db6365f7ea35) )
	ROM_LOAD( "gbp11", 0x0000, 0x00dee2, CRC(2a6dfd99) SHA1(661ecfab6e534d606fbb22d0ef682d087e63d75f) )
	ROM_LOAD( "gbp12", 0x0000, 0x0096e2, CRC(1901c60b) SHA1(d1c77b56b8ef3716efcd703c12c74c82b4d407b3) )
	ROM_LOAD( "gbpnlg01", 0x0000, 0x017ae2, CRC(9bd781c3) SHA1(7499e3767966955a6d09079a22324ae1a7a9551a) )
	ROM_LOAD( "grd01", 0x0000, 0x010ee2, CRC(2ceb7d40) SHA1(6d4360aeac6d13033f93b13e4e3d1d9626795bf3) )
	ROM_LOAD( "grd02", 0x0000, 0x00c6e2, CRC(49949463) SHA1(15875951c4bb17e90accd8031534df3bf11aa613) )
	ROM_LOAD( "grd04", 0x0000, 0x00aee2, CRC(d09f40a9) SHA1(72ddb78827cd9d710fb73ab512ad3fb8baa9d144) )
	ROM_LOAD( "grd05", 0x0000, 0x00c6e2, CRC(7aecbb2d) SHA1(6e59b66528a80c929e0ee3b7573c8b6d91eec80a) )
	ROM_LOAD( "grd06", 0x0000, 0x00c6e2, CRC(e2cd2081) SHA1(8a155e78fb6a4a755b14fb2afbf45087f8777de0) )
	ROM_LOAD( "huf01", 0x0000, 0x0096e2, CRC(b1520916) SHA1(d183b67d64ff0fbe7374d8a25686cf935d1ea36b) )
	ROM_LOAD( "huf02", 0x0000, 0x0096e2, CRC(c0120fe7) SHA1(8ca5a1fc20c06414bd0f02a052aa2ec97c40b451) )
	ROM_LOAD( "huf05", 0x0000, 0x0066e2, CRC(305fcd39) SHA1(9b700c5494349d8c0237eeae27190789f8cdc017) )
	ROM_LOAD( "huf06", 0x0000, 0x0066e2, CRC(c5e2e2c4) SHA1(b4448c714ab1f713566fe438a827a232aaf7458a) )
	ROM_LOAD( "huf07", 0x0000, 0x0066e2, CRC(4d75ec3c) SHA1(1f601a6c0437a14b217f5df7fe01cc62c0b5dc27) )
	ROM_LOAD( "idr01", 0x0000, 0x0066e2, CRC(143518d1) SHA1(68c9796b793f60f19d5f3df5776006f4290387ab) )
	ROM_LOAD( "iep01", 0x0000, 0x0096e2, CRC(4d3ef434) SHA1(829c3e09f2b69caeaf37c567d30b2921ace7bfc9) )
	ROM_LOAD( "iep02", 0x0000, 0x0066e2, CRC(dc9fe966) SHA1(c6342a998297b4bda4a0a662b17449f8f740bbde) )
	ROM_LOAD( "ils01", 0x0000, 0x00aee2, CRC(48bfd441) SHA1(f842fff7c00a1ba94ada3e977203c4246e18eb89) )
	ROM_LOAD( "itl01", 0x0000, 0x00aee2, CRC(0c2a6539) SHA1(a7cabc796def4c8563bb61ad071c6a4eee615409) )
	ROM_LOAD( "itl02", 0x0000, 0x00aee2, CRC(b063efa9) SHA1(e3b733bcd813ea31543d0368dddb5ceea29bef8c) )
	ROM_LOAD( "itl03", 0x0000, 0x007ee2, CRC(fccb2121) SHA1(9e1d5a73df3911ef3fd35b3f516d798d50019949) )
	ROM_LOAD( "itl04", 0x0000, 0x00aee2, CRC(d6722143) SHA1(89ce896153583e041489c8490da2907742087850) )
	ROM_LOAD( "itl05", 0x0000, 0x00aee2, CRC(b78cb39b) SHA1(32caf62d054300f8ab4d8894ba4425527206d976) )
	ROM_LOAD( "itl06", 0x0000, 0x007ee2, CRC(84362dbe) SHA1(a95d3e2553741c8ea758176d9864ac2db8f0f030) )
	ROM_LOAD( "itl07", 0x0000, 0x007ee2, CRC(fcf95162) SHA1(92e0a91d6d4f51ed780911c19c27568c1c87c6b6) )
	ROM_LOAD( "itl08", 0x0000, 0x0066e2, CRC(6d826af2) SHA1(54eee881997f0a518ea3ad3e762ed42fd3213b74) )
	ROM_LOAD( "itl09", 0x0000, 0x008ae2, CRC(1f28d83e) SHA1(cee015901480bfaa7b5cdb3e92238fb977159705) )
	ROM_LOAD( "itl10", 0x0000, 0x007ee2, CRC(3e19cea9) SHA1(748fc499cd46cb8343a376ca60c3f30bfd9755f0) )
	ROM_LOAD( "itlsit01", 0x0000, 0x0126e2, CRC(29a51c4c) SHA1(973c72f556d4106a55e241e381237dfae6bab90f) )
	ROM_LOAD( "jmd01", 0x0000, 0x0096e2, CRC(128a1311) SHA1(8ad084e5ce9f79583199796ccf631b945ca437ba) )
	ROM_LOAD( "jpy01", 0x0000, 0x004ee2, CRC(d0943ff0) SHA1(c3fd4120c748db5c85680ab1dfa71ca8ff66a9e7) )
	ROM_LOAD( "kwd02", 0x0000, 0x0096e2, CRC(08b017a0) SHA1(dc7417f094dc72d48687847d9a54c9fe793556bc) )
	ROM_LOAD( "lbp01", 0x0000, 0x0066e2, CRC(c4eb4154) SHA1(dd542e69726f27f9cc39f0b0c5e017c461359ee3) )
	ROM_LOAD( "mkd01", 0x0000, 0x0036e2, CRC(c10cf164) SHA1(f57ebf9a160683818c775fcfe41ac3777d4b18c2) )
	ROM_LOAD( "mxp01", 0x0000, 0x00f6e2, CRC(1a82436e) SHA1(e026c1f68d0910536a9b620e4491600330f90abf) )
	ROM_LOAD( "mxp02", 0x0000, 0x00c6e2, CRC(28e1e180) SHA1(f22fac0928c7c862f0b35365fb274bc2b1e4dc1c) )
	ROM_LOAD( "myr01", 0x0000, 0x00c6e2, CRC(48de91f7) SHA1(6e103a878b3104ffe64415c98689af73e3834ed2) )
	ROM_LOAD( "nlg01", 0x0000, 0x00d2e2, CRC(ba4854d4) SHA1(f260984222a85063ab58e27694b15b7ab11489c9) )
	ROM_LOAD( "nlg02", 0x0000, 0x008ae2, CRC(6f60d306) SHA1(1d8c4e0f27c6de0b0de45fa8765c2183dd1bd979) )
	ROM_LOAD( "nlgdem01", 0x0000, 0x00cce2, CRC(d8538012) SHA1(7a9b9f78335a0cb6858a8dbd2ffc0b5d787b77f6) )
	ROM_LOAD( "nok01", 0x0000, 0x004ee2, CRC(ba94554e) SHA1(69535dbe94ae605cf2cfd607dfb0fba4e00fb1a8) )
	ROM_LOAD( "nok04", 0x0000, 0x0036e2, CRC(b3e43d84) SHA1(29d65bcd79841a2af8f675145a041733daab2a83) )
	ROM_LOAD( "nok05", 0x0000, 0x004ee2, CRC(28280de4) SHA1(72d340548ea3cad2bf1a1d226514fc4fa47a7842) )
	ROM_LOAD( "nokdem01", 0x0000, 0x010ee2, CRC(ad201aa3) SHA1(bd79fc68bb23eebcdd917dd090b1447ae8bc8ba5) )
	ROM_LOAD( "nokdkk01", 0x0000, 0x00aee2, CRC(0a2a8b65) SHA1(b0973526a6bc79e4d75bee8c56b220edff1a3584) )
	ROM_LOAD( "nv4 2.67 1.77 37", 0x0000, 0x010000, CRC(8fe50b3f) SHA1(1d0b5ce215be7e4a50d3f3b743e0a066345a58db) )
	ROM_LOAD( "nv4x 52 377", 0x0000, 0x010000, CRC(7b8c5354) SHA1(e9770dabfacc006089448808cb29139679fbaa15) )
	ROM_LOAD( "nzd01", 0x0000, 0x0102e2, CRC(508e5edf) SHA1(9c653e01612c13c8dc194b18c42c45fe319cb56e) )
	ROM_LOAD( "omr01", 0x0000, 0x0036e2, CRC(6acb862c) SHA1(beb5edced779ea2ef9f56fe0e1bb8658af295f55) )
	ROM_LOAD( "pkr02", 0x0000, 0x00aee2, CRC(8aaa977e) SHA1(91e7736ed7d8dfe2a85417cf7ac704a42cd8ebf4) )
	ROM_LOAD( "plz01", 0x0000, 0x0066e2, CRC(c3892e74) SHA1(055fb702dccb3e8a88c917ac04c535eda03b2cef) )
	ROM_LOAD( "plz02", 0x0000, 0x004ee2, CRC(64740a69) SHA1(0658ea26f83d19cbf4d94a21d67be73c45f66760) )
	ROM_LOAD( "pte01", 0x0000, 0x007ee2, CRC(f171555e) SHA1(e7f9cbbcac1130b853ceea043ce4227eff53e3f3) )
	ROM_LOAD( "qar01", 0x0000, 0x0096e2, CRC(fc26cddb) SHA1(8e6c8a56ef0e539ba05fbb0341647193423549ff) )
	ROM_LOAD( "qar02", 0x0000, 0x007ee2, CRC(7db9fd07) SHA1(ada30c5c55c3ce2f0ba978474acfb39c7c91ba6f) )
	ROM_LOAD( "qar03", 0x0000, 0x005ae2, CRC(fc84bffc) SHA1(339ded907866cda4a321663393fe9972c16d26b6) )
	ROM_LOAD( "qar04", 0x0000, 0x005ae2, CRC(e71bc66b) SHA1(3507d0b287c6fe86ce77175ea74569301b054997) )
	ROM_LOAD( "qar05", 0x0000, 0x001ee2, CRC(104993ba) SHA1(3803ee587a572c402d0bdb2f378d8aa5ccc0010d) )
	ROM_LOAD( "rol01", 0x0000, 0x00dee2, CRC(f0f17bc8) SHA1(21d2d29cec6ad6a62712e36933a8145a8c01d0fc) )
	ROM_LOAD( "rol02", 0x0000, 0x0096e2, CRC(056d9fa2) SHA1(4a221d873d4f35c1fdaa39390c94e57b4c3e3a91) )
	ROM_LOAD( "rol03", 0x0000, 0x00aee2, CRC(6dc062c5) SHA1(9849161eef3fccc8a0fbe0c817c5aea30ac0fd34) )
	ROM_LOAD( "rol04", 0x0000, 0x0096e2, CRC(f994e19e) SHA1(c8e2134b0667ae369d8e148dd47a20cdf5683e2c) )
	ROM_LOAD( "rol05", 0x0000, 0x0066e2, CRC(8685ad64) SHA1(018e2c05cbbc4c377eaad9b6fc5b57be65705095) )
	ROM_LOAD( "rur01", 0x0000, 0x00f6e2, CRC(35bc7845) SHA1(319788697449d9c9cab1ca44773cd9a66b042420) )
	ROM_LOAD( "sar01", 0x0000, 0x00dee2, CRC(dbc0380d) SHA1(a4b6518a8f606c32816557e076b36052635c1111) )
	ROM_LOAD( "sar03", 0x0000, 0x004ee2, CRC(5ff7887b) SHA1(a48279977b430b203769505a3e2e1a81bc04f5e4) )
	ROM_LOAD( "sar04", 0x0000, 0x004ee2, CRC(36f56733) SHA1(1415ad1d96db23dceeacf5a1c192cb4c2a86e527) )
	ROM_LOAD( "sar05", 0x0000, 0x00c6e2, CRC(eb1229c4) SHA1(cf197b4e2601f7fa95054628c87de54f3a049114) )
	ROM_LOAD( "saregp01", 0x0000, 0x00d8e2, CRC(d9963f25) SHA1(20a224351a23cbfd87ea6f2cad3e6f94733c795e) )
	ROM_LOAD( "sek01", 0x0000, 0x00dee2, CRC(5a255f5b) SHA1(ebd25b2463d3fd5ff97a1aac1e7f64f726e59912) )
	ROM_LOAD( "sek02", 0x0000, 0x00aee2, CRC(f9afc549) SHA1(e5d1f173d863b17609b4810ff872c925a2e5750c) )
	ROM_LOAD( "sekdem01", 0x0000, 0x00c6e2, CRC(630a4d5c) SHA1(1c2236063b4c2221148def18e8e512d4c8482c58) )
	ROM_LOAD( "sekdkk01", 0x0000, 0x00dee2, CRC(d8f39097) SHA1(337dd12a4ddfe7a0dca1bb7fc1227c203095b505) )
	ROM_LOAD( "sekgbp01", 0x0000, 0x00dee2, CRC(3a8697ac) SHA1(6610caee5d8e9b9f17b3a439ab0bbc9a4375f818) )
	ROM_LOAD( "sekplz01", 0x0000, 0x0096e2, CRC(776380fe) SHA1(b1f4dcbcb42f14ce291ff97c8d8ecd3a708748bf) )
	ROM_LOAD( "senogb01", 0x0000, 0x0156e2, CRC(dcf837f0) SHA1(c47f23886bbe11426bf136594f1f898034e89e2b) )
	ROM_LOAD( "sgd01", 0x0000, 0x010ee2, CRC(4a8316db) SHA1(b67e01d90a346f1a458947501e8b5329b2b69d6d) )
	ROM_LOAD( "sit01", 0x0000, 0x00aee2, CRC(6987dcfe) SHA1(cfd8ba5fc4b79a3870e7a953d8d17ad80505aa84) )
	ROM_LOAD( "sit02", 0x0000, 0x0066e2, CRC(ebac5fe9) SHA1(ff6c0351b07817d47b2905b56b320c85b4cfe7db) )
	ROM_LOAD( "sit03", 0x0000, 0x007ee2, CRC(ad82f79c) SHA1(fba4812364f335283d85d98e4d8f0e743a06a73e) )
	ROM_LOAD( "sit04", 0x0000, 0x004ee2, CRC(c3093338) SHA1(a5ebe26481c466d5804617af0f6336ea8a8b32f9) )
	ROM_LOAD( "sit05", 0x0000, 0x0096e2, CRC(c0e9ca0a) SHA1(d930efb7d97f30505caf8d62a6b68229f0b96afa) )
	ROM_LOAD( "sit06", 0x0000, 0x0066e2, CRC(cda230f5) SHA1(21b35f2c84bafc9e8db3db2f35d32c959e544d64) )
	ROM_LOAD( "sit07", 0x0000, 0x007ee2, CRC(151314a9) SHA1(fd38f4671127c09f0bfbc3d881bcedd8b4ce8b08) )
	ROM_LOAD( "sit08", 0x0000, 0x0066e2, CRC(73be12c7) SHA1(dd0ae3b175747101d60b7237e3661a0e974cedad) )
	ROM_LOAD( "skk02", 0x0000, 0x0066e2, CRC(786a4611) SHA1(d544bb42bcaa53aa2f806e216b1c11659eb58b41) )
	ROM_LOAD( "skko1", 0x0000, 0x007ee2, CRC(d496d44c) SHA1(6d4fabc04af356715fc8dc734416ef8a12ef5543) )
	ROM_LOAD( "tlb01", 0x0000, 0x00dee2, CRC(a3017a9c) SHA1(dd01c2c17b546985cf99a4487e1c05171607dd61) )
	ROM_LOAD( "trl01", 0x0000, 0x00dee2, CRC(e3c95c1f) SHA1(b1d4de10320b7966f598045aeb1c6c1acd304f58) )
	ROM_LOAD( "trl02", 0x0000, 0x00aee2, CRC(583f6a98) SHA1(9a257f2ec82206ed0c97b477078ca85ade661389) )
	ROM_LOAD( "trl03", 0x0000, 0x0096e2, CRC(c2875ac0) SHA1(a4f3db63beae552dd21086daa044945c4c2f5182) )
	ROM_LOAD( "trl04", 0x0000, 0x007ee2, CRC(57e953a4) SHA1(5b0b778900e2f5f46e9b883f04bedc42b3c0ab85) )
	ROM_LOAD( "trl05", 0x0000, 0x004ee2, CRC(8996ee7a) SHA1(23191ece0dcf1ca864bbf71862ed68cfbe3b84f4) )
	ROM_LOAD( "uad01", 0x0000, 0x00dee2, CRC(379d1f3c) SHA1(91b6a18e358f10dcf7702ffedcb595bcb7bcb654) )
	ROM_LOAD( "uah01", 0x0000, 0x0096e2, CRC(34b182b1) SHA1(7b2db880d7a25e06717c12db42db2f12cd474aeb) )
	ROM_LOAD( "uyp01", 0x0000, 0x00c6e2, CRC(73910f85) SHA1(8d191302d55f6f9247adf9add25b0df80798f362) )
	ROM_LOAD( "veb01", 0x0000, 0x00c6e2, CRC(c3139d53) SHA1(274f80094682a041887ee8cade48ee76d6467950) )
	ROM_LOAD( "zar03", 0x0000, 0x00f6e2, CRC(96a2a431) SHA1(7817bd3d53d62d6253068b2a14189a56d019dbc0) )
	ROM_LOAD( "zwd01", 0x0000, 0x0066e2, CRC(d1897ea7) SHA1(1824d4e765216b5a1d62bcff70574dbebaf30c1d) )
// Quintoon (Bellfruit)
	ROM_LOAD( "95750231.bin", 0x0000, 0x010000, CRC(1227367f) SHA1(b6249db6b3a814fed1cf11713b70a17be8d6e3d0) )
	ROM_LOAD( "qublcy351rp.bin", 0x0000, 0x080000, CRC(bd6b0c8b) SHA1(a79626de03e5e432f81eb93ff2dc38a7510733ba) )
// Rhythm & Blues (JPM)
	ROM_LOAD( "rhythm_&_blues1.1", 0x0000, 0x01681e, CRC(d7092860) SHA1(765621bd4c487ff20cccd70c6d2d514109cb83c4) )
	ROM_LOAD( "rhythm_&_blues1.2", 0x0000, 0x01681e, CRC(1fc40a07) SHA1(2d8f50fc1f01fcdc737c42608c98d4b6abccb3c1) )
// Scrabble (JPM)
	ROM_LOAD( "scravfp1", 0x0000, 0x080000, CRC(e1941639) SHA1(ae8e5428eb28edba5bd25f496479d8e3e9b00d86) ) //Ver F. same as we already have?
// Terrance & Phillip (Bootleg)
	ROM_LOAD( "terranceandphillipsound.bin", 0x0000, 0x04fcc3, CRC(f614112e) SHA1(a628d785bb9e8e3747b1f55be3b23eca0dd058ab) )
// Thriller (JPM)
	ROM_LOAD( "thriller_2.1", 0x0000, 0x01681e, CRC(bff1defe) SHA1(83f95c7448ea2023bf640b59570b852c70c0ca08) )
// Treble Top (Bellfruit)
	ROM_LOAD( "ttpcob.pa", 0x0000, 0x010000, CRC(391181d4) SHA1(42c499ae78f38ccfec572701b3c99b7cf200ff98) )
// zzz_unk 004 (Unk)
	ROM_LOAD( "nolabel.rom", 0x0000, 0x000800, CRC(273a140c) SHA1(ea4962e1c9aa3e593b8d5b2b3eed1b791cda74a6) )
// zzz_unk 326s (Project)
	ROM_LOAD( "326-s-01.001", 0x0000, 0x080000, CRC(5a23e17e) SHA1(e664da5213ca572288193101e4a33ac8bc3d553b) )
// zzz_unk cmz (Barcrest)
	ROM_LOAD( "cmzic10", 0x0000, 0x080000, CRC(2a66564c) SHA1(52665fbc88a1e3e0fa2dfd1d846c99c1f8055bd8) )
	ROM_LOAD( "cmzic9", 0x0000, 0x080000, CRC(5db969e0) SHA1(768ba1dbf014d8efceb9c63aeb0edd107c5753de) )
// zzz_unk fred (Barcrest)
	ROM_LOAD( "fred.bin", 0x0000, 0x000c1b, CRC(cf46223b) SHA1(dcf5d0c310b8ccc2783d4d7a80ce496d7ecd0d56) )
// zzz_unk lahroc5 (Electrocoin) - Last Action Hero (Data East Pinball)
//  ROM_LOAD( "lahroc5", 0x0000, 0x010000, CRC(94102fdd) SHA1(b741fe7a646225351148f5e675bd232881730221) )
// zzz_unk pgsnd (Maygay)
	ROM_LOAD( "pgsnd", 0x0000, 0x080000, CRC(c1d5a1f1) SHA1(8b7ded8aa4a84310d08c1438d0d91a28e1d95a21) )
// zzz_unk sil (Barcrest)
	ROM_LOAD( "sil", 0x0000, 0x002000, CRC(1f8a48d2) SHA1(143c2474af9469a753bbf0e82e8e6f4f88e4d38f) )
	ROM_LOAD( "sil.p4", 0x0000, 0x002000, CRC(72f49fe9) SHA1(d6bb31d830fe125912e73cfcdc6b4e32027c45cc) )

	ROM_REGION( 0x800000, "astra", 0 ) // these are clearly astrafr.c sets
// zzz_unk pbm (Unk)
	ROM_LOAD( "pbmv0-06.u1", 0x0000, 0x080000, CRC(d0283320) SHA1(472f0e0dd45da61081ca12e466ac02dc82eb4431) )
	ROM_LOAD( "pbmv0-06.u2", 0x0000, 0x080000, CRC(38fb2ff6) SHA1(628dcdcbf4767db62b4bdee7b7feff32715e6a2d) )
// zzz_unk pbs (Unk)
	ROM_LOAD( "pbs0-06d.u1", 0x0000, 0x080000, CRC(f24e84d2) SHA1(d54e787c91c79a26383971249f935529e2a492f4) )
	ROM_LOAD( "pbs0-06g.u1", 0x0000, 0x080000, CRC(937af673) SHA1(88f33fd3921440a99b662fec7291c8b9845210a5) )
	ROM_LOAD( "pbsv0-06.u1", 0x0000, 0x080000, CRC(fbb51b61) SHA1(c1459f8f2d9f182e5be55bbcaf143315f7efc3b0) )
	ROM_LOAD( "pbsv0-06.u2", 0x0000, 0x080000, CRC(2f0934de) SHA1(915a16898087f396457d712e3847f4f7c0bd5c06) )
// zzz_unk pgm (Unk)
	ROM_LOAD( "pgm0-04.u1", 0x0000, 0x040000, CRC(2885367c) SHA1(c33cb554889b1f7390baa416a77953f45a80044f) )
	ROM_LOAD( "pgm0-04.u2", 0x0000, 0x040000, CRC(c5eed515) SHA1(9b832a6ef301a25bccf2d97cca0c9a012ca0090a) )
	ROM_LOAD( "pgm1-00.u1", 0x0000, 0x040000, CRC(1fa4e10f) SHA1(787ec967a9aba5934db79fe67efb32370d2c0258) )
	ROM_LOAD( "pgm1-00.u2", 0x0000, 0x040000, CRC(8b5a6178) SHA1(e1f9898ef37877ce50630a468b3c187a4fe253fa) )
// zzz_unk pgs (Unk)
	ROM_LOAD( "pgs0-04d.u1", 0x0000, 0x040000, CRC(1f5ede2c) SHA1(ac67536a021b531efe18027806f1f86504d72493) )
	ROM_LOAD( "pgsv0-04.u1", 0x0000, 0x040000, CRC(cb3387be) SHA1(2add224a8839e83cc04901274acc7ca4a781b7d9) )
	ROM_LOAD( "pgsv0-04.u2", 0x0000, 0x040000, CRC(63054bd6) SHA1(59cf8dd7efdaf2491a2aca8fbcda2d3b8b70fbf7) )
	ROM_LOAD( "pgsv1-00.u1", 0x0000, 0x040000, CRC(725dd2af) SHA1(f8ecd1282809c0906497c62a68429152c10e2da0) )
	ROM_LOAD( "pgsv1-00.u2", 0x0000, 0x040000, CRC(067dd0c2) SHA1(ac36aeb63b33969dc0a49150e41bfdd8624072de) )
	ROM_LOAD( "pgsv100d.u1", 0x0000, 0x040000, CRC(a6308b3d) SHA1(125ed244bcb7a515dfc9c34c12bc74f8cd50e8dd) )
// zzz_unk ptm (Unk)
	ROM_LOAD( "ptmv0-02.bin", 0x0000, 0x080000, CRC(e9dd8674) SHA1(ace543bc7fea8d09661e76c1ade4e1f27db5a116) )
	ROM_LOAD( "ptmv1-04.bin", 0x0000, 0x080000, CRC(32af5358) SHA1(bd61c396824bb2b6845126162c4ff797564ebdf2) )
	ROM_LOAD( "ptmv1-13.bin", 0x0000, 0x080000, CRC(4f321735) SHA1(3f9b0b64c42011d948291cd774a922393793a4b1) )
// zzz_unk ptp (Unk)
	ROM_LOAD( "ptp003d.u1", 0x0000, 0x100000, CRC(2b2c05b6) SHA1(541a53c84c07bd7e1f09d4d033cf652ab838b4ef) )
	ROM_LOAD( "ptp003g.u1", 0x0000, 0x100000, CRC(d9d0e151) SHA1(35fb4412602b9fd3b66e7170cc1984693b9c9ebd) )
	ROM_LOAD( "ptpv003.u1", 0x0000, 0x100000, CRC(07c189da) SHA1(c4574cdedba87058312db84c6ee7f4a7142eea65) )
	ROM_LOAD( "ptpv003.u2", 0x0000, 0x100000, CRC(e1f78cf4) SHA1(5f72b2604fd7ee300f6bd5b5a12d98c77b03b9ba) )
// zzz_unk pts (Unk)
	ROM_LOAD( "pts1-04d.bin", 0x0000, 0x080000, CRC(95564b9f) SHA1(98091d4badd346578882db75a8d72ddaa810b3f5) )
	ROM_LOAD( "pts1-13d.bin", 0x0000, 0x080000, CRC(876232cf) SHA1(5d2355f85bde636dcb6f3dbd87874294db8e1ded) )
	ROM_LOAD( "ptsv0-02.bin", 0x0000, 0x080000, CRC(3cc9c022) SHA1(1eb3c237971cf407057d077fd08e4436c765ae43) )
	ROM_LOAD( "ptsv1-04.bin", 0x0000, 0x080000, CRC(9cadd42c) SHA1(e6ead7112195a17797672112c7bbd4910ae6eb50) )
	ROM_LOAD( "ptsv1-13.bin", 0x0000, 0x080000, CRC(8e99ad7c) SHA1(d4cfce825b4a718a12d80e79ed943797c6510ad6) )
// zzz_unk joker (Unk)
	ROM_LOAD( "joker03.u1", 0x0000, 0x080000, CRC(a3dd15e8) SHA1(95d04de6c991b3c1ff43b0f477f03213e83f63f2) )
	ROM_LOAD( "joker03.u2", 0x0000, 0x080000, CRC(57b3305a) SHA1(c38bc7db6c9a3f8f5371bb4c555333404fed6a9f) )
	ROM_LOAD( "jokr03d.u1", 0x0000, 0x080000, CRC(aa268a5b) SHA1(cce89dbaaaf2d44daf127de1ad6d621c46d892fc) )
	ROM_LOAD( "jokr03g.u1", 0x0000, 0x080000, CRC(cb12f8fa) SHA1(7a9c9fe72b70fe1b4a3be2edfde9d7a54d7a8219) )
// zzz_unk hog0-03 (Unk)
	ROM_LOAD( "hog0-03.u1", 0x0000, 0x080000, CRC(eaa26ab0) SHA1(ee7d76b92c3274ba8c5ba59184bb3334fbbc64c4) )
// zzz_unk jjrv102 (Unk)
	ROM_LOAD( "jjrv1-02.u1", 0x0000, 0x080000, CRC(0f05e392) SHA1(64c885c92fb26c0ed64b8283793cdf86d2bc0e35) )
	ROM_LOAD( "jjrv1-02.u2", 0x0000, 0x080000, CRC(1d86f26c) SHA1(e7db51b217e9fb8a0440b7c7591c5ea4142540bc) )
// zzz_unk jst (Unk)
	ROM_LOAD( "jst0-05.u1", 0x0000, 0x080000, CRC(38f2d7b0) SHA1(11ccb5b5a35e43f505a7d3ebc36a0694111fed11) )
	ROM_LOAD( "jst0-05.u2", 0x0000, 0x080000, CRC(97c14933) SHA1(8515601fbacf76a78a95e4a46a47809fcec021bc) )
	ROM_LOAD( "jst0-05d.u1", 0x0000, 0x080000, CRC(31094803) SHA1(b7b5fd97681c38de5e877ca7b09909c82316d4d8) )
	ROM_LOAD( "jst0-05g.u1", 0x0000, 0x080000, CRC(503d3aa2) SHA1(818e79126ca8ae6bbd1eaac2ae13977b3402f497) )
	ROM_LOAD( "jst0-06.u1", 0x0000, 0x080000, CRC(b6106ca4) SHA1(dedeeff6e8c13da1f62e882cbeb36567a631e563) )
	ROM_LOAD( "jst0-06.u2", 0x0000, 0x080000, CRC(49a78695) SHA1(af99df8c97a8c3bcb5a81a38b985e1fc92176927) )
	ROM_LOAD( "jst0-06d.u1", 0x0000, 0x080000, CRC(bfebf317) SHA1(7f1a2a8e3f3de6a03452f535d2c314810bc652da) )
	ROM_LOAD( "jst0-06g.u1", 0x0000, 0x080000, CRC(dedf81b6) SHA1(0579501c939eacb93d1455eaf74b629c2170b05b) )
// zzz_unk l7 (Unk) [Rom] LUCKY 7 ASTRA
	ROM_LOAD( "l7v1-03.bin", 0x0000, 0x080000, CRC(878d1a3d) SHA1(fd7cb08f698bb6bbfed1c57486e53dce062d22e4) )
	ROM_LOAD( "l7v1-03d.bin", 0x0000, 0x080000, CRC(91a81e50) SHA1(6086861bd5a53fa17df8b155acd47e9aa45a032d) )

ROM_END


// despite being in an 'EPOCH' roms zip, most of this stuff clearly isn't EPOCH - sort it, place it.
ROM_START( unkfra )
	ROM_REGION( 0x200000, "maincpu", 0 )
	//ROM_LOAD( "abt1.7", 0x0000, 0x020000, CRC(2eaaec99) SHA1(d993f8bd2ba286aa64c13e1520d702955e702b95) ) bad
	//ROM_LOAD( "blackjak.p1", 0x0000, 0x020000, CRC(31660bf5) SHA1(225c8ef7138b642cbf07a0cb8a575b1e768463ca) ) bad
	//ROM_LOAD( "blackjak.p2", 0x0000, 0x020000, CRC(cacfcadb) SHA1(b6af22664abffe853007a6fa62631431220f46ac) ) bad
	ROM_LOAD( "buble&sq.go", 0x0000, 0x080000, CRC(b05323f5) SHA1(290d7716cb61f6788d052611d662575ffdcfd55a) ) // it's not bubble & squeak?
	ROM_LOAD( "cash_box.p1", 0x0000, 0x020000, CRC(2978eca5) SHA1(372e010404c4af2e905215e23ad9c8d1cf6314a3) )
	ROM_LOAD( "cstreet.swp", 0x0000, 0x080000, CRC(8e2c6d7f) SHA1(835cb7bf51260d0ba732e6b3895f77bef25a1fb4) )
	ROM_LOAD( "c.fas", 0x0000, 0x080000, CRC(e942c4bc) SHA1(9833f4b8c418d51bdab851602162811d1ebb6956) )
	ROM_LOAD( "fesnd1", 0x0000, 0x080000, CRC(d2dab810) SHA1(daa26821ad31a81e714a2ddcc0a467a60d650ed3) )
	ROM_LOAD( "fe_p_std.hi", 0x0000, 0x080000, CRC(c38a1263) SHA1(5431c9b9c000a184f4753b4aa05e037c2d3bfa46) )
	ROM_LOAD( "fruitopi.lo", 0x0000, 0x080000, CRC(da9d5edb) SHA1(249445a5193b04490641a0498f577cb2be69c0dd) )
	//ROM_LOAD( "gia_gems.p1", 0x0000, 0x080000, CRC(c841d2f7) SHA1(480397141c917bce26cfdc8ba7fa8d21ab741770) ) bad
	//ROM_LOAD( "gia_gems.p2", 0x0000, 0x080000, CRC(7824adf5) SHA1(99b59d28adb80d5cf3d70691cc134eba72288f20) ) bad
	ROM_LOAD( "gimme_st.p1", 0x0000, 0x080000, CRC(d5df19b3) SHA1(3efdff2894f6edcae1121a63c654b7d58bd378c0) )
	ROM_LOAD( "h hop.p1", 0x0000, 0x080000, CRC(71c3549f) SHA1(7b98acd3ce9d72dbbef573330d3206d9af60c15e) ) // bad? (looks like fixed bits in places)
//  ROM_LOAD( "hbrk_hot.txt", 0x0000, 0x0000ff, CRC(c95eecc8) SHA1(fd3e5658028ab39622e761445d72ed110da3e091) )
	ROM_LOAD( "jc5p_pound5", 0x0000, 0x020000, CRC(cf1d708e) SHA1(df0188b6d66763a91ae153821f6e12b9df391146) ) // mpu4
	ROM_LOAD( "jungle.s2", 0x0000, 0x080000, CRC(df59d976) SHA1(b3a11b19228487eec36118a0ef72db15b743db80) )
	//ROM_LOAD( "jewel s", 0x0000, 0x000001, CRC(38d7a8b4) SHA1(999a0a8cad102eb519ca788d6e0cd48ee9e6ca3e) )
	ROM_LOAD( "jpoter.p1s", 0x0000, 0x080000, CRC(56aec852) SHA1(df6b35176dadc6f2b7736a2557b9af254a1e4dd2) ) // sc5
	ROM_LOAD( "jpoter.p2_", 0x0000, 0x080000, CRC(032ebbf5) SHA1(ed21f30e02826c629d0c3bfbec332aeb9a6266a9) ) // sc5
//  ROM_LOAD( "ra_cd100.3_6", 0x0000, 0x020000, CRC(4cc8cf79) SHA1(8eb51e0f6c0f66d155f9b325ee02a313f1f3a525) ) // cd100 jukebox?
	ROM_LOAD( "wb_v22", 0x0000, 0x002000, CRC(bd02c9c8) SHA1(044024ce40668397e9ca2ea3ec4f68d05fd20bd0) )

	// these look like astra/pluto
	ROM_LOAD( "ldeven", 0x0000, 0x040000, CRC(179505b4) SHA1(2c80a5289f8945eba222d3daa29a1ecca26aae0c) )
	ROM_LOAD( "ldodd", 0x0000, 0x040000, CRC(9611a17f) SHA1(06199f2f8660162ce4157e07927406b4046d8457) )
	//ROM_LOAD( "sldodd", 0x0000, 0x040000, CRC(9611a17f) SHA1(06199f2f8660162ce4157e07927406b4046d8457)
	ROM_LOAD( "sldeven", 0x0000, 0x040000, CRC(cbd08464) SHA1(d7b6397b597d05efcffc5ed975723f07b794a1f5) )

	ROM_LOAD( "legion.sn1", 0x0000, 0x080000, CRC(782827cd) SHA1(0f5aeba70e639549376c5df9146fe6a9c58396d5) )
	ROM_LOAD( "mon_60.p1", 0x0000, 0x020000, CRC(ddb30a35) SHA1(c225995fe41f76d32d101cc91dcfa9c3d0e9aa02) )
	ROM_LOAD( "manic st.p2", 0x0000, 0x080000, CRC(ab8afc46) SHA1(39b75bf5e623458f256966458918a1f90b138c13) ) // manic streak features alt dump?
	ROM_LOAD( "monty_p.p3", 0x0000, 0x080000, CRC(f4b034b0) SHA1(ef055a42414008f7ef2d9aad25fccd7d2c57b656) ) // monty python alt?
	ROM_LOAD( "monswp1v", 0x0000, 0x080000, CRC(263f7e39) SHA1(2f554454df10b6da90cee2b1c851272d5734b644) )
	ROM_LOAD( "monswp2v", 0x0000, 0x080000, CRC(2189f360) SHA1(b28024203c4655622587c9bc7d0b49472be2c1d9) )
	ROM_LOAD( "monswp3v", 0x0000, 0x080000, CRC(3577c3b9) SHA1(3194d11dcdc39e82fa0098065e7ec3eec4f6f944) )
	ROM_LOAD( "monswp5v", 0x0000, 0x080000, CRC(1bb26415) SHA1(7f59e1aeceb9959c7ef26285648b148c2c5c3671) )
	ROM_LOAD( "monswp6v", 0x0000, 0x080000, CRC(5797e892) SHA1(261ae31cdd3b666bc759244c8d27e82dc52153c6) )
	ROM_LOAD( "monv4p1", 0x0000, 0x080000, CRC(3c689a59) SHA1(e7deb992db1d406a5626c51c270ab7285a62b535) )

	ROM_LOAD( "note vat", 0x0000, 0x020000, CRC(b77c8f48) SHA1(5c52c156227152f6b38dea47b8a3edf241c923e0) ) // sound
	ROM_LOAD( "note.vat", 0x0000, 0x020000, CRC(7885311a) SHA1(f139399f0829da389e935519148e5ba1c064e34e) ) // 68k code (jpm) (missing other rom?)

	ROM_LOAD( "noonshin.g1", 0x0000, 0x080000, CRC(b2c5f80b) SHA1(4ec7b0bd758ddad88315021ed746aec35fa688b7) ) // moonshine club?
	ROM_LOAD( "phoenix.hi", 0x0000, 0x080000, CRC(f23ae723) SHA1(9a4bbe9d305f7a24ee71216270d98e5830630c63) )
	ROM_LOAD( "phoenix.lo", 0x0000, 0x080000, CRC(793350ce) SHA1(888be3c3e4711750c5102a6a4a19fd0458462444) )
//  ROM_LOAD( "pick.p2", 0x0000, 0x080000, CRC(cb170a74) SHA1(913914dcfa9c94f6e6d6d0aae6e0ba98cdcb66ce) ) bad
//  ROM_LOAD( "pick_pac", 0x0000, 0x080000, CRC(c1127969) SHA1(ea72b90591df2398efbdeb55520b0fde5dd4e5a0) ) bad
	ROM_LOAD( "rc_club.p1", 0x0000, 0x020000, CRC(5bf41b92) SHA1(48f85ef7352d75a7f9e9c7a9e01408b2a00b0053) ) // impact
	ROM_LOAD( "rc_club.p2", 0x0000, 0x020000, CRC(e790dda8) SHA1(5564626e3235bad8048e8be00ca7a5a7798b236e) ) // impact
	ROM_LOAD( "redalert.p1", 0x0000, 0x020000, CRC(ff5952b2) SHA1(c4fd40d9eae05f80497f312b85bc97c88a0c3502) )
	ROM_LOAD( "side split.lo", 0x0000, 0x080000, CRC(89e97aee) SHA1(1e0a21b9cdd049a1ed7bfd2216c9b9789ff103a2) )
	//ROM_LOAD( "side spl", 0x0000, 0x080000, CRC(89e97aee) SHA1(1e0a21b9cdd049a1ed7bfd2216c9b9789ff103a2) )
//  ROM_LOAD( "smg1", 0x0000, 0x080000, CRC(6dc368c5) SHA1(afc65e5ceefadf794b53bd073d483e4616b9cb34) ) // bad? (crystal maze rom, paired with cry.p4)
	ROM_LOAD( "s_night.lo", 0x0000, 0x080000, CRC(65f8fa73) SHA1(59bc4ca637615a4e4b3ca7750a9257632ce3a31b) )
	//ROM_LOAD( "s_tonic.p4", 0x0000, 0x000001, CRC(ff000000) SHA1(85e53271e14006f0265921d02d4d736cdc580b0b) )

	ROM_LOAD( "upov03.p2", 0x0000, 0x080000, CRC(8601a331) SHA1(b5caddd15ccd140e28eba1ae44e7d944e37ccbb3) ) // Up and Over, missing the rest of v3

	// looks like a pluto style decode, but isn't (text is corrupt).. might just be bad
	ROM_LOAD( "winamil.p1", 0x0000, 0x020000, CRC(c23539e9) SHA1(1fb5ea2a4ffe8eda890c580329471c5ec820c4ca) )
	ROM_LOAD( "winamil.p2", 0x0000, 0x020000, CRC(a2e12e68) SHA1(6abdf37a48ee8fa4728dcc6553b6e5d8f834620a) )


	ROM_REGION( 0x200000, "palsetc", 0 )
	ROM_LOAD( "gsg", 0x0000, 0x000b94, CRC(31a65a15) SHA1(97508a3334a72e1c44719421adecefe7845bf2fe) )
	ROM_LOAD( "_pound15gold", 0x0000, 0x000bd8, CRC(b44d0b28) SHA1(b2546d8cb1b22ba532f7de15a559e27349df2b4b) )
	ROM_LOAD( "_pound15_key", 0x0000, 0x000b99, CRC(3baa0343) SHA1(3ba6ddc35d47caa7852fb9eb72e385526d5f5cf0) )
	ROM_LOAD( "_pound15_pic", 0x0000, 0x000400, CRC(9bdab7e2) SHA1(a65915c3d7e836c6952680fa1b5276b432718c62) )
	ROM_LOAD( "cjgerm", 0x0000, 0x000ad1, CRC(9a2a4ca7) SHA1(09864d7f1fa606b18d7bfb427f936911e8f3988c) )
	ROM_LOAD( "hrpal", 0x0000, 0x000b99, CRC(386ae20f) SHA1(5768d2340357cdcacebf80911665a8c3052486bf) )
	ROM_LOAD( "hvpal", 0x0000, 0x000b99, CRC(fd99d539) SHA1(affd72faa6037dbbf6884f9490427cd1d97ff515) )
	ROM_LOAD( "pal16v8", 0x0000, 0x000b99, CRC(aabffecc) SHA1(926cc4e995715b95e0de90da2a9d98ef4da94f4a) )
	ROM_LOAD( "pinball", 0x0000, 0x000b99, CRC(e59fb17f) SHA1(0150b4f123a0ac622a99ee2e518e9fde15b96c21) )
	ROM_LOAD( "rhpal", 0x0000, 0x000b99, CRC(a6ccb2fe) SHA1(800c785c400df808bfb6bf6fd72faf2d6e7bcbaf) )
	ROM_LOAD( "sndpal", 0x0000, 0x000ad1, CRC(d8a9f9b9) SHA1(0709364647c9812cea97e95dbf82983aa73c4f22) )
	ROM_LOAD( "sound pa", 0x0000, 0x020000, CRC(896323a2) SHA1(62d458de02e0901f5d0abf5622b6f13e4de63c77) )
	ROM_LOAD( "sound.pal", 0x0000, 0x000ac2, CRC(e2946d39) SHA1(72c806213dc713bfcc2b80cc0ae5f19174149645) )
	ROM_LOAD( "vv.pal", 0x0000, 0x000b99, CRC(6bf0d1d6) SHA1(416cb32909b1b2ffdbd4b495ebceb4970680da9b) )
	ROM_LOAD( "wtapal", 0x0000, 0x000b99, CRC(1faada64) SHA1(9f04c503ea10935a888ad1cc5fa2f81ef84000a3) )
	ROM_LOAD( "age.gal", 0x0000, 0x000b99, CRC(6f1113cd) SHA1(365ffc6fe91f6f54a00ee4c764478a120f4a39a0) ) //Andy's Great Escape?
	ROM_LOAD( "nwpal", 0x0000, 0x000b99, CRC(6f1113cd) SHA1(365ffc6fe91f6f54a00ee4c764478a120f4a39a0) )
	ROM_LOAD( "1-153", 0x0000, 0x000b96, CRC(95624748) SHA1(3be008f5232b6f35b6b897784d47ba060584c4ad) )

	ROM_REGION( 0x200000, "snd", 0 )
	ROM_LOAD( "r_rich.s0", 0x0000, 0x080000, CRC(75b98d09) SHA1(f81b3b9d8aa4b9730a4ea197a30760f3f331713e) )
	ROM_LOAD( "r_rich.s1", 0x0000, 0x080000, CRC(701615a7) SHA1(b426c5bff4f172241371a9fb6be3bd021f703004) )
	ROM_LOAD( "r_roul.snd", 0x0000, 0x080000, CRC(8897f543) SHA1(8964f35e1df3ea95f74cea55536f4d0aeed16dcd) )
	ROM_LOAD( "jolly r.s0", 0x0000, 0x080000, CRC(8d30786a) SHA1(270a138895ba99a32bc165e1f1ccf2faaa84e75b) )
	ROM_LOAD( "jolly r.s1", 0x0000, 0x080000, CRC(11270f30) SHA1(6ea10d60c50359e73f543f5c6c8f86e32c1bf185) )
	//ROM_LOAD( "showspec", 0x0000, 0x080000, CRC(98a3dff2) SHA1(1f56ec3237559105131de74a71b30592c346c680) )//Almost certainly bad copy of stspec
	ROM_LOAD( "skillga~.snd", 0x0000, 0x080000, CRC(a28cb082) SHA1(5b2b5dab1c11751b469ad22f8cad80d38c445cd5) )
	//ROM_LOAD( "tttsnd1", 0x0000, 0x080000, CRC(9d1a878f) SHA1(54c84790edc2b57af3d963f0b4ad99d956ec48e4) )
	ROM_LOAD( "ticttoes", 0x0000, 0x080000, CRC(9d1a878f) SHA1(54c84790edc2b57af3d963f0b4ad99d956ec48e4) )
	ROM_LOAD( "triplgol.s0", 0x0000, 0x080000, CRC(cb9da972) SHA1(8c50049aaa194fbf54dc35ba997246486f33c2fb) )
	ROM_LOAD( "triplgol.s1", 0x0000, 0x080000, CRC(5661665b) SHA1(74123be9ab5c1f19a29207e2aaf866a709037444) )
	ROM_LOAD( "superpoo.s1", 0x0000, 0x080000, CRC(10b66838) SHA1(24e202edec41f9d1c5822ebbfcbf9c17c2cd4a2c) )
	ROM_LOAD( "supetpoo.s0", 0x0000, 0x080000, CRC(fdbc8b26) SHA1(16644c83780f300133a99821526c35b86bb25aad) )
	ROM_LOAD( "mmsnd1", 0x0000, 0x080000, CRC(fc33fb69) SHA1(f2d2a4469d03f5a86f3a2a08b81b0fb0b7ce6183) )
	ROM_LOAD( "mmsnd2", 0x0000, 0x080000, CRC(8de0c411) SHA1(ee6d08be19f28ef113d89be60f3f353c857da74d) )
	ROM_LOAD( "c sound2", 0x0000, 0x080000, CRC(ad191be1) SHA1(1d0934cf0d39ad842d68eeea5c91ddd8637644e6) )
	ROM_LOAD( "carry on", 0x0000, 0x080000, CRC(4282b495) SHA1(7cdec8e8219a892c26311608ebd8953b381ecc70) )
	ROM_LOAD( "double d.s0", 0x0000, 0x080000, CRC(c57cc5c1) SHA1(03e0062048eeedf55a35f31eccd658347fc68576) )
	ROM_LOAD( "double d.s1", 0x0000, 0x080000, CRC(d74b49d2) SHA1(d6d39ad08ef1dfdd36163984ed3f9ae89cbad138) )
	ROM_LOAD( "sound2.bin", 0x0000, 0x008000, CRC(84e8cf84) SHA1(e3e05a7dd5264c26378aefa540c3fd9d7b415827) )// Seems bad
	ROM_LOAD( "sound3.bin", 0x0000, 0x008000, CRC(36b25191) SHA1(8a3237fa7bc5b5e630b04f76e25d22e62a4a2375) )// Similar to Club Explosion sound roms
	ROM_LOAD( "sn-33-white.bin", 0x0000, 0x010000, CRC(8d5aba16) SHA1(3b63cf53e8bc7790f63fa395711114d1b195a07c) )//just bad I think
	ROM_LOAD( "taker-over-008.bin", 0x0000, 0x008000, CRC(2dad1088) SHA1(b8bdf5bf4e0ef5bee44d1f7031b08e4e6a8ae5ca) )//looks a bit ACE ish, but no strings to make sure
ROM_END

//GAME(19??,  unkfr,   0,  unkfr,  unkfr, driver_device,  0,  ROT0,  "<unknown>",    "Unknown Fruit Machine ROMs (set 1)",     MACHINE_IS_SKELETON_MECHANICAL)
//GAME(19??,  unkfra,  0,  unkfr,  unkfr, driver_device,  0,  ROT0,  "<unknown>",    "Unknown Fruit Machine ROMs (set 2)",     MACHINE_IS_SKELETON_MECHANICAL)

#endif
