/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.table;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public final class AutoResizeTableColumns
implements TableModelListener {
    public static final int DEFAULT_COLUMN_PADDING = 5;
    private JTable m_table = null;
    private TableModel m_model = null;
    private int m_columnPadding = 0;
    private boolean m_includeHeaders = false;
    private boolean m_includeRows = false;
    private boolean[] m_lockColumns = null;
    private boolean m_debugMode = false;

    public AutoResizeTableColumns(JTable tbl) {
        this(tbl, false);
    }

    public AutoResizeTableColumns(JTable tbl, boolean allColumnsLock) {
        this(tbl, tbl.getModel(), 5, true, true, AutoResizeTableColumns.getBooleanArray(tbl.getColumnCount(), allColumnsLock));
    }

    public AutoResizeTableColumns(JTable tbl, TableModel mdl, int columnPadding, boolean includeHeaders, boolean includeRows, boolean[] lockColumns) {
        this.m_table = tbl;
        this.m_model = mdl;
        this.m_columnPadding = columnPadding;
        this.m_includeHeaders = includeHeaders;
        this.m_includeRows = includeRows;
        this.m_lockColumns = lockColumns;
        this.m_model.addTableModelListener(this);
    }

    public void setDebugMode(boolean debugMode) {
        this.m_debugMode = debugMode;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.printDebug("AutoResizeTableColumns::tableChanged(): started");
        int numColumns = this.m_table.getColumnCount();
        int numRows = this.m_model.getRowCount();
        this.printDebug("table columns: " + numColumns + " rows: " + numRows);
        if (numColumns > 0) {
            int[] columnsWidths = new int[numColumns];
            TableColumnModel tcMdl = this.m_table.getTableHeader().getColumnModel();
            int inter_cell_spacing = this.m_table.getIntercellSpacing().width;
            this.printDebug("inter cell spacing=" + inter_cell_spacing);
            int column_margin = tcMdl.getColumnMargin();
            this.printDebug("column margin=" + column_margin);
            int increment = this.m_columnPadding + 2 * inter_cell_spacing + 2 * column_margin;
            this.printDebug("total increment for each column=" + increment);
            for (int col = 0; col < numColumns; ++col) {
                this.printDebug("processing column: " + col);
                int max1 = 0;
                int max2 = 0;
                TableColumn tCol = tcMdl.getColumn(col);
                if (tCol.getMaxWidth() == 0 && tCol.getMinWidth() == 0 && tCol.getPreferredWidth() == 0) {
                    this.printDebug("\tthis table column is hidden will be ignored");
                    max1 = 0;
                    max2 = 0;
                } else {
                    if (this.m_includeHeaders) {
                        this.printDebug("\tchecking table header");
                        String col_debug = "\t";
                        TableCellRenderer tCelRndr = tCol.getHeaderRenderer();
                        if (tCelRndr != null) {
                            col_debug = col_debug + "FOUND header renderer; ";
                            Component comp = tCelRndr.getTableCellRendererComponent(this.m_table, tCol.getHeaderValue(), false, false, -1, col);
                            col_debug = col_debug + "renderer component is ";
                            if (comp instanceof JTextComponent) {
                                col_debug = col_debug + "a JTextComponent";
                                max1 = increment + this.getTextPixels((JTextComponent)comp);
                            } else {
                                col_debug = col_debug + "NOT a JTextComponent";
                                max1 = increment + comp.getPreferredSize().width;
                            }
                        } else {
                            col_debug = col_debug + "NO header renderer found; ";
                            Object headerValue = tCol.getHeaderValue();
                            if (headerValue instanceof String) {
                                col_debug = col_debug + "HeaderValue is a String";
                                String txt = (String)headerValue;
                                JLabel tmpLabel = new JLabel(txt);
                                max1 = increment + this.getTextPixels(tmpLabel, txt);
                            } else {
                                col_debug = col_debug + "UNKNOWN HeaderValue type!";
                                max1 = increment + 0;
                            }
                        }
                        this.printDebug(col_debug);
                        this.printDebug("\tcalculated size based on column header: " + max1);
                    }
                    if (this.m_includeRows && numRows > 0) {
                        this.printDebug("\tchecking table rows");
                        for (int row = 0; row < numRows; ++row) {
                            String row_debug = "\t\trow: " + row;
                            int tmpSize = 0;
                            TableCellRenderer tCelRndr = this.m_table.getCellRenderer(row, col);
                            Component comp = tCelRndr.getTableCellRendererComponent(this.m_table, this.m_model.getValueAt(row, col), false, false, row, col);
                            if (comp instanceof JTextComponent) {
                                tmpSize = increment + this.getTextPixels((JTextComponent)comp);
                                row_debug = row_debug + " size: " + tmpSize;
                                row_debug = row_debug + " FOUND cell renderer;";
                                row_debug = row_debug + " renderer component is";
                                row_debug = row_debug + " a JTextComponent";
                            } else {
                                tmpSize = increment + comp.getPreferredSize().width;
                                row_debug = row_debug + " size: " + tmpSize;
                                row_debug = row_debug + " FOUND cell renderer;";
                                row_debug = row_debug + " renderer component is";
                                row_debug = row_debug + " NOT a JTextComponent";
                            }
                            this.printDebug(row_debug);
                            max2 = Math.max(max2, tmpSize);
                        }
                        this.printDebug("\tcalculated size based on column's rows: " + max2);
                    }
                }
                columnsWidths[col] = Math.max(max1, max2);
                if (columnsWidths[col] > 0) {
                    this.printDebug("resizing column: " + col + " size: " + columnsWidths[col]);
                    this.resizeTableColumn(tCol, columnsWidths[col], this.m_lockColumns[col]);
                    continue;
                }
                this.printDebug("column: " + col + " was not resized");
            }
        }
        this.printDebug("AutoResizeTableColumns::tableChanged(): finished");
    }

    private int getTextPixels(JTextComponent c) {
        FontMetrics f = c.getFontMetrics(c.getFont());
        int pixels = f.stringWidth(c.getText());
        return pixels;
    }

    private int getTextPixels(Component c, String s) {
        FontMetrics f = c.getFontMetrics(c.getFont());
        int pixels = f.stringWidth(s);
        return pixels;
    }

    private void resizeTableColumn(TableColumn tc, int pixels, boolean lock) {
        tc.setPreferredWidth(pixels);
        if (lock) {
            tc.setMinWidth(pixels);
            tc.setMaxWidth(pixels);
            tc.setResizable(false);
        }
    }

    private void printDebug(String s) {
        if (this.m_debugMode) {
            System.out.println(s);
        }
    }

    private static boolean[] getBooleanArray(int size, boolean value) {
        boolean[] flags = new boolean[size];
        for (int i = 0; i < size; ++i) {
            flags[i] = value;
        }
        return flags;
    }
}

