/*
 * Copyright 2004-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.webflow.mvc.view;

import java.beans.PropertyEditorSupport;

import org.springframework.binding.convert.ConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ConversionExecutorPropertyEditor extends PropertyEditorSupport {

	private ConversionService conversionService;

	private Class fieldType;

	private String converterId;

	public ConversionExecutorPropertyEditor(ConversionService conversionService, Class fieldType, String converterId) {
		Assert.notNull(fieldType, "The field type is required");
		this.conversionService = conversionService;
		this.fieldType = fieldType;
		this.converterId = converterId;
	}

	public String getAsText() {
		if (StringUtils.hasText(converterId)) {
			return (String) conversionService.executeConversion(converterId, getValue(), String.class);
		} else {
			return (String) conversionService.executeConversion(getValue(), String.class);
		}
	}

	public void setAsText(String text) throws IllegalArgumentException {
		if (StringUtils.hasText(converterId)) {
			setValue(conversionService.executeConversion(converterId, text, fieldType));
		} else {
			setValue(conversionService.executeConversion(text, fieldType));
		}
	}
}