/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.kde.kjas.server.KIOHttpConnection;
import org.kde.kjas.server.Main;

final class KJASHttpURLConnection
extends HttpURLConnection {
    private KIOHttpConnection kioconnection;

    KJASHttpURLConnection(URL uRL) {
        super(uRL);
        this.kioconnection = new KIOHttpConnection(uRL);
    }

    public Map getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            Main.debug("Error on implicit connect()");
        }
        Main.debug("KIO getHeaderFields");
        return this.kioconnection.headersmap;
    }

    public String getHeaderField(String string) {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            Main.debug("Error on implicit connect()");
        }
        String string2 = (String)this.kioconnection.headersmap.get(string);
        Main.debug("KIO getHeaderField:" + string + "=" + string2);
        return string2;
    }

    public String getHeaderField(int n) {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            Main.debug("Error on implicit connect()");
        }
        Main.debug("KIO getHeaderField(" + n + ") size=" + this.kioconnection.headersmap.size());
        if (n >= this.kioconnection.headersmap.size()) {
            return null;
        }
        String[] stringArray = (String[])this.kioconnection.headers.get(n);
        String string = stringArray[0];
        if (stringArray[1].length() > 0) {
            string = string + ":" + stringArray[1];
        }
        Main.debug("KIO getHeaderField(" + n + ")=#" + string + "#");
        return string;
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            Main.debug("Error on implicit connect()");
        }
        Main.debug("KIO getHeaderFieldKey " + n);
        if (n >= this.kioconnection.headersmap.size()) {
            return null;
        }
        return ((String[])this.kioconnection.headers.get(n))[0];
    }

    public int getResponseCode() throws IOException {
        block3: {
            Main.debug("KIO getResponseCode");
            if (this.kioconnection.responseCode == -1) {
                try {
                    this.connect();
                }
                catch (IOException iOException) {
                    if (this.kioconnection.responseCode != -1) break block3;
                    throw iOException;
                }
            }
        }
        this.responseMessage = this.kioconnection.responseMessage;
        return this.kioconnection.responseCode;
    }

    public boolean usingProxy() {
        return false;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        Main.debug("KIO KJASHttpURLConnection.connect " + this.url);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.getPermission());
        }
        this.kioconnection.connect(this.doInput);
        this.connected = true;
        if (this.kioconnection.responseCode == 404) {
            throw new FileNotFoundException(this.url.toExternalForm());
        }
    }

    public void disconnect() {
        this.kioconnection.disconnect();
        this.connected = false;
    }

    public InputStream getInputStream() throws IOException {
        this.doInput = true;
        this.doOutput = false;
        this.connect();
        return this.kioconnection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.doInput = false;
        this.doOutput = true;
        this.connect();
        return this.kioconnection.getOutputStream();
    }

    public InputStream getErrorStream() {
        Main.debug("KIO KJASHttpURLConnection.getErrorStream" + this.url);
        try {
            if (this.connected && this.kioconnection.responseCode == 404) {
                return this.kioconnection.getInputStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

