/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.xml.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;


/**
 * This class was generated by the JAX-WS RI.
 * Oracle JAX-WS 2.1.5
 * Generated source version: 2.1
 * 
 */
@WebServiceClient(name = "DocService", targetNamespace = "http://performance.bea.com", wsdlLocation = "http://localhost:7001/DocService/DocService?WSDL")
public class DocService
    extends Service
{

    private final static URL DOCSERVICE_WSDL_LOCATION;
    private final static Logger logger = Logger.getLogger(com.sun.xml.ws.client.DocService.class.getName());

    static {
        URL url = null;
        try {
            URL baseUrl;
            baseUrl = com.sun.xml.ws.client.DocService.class.getResource(".");
            url = new URL(baseUrl, "http://localhost:7001/DocService/DocService?WSDL");
        } catch (MalformedURLException e) {
            logger.warning("Failed to create URL for the wsdl Location: 'http://localhost:7001/DocService/DocService?WSDL', retrying as a local file");
            logger.warning(e.getMessage());
        }
        DOCSERVICE_WSDL_LOCATION = url;
    }

    public DocService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public DocService() {
        super(DOCSERVICE_WSDL_LOCATION, new QName("http://performance.bea.com", "DocService"));
    }

    /**
     * 
     * @return
     *     returns DocServicePortType
     */
    @WebEndpoint(name = "DocServicePortTypePort")
    public DocServicePortType getDocServicePortTypePort() {
        return super.getPort(new QName("http://performance.bea.com", "DocServicePortTypePort"), DocServicePortType.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns DocServicePortType
     */
    @WebEndpoint(name = "DocServicePortTypePort")
    public DocServicePortType getDocServicePortTypePort(WebServiceFeature... features) {
        return super.getPort(new QName("http://performance.bea.com", "DocServicePortTypePort"), DocServicePortType.class, features);
    }

}
