-----------------------------------------------------------------------------
-- |
-- Module      :  Graphics.X11.ExtraTypes.XF86
-- Copyright   :  (c) XFree86/X.org
-- License     :  X11 (see below) due to X headers
--
-- Maintainer  :  libraries@haskell.org
-- Stability   :  unstable
-- Portability :  unportable
--
--
-- This file is generated based on X.org includes.  It contains
-- the keysyms for XF86.
-----------------------------------------------------------------------------

-- Generated from /usr/include/X11/XF86keysym.h
--

-- Presumably XFree86/X.org has copyright on the header but it's not
-- explicit in the file.


module Graphics.X11.ExtraTypes.XF86
        (

#ifdef XF86XK_ModeLock
         xF86XK_ModeLock,            --  Mode Switch Lock
#else
         -- Skipping xF86XK_ModeLock because your X doesn't define it
#endif
#ifdef XF86XK_MonBrightnessUp
         xF86XK_MonBrightnessUp,     --  Monitor/panel brightness
#else
         -- Skipping xF86XK_MonBrightnessUp because your X doesn't define it
#endif
#ifdef XF86XK_MonBrightnessDown
         xF86XK_MonBrightnessDown,   --  Monitor/panel brightness
#else
         -- Skipping xF86XK_MonBrightnessDown because your X doesn't define it
#endif
#ifdef XF86XK_KbdLightOnOff
         xF86XK_KbdLightOnOff,       --  Keyboards may be lit
#else
         -- Skipping xF86XK_KbdLightOnOff because your X doesn't define it
#endif
#ifdef XF86XK_KbdBrightnessUp
         xF86XK_KbdBrightnessUp,     --  Keyboards may be lit
#else
         -- Skipping xF86XK_KbdBrightnessUp because your X doesn't define it
#endif
#ifdef XF86XK_KbdBrightnessDown
         xF86XK_KbdBrightnessDown,   --  Keyboards may be lit
#else
         -- Skipping xF86XK_KbdBrightnessDown because your X doesn't define it
#endif
#ifdef XF86XK_Standby
         xF86XK_Standby,             --  System into standby mode
#else
         -- Skipping xF86XK_Standby because your X doesn't define it
#endif
#ifdef XF86XK_AudioLowerVolume
         xF86XK_AudioLowerVolume,    --  Volume control down
#else
         -- Skipping xF86XK_AudioLowerVolume because your X doesn't define it
#endif
#ifdef XF86XK_AudioMute
         xF86XK_AudioMute,           --  Mute sound from the system
#else
         -- Skipping xF86XK_AudioMute because your X doesn't define it
#endif
#ifdef XF86XK_AudioRaiseVolume
         xF86XK_AudioRaiseVolume,    --  Volume control up
#else
         -- Skipping xF86XK_AudioRaiseVolume because your X doesn't define it
#endif
#ifdef XF86XK_AudioPlay
         xF86XK_AudioPlay,           --  Start playing of audio >
#else
         -- Skipping xF86XK_AudioPlay because your X doesn't define it
#endif
#ifdef XF86XK_AudioStop
         xF86XK_AudioStop,           --  Stop playing audio
#else
         -- Skipping xF86XK_AudioStop because your X doesn't define it
#endif
#ifdef XF86XK_AudioPrev
         xF86XK_AudioPrev,           --  Previous track
#else
         -- Skipping xF86XK_AudioPrev because your X doesn't define it
#endif
#ifdef XF86XK_AudioNext
         xF86XK_AudioNext,           --  Next track
#else
         -- Skipping xF86XK_AudioNext because your X doesn't define it
#endif
#ifdef XF86XK_HomePage
         xF86XK_HomePage,            --  Display user's home page
#else
         -- Skipping xF86XK_HomePage because your X doesn't define it
#endif
#ifdef XF86XK_Mail
         xF86XK_Mail,                --  Invoke user's mail program
#else
         -- Skipping xF86XK_Mail because your X doesn't define it
#endif
#ifdef XF86XK_Start
         xF86XK_Start,               --  Start application
#else
         -- Skipping xF86XK_Start because your X doesn't define it
#endif
#ifdef XF86XK_Search
         xF86XK_Search,              --  Search
#else
         -- Skipping xF86XK_Search because your X doesn't define it
#endif
#ifdef XF86XK_AudioRecord
         xF86XK_AudioRecord,         --  Record audio application
#else
         -- Skipping xF86XK_AudioRecord because your X doesn't define it
#endif
#ifdef XF86XK_Calculator
         xF86XK_Calculator,          --  Invoke calculator program
#else
         -- Skipping xF86XK_Calculator because your X doesn't define it
#endif
#ifdef XF86XK_Memo
         xF86XK_Memo,                --  Invoke Memo taking program
#else
         -- Skipping xF86XK_Memo because your X doesn't define it
#endif
#ifdef XF86XK_ToDoList
         xF86XK_ToDoList,            --  Invoke To Do List program
#else
         -- Skipping xF86XK_ToDoList because your X doesn't define it
#endif
#ifdef XF86XK_Calendar
         xF86XK_Calendar,            --  Invoke Calendar program
#else
         -- Skipping xF86XK_Calendar because your X doesn't define it
#endif
#ifdef XF86XK_PowerDown
         xF86XK_PowerDown,           --  Deep sleep the system
#else
         -- Skipping xF86XK_PowerDown because your X doesn't define it
#endif
#ifdef XF86XK_ContrastAdjust
         xF86XK_ContrastAdjust,      --  Adjust screen contrast
#else
         -- Skipping xF86XK_ContrastAdjust because your X doesn't define it
#endif
#ifdef XF86XK_RockerUp
         xF86XK_RockerUp,            --  Rocker switches exist up
#else
         -- Skipping xF86XK_RockerUp because your X doesn't define it
#endif
#ifdef XF86XK_RockerDown
         xF86XK_RockerDown,          --  and down
#else
         -- Skipping xF86XK_RockerDown because your X doesn't define it
#endif
#ifdef XF86XK_RockerEnter
         xF86XK_RockerEnter,         --  and let you press them
#else
         -- Skipping xF86XK_RockerEnter because your X doesn't define it
#endif
#ifdef XF86XK_Back
         xF86XK_Back,                --  Like back on a browser
#else
         -- Skipping xF86XK_Back because your X doesn't define it
#endif
#ifdef XF86XK_Forward
         xF86XK_Forward,             --  Like forward on a browser
#else
         -- Skipping xF86XK_Forward because your X doesn't define it
#endif
#ifdef XF86XK_Stop
         xF86XK_Stop,                --  Stop current operation
#else
         -- Skipping xF86XK_Stop because your X doesn't define it
#endif
#ifdef XF86XK_Refresh
         xF86XK_Refresh,             --  Refresh the page
#else
         -- Skipping xF86XK_Refresh because your X doesn't define it
#endif
#ifdef XF86XK_PowerOff
         xF86XK_PowerOff,            --  Power off system entirely
#else
         -- Skipping xF86XK_PowerOff because your X doesn't define it
#endif
#ifdef XF86XK_WakeUp
         xF86XK_WakeUp,              --  Wake up system from sleep
#else
         -- Skipping xF86XK_WakeUp because your X doesn't define it
#endif
#ifdef XF86XK_Eject
         xF86XK_Eject,               --  Eject device (e.g. DVD)
#else
         -- Skipping xF86XK_Eject because your X doesn't define it
#endif
#ifdef XF86XK_ScreenSaver
         xF86XK_ScreenSaver,         --  Invoke screensaver
#else
         -- Skipping xF86XK_ScreenSaver because your X doesn't define it
#endif
#ifdef XF86XK_WWW
         xF86XK_WWW,                 --  Invoke web browser
#else
         -- Skipping xF86XK_WWW because your X doesn't define it
#endif
#ifdef XF86XK_Sleep
         xF86XK_Sleep,               --  Put system to sleep
#else
         -- Skipping xF86XK_Sleep because your X doesn't define it
#endif
#ifdef XF86XK_Favorites
         xF86XK_Favorites,           --  Show favorite locations
#else
         -- Skipping xF86XK_Favorites because your X doesn't define it
#endif
#ifdef XF86XK_AudioPause
         xF86XK_AudioPause,          --  Pause audio playing
#else
         -- Skipping xF86XK_AudioPause because your X doesn't define it
#endif
#ifdef XF86XK_AudioMedia
         xF86XK_AudioMedia,          --  Launch media collection app
#else
         -- Skipping xF86XK_AudioMedia because your X doesn't define it
#endif
#ifdef XF86XK_MyComputer
         xF86XK_MyComputer,          --  Display "My Computer" window
#else
         -- Skipping xF86XK_MyComputer because your X doesn't define it
#endif
#ifdef XF86XK_VendorHome
         xF86XK_VendorHome,          --  Display vendor home web site
#else
         -- Skipping xF86XK_VendorHome because your X doesn't define it
#endif
#ifdef XF86XK_LightBulb
         xF86XK_LightBulb,           --  Light bulb keys exist
#else
         -- Skipping xF86XK_LightBulb because your X doesn't define it
#endif
#ifdef XF86XK_Shop
         xF86XK_Shop,                --  Display shopping web site
#else
         -- Skipping xF86XK_Shop because your X doesn't define it
#endif
#ifdef XF86XK_History
         xF86XK_History,             --  Show history of web surfing
#else
         -- Skipping xF86XK_History because your X doesn't define it
#endif
#ifdef XF86XK_OpenURL
         xF86XK_OpenURL,             --  Open selected URL
#else
         -- Skipping xF86XK_OpenURL because your X doesn't define it
#endif
#ifdef XF86XK_AddFavorite
         xF86XK_AddFavorite,         --  Add URL to favorites list
#else
         -- Skipping xF86XK_AddFavorite because your X doesn't define it
#endif
#ifdef XF86XK_HotLinks
         xF86XK_HotLinks,            --  Show "hot" links
#else
         -- Skipping xF86XK_HotLinks because your X doesn't define it
#endif
#ifdef XF86XK_BrightnessAdjust
         xF86XK_BrightnessAdjust,    --  Invoke brightness adj. UI
#else
         -- Skipping xF86XK_BrightnessAdjust because your X doesn't define it
#endif
#ifdef XF86XK_Finance
         xF86XK_Finance,             --  Display financial site
#else
         -- Skipping xF86XK_Finance because your X doesn't define it
#endif
#ifdef XF86XK_Community
         xF86XK_Community,           --  Display user's community
#else
         -- Skipping xF86XK_Community because your X doesn't define it
#endif
#ifdef XF86XK_AudioRewind
         xF86XK_AudioRewind,         --  "rewind" audio track
#else
         -- Skipping xF86XK_AudioRewind because your X doesn't define it
#endif
#ifdef XF86XK_XF86BackForward
         xF86XK_XF86BackForward,     --  ???
#else
         -- Skipping xF86XK_XF86BackForward because your X doesn't define it
#endif
#ifdef XF86XK_Launch0
         xF86XK_Launch0,             --  Launch Application
#else
         -- Skipping xF86XK_Launch0 because your X doesn't define it
#endif
#ifdef XF86XK_Launch1
         xF86XK_Launch1,             --  Launch Application
#else
         -- Skipping xF86XK_Launch1 because your X doesn't define it
#endif
#ifdef XF86XK_Launch2
         xF86XK_Launch2,             --  Launch Application
#else
         -- Skipping xF86XK_Launch2 because your X doesn't define it
#endif
#ifdef XF86XK_Launch3
         xF86XK_Launch3,             --  Launch Application
#else
         -- Skipping xF86XK_Launch3 because your X doesn't define it
#endif
#ifdef XF86XK_Launch4
         xF86XK_Launch4,             --  Launch Application
#else
         -- Skipping xF86XK_Launch4 because your X doesn't define it
#endif
#ifdef XF86XK_Launch5
         xF86XK_Launch5,             --  Launch Application
#else
         -- Skipping xF86XK_Launch5 because your X doesn't define it
#endif
#ifdef XF86XK_Launch6
         xF86XK_Launch6,             --  Launch Application
#else
         -- Skipping xF86XK_Launch6 because your X doesn't define it
#endif
#ifdef XF86XK_Launch7
         xF86XK_Launch7,             --  Launch Application
#else
         -- Skipping xF86XK_Launch7 because your X doesn't define it
#endif
#ifdef XF86XK_Launch8
         xF86XK_Launch8,             --  Launch Application
#else
         -- Skipping xF86XK_Launch8 because your X doesn't define it
#endif
#ifdef XF86XK_Launch9
         xF86XK_Launch9,             --  Launch Application
#else
         -- Skipping xF86XK_Launch9 because your X doesn't define it
#endif
#ifdef XF86XK_LaunchA
         xF86XK_LaunchA,             --  Launch Application
#else
         -- Skipping xF86XK_LaunchA because your X doesn't define it
#endif
#ifdef XF86XK_LaunchB
         xF86XK_LaunchB,             --  Launch Application
#else
         -- Skipping xF86XK_LaunchB because your X doesn't define it
#endif
#ifdef XF86XK_LaunchC
         xF86XK_LaunchC,             --  Launch Application
#else
         -- Skipping xF86XK_LaunchC because your X doesn't define it
#endif
#ifdef XF86XK_LaunchD
         xF86XK_LaunchD,             --  Launch Application
#else
         -- Skipping xF86XK_LaunchD because your X doesn't define it
#endif
#ifdef XF86XK_LaunchE
         xF86XK_LaunchE,             --  Launch Application
#else
         -- Skipping xF86XK_LaunchE because your X doesn't define it
#endif
#ifdef XF86XK_LaunchF
         xF86XK_LaunchF,             --  Launch Application
#else
         -- Skipping xF86XK_LaunchF because your X doesn't define it
#endif
#ifdef XF86XK_ApplicationLeft
         xF86XK_ApplicationLeft,     --  switch to application, left
#else
         -- Skipping xF86XK_ApplicationLeft because your X doesn't define it
#endif
#ifdef XF86XK_ApplicationRight
         xF86XK_ApplicationRight,    --  switch to application, right
#else
         -- Skipping xF86XK_ApplicationRight because your X doesn't define it
#endif
#ifdef XF86XK_Book
         xF86XK_Book,                --  Launch bookreader
#else
         -- Skipping xF86XK_Book because your X doesn't define it
#endif
#ifdef XF86XK_CD
         xF86XK_CD,                  --  Launch CD/DVD player
#else
         -- Skipping xF86XK_CD because your X doesn't define it
#endif
#ifdef XF86XK_Calculater
         xF86XK_Calculater,          --  Launch Calculater
#else
         -- Skipping xF86XK_Calculater because your X doesn't define it
#endif
#ifdef XF86XK_Clear
         xF86XK_Clear,               --  Clear window, screen
#else
         -- Skipping xF86XK_Clear because your X doesn't define it
#endif
#ifdef XF86XK_Close
         xF86XK_Close,               --  Close window
#else
         -- Skipping xF86XK_Close because your X doesn't define it
#endif
#ifdef XF86XK_Copy
         xF86XK_Copy,                --  Copy selection
#else
         -- Skipping xF86XK_Copy because your X doesn't define it
#endif
#ifdef XF86XK_Cut
         xF86XK_Cut,                 --  Cut selection
#else
         -- Skipping xF86XK_Cut because your X doesn't define it
#endif
#ifdef XF86XK_Display
         xF86XK_Display,             --  Output switch key
#else
         -- Skipping xF86XK_Display because your X doesn't define it
#endif
#ifdef XF86XK_DOS
         xF86XK_DOS,                 --  Launch DOS (emulation)
#else
         -- Skipping xF86XK_DOS because your X doesn't define it
#endif
#ifdef XF86XK_Documents
         xF86XK_Documents,           --  Open documents window
#else
         -- Skipping xF86XK_Documents because your X doesn't define it
#endif
#ifdef XF86XK_Excel
         xF86XK_Excel,               --  Launch spread sheet
#else
         -- Skipping xF86XK_Excel because your X doesn't define it
#endif
#ifdef XF86XK_Explorer
         xF86XK_Explorer,            --  Launch file explorer
#else
         -- Skipping xF86XK_Explorer because your X doesn't define it
#endif
#ifdef XF86XK_Game
         xF86XK_Game,                --  Launch game
#else
         -- Skipping xF86XK_Game because your X doesn't define it
#endif
#ifdef XF86XK_Go
         xF86XK_Go,                  --  Go to URL
#else
         -- Skipping xF86XK_Go because your X doesn't define it
#endif
#ifdef XF86XK_iTouch
         xF86XK_iTouch,              --  Logitch iTouch- don't use
#else
         -- Skipping xF86XK_iTouch because your X doesn't define it
#endif
#ifdef XF86XK_LogOff
         xF86XK_LogOff,              --  Log off system
#else
         -- Skipping xF86XK_LogOff because your X doesn't define it
#endif
#ifdef XF86XK_Market
         xF86XK_Market,              --  ??
#else
         -- Skipping xF86XK_Market because your X doesn't define it
#endif
#ifdef XF86XK_Meeting
         xF86XK_Meeting,             --  enter meeting in calendar
#else
         -- Skipping xF86XK_Meeting because your X doesn't define it
#endif
#ifdef XF86XK_MenuKB
         xF86XK_MenuKB,              --  distingush keyboard from PB
#else
         -- Skipping xF86XK_MenuKB because your X doesn't define it
#endif
#ifdef XF86XK_MenuPB
         xF86XK_MenuPB,              --  distinuish PB from keyboard
#else
         -- Skipping xF86XK_MenuPB because your X doesn't define it
#endif
#ifdef XF86XK_MySites
         xF86XK_MySites,             --  Favourites
#else
         -- Skipping xF86XK_MySites because your X doesn't define it
#endif
#ifdef XF86XK_New
         xF86XK_New,                 --  New (folder, document...
#else
         -- Skipping xF86XK_New because your X doesn't define it
#endif
#ifdef XF86XK_News
         xF86XK_News,                --  News
#else
         -- Skipping xF86XK_News because your X doesn't define it
#endif
#ifdef XF86XK_OfficeHome
         xF86XK_OfficeHome,          --  Office home (old Staroffice)
#else
         -- Skipping xF86XK_OfficeHome because your X doesn't define it
#endif
#ifdef XF86XK_Open
         xF86XK_Open,                --  Open
#else
         -- Skipping xF86XK_Open because your X doesn't define it
#endif
#ifdef XF86XK_Option
         xF86XK_Option,              --  ??
#else
         -- Skipping xF86XK_Option because your X doesn't define it
#endif
#ifdef XF86XK_Paste
         xF86XK_Paste,               --  Paste
#else
         -- Skipping xF86XK_Paste because your X doesn't define it
#endif
#ifdef XF86XK_Phone
         xF86XK_Phone,               --  Launch phone; dial number
#else
         -- Skipping xF86XK_Phone because your X doesn't define it
#endif
#ifdef XF86XK_Q
         xF86XK_Q,                   --  Compaq's Q - don't use
#else
         -- Skipping xF86XK_Q because your X doesn't define it
#endif
#ifdef XF86XK_Reply
         xF86XK_Reply,               --  Reply e.g., mail
#else
         -- Skipping xF86XK_Reply because your X doesn't define it
#endif
#ifdef XF86XK_Reload
         xF86XK_Reload,              --  Reload web page, file, etc.
#else
         -- Skipping xF86XK_Reload because your X doesn't define it
#endif
#ifdef XF86XK_RotateWindows
         xF86XK_RotateWindows,       --  Rotate windows e.g. xrandr
#else
         -- Skipping xF86XK_RotateWindows because your X doesn't define it
#endif
#ifdef XF86XK_RotationPB
         xF86XK_RotationPB,          --  don't use
#else
         -- Skipping xF86XK_RotationPB because your X doesn't define it
#endif
#ifdef XF86XK_RotationKB
         xF86XK_RotationKB,          --  don't use
#else
         -- Skipping xF86XK_RotationKB because your X doesn't define it
#endif
#ifdef XF86XK_Save
         xF86XK_Save,                --  Save (file, document, state
#else
         -- Skipping xF86XK_Save because your X doesn't define it
#endif
#ifdef XF86XK_ScrollUp
         xF86XK_ScrollUp,            --  Scroll window/contents up
#else
         -- Skipping xF86XK_ScrollUp because your X doesn't define it
#endif
#ifdef XF86XK_ScrollDown
         xF86XK_ScrollDown,          --  Scrool window/contentd down
#else
         -- Skipping xF86XK_ScrollDown because your X doesn't define it
#endif
#ifdef XF86XK_ScrollClick
         xF86XK_ScrollClick,         --  Use XKB mousekeys instead
#else
         -- Skipping xF86XK_ScrollClick because your X doesn't define it
#endif
#ifdef XF86XK_Send
         xF86XK_Send,                --  Send mail, file, object
#else
         -- Skipping xF86XK_Send because your X doesn't define it
#endif
#ifdef XF86XK_Spell
         xF86XK_Spell,               --  Spell checker
#else
         -- Skipping xF86XK_Spell because your X doesn't define it
#endif
#ifdef XF86XK_SplitScreen
         xF86XK_SplitScreen,         --  Split window or screen
#else
         -- Skipping xF86XK_SplitScreen because your X doesn't define it
#endif
#ifdef XF86XK_Support
         xF86XK_Support,             --  Get support (??)
#else
         -- Skipping xF86XK_Support because your X doesn't define it
#endif
#ifdef XF86XK_TaskPane
         xF86XK_TaskPane,            --  Show tasks
#else
         -- Skipping xF86XK_TaskPane because your X doesn't define it
#endif
#ifdef XF86XK_Terminal
         xF86XK_Terminal,            --  Launch terminal emulator
#else
         -- Skipping xF86XK_Terminal because your X doesn't define it
#endif
#ifdef XF86XK_Tools
         xF86XK_Tools,               --  toolbox of desktop/app.
#else
         -- Skipping xF86XK_Tools because your X doesn't define it
#endif
#ifdef XF86XK_Travel
         xF86XK_Travel,              --  ??
#else
         -- Skipping xF86XK_Travel because your X doesn't define it
#endif
#ifdef XF86XK_UserPB
         xF86XK_UserPB,              --  ??
#else
         -- Skipping xF86XK_UserPB because your X doesn't define it
#endif
#ifdef XF86XK_User1KB
         xF86XK_User1KB,             --  ??
#else
         -- Skipping xF86XK_User1KB because your X doesn't define it
#endif
#ifdef XF86XK_User2KB
         xF86XK_User2KB,             --  ??
#else
         -- Skipping xF86XK_User2KB because your X doesn't define it
#endif
#ifdef XF86XK_Video
         xF86XK_Video,               --  Launch video player
#else
         -- Skipping xF86XK_Video because your X doesn't define it
#endif
#ifdef XF86XK_WheelButton
         xF86XK_WheelButton,         --  button from a mouse wheel
#else
         -- Skipping xF86XK_WheelButton because your X doesn't define it
#endif
#ifdef XF86XK_Word
         xF86XK_Word,                --  Launch word processor
#else
         -- Skipping xF86XK_Word because your X doesn't define it
#endif
#ifdef XF86XK_Xfer
         xF86XK_Xfer,
#else
         -- Skipping xF86XK_Xfer because your X doesn't define it
#endif
#ifdef XF86XK_ZoomIn
         xF86XK_ZoomIn,              --  zoom in view, map, etc.
#else
         -- Skipping xF86XK_ZoomIn because your X doesn't define it
#endif
#ifdef XF86XK_ZoomOut
         xF86XK_ZoomOut,             --  zoom out view, map, etc.
#else
         -- Skipping xF86XK_ZoomOut because your X doesn't define it
#endif
#ifdef XF86XK_Away
         xF86XK_Away,                --  mark yourself as away
#else
         -- Skipping xF86XK_Away because your X doesn't define it
#endif
#ifdef XF86XK_Messenger
         xF86XK_Messenger,           --  as in instant messaging
#else
         -- Skipping xF86XK_Messenger because your X doesn't define it
#endif
#ifdef XF86XK_WebCam
         xF86XK_WebCam,              --  Launch web camera app.
#else
         -- Skipping xF86XK_WebCam because your X doesn't define it
#endif
#ifdef XF86XK_MailForward
         xF86XK_MailForward,         --  Forward in mail
#else
         -- Skipping xF86XK_MailForward because your X doesn't define it
#endif
#ifdef XF86XK_Pictures
         xF86XK_Pictures,            --  Show pictures
#else
         -- Skipping xF86XK_Pictures because your X doesn't define it
#endif
#ifdef XF86XK_Music
         xF86XK_Music,               --  Launch music application
#else
         -- Skipping xF86XK_Music because your X doesn't define it
#endif
#ifdef XF86XK_Battery
         xF86XK_Battery,             --  Display battery information
#else
         -- Skipping XF86XK_Battery because your X doesn't define it
#endif
#ifdef XF86XK_Bluetooth
         xF86XK_Bluetooth,           --  Enable/disable Bluetooth
#else
         -- Skipping XF86XK_Bluetooth because your X doesn't define it
#endif
#ifdef XF86XK_WLAN
         xF86XK_WLAN,                --  Enable/disable WLAN
#else
         -- Skipping XF86XK_WLAN because your X doesn't define it
#endif
#ifdef XF86XK_UWB
         xF86XK_UWB,                 --  Enable/disable UWB
#else
         -- Skipping XF86XK_UWB because your X doesn't define it
#endif
#ifdef XF86XK_AudioForward,
         xF86XK_AudioForward,        --  Fast-forward audio track
#else
         -- Skipping XF86XK_AudioForward because your X doesn't define it
#endif
#ifdef XF86XK_AudioRepeat
         xF86XK_AudioRepeat,         --  Toggle repeat mode
#else
         -- Skipping XF86XK_AudioRepeat because your X doesn't define it
#endif
#ifdef XF86XK_AudioRandomPlay
         xF86XK_AudioRandomPlay,     --  Toggle shuffle mode
#else
         -- Skipping XF86XK_AudioRandomPlay because your X doesn't define it
#endif
#ifdef XF86XK_Subtitle
         xF86XK_Subtitle,            --  Cycle through subtitle
#else
         -- Skipping XF86XK_Subtitle because your X doesn't define it
#endif
#ifdef XF86XK_AudioCycleTrack
         xF86XK_AudioCycleTrack,     --  Cycle through audio tracks
#else
         -- Skipping XF86XK_AudioCycleTrack because your X doesn't define it
#endif
#ifdef XF86XK_CycleAngle
         xF86XK_CycleAngle,          --  Cycle through angles
#else
         -- Skipping XF86XK_CycleAngle because your X doesn't define it
#endif
#ifdef XF86XK_FrameBack
         xF86XK_FrameBack,           --  Video: go one frame back
#else
         -- Skipping XF86XK_FrameBack because your X doesn't define it
#endif
#ifdef XF86XK_FrameForward
         xF86XK_FrameForward,        --  Video: go one frame forward
#else
         -- Skipping XF86XK_FrameForward because your X doesn't define it
#endif
#ifdef XF86XK_Time
         xF86XK_Time,                --  Display, or shows an entry for time seeking
#else
         -- Skipping XF86XK_Time because your X doesn't define it
#endif
#ifdef XF86XK_Select
         xF86XK_Select,              --  Select button on joypads and remotes
#else
         -- Skipping XF86XK_Select because your X doesn't define it
#endif
#ifdef XF86XK_View
         xF86XK_View,                --  Show a view options/properties
#else
         -- Skipping XF86XK_View because your X doesn't define it
#endif
#ifdef XF86XK_TopMenu
         xF86XK_TopMenu,             --  Go to a top-level menu in a video
#else
         -- Skipping XF86XK_TopMenu because your X doesn't define it
#endif
#ifdef XF86XK_Red
         xF86XK_Red,                 --  Red button
#else
         -- Skipping XF86XK_Red because your X doesn't define it
#endif
#ifdef XF86XK_Green
         xF86XK_Green,               --  Green button
#else
         -- Skipping XF86XK_Green because your X doesn't define it
#endif
#ifdef XF86XK_Yellow
         xF86XK_Yellow,              --  Yellow button
#else
         -- Skipping XF86XK_Yellow because your X doesn't define it
#endif
#ifdef XF86XK_Blue
         xF86XK_Blue,                --  Blue button
#else
         -- Skipping XF86XK_Blue because your X doesn't define it
#endif
#ifdef XF86XK_Suspend
         xF86XK_Suspend,             --  Sleep to RAM
#else
         -- Skipping XF86XK_Suspend because your X doesn't define it
#endif
#ifdef XF86XK_Hibernate
         xF86XK_Hibernate,           --  Sleep to disk
#else
         -- Skipping XF86XK_Hibernate because your X doesn't define it
#endif
#ifdef XF86XK_TouchpadToggle
         xF86XK_TouchpadToggle,      --  Toggle between touchpad/trackstick
#else
         -- Skipping XF86XK_TouchpadToggle because your X doesn't define it
#endif
#ifdef XF86XK_TouchpadOn
         xF86XK_TouchpadOn,          --  The touchpad got switched on
#else
         -- Skipping XF86XK_TouchpadOn because your X doesn't define it
#endif
#ifdef XF86XK_TouchpadOff
         xF86XK_TouchpadOff,         --  The touchpad got switched off
#else
         -- Skipping XF86XK_TouchpadOff because your X doesn't define it
#endif
#ifdef XF86XK_AudioMicMute
         xF86XK_AudioMicMute,        --  Mute the Mic from the system
#else
         -- Skipping XF86XK_AudioMicMute because your X doesn't define it
#endif
#ifdef XF86XK_LogWindowTree
         xF86XK_LogWindowTree,       --  Print window tree to log
#else
         -- Skipping XF86XK_LogWindowTree because your X doesn't define it
#endif
#ifdef XF86XK_LogGrabInfo
         xF86XK_LogGrabInfo,         --  Print all active grabs to log
#else
         -- Skipping XF86XK_LogGrabInfo because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_1
         xF86XK_Switch_VT_1,
#else
         -- Skipping xF86XK_Switch_VT_1 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_2
         xF86XK_Switch_VT_2,
#else
         -- Skipping xF86XK_Switch_VT_2 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_3
         xF86XK_Switch_VT_3,
#else
         -- Skipping xF86XK_Switch_VT_3 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_4
         xF86XK_Switch_VT_4,
#else
         -- Skipping xF86XK_Switch_VT_4 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_5
         xF86XK_Switch_VT_5,
#else
         -- Skipping xF86XK_Switch_VT_5 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_6
         xF86XK_Switch_VT_6,
#else
         -- Skipping xF86XK_Switch_VT_6 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_7
         xF86XK_Switch_VT_7,
#else
         -- Skipping xF86XK_Switch_VT_7 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_8
         xF86XK_Switch_VT_8,
#else
         -- Skipping xF86XK_Switch_VT_8 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_9
         xF86XK_Switch_VT_9,
#else
         -- Skipping xF86XK_Switch_VT_9 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_10
         xF86XK_Switch_VT_10,
#else
         -- Skipping xF86XK_Switch_VT_10 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_11
         xF86XK_Switch_VT_11,
#else
         -- Skipping xF86XK_Switch_VT_11 because your X doesn't define it
#endif
#ifdef XF86XK_Switch_VT_12
         xF86XK_Switch_VT_12,
#else
         -- Skipping xF86XK_Switch_VT_12 because your X doesn't define it
#endif
#ifdef XF86XK_Ungrab
         xF86XK_Ungrab,              --  force ungrab
#else
         -- Skipping xF86XK_Ungrab because your X doesn't define it
#endif
#ifdef XF86XK_ClearGrab
         xF86XK_ClearGrab,           --  kill application with grab
#else
         -- Skipping xF86XK_ClearGrab because your X doesn't define it
#endif
#ifdef XF86XK_Next_VMode
         xF86XK_Next_VMode,          --  next video mode available
#else
         -- Skipping xF86XK_Next_VMode because your X doesn't define it
#endif
#ifdef XF86XK_Prev_VMode
         xF86XK_Prev_VMode,          --  prev. video mode available
#else
         -- Skipping xF86XK_Prev_VMode because your X doesn't define it
#endif
        ) where

import Graphics.X11.Types

#include "HsAllKeysyms.h"

#ifdef XF86XK_ModeLock
xF86XK_ModeLock             :: KeySym
xF86XK_ModeLock             = #const XF86XK_ModeLock
#endif
#ifdef XF86XK_MonBrightnessUp
xF86XK_MonBrightnessUp      :: KeySym
xF86XK_MonBrightnessUp      = #const XF86XK_MonBrightnessUp
#endif
#ifdef XF86XK_MonBrightnessDown
xF86XK_MonBrightnessDown    :: KeySym
xF86XK_MonBrightnessDown    = #const XF86XK_MonBrightnessDown
#endif
#ifdef XF86XK_KbdLightOnOff
xF86XK_KbdLightOnOff        :: KeySym
xF86XK_KbdLightOnOff        = #const XF86XK_KbdLightOnOff
#endif
#ifdef XF86XK_KbdBrightnessUp
xF86XK_KbdBrightnessUp      :: KeySym
xF86XK_KbdBrightnessUp      = #const XF86XK_KbdBrightnessUp
#endif
#ifdef XF86XK_KbdBrightnessDown
xF86XK_KbdBrightnessDown    :: KeySym
xF86XK_KbdBrightnessDown    = #const XF86XK_KbdBrightnessDown
#endif
#ifdef XF86XK_Standby
xF86XK_Standby              :: KeySym
xF86XK_Standby              = #const XF86XK_Standby
#endif
#ifdef XF86XK_AudioLowerVolume
xF86XK_AudioLowerVolume     :: KeySym
xF86XK_AudioLowerVolume     = #const XF86XK_AudioLowerVolume
#endif
#ifdef XF86XK_AudioMute
xF86XK_AudioMute            :: KeySym
xF86XK_AudioMute            = #const XF86XK_AudioMute
#endif
#ifdef XF86XK_AudioRaiseVolume
xF86XK_AudioRaiseVolume     :: KeySym
xF86XK_AudioRaiseVolume     = #const XF86XK_AudioRaiseVolume
#endif
#ifdef XF86XK_AudioPlay
xF86XK_AudioPlay            :: KeySym
xF86XK_AudioPlay            = #const XF86XK_AudioPlay
#endif
#ifdef XF86XK_AudioStop
xF86XK_AudioStop            :: KeySym
xF86XK_AudioStop            = #const XF86XK_AudioStop
#endif
#ifdef XF86XK_AudioPrev
xF86XK_AudioPrev            :: KeySym
xF86XK_AudioPrev            = #const XF86XK_AudioPrev
#endif
#ifdef XF86XK_AudioNext
xF86XK_AudioNext            :: KeySym
xF86XK_AudioNext            = #const XF86XK_AudioNext
#endif
#ifdef XF86XK_HomePage
xF86XK_HomePage             :: KeySym
xF86XK_HomePage             = #const XF86XK_HomePage
#endif
#ifdef XF86XK_Mail
xF86XK_Mail                 :: KeySym
xF86XK_Mail                 = #const XF86XK_Mail
#endif
#ifdef XF86XK_Start
xF86XK_Start                :: KeySym
xF86XK_Start                = #const XF86XK_Start
#endif
#ifdef XF86XK_Search
xF86XK_Search               :: KeySym
xF86XK_Search               = #const XF86XK_Search
#endif
#ifdef XF86XK_AudioRecord
xF86XK_AudioRecord          :: KeySym
xF86XK_AudioRecord          = #const XF86XK_AudioRecord
#endif
#ifdef XF86XK_Calculator
xF86XK_Calculator           :: KeySym
xF86XK_Calculator           = #const XF86XK_Calculator
#endif
#ifdef XF86XK_Memo
xF86XK_Memo                 :: KeySym
xF86XK_Memo                 = #const XF86XK_Memo
#endif
#ifdef XF86XK_ToDoList
xF86XK_ToDoList             :: KeySym
xF86XK_ToDoList             = #const XF86XK_ToDoList
#endif
#ifdef XF86XK_Calendar
xF86XK_Calendar             :: KeySym
xF86XK_Calendar             = #const XF86XK_Calendar
#endif
#ifdef XF86XK_PowerDown
xF86XK_PowerDown            :: KeySym
xF86XK_PowerDown            = #const XF86XK_PowerDown
#endif
#ifdef XF86XK_ContrastAdjust
xF86XK_ContrastAdjust       :: KeySym
xF86XK_ContrastAdjust       = #const XF86XK_ContrastAdjust
#endif
#ifdef XF86XK_RockerUp
xF86XK_RockerUp             :: KeySym
xF86XK_RockerUp             = #const XF86XK_RockerUp
#endif
#ifdef XF86XK_RockerDown
xF86XK_RockerDown           :: KeySym
xF86XK_RockerDown           = #const XF86XK_RockerDown
#endif
#ifdef XF86XK_RockerEnter
xF86XK_RockerEnter          :: KeySym
xF86XK_RockerEnter          = #const XF86XK_RockerEnter
#endif
#ifdef XF86XK_Back
xF86XK_Back                 :: KeySym
xF86XK_Back                 = #const XF86XK_Back
#endif
#ifdef XF86XK_Forward
xF86XK_Forward              :: KeySym
xF86XK_Forward              = #const XF86XK_Forward
#endif
#ifdef XF86XK_Stop
xF86XK_Stop                 :: KeySym
xF86XK_Stop                 = #const XF86XK_Stop
#endif
#ifdef XF86XK_Refresh
xF86XK_Refresh              :: KeySym
xF86XK_Refresh              = #const XF86XK_Refresh
#endif
#ifdef XF86XK_PowerOff
xF86XK_PowerOff             :: KeySym
xF86XK_PowerOff             = #const XF86XK_PowerOff
#endif
#ifdef XF86XK_WakeUp
xF86XK_WakeUp               :: KeySym
xF86XK_WakeUp               = #const XF86XK_WakeUp
#endif
#ifdef XF86XK_Eject
xF86XK_Eject                :: KeySym
xF86XK_Eject                = #const XF86XK_Eject
#endif
#ifdef XF86XK_ScreenSaver
xF86XK_ScreenSaver          :: KeySym
xF86XK_ScreenSaver          = #const XF86XK_ScreenSaver
#endif
#ifdef XF86XK_WWW
xF86XK_WWW                  :: KeySym
xF86XK_WWW                  = #const XF86XK_WWW
#endif
#ifdef XF86XK_Sleep
xF86XK_Sleep                :: KeySym
xF86XK_Sleep                = #const XF86XK_Sleep
#endif
#ifdef XF86XK_Favorites
xF86XK_Favorites            :: KeySym
xF86XK_Favorites            = #const XF86XK_Favorites
#endif
#ifdef XF86XK_AudioPause
xF86XK_AudioPause           :: KeySym
xF86XK_AudioPause           = #const XF86XK_AudioPause
#endif
#ifdef XF86XK_AudioMedia
xF86XK_AudioMedia           :: KeySym
xF86XK_AudioMedia           = #const XF86XK_AudioMedia
#endif
#ifdef XF86XK_MyComputer
xF86XK_MyComputer           :: KeySym
xF86XK_MyComputer           = #const XF86XK_MyComputer
#endif
#ifdef XF86XK_VendorHome
xF86XK_VendorHome           :: KeySym
xF86XK_VendorHome           = #const XF86XK_VendorHome
#endif
#ifdef XF86XK_LightBulb
xF86XK_LightBulb            :: KeySym
xF86XK_LightBulb            = #const XF86XK_LightBulb
#endif
#ifdef XF86XK_Shop
xF86XK_Shop                 :: KeySym
xF86XK_Shop                 = #const XF86XK_Shop
#endif
#ifdef XF86XK_History
xF86XK_History              :: KeySym
xF86XK_History              = #const XF86XK_History
#endif
#ifdef XF86XK_OpenURL
xF86XK_OpenURL              :: KeySym
xF86XK_OpenURL              = #const XF86XK_OpenURL
#endif
#ifdef XF86XK_AddFavorite
xF86XK_AddFavorite          :: KeySym
xF86XK_AddFavorite          = #const XF86XK_AddFavorite
#endif
#ifdef XF86XK_HotLinks
xF86XK_HotLinks             :: KeySym
xF86XK_HotLinks             = #const XF86XK_HotLinks
#endif
#ifdef XF86XK_BrightnessAdjust
xF86XK_BrightnessAdjust     :: KeySym
xF86XK_BrightnessAdjust     = #const XF86XK_BrightnessAdjust
#endif
#ifdef XF86XK_Finance
xF86XK_Finance              :: KeySym
xF86XK_Finance              = #const XF86XK_Finance
#endif
#ifdef XF86XK_Community
xF86XK_Community            :: KeySym
xF86XK_Community            = #const XF86XK_Community
#endif
#ifdef XF86XK_AudioRewind
xF86XK_AudioRewind          :: KeySym
xF86XK_AudioRewind          = #const XF86XK_AudioRewind
#endif
#ifdef XF86XK_XF86BackForward
xF86XK_XF86BackForward      :: KeySym
xF86XK_XF86BackForward      = #const XF86XK_XF86BackForward
#endif
#ifdef XF86XK_Launch0
xF86XK_Launch0              :: KeySym
xF86XK_Launch0              = #const XF86XK_Launch0
#endif
#ifdef XF86XK_Launch1
xF86XK_Launch1              :: KeySym
xF86XK_Launch1              = #const XF86XK_Launch1
#endif
#ifdef XF86XK_Launch2
xF86XK_Launch2              :: KeySym
xF86XK_Launch2              = #const XF86XK_Launch2
#endif
#ifdef XF86XK_Launch3
xF86XK_Launch3              :: KeySym
xF86XK_Launch3              = #const XF86XK_Launch3
#endif
#ifdef XF86XK_Launch4
xF86XK_Launch4              :: KeySym
xF86XK_Launch4              = #const XF86XK_Launch4
#endif
#ifdef XF86XK_Launch5
xF86XK_Launch5              :: KeySym
xF86XK_Launch5              = #const XF86XK_Launch5
#endif
#ifdef XF86XK_Launch6
xF86XK_Launch6              :: KeySym
xF86XK_Launch6              = #const XF86XK_Launch6
#endif
#ifdef XF86XK_Launch7
xF86XK_Launch7              :: KeySym
xF86XK_Launch7              = #const XF86XK_Launch7
#endif
#ifdef XF86XK_Launch8
xF86XK_Launch8              :: KeySym
xF86XK_Launch8              = #const XF86XK_Launch8
#endif
#ifdef XF86XK_Launch9
xF86XK_Launch9              :: KeySym
xF86XK_Launch9              = #const XF86XK_Launch9
#endif
#ifdef XF86XK_LaunchA
xF86XK_LaunchA              :: KeySym
xF86XK_LaunchA              = #const XF86XK_LaunchA
#endif
#ifdef XF86XK_LaunchB
xF86XK_LaunchB              :: KeySym
xF86XK_LaunchB              = #const XF86XK_LaunchB
#endif
#ifdef XF86XK_LaunchC
xF86XK_LaunchC              :: KeySym
xF86XK_LaunchC              = #const XF86XK_LaunchC
#endif
#ifdef XF86XK_LaunchD
xF86XK_LaunchD              :: KeySym
xF86XK_LaunchD              = #const XF86XK_LaunchD
#endif
#ifdef XF86XK_LaunchE
xF86XK_LaunchE              :: KeySym
xF86XK_LaunchE              = #const XF86XK_LaunchE
#endif
#ifdef XF86XK_LaunchF
xF86XK_LaunchF              :: KeySym
xF86XK_LaunchF              = #const XF86XK_LaunchF
#endif
#ifdef XF86XK_ApplicationLeft
xF86XK_ApplicationLeft      :: KeySym
xF86XK_ApplicationLeft      = #const XF86XK_ApplicationLeft
#endif
#ifdef XF86XK_ApplicationRight
xF86XK_ApplicationRight     :: KeySym
xF86XK_ApplicationRight     = #const XF86XK_ApplicationRight
#endif
#ifdef XF86XK_Book
xF86XK_Book                 :: KeySym
xF86XK_Book                 = #const XF86XK_Book
#endif
#ifdef XF86XK_CD
xF86XK_CD                   :: KeySym
xF86XK_CD                   = #const XF86XK_CD
#endif
#ifdef XF86XK_Calculater
xF86XK_Calculater           :: KeySym
xF86XK_Calculater           = #const XF86XK_Calculater
#endif
#ifdef XF86XK_Clear
xF86XK_Clear                :: KeySym
xF86XK_Clear                = #const XF86XK_Clear
#endif
#ifdef XF86XK_Close
xF86XK_Close                :: KeySym
xF86XK_Close                = #const XF86XK_Close
#endif
#ifdef XF86XK_Copy
xF86XK_Copy                 :: KeySym
xF86XK_Copy                 = #const XF86XK_Copy
#endif
#ifdef XF86XK_Cut
xF86XK_Cut                  :: KeySym
xF86XK_Cut                  = #const XF86XK_Cut
#endif
#ifdef XF86XK_Display
xF86XK_Display              :: KeySym
xF86XK_Display              = #const XF86XK_Display
#endif
#ifdef XF86XK_DOS
xF86XK_DOS                  :: KeySym
xF86XK_DOS                  = #const XF86XK_DOS
#endif
#ifdef XF86XK_Documents
xF86XK_Documents            :: KeySym
xF86XK_Documents            = #const XF86XK_Documents
#endif
#ifdef XF86XK_Excel
xF86XK_Excel                :: KeySym
xF86XK_Excel                = #const XF86XK_Excel
#endif
#ifdef XF86XK_Explorer
xF86XK_Explorer             :: KeySym
xF86XK_Explorer             = #const XF86XK_Explorer
#endif
#ifdef XF86XK_Game
xF86XK_Game                 :: KeySym
xF86XK_Game                 = #const XF86XK_Game
#endif
#ifdef XF86XK_Go
xF86XK_Go                   :: KeySym
xF86XK_Go                   = #const XF86XK_Go
#endif
#ifdef XF86XK_iTouch
xF86XK_iTouch               :: KeySym
xF86XK_iTouch               = #const XF86XK_iTouch
#endif
#ifdef XF86XK_LogOff
xF86XK_LogOff               :: KeySym
xF86XK_LogOff               = #const XF86XK_LogOff
#endif
#ifdef XF86XK_Market
xF86XK_Market               :: KeySym
xF86XK_Market               = #const XF86XK_Market
#endif
#ifdef XF86XK_Meeting
xF86XK_Meeting              :: KeySym
xF86XK_Meeting              = #const XF86XK_Meeting
#endif
#ifdef XF86XK_MenuKB
xF86XK_MenuKB               :: KeySym
xF86XK_MenuKB               = #const XF86XK_MenuKB
#endif
#ifdef XF86XK_MenuPB
xF86XK_MenuPB               :: KeySym
xF86XK_MenuPB               = #const XF86XK_MenuPB
#endif
#ifdef XF86XK_MySites
xF86XK_MySites              :: KeySym
xF86XK_MySites              = #const XF86XK_MySites
#endif
#ifdef XF86XK_New
xF86XK_New                  :: KeySym
xF86XK_New                  = #const XF86XK_New
#endif
#ifdef XF86XK_News
xF86XK_News                 :: KeySym
xF86XK_News                 = #const XF86XK_News
#endif
#ifdef XF86XK_OfficeHome
xF86XK_OfficeHome           :: KeySym
xF86XK_OfficeHome           = #const XF86XK_OfficeHome
#endif
#ifdef XF86XK_Open
xF86XK_Open                 :: KeySym
xF86XK_Open                 = #const XF86XK_Open
#endif
#ifdef XF86XK_Option
xF86XK_Option               :: KeySym
xF86XK_Option               = #const XF86XK_Option
#endif
#ifdef XF86XK_Paste
xF86XK_Paste                :: KeySym
xF86XK_Paste                = #const XF86XK_Paste
#endif
#ifdef XF86XK_Phone
xF86XK_Phone                :: KeySym
xF86XK_Phone                = #const XF86XK_Phone
#endif
#ifdef XF86XK_Q
xF86XK_Q                    :: KeySym
xF86XK_Q                    = #const XF86XK_Q
#endif
#ifdef XF86XK_Reply
xF86XK_Reply                :: KeySym
xF86XK_Reply                = #const XF86XK_Reply
#endif
#ifdef XF86XK_Reload
xF86XK_Reload               :: KeySym
xF86XK_Reload               = #const XF86XK_Reload
#endif
#ifdef XF86XK_RotateWindows
xF86XK_RotateWindows        :: KeySym
xF86XK_RotateWindows        = #const XF86XK_RotateWindows
#endif
#ifdef XF86XK_RotationPB
xF86XK_RotationPB           :: KeySym
xF86XK_RotationPB           = #const XF86XK_RotationPB
#endif
#ifdef XF86XK_RotationKB
xF86XK_RotationKB           :: KeySym
xF86XK_RotationKB           = #const XF86XK_RotationKB
#endif
#ifdef XF86XK_Save
xF86XK_Save                 :: KeySym
xF86XK_Save                 = #const XF86XK_Save
#endif
#ifdef XF86XK_ScrollUp
xF86XK_ScrollUp             :: KeySym
xF86XK_ScrollUp             = #const XF86XK_ScrollUp
#endif
#ifdef XF86XK_ScrollDown
xF86XK_ScrollDown           :: KeySym
xF86XK_ScrollDown           = #const XF86XK_ScrollDown
#endif
#ifdef XF86XK_ScrollClick
xF86XK_ScrollClick          :: KeySym
xF86XK_ScrollClick          = #const XF86XK_ScrollClick
#endif
#ifdef XF86XK_Send
xF86XK_Send                 :: KeySym
xF86XK_Send                 = #const XF86XK_Send
#endif
#ifdef XF86XK_Spell
xF86XK_Spell                :: KeySym
xF86XK_Spell                = #const XF86XK_Spell
#endif
#ifdef XF86XK_SplitScreen
xF86XK_SplitScreen          :: KeySym
xF86XK_SplitScreen          = #const XF86XK_SplitScreen
#endif
#ifdef XF86XK_Support
xF86XK_Support              :: KeySym
xF86XK_Support              = #const XF86XK_Support
#endif
#ifdef XF86XK_TaskPane
xF86XK_TaskPane             :: KeySym
xF86XK_TaskPane             = #const XF86XK_TaskPane
#endif
#ifdef XF86XK_Terminal
xF86XK_Terminal             :: KeySym
xF86XK_Terminal             = #const XF86XK_Terminal
#endif
#ifdef XF86XK_Tools
xF86XK_Tools                :: KeySym
xF86XK_Tools                = #const XF86XK_Tools
#endif
#ifdef XF86XK_Travel
xF86XK_Travel               :: KeySym
xF86XK_Travel               = #const XF86XK_Travel
#endif
#ifdef XF86XK_UserPB
xF86XK_UserPB               :: KeySym
xF86XK_UserPB               = #const XF86XK_UserPB
#endif
#ifdef XF86XK_User1KB
xF86XK_User1KB              :: KeySym
xF86XK_User1KB              = #const XF86XK_User1KB
#endif
#ifdef XF86XK_User2KB
xF86XK_User2KB              :: KeySym
xF86XK_User2KB              = #const XF86XK_User2KB
#endif
#ifdef XF86XK_Video
xF86XK_Video                :: KeySym
xF86XK_Video                = #const XF86XK_Video
#endif
#ifdef XF86XK_WheelButton
xF86XK_WheelButton          :: KeySym
xF86XK_WheelButton          = #const XF86XK_WheelButton
#endif
#ifdef XF86XK_Word
xF86XK_Word                 :: KeySym
xF86XK_Word                 = #const XF86XK_Word
#endif
#ifdef XF86XK_Xfer
xF86XK_Xfer                 :: KeySym
xF86XK_Xfer                 = #const XF86XK_Xfer
#endif
#ifdef XF86XK_ZoomIn
xF86XK_ZoomIn               :: KeySym
xF86XK_ZoomIn               = #const XF86XK_ZoomIn
#endif
#ifdef XF86XK_ZoomOut
xF86XK_ZoomOut              :: KeySym
xF86XK_ZoomOut              = #const XF86XK_ZoomOut
#endif
#ifdef XF86XK_Away
xF86XK_Away                 :: KeySym
xF86XK_Away                 = #const XF86XK_Away
#endif
#ifdef XF86XK_Messenger
xF86XK_Messenger            :: KeySym
xF86XK_Messenger            = #const XF86XK_Messenger
#endif
#ifdef XF86XK_WebCam
xF86XK_WebCam               :: KeySym
xF86XK_WebCam               = #const XF86XK_WebCam
#endif
#ifdef XF86XK_MailForward
xF86XK_MailForward          :: KeySym
xF86XK_MailForward          = #const XF86XK_MailForward
#endif
#ifdef XF86XK_Pictures
xF86XK_Pictures             :: KeySym
xF86XK_Pictures             = #const XF86XK_Pictures
#endif
#ifdef XF86XK_Music
xF86XK_Music                :: KeySym
xF86XK_Music                = #const XF86XK_Music
#endif
#ifdef XF86XK_Battery
xF86XK_Battery              :: KeySym
xF86XK_Battery              = #const XF86XK_Battery
#endif
#ifdef XF86XK_Bluetooth
xF86XK_Bluetooth            :: KeySym
xF86XK_Bluetooth            = #const XF86XK_Bluetooth
#endif
#ifdef XF86XK_WLAN
xF86XK_WLAN                 :: KeySym
xF86XK_WLAN                 = #const XF86XK_WLAN
#endif
#ifdef XF86XK_UWB
xF86XK_UWB                  :: KeySym
xF86XK_UWB                  = #const XF86XK_UWB
#endif
#ifdef XF86XK_AudioForward
xF86XK_AudioForward         :: KeySym
xF86XK_AudioForward         = #const XF86XK_AudioForward
#endif
#ifdef XF86XK_AudioRepeat
xF86XK_AudioRepeat          :: KeySym
xF86XK_AudioRepeat          = #const XF86XK_AudioRepeat
#endif
#ifdef XF86XK_AudioRandomPlay
xF86XK_AudioRandomPlay      :: KeySym
xF86XK_AudioRandomPlay      = #const XF86XK_AudioRandomPlay
#endif
#ifdef XF86XK_Subtitle
xF86XK_Subtitle             :: KeySym
xF86XK_Subtitle             = #const XF86XK_Subtitle
#endif
#ifdef XF86XK_AudioCycleTrack
xF86XK_AudioCycleTrack      :: KeySym
xF86XK_AudioCycleTrack      = #const XF86XK_AudioCycleTrack
#endif
#ifdef XF86XK_CycleAngle
xF86XK_CycleAngle           :: KeySym
xF86XK_CycleAngle           = #const XF86XK_CycleAngle
#endif
#ifdef XF86XK_FrameBack
xF86XK_FrameBack            :: KeySym
xF86XK_FrameBack            = #const XF86XK_FrameBack
#endif
#ifdef XF86XK_FrameForward
xF86XK_FrameForward         :: KeySym
xF86XK_FrameForward         = #const XF86XK_FrameForward
#endif
#ifdef XF86XK_Time
xF86XK_Time                 :: KeySym
xF86XK_Time                 = #const XF86XK_Time
#endif
#ifdef XF86XK_Select
xF86XK_Select               :: KeySym
xF86XK_Select               = #const XF86XK_Select
#endif
#ifdef XF86XK_View
xF86XK_View                 :: KeySym
xF86XK_View                 = #const XF86XK_View
#endif
#ifdef XF86XK_TopMenu
xF86XK_TopMenu              :: KeySym
xF86XK_TopMenu              = #const XF86XK_TopMenu
#endif
#ifdef XF86XK_Red
xF86XK_Red                  :: KeySym
xF86XK_Red                  = #const XF86XK_Red
#endif
#ifdef XF86XK_Green
xF86XK_Green                :: KeySym
xF86XK_Green                = #const XF86XK_Green
#endif
#ifdef XF86XK_Yellow
xF86XK_Yellow               :: KeySym
xF86XK_Yellow               = #const XF86XK_Yellow
#endif
#ifdef XF86XK_Blue
xF86XK_Blue                 :: KeySym
xF86XK_Blue                 = #const XF86XK_Blue
#endif
#ifdef XF86XK_Suspend
xF86XK_Suspend              :: KeySym
xF86XK_Suspend              = #const XF86XK_Suspend
#endif
#ifdef XF86XK_Hibernate
xF86XK_Hibernate            :: KeySym
xF86XK_Hibernate            = #const XF86XK_Hibernate
#endif
#ifdef XF86XK_TouchpadToggle
xF86XK_TouchpadToggle       :: KeySym
xF86XK_TouchpadToggle       = #const XF86XK_TouchpadToggle
#endif
#ifdef XF86XK_TouchpadOn
xF86XK_TouchpadOn           :: KeySym
xF86XK_TouchpadOn           = #const XF86XK_TouchpadOn
#endif
#ifdef XF86XK_TouchpadOff
xF86XK_TouchpadOff          :: KeySym
xF86XK_TouchpadOff          = #const XF86XK_TouchpadOff
#endif
#ifdef XF86XK_AudioMicMute
xF86XK_AudioMicMute         :: KeySym
xF86XK_AudioMicMute         = #const XF86XK_AudioMicMute
#endif
#ifdef XF86XK_LogWindowTree
xF86XK_LogWindowTree        :: KeySym
xF86XK_LogWindowTree        = #const XF86XK_LogWindowTree
#endif
#ifdef XF86XK_LogGrabInfo
xF86XK_LogGrabInfo          :: KeySym
xF86XK_LogGrabInfo          = #const XF86XK_LogGrabInfo
#endif
#ifdef XF86XK_Switch_VT_1
xF86XK_Switch_VT_1          :: KeySym
xF86XK_Switch_VT_1          = #const XF86XK_Switch_VT_1
#endif
#ifdef XF86XK_Switch_VT_2
xF86XK_Switch_VT_2          :: KeySym
xF86XK_Switch_VT_2          = #const XF86XK_Switch_VT_2
#endif
#ifdef XF86XK_Switch_VT_3
xF86XK_Switch_VT_3          :: KeySym
xF86XK_Switch_VT_3          = #const XF86XK_Switch_VT_3
#endif
#ifdef XF86XK_Switch_VT_4
xF86XK_Switch_VT_4          :: KeySym
xF86XK_Switch_VT_4          = #const XF86XK_Switch_VT_4
#endif
#ifdef XF86XK_Switch_VT_5
xF86XK_Switch_VT_5          :: KeySym
xF86XK_Switch_VT_5          = #const XF86XK_Switch_VT_5
#endif
#ifdef XF86XK_Switch_VT_6
xF86XK_Switch_VT_6          :: KeySym
xF86XK_Switch_VT_6          = #const XF86XK_Switch_VT_6
#endif
#ifdef XF86XK_Switch_VT_7
xF86XK_Switch_VT_7          :: KeySym
xF86XK_Switch_VT_7          = #const XF86XK_Switch_VT_7
#endif
#ifdef XF86XK_Switch_VT_8
xF86XK_Switch_VT_8          :: KeySym
xF86XK_Switch_VT_8          = #const XF86XK_Switch_VT_8
#endif
#ifdef XF86XK_Switch_VT_9
xF86XK_Switch_VT_9          :: KeySym
xF86XK_Switch_VT_9          = #const XF86XK_Switch_VT_9
#endif
#ifdef XF86XK_Switch_VT_10
xF86XK_Switch_VT_10         :: KeySym
xF86XK_Switch_VT_10         = #const XF86XK_Switch_VT_10
#endif
#ifdef XF86XK_Switch_VT_11
xF86XK_Switch_VT_11         :: KeySym
xF86XK_Switch_VT_11         = #const XF86XK_Switch_VT_11
#endif
#ifdef XF86XK_Switch_VT_12
xF86XK_Switch_VT_12         :: KeySym
xF86XK_Switch_VT_12         = #const XF86XK_Switch_VT_12
#endif
#ifdef XF86XK_Ungrab
xF86XK_Ungrab               :: KeySym
xF86XK_Ungrab               = #const XF86XK_Ungrab
#endif
#ifdef XF86XK_ClearGrab
xF86XK_ClearGrab            :: KeySym
xF86XK_ClearGrab            = #const XF86XK_ClearGrab
#endif
#ifdef XF86XK_Next_VMode
xF86XK_Next_VMode           :: KeySym
xF86XK_Next_VMode           = #const XF86XK_Next_VMode
#endif
#ifdef XF86XK_Prev_VMode
xF86XK_Prev_VMode           :: KeySym
xF86XK_Prev_VMode           = #const XF86XK_Prev_VMode
#endif
