# NSPR emulation library

Author: Max Bolingbroke (<batterseapower@hotmail.com>)

This library was created by pulling together the minimal pieces of NSPR required to get the Universal Character Set
Detector (UCSD) to compile. It turns out that the UCSD uses only very minimal parts of NSPR, so we can get away with just a few
header files and totally forget about linking to the library.

Precisely, we used these files from [NSPR v4.8.6](https://ftp.mozilla.org/pub/mozilla.org/nspr/releases/v4.8.6/):

  * prtypes.h
  * prmem.h
  * obsolete/protypes.h

I then patched some prototypes in prmem.h to use C library functions directly. The protypes were replaced with #define directives
that ensure that callers of PR_Malloc, PR_Calloc, PR_Realloc, PR_Free just use their C library counterparts directly.

To finish off, I needed to provide prcpucfg.h. Normally this is generated by the nspr build process, but to simplify things I used
the version from [Google's Chrome source tree](http://src.chromium.org/viewvc/chrome/trunk/src/base/third_party/nspr/prcpucfg.h?view=markup)
that just uses the preprocessor to choose between several pre-generated versions.

I had to patch the Google-provided prcpucfg.h so that the #included paths pointed to the right directory.

## Licensing

Chromium (and thus presumably their contribution) is licensed under the BSD license.

NSPR is licensed under the MPL/GPL/LGPL tri-license.

Thus, this emulation library is licensed under the LGPL (I think).