/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.Index;
import ucar.grib.TableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.grib.GribVariable;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Orthographic;
import ucar.unidata.geoloc.projection.RotatedLatLon;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.util.GaussianLatitudes;
import ucar.unidata.util.StringUtil;

public class GribHorizCoordSys {
    private static Logger log = LoggerFactory.getLogger(GribHorizCoordSys.class);
    private TableLookup lookup;
    private Index.GdsRecord gdsIndex;
    private Group g;
    int nx;
    int ny;
    double dx;
    double dy;
    private String grid_name;
    private String shape_name;
    private String id;
    private boolean isLatLon = true;
    private boolean isGaussian = false;
    Map<String, GribVariable> varHash = new HashMap<String, GribVariable>(200);
    Map<String, List<GribVariable>> productHash = new HashMap<String, List<GribVariable>>(100);
    HashMap vcsHash = new HashMap(30);
    private double startx;
    private double starty;
    private ProjectionImpl proj;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    GribHorizCoordSys(Index.GdsRecord gdsIndex, TableLookup lookup, Group g) {
        this.gdsIndex = gdsIndex;
        this.lookup = lookup;
        this.g = g;
        this.nx = gdsIndex.nx;
        this.ny = gdsIndex.ny;
        this.dx = gdsIndex.dx * 0.001;
        this.dy = gdsIndex.dy * 0.001;
        this.grid_name = lookup.getGridName(gdsIndex);
        this.grid_name = StringUtil.replace(this.grid_name, ' ', "_");
        this.shape_name = lookup.getShapeName(gdsIndex);
        this.g = g;
        this.isLatLon = lookup.isLatLon(gdsIndex);
        String string = this.id = g == null ? this.grid_name : g.getName();
        if (this.isLatLon && lookup.getProjectionType(gdsIndex) == 8) {
            this.isGaussian = true;
            double np = 90.0;
            String nps = (String)gdsIndex.params.get("Np");
            if (null != nps) {
                np = Double.parseDouble(nps);
            }
            gdsIndex.dy = np;
        }
    }

    String getID() {
        return this.id;
    }

    String getGridName() {
        return this.grid_name;
    }

    Group getGroup() {
        return this.g;
    }

    boolean isLatLon() {
        return this.isLatLon;
    }

    int getNx() {
        return this.nx;
    }

    int getNy() {
        return this.ny;
    }

    private double getDxInKm() {
        return this.dx;
    }

    private double getDyInKm() {
        return this.dy;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile) {
        if (this.isLatLon) {
            ncfile.addDimension(this.g, new Dimension("lat", this.ny));
            ncfile.addDimension(this.g, new Dimension("lon", this.nx));
        } else {
            ncfile.addDimension(this.g, new Dimension("y", this.ny));
            ncfile.addDimension(this.g, new Dimension("x", this.nx));
        }
    }

    void addToNetcdfFile(NetcdfFile ncfile) {
        if (this.isLatLon) {
            double dy;
            double d = dy = this.gdsIndex.readDouble("La2") < this.gdsIndex.La1 ? -this.gdsIndex.dy : this.gdsIndex.dy;
            if (this.isGaussian) {
                this.addGaussianLatAxis(ncfile, "lat", "degrees_north", "latitude coordinate", "latitude", AxisType.Lat);
            } else {
                this.addCoordAxis(ncfile, "lat", this.gdsIndex.ny, this.gdsIndex.La1, dy, "degrees_north", "latitude coordinate", "latitude", AxisType.Lat);
            }
            this.addCoordAxis(ncfile, "lon", this.gdsIndex.nx, this.gdsIndex.Lo1, this.gdsIndex.dx, "degrees_east", "longitude coordinate", "longitude", AxisType.Lon);
            this.addCoordSystemVariable(ncfile, "latLonCoordSys", "time lat lon");
        } else {
            boolean hasProj = this.makeProjection(ncfile);
            if (hasProj) {
                double[] xData;
                double[] yData;
                if (this.lookup.getProjectionType(this.gdsIndex) == 10) {
                    double dy = this.gdsIndex.readDouble("La2") < this.gdsIndex.La1 ? -this.gdsIndex.dy : this.gdsIndex.dy;
                    yData = this.addCoordAxis(ncfile, "y", this.gdsIndex.ny, this.gdsIndex.La1, dy, "degrees", "y coordinate of projection", "projection_y_coordinate", AxisType.GeoY);
                    xData = this.addCoordAxis(ncfile, "x", this.gdsIndex.nx, this.gdsIndex.Lo1, this.gdsIndex.dx, "degrees", "x coordinate of projection", "projection_x_coordinate", AxisType.GeoX);
                } else {
                    yData = this.addCoordAxis(ncfile, "y", this.gdsIndex.ny, this.starty, this.getDyInKm(), "km", "y coordinate of projection", "projection_y_coordinate", AxisType.GeoY);
                    xData = this.addCoordAxis(ncfile, "x", this.gdsIndex.nx, this.startx, this.getDxInKm(), "km", "x coordinate of projection", "projection_x_coordinate", AxisType.GeoX);
                }
                if (GribServiceProvider.addLatLon) {
                    this.addLatLon2D(ncfile, xData, yData);
                }
            } else {
                log.warn("Unknown grid type= " + this.gdsIndex.grid_type + "; no projection found");
            }
        }
    }

    void empty() {
        this.gdsIndex = null;
        this.varHash = null;
        this.productHash = null;
        this.vcsHash = null;
    }

    private double[] addCoordAxis(NetcdfFile ncfile, String name, int n, double start, double incr, String units, String desc, String standard_name, AxisType axis) {
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = start + incr * (double)i;
        }
        Array dataArray = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)data);
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        v.addAttribute(new Attribute("grid_spacing", incr + " " + units));
        v.addAttribute(new Attribute("_CoordinateAxisType", axis.toString()));
        ncfile.addVariable(this.g, v);
        return data;
    }

    private double[] addGaussianLatAxis(NetcdfFile ncfile, String name, String units, String desc, String standard_name, AxisType axis) {
        double np = this.gdsIndex.readDouble("NumberParallels");
        if (Double.isNaN(np)) {
            np = this.gdsIndex.readDouble("Np");
        }
        if (Double.isNaN(np)) {
            throw new IllegalArgumentException("Gaussian Lat/Lon grid must have NumberParallels parameter");
        }
        double startLat = this.gdsIndex.La1;
        double endLat = this.gdsIndex.readDouble("La2");
        int nlats = (int)(2.0 * np);
        GaussianLatitudes gaussLats = new GaussianLatitudes(nlats);
        int bestStartIndex = 0;
        int bestEndIndex = 0;
        double bestStartDiff = Double.MAX_VALUE;
        double bestEndDiff = Double.MAX_VALUE;
        for (int i = 0; i < nlats; ++i) {
            double diff = Math.abs(gaussLats.latd[i] - startLat);
            if (diff < bestStartDiff) {
                bestStartDiff = diff;
                bestStartIndex = i;
            }
            if (!((diff = Math.abs(gaussLats.latd[i] - endLat)) < bestEndDiff)) continue;
            bestEndDiff = diff;
            bestEndIndex = i;
        }
        assert (Math.abs(bestEndIndex - bestStartIndex + 1) == this.gdsIndex.ny);
        boolean goesUp = bestEndIndex > bestStartIndex;
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        int n = this.gdsIndex.ny;
        int useIndex = bestStartIndex;
        double[] data = new double[n];
        double[] gaussw = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = gaussLats.latd[useIndex];
            gaussw[i] = gaussLats.gaussw[useIndex];
            if (goesUp) {
                ++useIndex;
                continue;
            }
            --useIndex;
        }
        Array dataArray = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)data);
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        v.addAttribute(new Attribute("weights", "gaussw"));
        v.addAttribute(new Attribute("_CoordinateAxisType", axis.toString()));
        ncfile.addVariable(this.g, v);
        v = new Variable(ncfile, this.g, null, "gaussw");
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        v.addAttribute(new Attribute("long_name", "gaussian weights (unnormalized)"));
        dataArray = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)gaussw);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(this.g, v);
        return data;
    }

    private void addLatLon2D(NetcdfFile ncfile, double[] xData, double[] yData) {
        Variable latVar = new Variable(ncfile, this.g, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions("y x");
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, this.g, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions("y x");
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                this.proj.projToLatLon(projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        ncfile.addVariable(this.g, latVar);
        ncfile.addVariable(this.g, lonVar);
    }

    private boolean makeProjection(NetcdfFile ncfile) {
        switch (this.lookup.getProjectionType(this.gdsIndex)) {
            case 10: {
                this.makeRotatedLatLon(ncfile);
                break;
            }
            case 1: {
                this.makePS();
                break;
            }
            case 2: {
                this.makeLC();
                break;
            }
            case 3: {
                this.makeMercator();
                break;
            }
            case 7: {
                this.makeSpaceViewOrOthographic();
                break;
            }
            default: {
                return false;
            }
        }
        Variable v = new Variable(ncfile, this.g, null, this.grid_name);
        v.setDataType(DataType.CHAR);
        v.setDimensions("");
        char[] data = new char[]{'d'};
        Array dataArray = Array.factory(DataType.CHAR, new int[0], (Object)data);
        v.setCachedData(dataArray, false);
        for (Attribute att : this.attributes) {
            v.addAttribute(att);
        }
        v.addAttribute(new Attribute("earth_shape", this.shape_name));
        if (this.gdsIndex.grid_shape_code == 1) {
            v.addAttribute(new Attribute("spherical_earth_radius_meters", this.gdsIndex.radius_spherical_earth));
        }
        this.addGDSparams(v);
        ncfile.addVariable(this.g, v);
        return true;
    }

    private void addGDSparams(Variable v) {
        Set keys = this.gdsIndex.params.keySet();
        ArrayList keyList = new ArrayList(keys);
        Collections.sort(keyList);
        for (String key : keyList) {
            String name = "GRIB_param_" + key;
            String vals = (String)this.gdsIndex.params.get(key);
            try {
                int vali = Integer.parseInt(vals);
                v.addAttribute(new Attribute(name, vali));
            }
            catch (Exception e) {
                try {
                    double vald = Double.parseDouble(vals);
                    v.addAttribute(new Attribute(name, vald));
                }
                catch (Exception e2) {
                    v.addAttribute(new Attribute(name, vals));
                }
            }
        }
    }

    private void addCoordSystemVariable(NetcdfFile ncfile, String name, String dims) {
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.CHAR);
        v.setDimensions("");
        Array dataArray = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{'0'});
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("_CoordinateAxes", dims));
        if (!this.isLatLon()) {
            v.addAttribute(new Attribute("_CoordinateTransforms", this.getGridName()));
        }
        this.addGDSparams(v);
        ncfile.addVariable(this.g, v);
    }

    private void makeLC() {
        this.proj = new LambertConformal(this.gdsIndex.latin1, this.gdsIndex.LoV, this.gdsIndex.latin1, this.gdsIndex.latin2);
        LatLonPointImpl startLL = new LatLonPointImpl(this.gdsIndex.La1, this.gdsIndex.Lo1);
        ProjectionPointImpl start = (ProjectionPointImpl)this.proj.latLonToProj(startLL);
        this.startx = start.getX();
        this.starty = start.getY();
        if (GribServiceProvider.debugProj) {
            System.out.println("GribHorizCoordSys.makeLC start at latlon " + startLL);
            double Lo2 = this.gdsIndex.readDouble("Lo2");
            double La2 = this.gdsIndex.readDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GribHorizCoordSys.makeLC end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj(endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)this.getNx() * this.getDxInKm();
            double endy = this.starty + (double)this.getNy() * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
        this.attributes.add(new Attribute("grid_mapping_name", "lambert_conformal_conic"));
        if (this.gdsIndex.latin1 == this.gdsIndex.latin2) {
            this.attributes.add(new Attribute("standard_parallel", this.gdsIndex.latin1));
        } else {
            double[] data = new double[]{this.gdsIndex.latin1, this.gdsIndex.latin2};
            this.attributes.add(new Attribute("standard_parallel", Array.factory(DataType.DOUBLE, new int[]{2}, (Object)data)));
        }
        this.attributes.add(new Attribute("longitude_of_central_meridian", this.gdsIndex.LoV));
        this.attributes.add(new Attribute("latitude_of_projection_origin", this.gdsIndex.latin1));
    }

    private void makePS() {
        double scale = 0.933;
        double latOrigin = 90.0;
        String s = (String)this.gdsIndex.params.get("NpProj");
        if (s != null && !s.equalsIgnoreCase("true")) {
            latOrigin = -90.0;
        }
        this.proj = new Stereographic(latOrigin, this.gdsIndex.LoV, scale);
        ProjectionPointImpl start = (ProjectionPointImpl)this.proj.latLonToProj(new LatLonPointImpl(this.gdsIndex.La1, this.gdsIndex.Lo1));
        this.startx = start.getX();
        this.starty = start.getY();
        if (GribServiceProvider.debugProj) {
            System.out.println("start at proj coord " + start);
            LatLonPoint llpt = this.proj.projToLatLon(start);
            System.out.println("   end at lat/lon coord " + llpt);
            System.out.println("   should be lat=" + this.gdsIndex.La1 + " lon=" + this.gdsIndex.Lo1);
        }
        this.attributes.add(new Attribute("grid_mapping_name", "polar_stereographic"));
        this.attributes.add(new Attribute("longitude_of_projection_origin", this.gdsIndex.LoV));
        this.attributes.add(new Attribute("straight_vertical_longitude_from_pole", this.gdsIndex.LoV));
        this.attributes.add(new Attribute("scale_factor_at_projection_origin", scale));
        this.attributes.add(new Attribute("latitude_of_projection_origin", latOrigin));
    }

    private void makeMercator() {
        double Latin = this.gdsIndex.readDouble("LaD");
        if (Double.isNaN(Latin)) {
            Latin = this.gdsIndex.readDouble("Latin");
        }
        double Lo1 = this.gdsIndex.Lo1;
        double La1 = this.gdsIndex.La1;
        this.proj = new Mercator(Lo1, Latin);
        LatLonPointImpl startLL = new LatLonPointImpl(La1, Lo1);
        ProjectionPoint startP = this.proj.latLonToProj(startLL);
        this.startx = startP.getX();
        this.starty = startP.getY();
        this.attributes.add(new Attribute("grid_mapping_name", "mercator"));
        this.attributes.add(new Attribute("standard_parallel", Latin));
        this.attributes.add(new Attribute("longitude_of_projection_origin", Lo1));
        if (GribServiceProvider.debugProj) {
            double Lo2 = this.gdsIndex.readDouble("Lo2");
            if (Lo2 < Lo2) {
                Lo2 += 360.0;
            }
            double La2 = this.gdsIndex.readDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GribHorizCoordSys.makeMercator: start at latlon= " + startLL);
            System.out.println("                                  end at latlon= " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj(endLL);
            System.out.println("   start at proj coord " + new ProjectionPointImpl(this.startx, this.starty));
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)(this.getNx() - 1) * this.getDxInKm();
            double endy = this.starty + (double)(this.getNy() - 1) * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }

    private void makeRotatedLatLon(NetcdfFile ncfile) {
        String spAngle;
        String spLon;
        double splat = 0.0;
        double splon = 0.0;
        double spangle = 0.0;
        String spLat = (String)this.gdsIndex.params.get("SpLat");
        if (null != spLat) {
            splat = Double.parseDouble(spLat);
        }
        if (null != (spLon = (String)this.gdsIndex.params.get("SpLon"))) {
            splon = Double.parseDouble(spLon);
        }
        if (null != (spAngle = (String)this.gdsIndex.params.get("RotationAngle"))) {
            spangle = Double.parseDouble(spAngle);
        }
        this.proj = new RotatedLatLon(splat, splon, spangle);
        LatLonPoint startLL = this.proj.projToLatLon(new ProjectionPointImpl(this.gdsIndex.Lo1, this.gdsIndex.La1));
        this.startx = startLL.getLongitude();
        this.starty = startLL.getLatitude();
        this.addCoordSystemVariable(ncfile, "latLonCoordSys", "time y x");
        this.attributes.add(new Attribute("grid_mapping_name", "rotated_lat_lon"));
        this.attributes.add(new Attribute("grid_south_pole_latitude", new Double(splat)));
        this.attributes.add(new Attribute("grid_south_pole_longitude", new Double(splon)));
        this.attributes.add(new Attribute("grid_south_pole_angle", new Double(spangle)));
        if (GribServiceProvider.debugProj) {
            System.out.println("Location of pole of rotated grid:");
            System.out.println("Lon=" + splon + ", Lat=" + splat);
            System.out.println("Axial rotation about pole of rotated grid:" + spangle);
            System.out.println("Location of LL in rotated grid:");
            System.out.println("Lon=" + this.gdsIndex.Lo1 + ", Lat=" + this.gdsIndex.La1);
            System.out.println("Location of LL in non-rotated grid:");
            System.out.println("Lon=" + this.startx + ", Lat=" + this.starty);
            double Lo2 = this.gdsIndex.readDouble("Lo2");
            double La2 = this.gdsIndex.readDouble("La2");
            System.out.println("Location of UR in rotated grid:");
            System.out.println("Lon=" + Lo2 + ", Lat=" + La2);
            System.out.println("Location of UR in non-rotated grid:");
            LatLonPoint endUR = this.proj.projToLatLon(new ProjectionPointImpl(Lo2, La2));
            System.out.println("Lon=" + endUR.getLongitude() + ", Lat=" + endUR.getLatitude());
            double dy = La2 < this.gdsIndex.La1 ? -this.gdsIndex.dy : this.gdsIndex.dy;
            double endx = this.gdsIndex.Lo1 + (double)(this.getNx() - 1) * this.gdsIndex.dx;
            double endy = this.gdsIndex.La1 + (double)(this.getNy() - 1) * dy;
            System.out.println("End point rotated grid should be x=" + endx + " y=" + endy);
        }
    }

    private void makeSpaceViewOrOthographic() {
        double minor_axis;
        double Lat0 = this.gdsIndex.readDouble("Lap");
        double Lon0 = this.gdsIndex.readDouble("Lop");
        double xp = this.gdsIndex.readDouble("Xp");
        double yp = this.gdsIndex.readDouble("Yp");
        double dx = this.gdsIndex.readDouble("Dx");
        double dy = this.gdsIndex.readDouble("Dy");
        double major_axis = this.gdsIndex.readDouble("major_axis_earth");
        if (Double.isNaN(major_axis)) {
            major_axis = this.gdsIndex.readDouble("grid_major_axis_earth");
        }
        if (Double.isNaN(minor_axis = this.gdsIndex.readDouble("minor_axis_earth"))) {
            minor_axis = this.gdsIndex.readDouble("grid_minor_axis_earth");
        }
        double nr = this.gdsIndex.readDouble("Nr") * 1.0E-6;
        double apparentDiameter = 2.0 * Math.sqrt((nr - 1.0) / (nr + 1.0));
        double gridLengthX = major_axis * apparentDiameter / dx;
        double gridLengthY = minor_axis * apparentDiameter / dy;
        this.gdsIndex.dx = 1000.0 * gridLengthX;
        this.gdsIndex.addParam("Dx", String.valueOf(1000.0 * gridLengthX));
        this.gdsIndex.dy = 1000.0 * gridLengthY;
        this.gdsIndex.addParam("Dy", String.valueOf(1000.0 * gridLengthY));
        this.startx = -gridLengthX * xp;
        this.starty = -gridLengthY * yp;
        double radius = Earth.getRadius() / 1000.0;
        if (nr == 1.111111111E9) {
            this.proj = new Orthographic(Lat0, Lon0, radius);
            this.attributes.add(new Attribute("grid_mapping_name", "orthographic"));
            this.attributes.add(new Attribute("longitude_of_projection_origin", Lon0));
            this.attributes.add(new Attribute("latitude_of_projection_origin", Lat0));
        } else {
            double height = (nr - 1.0) * radius;
            this.proj = new VerticalPerspectiveView(Lat0, Lon0, radius, height);
            this.attributes.add(new Attribute("grid_mapping_name", "vertical_perspective"));
            this.attributes.add(new Attribute("longitude_of_projection_origin", Lon0));
            this.attributes.add(new Attribute("latitude_of_projection_origin", Lat0));
            this.attributes.add(new Attribute("height_above_earth", height));
        }
        if (GribServiceProvider.debugProj) {
            double Lo2 = this.gdsIndex.readDouble("Lo2") + 360.0;
            double La2 = this.gdsIndex.readDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GribHorizCoordSys.makeOrthographic end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj(endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)this.getNx() * this.getDxInKm();
            double endy = this.starty + (double)this.getNy() * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }
}

