#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("enables or disables speech")

    def run(self):
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "speech", "enabled"
        ):
            self.env["runtime"]["OutputManager"].interrupt_output()
            self.env["runtime"]["OutputManager"].present_text(
                _("speech disabled"), sound_icon="SpeechOff", interrupt=True
            )
        self.env["runtime"]["SettingsManager"].set_setting(
            "speech",
            "enabled",
            str(
                not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                    "speech", "enabled"
                )
            ),
        )
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "speech", "enabled"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("speech enabled"), sound_icon="SpeechOn", interrupt=True
            )

    def set_callback(self, callback):
        pass
