/*
 * $Id: arch_eth_iface.c,v 1.4 2009-01-28 12:59:15 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE

#if defined(OPENBSD) || defined(DARWIN)
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <net/if.h>
#include <termios.h>
/*
 * IEEE 802.3 Ethernet magic constants.  The frame sizes omit the preamble
 * and FCS/CRC (frame check sequence).
 * Taken from Linux /usr/include/linux/if_ether.h
 */
#define ETH_ALEN	6		/* Octets in one ethernet addr   */
#define ETH_HLEN	14		/* Total octets in header.       */
#define ETH_FRAME_LEN	1514		/* Max. octets in frame sans FCS */

#else
#include <net/ethernet.h>
#endif

#endif /* INCLUDE */

#ifdef STATE

struct {
	uint8_t mac[6];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(recv)(struct cpssp *cpssp, const unsigned char *buf, unsigned int len)
{
	static const uint8_t broadcast[6] = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff
	};
	const struct ether_header *hdr = (const struct ether_header *) buf;

	if (memcmp(hdr->ether_dhost, broadcast, ETH_ALEN) != 0
	 && memcmp(hdr->ether_dhost, cpssp->NAME.mac, ETH_ALEN) != 0) {
		/* Message not for us... */
		fprintf(stderr, "Dropping message for %02x:%02x:%02x:%02x:%02x:%02x.\n",
			hdr->ether_dhost[0], hdr->ether_dhost[1],
			hdr->ether_dhost[2], hdr->ether_dhost[3],
			hdr->ether_dhost[4], hdr->ether_dhost[5]);
		return;
	}

	NAME_(to_arp)(cpssp, buf, len);
}

static void
NAME_(create)(struct cpssp *cpssp, const uint8_t *mac)
{
	memcpy(cpssp->NAME.mac, mac, sizeof(cpssp->NAME.mac));
}

static void
NAME_(destroy)(void *cpssp)
{
}

#endif /* BEHAVIOR */
