/*
 * $Id: sig_dio48.h,v 1.10 2012-03-06 14:46:49 siflkres Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_DIO48_H_INCLUDED
#define __SIG_DIO48_H_INCLUDED

#include "sig_gen.h"
#include "sig_std_logic.h"

struct sig_dio48 {
	enum sig_gen_type type;
	struct sig_std_logic *sig[48];
};

extern struct sig_dio48 *
sig_dio48_create(const char *name);
extern void
sig_dio48_destroy(struct sig_dio48 *sig);

extern void
sig_dio48_suspend(struct sig_dio48 *b, FILE *fSig);
extern void
sig_dio48_resume(struct sig_dio48 *b, FILE *fSig);

#endif /* __SIG_DIO48_H_INCLUDED */
