!{\src2tex{textfont=tt}}
!!****m* etsf_electrons/etsf_io_electrons_put
!! NAME
!!  etsf_io_electrons_put
!!
!! FUNCTION
!!    Write data related to the given group in an opened ETSF file (it must be in
!!    write mode, use etsf_io_low_set_write_mode() to change it).
!!    Only associated pointers of argument @folder will be accessed. If any errors
!!    occurs it returns with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * folder <type(etsf_electrons)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_electrons_put(ncid, folder, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_electrons), intent(in) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_electrons_put'
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_electrons_put : enter'
!ENDDEBUG

  
  allocate(varid(9))
  ! Begin by putting the file in write mode.
  call etsf_io_low_set_write_mode(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  if (associated(folder%number_of_electrons)) then
    call etsf_io_low_write_var(ncid, "number_of_electrons", &
                            & folder%number_of_electrons, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%exchange_functional)) then
    call etsf_io_low_write_var(ncid, "exchange_functional", &
                            & folder%exchange_functional, etsf_charlen, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%correlation_functional)) then
    call etsf_io_low_write_var(ncid, "correlation_functional", &
                            & folder%correlation_functional, etsf_charlen, &
                            & lstat, ncvarid = varid(3), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%fermi_energy)) then
    call etsf_io_low_write_var(ncid, "fermi_energy", &
                            & folder%fermi_energy, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%smearing_scheme)) then
    call etsf_io_low_write_var(ncid, "smearing_scheme", &
                            & folder%smearing_scheme, etsf_charlen, &
                            & lstat, ncvarid = varid(5), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%smearing_width)) then
    call etsf_io_low_write_var(ncid, "smearing_width", &
                            & folder%smearing_width, &
                            & lstat, ncvarid = varid(6), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%number_of_states)) then
    call etsf_io_low_write_var(ncid, "number_of_states", &
                            & folder%number_of_states, &
                            & lstat, ncvarid = varid(7), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%eigenvalues)) then
    allocate(start(3), count(3))
    start(:) = 1
    count(:) = 0
    if (folder%eigenvalues__spin_access /= etsf_no_sub_access) then
      start(3) = folder%eigenvalues__spin_access
      count(3) = 1
    end if
    if (folder%eigenvalues__kpoint_access /= etsf_no_sub_access) then
      start(2) = folder%eigenvalues__kpoint_access
      count(2) = 1
    end if
    count(1) = folder%eigenvalues__number_of_states
    if (folder%eigenvalues__state_access /= etsf_no_sub_access) then
      start(1) = folder%eigenvalues__state_access
      count(1) = 1
    end if
    call etsf_io_low_write_var(ncid, "eigenvalues", &
                            & folder%eigenvalues, &
                            & lstat, ncvarid = varid(8), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%occupations)) then
    allocate(start(3), count(3))
    start(:) = 1
    count(:) = 0
    if (folder%occupations__spin_access /= etsf_no_sub_access) then
      start(3) = folder%occupations__spin_access
      count(3) = 1
    end if
    if (folder%occupations__kpoint_access /= etsf_no_sub_access) then
      start(2) = folder%occupations__kpoint_access
      count(2) = 1
    end if
    count(1) = folder%occupations__number_of_states
    if (folder%occupations__state_access /= etsf_no_sub_access) then
      start(1) = folder%occupations__state_access
      count(1) = 1
    end if
    call etsf_io_low_write_var(ncid, "occupations", &
                            & folder%occupations, &
                            & lstat, ncvarid = varid(9), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_electrons_put : exit'
!ENDDEBUG

end subroutine etsf_io_electrons_put
!!***
