// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Diagnostics.CodeAnalysis;

namespace Microsoft.EntityFrameworkCore.Query;

/// <summary>
///     A factory creating managers for SQL aliases, capable of generate uniquified table aliases.
/// </summary>
/// <remarks>
///     <para>
///         The service lifetime is <see cref="ServiceLifetime.Singleton" />. This means a single instance
///         is used by many <see cref="DbContext" /> instances. The implementation must be thread-safe.
///         This service cannot depend on services registered as <see cref="ServiceLifetime.Scoped" />.
///     </para>
///     <para>
///         See <see href="https://aka.ms/efcore-docs-providers">Implementation of database providers and extensions</see>
///         for more information and examples.
///     </para>
/// </remarks>
[Experimental(EFDiagnostics.ProviderExperimentalApi)]
public interface ISqlAliasManagerFactory
{
    /// <summary>
    ///     Creates a new <see cref="SqlAliasManager" />.
    /// </summary>
    SqlAliasManager Create();
}
