# pki-server-ocsp 8 "Mar 21, 2018" PKI "PKI OCSP Management Commands"

## NAME

pki-server-ocsp - Command-line interface for managing PKI OCSP.

## SYNOPSIS

**pki-server** [*CLI-options*] **ocsp-clone-prepare** [*command-options*]  
**pki-server** [*CLI-options*] **ocsp-audit-event-find** [*command-options*]  
**pki-server** [*CLI-options*] **ocsp-audit-event-enable** [*command-options*] *event-ID*  
**pki-server** [*CLI-options*] **ocsp-audit-event-modify** [*command-options*] *event-ID*  
**pki-server** [*CLI-options*] **ocsp-audit-event-disable** [*command-options*] *event-ID*  
**pki-server** [*CLI-options*] **ocsp-audit-file-find** [*command-options*]  
**pki-server** [*CLI-options*] **ocsp-audit-file-verify** [*command-options*]  

## DESCRIPTION

The **pki-server ocsp** commands provide command-line interfaces to manage PKI OCSP.

**pki-server** [*CLI-options*] **ocsp** [*command-options*]  
    This command is to list available PKI OCSP management commands.

**pki-server** [*CLI-options*] **ocsp-clone-prepare** [*command-options*]  
    This command export  OCSP subsystem certificates into a PKCS #12 file with private keys.

**pki-server** [*CLI-options*] **ocsp-audit-event-find** [*command-options*]  
    This command list all the audit events which are enabled/disabled.

**pki-server** [*CLI-options*] **ocsp-audit-event-enable** [*command-options*] *event-ID*  
    This command will enable audit events in the OCSP.

**pki-server** [*CLI-options*] **ocsp-audit-event-disable** [*command-options*] *event-ID*  
    This command will disable audit events in the OCSP.

**pki-server** [*CLI-options*] **ocsp-audit-event-modify** [*command-options*] *event-ID*  
    This command will modify the event filter for audit events.

**pki-server** [*CLI-options*] **ocsp-audit-file-find** [*command-options*]  
    This command lists the audit log files generated by the OCSP.

**pki-server** [*CLI-options*] **ocsp-audit-file-verify** [*command-options*]  
    This command will verify whether the signatures in the audit log files are valid.

## AUDIT EVENTS

Logging audit events:

- AUDIT_LOG_STARTUP
- AUDIT_LOG_SHUTDOWN
- AUDIT_LOG_DELETE
- LOG_PATH_CHANGE
- LOG_EXPIRATION_CHANGE
- CONFIG_SIGNED_AUDIT

Authentication and authorization audit events:

- AUTHZ
- AUTH
- ROLE_ASSUME
- CONFIG_AUTH
- CONFIG_ROLE
- ACCESS_SESSION_ESTABLISH
- ACCESS_SESSION_TERMINATED

Key audit events:

- PRIVATE_KEY_ARCHIVE_REQUEST
- PRIVATE_KEY_ARCHIVE_REQUEST_PROCESSED
- PRIVATE_KEY_EXPORT_REQUEST_PROCESSED_SUCCESS
- CONFIG_TRUSTED_PUBLIC_KEY
- PRIVATE_KEY_EXPORT_REQUEST_PROCESSED_FAILURE
- KEY_RECOVERY_REQUEST
- KEY_RECOVERY_REQUEST_ASYNC
- KEY_RECOVERY_AGENT_LOGIN
- KEY_RECOVERY_REQUEST_PROCESSED
- KEY_RECOVERY_REQUEST_PROCESSED_ASYNC
- KEY_GEN_ASYMMETRIC
- COMPUTE_SESSION_KEY_REQUEST_PROCESSED_SUCCESS
- COMPUTE_SESSION_KEY_REQUEST
- COMPUTE_SESSION_KEY_REQUEST_PROCESSED_FAILURE
- DIVERSIFY_KEY_REQUEST
- DIVERSIFY_KEY_REQUEST_PROCESSED_SUCCESS
- DIVERSIFY_KEY_REQUEST_PROCESSED_FAILURE
- SERVER_SIDE_KEYGEN_REQUEST
- SERVER_SIDE_KEYGEN_REQUEST_PROCESSED_SUCCESS
- SERVER_SIDE_KEYGEN_REQUEST_PROCESSED_FAILURE

CMC audit events:

- CMC_RESPONSE_SENT
- CMC_ID_POP_LINK_WITNESS
- CMC_SIGNED_REQUEST_SIG_VERIFY
- CMC_PROOF_OF_IDENTIFICATION
- CMC_REQUEST_RECEIVED
- CMC_USER_SIGNED_REQUEST_SIG_VERIFY
- PROOF_OF_POSSESSION

Profile audit events:

- CONFIG_CERT_PROFILE
- CONFIG_CRL_PROFILE
- CONFIG_OCSP_PROFILE

Certificate audit events:

- CERT_SIGNING_INFO
- CERT_PROFILE_APPROVAL
- CERT_REQUEST_PROCESSED
- CERT_STATUS_CHANGE_REQUEST
- CERT_STATUS_CHANGE_REQUEST_PROCESSED
- CONFIG_CERT_POLICY
- PROFILE_CERT_REQUEST
- CIMC_CERT_VERIFICATION
- NON_PROFILE_CERT_REQUEST

ACL audit events:

- CONFIG_ACL

OCSP audit events:

- OCSP_SIGNING_INFO
- OCSP_GENERATION

CRL audit events:

- SCHEDULE_CRL_GENERATION
- DELTA_CRL_PUBLISHING
- CRL_VALIDATION
- CRL_RETRIEVAL
- CRL_SIGNING_INFO
- FULL_CRL_GENERATION
- DELTA_CRL_GENERATION

Authority audit events:

- AUTHORITY_CONFIG
- SECURITY_DOMAIN_UPDATE
- CONFIG_DRM

Selftest audit events:

- SELFTESTS_EXECUTION

Encryption data audit events:

- CONFIG_ENCRYPTION
- ENCRYPT_DATA_REQUEST
- ENCRYPT_DATA_REQUEST_PROCESSED_SUCCESS
- ENCRYPT_DATA_REQUEST_PROCESSED_FAILURE
- COMPUTE_RANDOM_DATA_REQUEST
- COMPUTE_RANDOM_DATA_REQUEST_PROCESSED_FAILURE
- COMPUTE_RANDOM_DATA_REQUEST_PROCESSED_SUCCESS
- SECURITY_DATA_ARCHIVAL_REQUEST

Serial/random number audit event:

- INTER_BOUNDARY
- CONFIG_SERIAL_NUMBER
- RANDOM_GENERATION

## SEE ALSO

**pki-server(8)**  
    PKI server management commands

## AUTHORS

Amol Kahat &lt;akahat@redhat.com&gt;.

## COPYRIGHT

Copyright (c) 2018 Red Hat, Inc.
This is licensed under the GNU General Public License, version 2 (GPLv2).
A copy of this license is available at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
