/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_logger.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: alpha] @ref ::diagnostics::testing::Dummy_Logger
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__DUMMY_LOGGER_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DUMMY_LOGGER_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>

#include <diagnostics/frame/logger.hpp>

#include <vector>

DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

class Dummy_Logger
    : public Logger
{
public:
    typedef ::std::vector<Record> Records_t;

    Dummy_Logger();
    
    virtual void log(Record const & record);
    virtual void close();


    Records_t & records()  { return m_records; }
    int & is_closed() { return m_is_closed; }
private:
    Records_t m_records;
    int m_is_closed;
};

TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
