#ifndef QUEUE_MODEL_H__
#define QUEUE_MODEL_H__


#include "global.h"
#include "filetransfer.h"
#include "exceptions.h"

#include <QAbstractTableModel>
#include <QList>
#include "queueitem.h"
#include "globalusermodel.h"
#include <boost/shared_ptr.hpp>

//! Transfer queue data model.
class QueueModel : public QAbstractTableModel
{
    Q_OBJECT
    public:
		QueueModel( boost::shared_ptr<GlobalUserModel> aUserModel ) throw() : userModel(aUserModel) {}
		virtual ~QueueModel() throw() {}
                 
        int rowCount ( const QModelIndex& ) const {return itemList.size();}
        int columnCount ( const QModelIndex& ) const {return 6;}
        QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
        QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
		QueueItem* getItem(int row) const throw(IndexOutOfBoundsException);
		
    public slots:
        void onItemAdded( const QueueItem& );
		void onItemsAdded( const QList<QueueItem>& );
        void onItemRemoved( int );
        void onFinished( int );
        void onSourcesUpdated( int, QList<int> );
        void onStatusUpdated(int,int,int,int);      
    
    private:
        QMap<int,QueueItem> items;
        QList<QueueItem*> itemList;
		boost::shared_ptr<GlobalUserModel> userModel;
};










#endif

