#include "commonapi.h"
#include "dballe/core/var.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace fortran {

bool CommonAPIImplementation::_seti(const char* key, unsigned len, int val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            input_query.level.l1     = input_data.level.l1     = val;
                            break;
                        case '2':
                            input_query.level.l2     = input_data.level.l2     = val;
                            break;
                        default: return false;
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            input_query.trange.p1    = input_data.trange.p1    = val;
                            break;
                        case '2':
                            input_query.trange.p2    = input_data.trange.p2    = val;
                            break;
                        default: return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                input_data.station.coords.set_lat(val); input_query.latrange.set(val, val);
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                input_data.station.coords.set_lon(val); input_query.lonrange.set(val, val);
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        input_query.dtrange.min.day    = input_query.dtrange.max.day    = input_data.datetime.day    = val;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        input_query.dtrange.min.minute = input_query.dtrange.max.minute = input_data.datetime.minute = val;
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        input_query.dtrange.min.second = input_query.dtrange.max.second = input_data.datetime.second = val;
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        throw error_consistency("cannot seti var");
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        input_query.dtrange.min.year   = input_query.dtrange.max.year   = input_data.datetime.year   = val;
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        input_query.dtrange.min.hour   = input_query.dtrange.max.hour   = input_data.datetime.hour   = val;
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        throw error_consistency("cannot seti ident");
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        input_query.dtrange.min.month  = input_query.dtrange.max.month  = input_data.datetime.month  = val;
                    } else {
                        return false;
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        throw error_consistency("cannot seti query");
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "imit", 4) == 0) {
                        input_query.limit = val;
                    } else {
                        return false;
                    }
                    break;
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        input_query.block = val;   input_data.values.set(WR_VAR(0, 1, 1), val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 6:
            switch (key[0]) {
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        input_query.ana_id = input_data.station.id = val;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        input_query.mobile = val;
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.latrange.imax = val == MISSING_INT ? LatRange::IMAX : val;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.latrange.imin = val == MISSING_INT ? LatRange::IMIN : val;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.lonrange.imax = val;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.lonrange.imin = val;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.day    = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.day    = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.second = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.second = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.priomax = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.priomin = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.year   = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.year   = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.hour   = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.hour   = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.minute = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.minute = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        throw error_consistency("cannot seti varlist");
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        input_query.station = val; input_data.values.set(WR_VAR(0, 1, 2), val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        input_query.priomin = input_query.priomax = val;
                    } else {
                        return false;
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        throw error_consistency("cannot seti rep_memo");
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    input_query.dtrange.max.month  = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    input_query.dtrange.min.month  = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                input_query.level.ltype1 = input_data.level.ltype1 = val;
                                break;
                            case '2':
                                input_query.level.ltype2 = input_data.level.ltype2 = val;
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        input_query.trange.pind  = input_data.trange.pind  = val;
                    } else {
                        return false;
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        throw error_consistency("cannot set context_id");
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        throw error_consistency("cannot seti ana_filter");
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ata_filter", 10) == 0) {
                        throw error_consistency("cannot seti data_filter");
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        throw error_consistency("cannot seti attr_filter");
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        default: return false;
    }
    return true;
}

bool CommonAPIImplementation::_setd(const char* key, unsigned len, double val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            input_query.level.l1     = input_data.level.l1     = val;
                            break;
                        case '2':
                            input_query.level.l2     = input_data.level.l2     = val;
                            break;
                        default: return false;
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            input_query.trange.p1    = input_data.trange.p1    = val;
                            break;
                        case '2':
                            input_query.trange.p2    = input_data.trange.p2    = val;
                            break;
                        default: return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                input_data.station.coords.set_lat(val); input_query.latrange.set(val, val);
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                input_data.station.coords.set_lon(val); input_query.lonrange.set(val, val);
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        input_query.dtrange.min.day    = input_query.dtrange.max.day    = input_data.datetime.day    = val;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        input_query.dtrange.min.minute = input_query.dtrange.max.minute = input_data.datetime.minute = val;
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        input_query.dtrange.min.second = input_query.dtrange.max.second = input_data.datetime.second = val;
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        throw error_consistency("cannot setd var");
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        input_query.dtrange.min.year   = input_query.dtrange.max.year   = input_data.datetime.year   = val;
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        input_query.dtrange.min.hour   = input_query.dtrange.max.hour   = input_data.datetime.hour   = val;
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        throw error_consistency("cannot setd ident");
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        input_query.dtrange.min.month  = input_query.dtrange.max.month  = input_data.datetime.month  = val;
                    } else {
                        return false;
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        throw error_consistency("cannot setd query");
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "imit", 4) == 0) {
                        input_query.limit = val;
                    } else {
                        return false;
                    }
                    break;
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        input_query.block = val;   input_data.values.set(WR_VAR(0, 1, 1), val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 6:
            switch (key[0]) {
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        input_query.ana_id = input_data.station.id = val;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        input_query.mobile = val;
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.latrange.imax = Coords::lat_to_int(val);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.latrange.imin = Coords::lat_to_int(val);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.lonrange.imax = Coords::lon_to_int(val);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.lonrange.imin = Coords::lon_to_int(val);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.day    = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.day    = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.second = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.second = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.priomax = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.priomin = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.year   = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.year   = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.hour   = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.hour   = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.minute = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.minute = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        throw error_consistency("cannot setd varlist");
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        input_query.station = val; input_data.values.set(WR_VAR(0, 1, 2), val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        input_query.priomin = input_query.priomax = val;
                    } else {
                        return false;
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        throw error_consistency("cannot setd rep_memo");
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    input_query.dtrange.max.month  = val;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    input_query.dtrange.min.month  = val;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                input_query.level.ltype1 = input_data.level.ltype1 = val;
                                break;
                            case '2':
                                input_query.level.ltype2 = input_data.level.ltype2 = val;
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        input_query.trange.pind  = input_data.trange.pind  = val;
                    } else {
                        return false;
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        throw error_consistency("cannot set context_id");
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        throw error_consistency("cannot setd ana_filter");
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ata_filter", 10) == 0) {
                        throw error_consistency("cannot setd data_filter");
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        throw error_consistency("cannot setd attr_filter");
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        default: return false;
    }
    return true;
}

bool CommonAPIImplementation::_setc(const char* key, unsigned len, const char* val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            input_query.level.l1     = input_data.level.l1     = strtol(val, nullptr, 10);
                            break;
                        case '2':
                            input_query.level.l2     = input_data.level.l2     = strtol(val, nullptr, 10);
                            break;
                        default: return false;
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            input_query.trange.p1    = input_data.trange.p1    = strtol(val, nullptr, 10);
                            break;
                        case '2':
                            input_query.trange.p2    = input_data.trange.p2    = strtol(val, nullptr, 10);
                            break;
                        default: return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                { int ival = strtol(val, nullptr, 10); input_data.station.coords.set_lat(ival); input_query.latrange.set(ival, ival); }
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                { int ival = strtol(val, nullptr, 10); input_data.station.coords.set_lon(ival); input_query.lonrange.set(ival, ival); }
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        input_query.dtrange.min.day    = input_query.dtrange.max.day    = input_data.datetime.day    = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        input_query.dtrange.min.minute = input_query.dtrange.max.minute = input_data.datetime.minute = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        input_query.dtrange.min.second = input_query.dtrange.max.second = input_data.datetime.second = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        input_query_var = resolve_varcode(val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        input_query.dtrange.min.year   = input_query.dtrange.max.year   = input_data.datetime.year   = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        input_query.dtrange.min.hour   = input_query.dtrange.max.hour   = input_data.datetime.hour   = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        input_query.ident = input_data.station.ident = val;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        input_query.dtrange.min.month  = input_query.dtrange.max.month  = input_data.datetime.month  = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        input_query.query = val;
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "imit", 4) == 0) {
                        input_query.limit = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        input_query.block   = strtol(val, nullptr, 10); input_data.values.set(WR_VAR(0, 1, 1), val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 6:
            switch (key[0]) {
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        input_query.ana_id = input_data.station.id = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        input_query.mobile = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.latrange.imax = strtol(val, nullptr, 10);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.latrange.imin = strtol(val, nullptr, 10);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.lonrange.imax = strtol(val, nullptr, 10);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.lonrange.imin = strtol(val, nullptr, 10);
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.day = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.day = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.second = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.second = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.priomax = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.priomin = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.year = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.year = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.hour = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.hour = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.minute = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.minute = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        input_query_varlist.clear(); resolve_varlist(val, input_query_varlist);
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        input_query.station = strtol(val, nullptr, 10); input_data.values.set(WR_VAR(0, 1, 2), val);
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        input_query.priomin = input_query.priomax = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        input_query.report = input_data.station.report = val;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    input_query.dtrange.max.month = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    input_query.dtrange.min.month = strtol(val, nullptr, 10);
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                input_query.level.ltype1 = input_data.level.ltype1 = strtol(val, nullptr, 10);
                                break;
                            case '2':
                                input_query.level.ltype2 = input_data.level.ltype2 = strtol(val, nullptr, 10);
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        input_query.trange.pind  = input_data.trange.pind  = strtol(val, nullptr, 10);
                    } else {
                        return false;
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        throw error_consistency("cannot set context_id");
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        input_query.ana_filter = val;
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ata_filter", 10) == 0) {
                        input_query.data_filter = val;
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        input_query.attr_filter = val;
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        default: return false;
    }
    return true;
}

bool CommonAPIImplementation::_unset(const char* key, unsigned len)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            input_query.level.l1     = input_data.level.l1     = MISSING_INT;
                            break;
                        case '2':
                            input_query.level.l2     = input_data.level.l2     = MISSING_INT;
                            break;
                        default: return false;
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            input_query.trange.p1    = input_data.trange.p1    = MISSING_INT;
                            break;
                        case '2':
                            input_query.trange.p2    = input_data.trange.p2    = MISSING_INT;
                            break;
                        default: return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                input_data.station.coords = Coords(); input_query.latrange = LatRange();
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                input_data.station.coords = Coords(); input_query.lonrange = LonRange();
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        input_query.dtrange.min.day    = input_query.dtrange.max.day    = input_data.datetime.day    = 0xff;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        input_query.dtrange.min.minute = input_query.dtrange.max.minute = input_data.datetime.minute = 0xff;
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        input_query.dtrange.min.second = input_query.dtrange.max.second = input_data.datetime.second = 0xff;
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        input_query_var = 0;
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        input_query.dtrange.min.year   = input_query.dtrange.max.year   = input_data.datetime.year   = 0xffff;
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        input_query.dtrange.min.hour   = input_query.dtrange.max.hour   = input_data.datetime.hour   = 0xff;
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        input_data.station.ident.clear();
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        input_query.dtrange.min.month  = input_query.dtrange.max.month  = input_data.datetime.month  = 0xff;
                    } else {
                        return false;
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        input_query.query.clear();
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "imit", 4) == 0) {
                        input_query.limit = MISSING_INT;
                    } else {
                        return false;
                    }
                    break;
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        input_query.block   = MISSING_INT; input_data.values.unset(WR_VAR(0, 1, 1));
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 6:
            switch (key[0]) {
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        input_query.ana_id = input_data.station.id = MISSING_INT;
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        input_query.mobile = MISSING_INT;
                    } else {
                        return false;
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.latrange.imax = LatRange::IMAX;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.latrange.imin = LatRange::IMIN;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            input_query.lonrange.imax = MISSING_INT;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            input_query.lonrange.imin = MISSING_INT;
                                        } else {
                                            return false;
                                        }
                                        break;
                                    default: return false;
                                }
                            } else {
                                return false;
                            }
                            break;
                        default: return false;
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.day = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.day = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    input_query.dtrange.max.second = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    input_query.dtrange.min.second = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.priomax = MISSING_INT;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.priomin = MISSING_INT;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.year = 0xffff;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.year = 0xffff;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.hour = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.hour = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    input_query.dtrange.max.minute = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    input_query.dtrange.min.minute = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        input_query_varlist.clear();
                    } else {
                        return false;
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        input_query.station = MISSING_INT; input_data.values.unset(WR_VAR(0, 1, 2));
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        input_query.priomin = input_query.priomax = MISSING_INT;
                    } else {
                        return false;
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        input_query.report.clear(); input_data.station.report.clear();
                    } else {
                        return false;
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    input_query.dtrange.max.month = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    input_query.dtrange.min.month = 0xff;
                                } else {
                                    return false;
                                }
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                input_query.level.ltype1 = input_data.level.ltype1 = MISSING_INT;
                                break;
                            case '2':
                                input_query.level.ltype2 = input_data.level.ltype2 = MISSING_INT;
                                break;
                            default: return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        input_query.trange.pind  = input_data.trange.pind  = MISSING_INT;
                    } else {
                        return false;
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        throw error_consistency("cannot set/unset context_id");
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        input_query.ana_filter.clear();
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ata_filter", 10) == 0) {
                        input_query.data_filter.clear();
                    } else {
                        return false;
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        input_query.attr_filter.clear();
                    } else {
                        return false;
                    }
                    break;
                default: return false;
            }
            break;
        default: return false;
    }
    return true;
}

}
}
