DACS_ADMIN(8)              DACS Web Services Manual              DACS_ADMIN(8)



[1mNAME[0m
       dacs_admin - [1mDACS [22madministration service

[1mSYNOPSIS[0m
       [1mdacs_admin [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_admin [22mweb service is a tool for administering various [1mDACS[0m
       resources at a jurisdiction. Providing both a browser-based interface
       and a simple, [34m[1mREST-oriented[0m[1m[22m[2] HTTP interface that can be used by
       middleware, scripts, and web browsers, [1mdacs_admin [22mallows inspection
       (and sometimes modification) of a jurisdiction's access control rules,
       configuration directives, group definitions, [1mDACS [22muser accounts,
       revocation list, version information, authorization cache, [1mDACS [22mlog
       files, user tracking records, and more. An administrator can manage a
       different jurisdiction simply by aiming a browser or other HTTP client
       at that jurisdiction's [1mdacs_admin [22mweb service.

       Probably the best way to understand the tool is to simply use it
       interactively to browse through a jurisdiction's resources.

           [1mSecurity[0m
           This web service provides a way to view and change security-related
           [1mDACS [22mconfiguration, [1mDACS [22mpasswords, and so on. The default access
           control rule denies all access to the web service - you must add a
           custom rule to enable access. All functionality should be
           restricted to an [34m[1mADMIN_IDENTITY[0m[1m[22m[3].

           [1mNotes[0m
           +o   Some features of this program may require JavaScript to be
               enabled in the browser.

           +o   [1mdacs_admin [22mwill eventually unify and replace several existing
               different [1mDACS [22madministrative web services. It may also include
               federation-wide functions, such as the capability of adding a
               new jurisdiction.

   [1mWeb Service Arguments[0m
       The following web service argument is always recognized:

       [4mFORMAT[0m
           By default, output is emitted in HTML. Several varieties of XML
           output can be selected, however, using the [4mFORMAT[24m argument (please
           refer to [34m[1mdacs(1)[0m[1m[22m[4]).

   [1mResources and Methods[0m
       The interface provided by [1mdacs_admin [22mallows various [1mDACS [22mresources to
       be examined and modified using standard HTTP methods (see [34m[1mRFC 2616[0m[1m[22m[5]).
       Not all [1mDACS [22mresources may be accessible using [1mdacs_admin [22mand not all
       methods may be valid for some resources.

       In keeping with the REST architectural style, every persistent resource
       is identified by a URI ([34m[1mRFC 2396[0m[1m[22m[6] and [34m[1mRFC 3986[0m[1m[22m[7]). Invoking the GET
       method on https://www.example.com/cgi-bin/dacs/dacs_admin, for example,
       will (assuming appropriate configuration and permission) return a list
       of root-level resources managed by [1mdacs_admin[22m.

       Invoking the GET method on a resource either returns a listing (by
       default, formatted as an HTML list or table) or an unadorned value (by
       default, formatted as an HTML encoded string). For instance, this URL
       might return a list of configuration directives and their current
       values:

           https://www.example.com/cgi-bin/dacs/dacs_admin/conf/current

       while this URL might return the current value of a particular
       configuration directive:

           https://www.example.com/cgi-bin/dacs/dacs_admin/conf/current/AUTH_SUCCESS

       The functionality of [1mdacs_admin [22mis described in terms of resources and
       methods supported on those resources. Depending on the particular
       service request, the result consists of an HTTP status code (usually
       "[1m200 [22mOK", "[1m201 [22mCreated", "[1m400 [22mBad Request", or "[1m404 [22mNot Found"), and
       possibly an HTML or XML document (selectable). The XML document is
       described by [34m[1mdacs_admin.dtd[0m[1m[22m[8].

       Arguments are passed in the query part of a URI. Unrecognized and
       context-inappropriate arguments are silently ignored.

[1mOPTIONS[0m
       Only the standard [34m[4mdacsoptions[0m[4m[24m[1] command line arguments are recognized.

[1mFILES[0m
       [34m[1mdacs_admin.css[0m[1m[22m[9]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacsacl(1)[0m[1m[22m[10], [34m[1mdacspasswd(1)[0m[1m[22m[11], [34m[1mdacs.acls(5)[0m[1m[22m[12], [34m[1mdacs_conf(8)[0m[1m[22m[13],
       [34m[1mdacs_group(8)[0m[1m[22m[14], [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[15], [34m[1mdacs_passwd(8)[0m[1m[22m[16],
       [34m[1mdacs_version(8)[0m[1m[22m[17]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[18])

[1mCOPYING[0m
       Copyright (C) 2003-2014 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[19] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. REST-oriented
           https://code.google.com/p/implementing-rest/

        3. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

        4. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        5. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

        6. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

        7. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

        8. dacs_admin.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_admin.dtd

        9. dacs_admin.css
           http://dacs.dss.ca/man//css/dacs_admin.css

       10. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       11. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       12. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       13. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

       14. dacs_group(8)
           http://dacs.dss.ca/man/dacs_group.8.html

       15. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       16. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       17. dacs_version(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       18. www.dss.ca
           http://www.dss.ca

       19. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                     DACS_ADMIN(8)
